/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A Lambda function that processes documents.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransformationFunction implements SdkPojo, Serializable,
        ToCopyableBuilder<TransformationFunction.Builder, TransformationFunction> {
    private static final SdkField<TransformationLambdaConfiguration> TRANSFORMATION_LAMBDA_CONFIGURATION_FIELD = SdkField
            .<TransformationLambdaConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("transformationLambdaConfiguration")
            .getter(getter(TransformationFunction::transformationLambdaConfiguration))
            .setter(setter(Builder::transformationLambdaConfiguration))
            .constructor(TransformationLambdaConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformationLambdaConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRANSFORMATION_LAMBDA_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TransformationLambdaConfiguration transformationLambdaConfiguration;

    private TransformationFunction(BuilderImpl builder) {
        this.transformationLambdaConfiguration = builder.transformationLambdaConfiguration;
    }

    /**
     * <p>
     * The Lambda function.
     * </p>
     * 
     * @return The Lambda function.
     */
    public final TransformationLambdaConfiguration transformationLambdaConfiguration() {
        return transformationLambdaConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transformationLambdaConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformationFunction)) {
            return false;
        }
        TransformationFunction other = (TransformationFunction) obj;
        return Objects.equals(transformationLambdaConfiguration(), other.transformationLambdaConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransformationFunction")
                .add("TransformationLambdaConfiguration", transformationLambdaConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "transformationLambdaConfiguration":
            return Optional.ofNullable(clazz.cast(transformationLambdaConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("transformationLambdaConfiguration", TRANSFORMATION_LAMBDA_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransformationFunction, T> g) {
        return obj -> g.apply((TransformationFunction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransformationFunction> {
        /**
         * <p>
         * The Lambda function.
         * </p>
         * 
         * @param transformationLambdaConfiguration
         *        The Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformationLambdaConfiguration(TransformationLambdaConfiguration transformationLambdaConfiguration);

        /**
         * <p>
         * The Lambda function.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TransformationLambdaConfiguration.Builder} avoiding the need to create one manually via
         * {@link TransformationLambdaConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransformationLambdaConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #transformationLambdaConfiguration(TransformationLambdaConfiguration)}.
         * 
         * @param transformationLambdaConfiguration
         *        a consumer that will call methods on {@link TransformationLambdaConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transformationLambdaConfiguration(TransformationLambdaConfiguration)
         */
        default Builder transformationLambdaConfiguration(
                Consumer<TransformationLambdaConfiguration.Builder> transformationLambdaConfiguration) {
            return transformationLambdaConfiguration(TransformationLambdaConfiguration.builder()
                    .applyMutation(transformationLambdaConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TransformationLambdaConfiguration transformationLambdaConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformationFunction model) {
            transformationLambdaConfiguration(model.transformationLambdaConfiguration);
        }

        public final TransformationLambdaConfiguration.Builder getTransformationLambdaConfiguration() {
            return transformationLambdaConfiguration != null ? transformationLambdaConfiguration.toBuilder() : null;
        }

        public final void setTransformationLambdaConfiguration(
                TransformationLambdaConfiguration.BuilderImpl transformationLambdaConfiguration) {
            this.transformationLambdaConfiguration = transformationLambdaConfiguration != null ? transformationLambdaConfiguration
                    .build() : null;
        }

        @Override
        public final Builder transformationLambdaConfiguration(TransformationLambdaConfiguration transformationLambdaConfiguration) {
            this.transformationLambdaConfiguration = transformationLambdaConfiguration;
            return this;
        }

        @Override
        public TransformationFunction build() {
            return new TransformationFunction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
