/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an unknown source node for a connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnknownConnectionSourceFlowValidationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<UnknownConnectionSourceFlowValidationDetails.Builder, UnknownConnectionSourceFlowValidationDetails> {
    private static final SdkField<String> CONNECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connection").getter(getter(UnknownConnectionSourceFlowValidationDetails::connection))
            .setter(setter(Builder::connection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connection").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connection;

    private UnknownConnectionSourceFlowValidationDetails(BuilderImpl builder) {
        this.connection = builder.connection;
    }

    /**
     * <p>
     * The name of the connection with the unknown source.
     * </p>
     * 
     * @return The name of the connection with the unknown source.
     */
    public final String connection() {
        return connection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnknownConnectionSourceFlowValidationDetails)) {
            return false;
        }
        UnknownConnectionSourceFlowValidationDetails other = (UnknownConnectionSourceFlowValidationDetails) obj;
        return Objects.equals(connection(), other.connection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UnknownConnectionSourceFlowValidationDetails").add("Connection", connection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connection":
            return Optional.ofNullable(clazz.cast(connection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connection", CONNECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnknownConnectionSourceFlowValidationDetails, T> g) {
        return obj -> g.apply((UnknownConnectionSourceFlowValidationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnknownConnectionSourceFlowValidationDetails> {
        /**
         * <p>
         * The name of the connection with the unknown source.
         * </p>
         * 
         * @param connection
         *        The name of the connection with the unknown source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connection(String connection);
    }

    static final class BuilderImpl implements Builder {
        private String connection;

        private BuilderImpl() {
        }

        private BuilderImpl(UnknownConnectionSourceFlowValidationDetails model) {
            connection(model.connection);
        }

        public final String getConnection() {
            return connection;
        }

        public final void setConnection(String connection) {
            this.connection = connection;
        }

        @Override
        public final Builder connection(String connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public UnknownConnectionSourceFlowValidationDetails build() {
            return new UnknownConnectionSourceFlowValidationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
