/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAgentAliasResponse extends BedrockAgentResponse implements
        ToCopyableBuilder<UpdateAgentAliasResponse.Builder, UpdateAgentAliasResponse> {
    private static final SdkField<AgentAlias> AGENT_ALIAS_FIELD = SdkField.<AgentAlias> builder(MarshallingType.SDK_POJO)
            .memberName("agentAlias").getter(getter(UpdateAgentAliasResponse::agentAlias)).setter(setter(Builder::agentAlias))
            .constructor(AgentAlias::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAlias").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ALIAS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AgentAlias agentAlias;

    private UpdateAgentAliasResponse(BuilderImpl builder) {
        super(builder);
        this.agentAlias = builder.agentAlias;
    }

    /**
     * <p>
     * Contains details about the alias that was updated.
     * </p>
     * 
     * @return Contains details about the alias that was updated.
     */
    public final AgentAlias agentAlias() {
        return agentAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentAlias());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAgentAliasResponse)) {
            return false;
        }
        UpdateAgentAliasResponse other = (UpdateAgentAliasResponse) obj;
        return Objects.equals(agentAlias(), other.agentAlias());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAgentAliasResponse").add("AgentAlias", agentAlias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentAlias":
            return Optional.ofNullable(clazz.cast(agentAlias()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentAlias", AGENT_ALIAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAgentAliasResponse, T> g) {
        return obj -> g.apply((UpdateAgentAliasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAgentAliasResponse> {
        /**
         * <p>
         * Contains details about the alias that was updated.
         * </p>
         * 
         * @param agentAlias
         *        Contains details about the alias that was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentAlias(AgentAlias agentAlias);

        /**
         * <p>
         * Contains details about the alias that was updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgentAlias.Builder} avoiding the need to
         * create one manually via {@link AgentAlias#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgentAlias.Builder#build()} is called immediately and its result
         * is passed to {@link #agentAlias(AgentAlias)}.
         * 
         * @param agentAlias
         *        a consumer that will call methods on {@link AgentAlias.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentAlias(AgentAlias)
         */
        default Builder agentAlias(Consumer<AgentAlias.Builder> agentAlias) {
            return agentAlias(AgentAlias.builder().applyMutation(agentAlias).build());
        }
    }

    static final class BuilderImpl extends BedrockAgentResponse.BuilderImpl implements Builder {
        private AgentAlias agentAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAgentAliasResponse model) {
            super(model);
            agentAlias(model.agentAlias);
        }

        public final AgentAlias.Builder getAgentAlias() {
            return agentAlias != null ? agentAlias.toBuilder() : null;
        }

        public final void setAgentAlias(AgentAlias.BuilderImpl agentAlias) {
            this.agentAlias = agentAlias != null ? agentAlias.build() : null;
        }

        @Override
        public final Builder agentAlias(AgentAlias agentAlias) {
            this.agentAlias = agentAlias;
            return this;
        }

        @Override
        public UpdateAgentAliasResponse build() {
            return new UpdateAgentAliasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
