/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDataSourceRequest extends BedrockAgentRequest implements
        ToCopyableBuilder<UpdateDataSourceRequest.Builder, UpdateDataSourceRequest> {
    private static final SdkField<String> DATA_DELETION_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataDeletionPolicy").getter(getter(UpdateDataSourceRequest::dataDeletionPolicyAsString))
            .setter(setter(Builder::dataDeletionPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataDeletionPolicy").build())
            .build();

    private static final SdkField<DataSourceConfiguration> DATA_SOURCE_CONFIGURATION_FIELD = SdkField
            .<DataSourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("dataSourceConfiguration")
            .getter(getter(UpdateDataSourceRequest::dataSourceConfiguration)).setter(setter(Builder::dataSourceConfiguration))
            .constructor(DataSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceConfiguration").build())
            .build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceId").getter(getter(UpdateDataSourceRequest::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("dataSourceId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateDataSourceRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(UpdateDataSourceRequest::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateDataSourceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ServerSideEncryptionConfiguration> SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<ServerSideEncryptionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("serverSideEncryptionConfiguration")
            .getter(getter(UpdateDataSourceRequest::serverSideEncryptionConfiguration))
            .setter(setter(Builder::serverSideEncryptionConfiguration))
            .constructor(ServerSideEncryptionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverSideEncryptionConfiguration")
                    .build()).build();

    private static final SdkField<VectorIngestionConfiguration> VECTOR_INGESTION_CONFIGURATION_FIELD = SdkField
            .<VectorIngestionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("vectorIngestionConfiguration")
            .getter(getter(UpdateDataSourceRequest::vectorIngestionConfiguration))
            .setter(setter(Builder::vectorIngestionConfiguration))
            .constructor(VectorIngestionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorIngestionConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_DELETION_POLICY_FIELD,
            DATA_SOURCE_CONFIGURATION_FIELD, DATA_SOURCE_ID_FIELD, DESCRIPTION_FIELD, KNOWLEDGE_BASE_ID_FIELD, NAME_FIELD,
            SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD, VECTOR_INGESTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dataDeletionPolicy;

    private final DataSourceConfiguration dataSourceConfiguration;

    private final String dataSourceId;

    private final String description;

    private final String knowledgeBaseId;

    private final String name;

    private final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

    private final VectorIngestionConfiguration vectorIngestionConfiguration;

    private UpdateDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.dataDeletionPolicy = builder.dataDeletionPolicy;
        this.dataSourceConfiguration = builder.dataSourceConfiguration;
        this.dataSourceId = builder.dataSourceId;
        this.description = builder.description;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.name = builder.name;
        this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
        this.vectorIngestionConfiguration = builder.vectorIngestionConfiguration;
    }

    /**
     * <p>
     * The data deletion policy for the data source that you want to update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataDeletionPolicy} will return {@link DataDeletionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #dataDeletionPolicyAsString}.
     * </p>
     * 
     * @return The data deletion policy for the data source that you want to update.
     * @see DataDeletionPolicy
     */
    public final DataDeletionPolicy dataDeletionPolicy() {
        return DataDeletionPolicy.fromValue(dataDeletionPolicy);
    }

    /**
     * <p>
     * The data deletion policy for the data source that you want to update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataDeletionPolicy} will return {@link DataDeletionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #dataDeletionPolicyAsString}.
     * </p>
     * 
     * @return The data deletion policy for the data source that you want to update.
     * @see DataDeletionPolicy
     */
    public final String dataDeletionPolicyAsString() {
        return dataDeletionPolicy;
    }

    /**
     * <p>
     * The connection configuration for the data source that you want to update.
     * </p>
     * 
     * @return The connection configuration for the data source that you want to update.
     */
    public final DataSourceConfiguration dataSourceConfiguration() {
        return dataSourceConfiguration;
    }

    /**
     * <p>
     * The unique identifier of the data source.
     * </p>
     * 
     * @return The unique identifier of the data source.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * Specifies a new description for the data source.
     * </p>
     * 
     * @return Specifies a new description for the data source.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier of the knowledge base for the data source.
     * </p>
     * 
     * @return The unique identifier of the knowledge base for the data source.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * Specifies a new name for the data source.
     * </p>
     * 
     * @return Specifies a new name for the data source.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Contains details about server-side encryption of the data source.
     * </p>
     * 
     * @return Contains details about server-side encryption of the data source.
     */
    public final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration() {
        return serverSideEncryptionConfiguration;
    }

    /**
     * <p>
     * Contains details about how to ingest the documents in the data source.
     * </p>
     * 
     * @return Contains details about how to ingest the documents in the data source.
     */
    public final VectorIngestionConfiguration vectorIngestionConfiguration() {
        return vectorIngestionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataDeletionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(vectorIngestionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataSourceRequest)) {
            return false;
        }
        UpdateDataSourceRequest other = (UpdateDataSourceRequest) obj;
        return Objects.equals(dataDeletionPolicyAsString(), other.dataDeletionPolicyAsString())
                && Objects.equals(dataSourceConfiguration(), other.dataSourceConfiguration())
                && Objects.equals(dataSourceId(), other.dataSourceId()) && Objects.equals(description(), other.description())
                && Objects.equals(knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(name(), other.name())
                && Objects.equals(serverSideEncryptionConfiguration(), other.serverSideEncryptionConfiguration())
                && Objects.equals(vectorIngestionConfiguration(), other.vectorIngestionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDataSourceRequest").add("DataDeletionPolicy", dataDeletionPolicyAsString())
                .add("DataSourceConfiguration", dataSourceConfiguration()).add("DataSourceId", dataSourceId())
                .add("Description", description()).add("KnowledgeBaseId", knowledgeBaseId()).add("Name", name())
                .add("ServerSideEncryptionConfiguration", serverSideEncryptionConfiguration())
                .add("VectorIngestionConfiguration", vectorIngestionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataDeletionPolicy":
            return Optional.ofNullable(clazz.cast(dataDeletionPolicyAsString()));
        case "dataSourceConfiguration":
            return Optional.ofNullable(clazz.cast(dataSourceConfiguration()));
        case "dataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "serverSideEncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(serverSideEncryptionConfiguration()));
        case "vectorIngestionConfiguration":
            return Optional.ofNullable(clazz.cast(vectorIngestionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataDeletionPolicy", DATA_DELETION_POLICY_FIELD);
        map.put("dataSourceConfiguration", DATA_SOURCE_CONFIGURATION_FIELD);
        map.put("dataSourceId", DATA_SOURCE_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("serverSideEncryptionConfiguration", SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD);
        map.put("vectorIngestionConfiguration", VECTOR_INGESTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataSourceRequest, T> g) {
        return obj -> g.apply((UpdateDataSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDataSourceRequest> {
        /**
         * <p>
         * The data deletion policy for the data source that you want to update.
         * </p>
         * 
         * @param dataDeletionPolicy
         *        The data deletion policy for the data source that you want to update.
         * @see DataDeletionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataDeletionPolicy
         */
        Builder dataDeletionPolicy(String dataDeletionPolicy);

        /**
         * <p>
         * The data deletion policy for the data source that you want to update.
         * </p>
         * 
         * @param dataDeletionPolicy
         *        The data deletion policy for the data source that you want to update.
         * @see DataDeletionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataDeletionPolicy
         */
        Builder dataDeletionPolicy(DataDeletionPolicy dataDeletionPolicy);

        /**
         * <p>
         * The connection configuration for the data source that you want to update.
         * </p>
         * 
         * @param dataSourceConfiguration
         *        The connection configuration for the data source that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration);

        /**
         * <p>
         * The connection configuration for the data source that you want to update.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceConfiguration.Builder} avoiding
         * the need to create one manually via {@link DataSourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #dataSourceConfiguration(DataSourceConfiguration)}.
         * 
         * @param dataSourceConfiguration
         *        a consumer that will call methods on {@link DataSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSourceConfiguration(DataSourceConfiguration)
         */
        default Builder dataSourceConfiguration(Consumer<DataSourceConfiguration.Builder> dataSourceConfiguration) {
            return dataSourceConfiguration(DataSourceConfiguration.builder().applyMutation(dataSourceConfiguration).build());
        }

        /**
         * <p>
         * The unique identifier of the data source.
         * </p>
         * 
         * @param dataSourceId
         *        The unique identifier of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * Specifies a new description for the data source.
         * </p>
         * 
         * @param description
         *        Specifies a new description for the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier of the knowledge base for the data source.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The unique identifier of the knowledge base for the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * Specifies a new name for the data source.
         * </p>
         * 
         * @param name
         *        Specifies a new name for the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Contains details about server-side encryption of the data source.
         * </p>
         * 
         * @param serverSideEncryptionConfiguration
         *        Contains details about server-side encryption of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration);

        /**
         * <p>
         * Contains details about server-side encryption of the data source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServerSideEncryptionConfiguration.Builder} avoiding the need to create one manually via
         * {@link ServerSideEncryptionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServerSideEncryptionConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration)}.
         * 
         * @param serverSideEncryptionConfiguration
         *        a consumer that will call methods on {@link ServerSideEncryptionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration)
         */
        default Builder serverSideEncryptionConfiguration(
                Consumer<ServerSideEncryptionConfiguration.Builder> serverSideEncryptionConfiguration) {
            return serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration.builder()
                    .applyMutation(serverSideEncryptionConfiguration).build());
        }

        /**
         * <p>
         * Contains details about how to ingest the documents in the data source.
         * </p>
         * 
         * @param vectorIngestionConfiguration
         *        Contains details about how to ingest the documents in the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorIngestionConfiguration(VectorIngestionConfiguration vectorIngestionConfiguration);

        /**
         * <p>
         * Contains details about how to ingest the documents in the data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link VectorIngestionConfiguration.Builder}
         * avoiding the need to create one manually via {@link VectorIngestionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VectorIngestionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #vectorIngestionConfiguration(VectorIngestionConfiguration)}.
         * 
         * @param vectorIngestionConfiguration
         *        a consumer that will call methods on {@link VectorIngestionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vectorIngestionConfiguration(VectorIngestionConfiguration)
         */
        default Builder vectorIngestionConfiguration(Consumer<VectorIngestionConfiguration.Builder> vectorIngestionConfiguration) {
            return vectorIngestionConfiguration(VectorIngestionConfiguration.builder()
                    .applyMutation(vectorIngestionConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRequest.BuilderImpl implements Builder {
        private String dataDeletionPolicy;

        private DataSourceConfiguration dataSourceConfiguration;

        private String dataSourceId;

        private String description;

        private String knowledgeBaseId;

        private String name;

        private ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;

        private VectorIngestionConfiguration vectorIngestionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataSourceRequest model) {
            super(model);
            dataDeletionPolicy(model.dataDeletionPolicy);
            dataSourceConfiguration(model.dataSourceConfiguration);
            dataSourceId(model.dataSourceId);
            description(model.description);
            knowledgeBaseId(model.knowledgeBaseId);
            name(model.name);
            serverSideEncryptionConfiguration(model.serverSideEncryptionConfiguration);
            vectorIngestionConfiguration(model.vectorIngestionConfiguration);
        }

        public final String getDataDeletionPolicy() {
            return dataDeletionPolicy;
        }

        public final void setDataDeletionPolicy(String dataDeletionPolicy) {
            this.dataDeletionPolicy = dataDeletionPolicy;
        }

        @Override
        public final Builder dataDeletionPolicy(String dataDeletionPolicy) {
            this.dataDeletionPolicy = dataDeletionPolicy;
            return this;
        }

        @Override
        public final Builder dataDeletionPolicy(DataDeletionPolicy dataDeletionPolicy) {
            this.dataDeletionPolicy(dataDeletionPolicy == null ? null : dataDeletionPolicy.toString());
            return this;
        }

        public final DataSourceConfiguration.Builder getDataSourceConfiguration() {
            return dataSourceConfiguration != null ? dataSourceConfiguration.toBuilder() : null;
        }

        public final void setDataSourceConfiguration(DataSourceConfiguration.BuilderImpl dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration != null ? dataSourceConfiguration.build() : null;
        }

        @Override
        public final Builder dataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration;
            return this;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ServerSideEncryptionConfiguration.Builder getServerSideEncryptionConfiguration() {
            return serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration.toBuilder() : null;
        }

        public final void setServerSideEncryptionConfiguration(
                ServerSideEncryptionConfiguration.BuilderImpl serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration
                    .build() : null;
        }

        @Override
        public final Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        public final VectorIngestionConfiguration.Builder getVectorIngestionConfiguration() {
            return vectorIngestionConfiguration != null ? vectorIngestionConfiguration.toBuilder() : null;
        }

        public final void setVectorIngestionConfiguration(VectorIngestionConfiguration.BuilderImpl vectorIngestionConfiguration) {
            this.vectorIngestionConfiguration = vectorIngestionConfiguration != null ? vectorIngestionConfiguration.build()
                    : null;
        }

        @Override
        public final Builder vectorIngestionConfiguration(VectorIngestionConfiguration vectorIngestionConfiguration) {
            this.vectorIngestionConfiguration = vectorIngestionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataSourceRequest build() {
            return new UpdateDataSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
