/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentClient;
import software.amazon.awssdk.services.bedrockagent.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagent.model.AgentKnowledgeBaseSummary;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentKnowledgeBasesRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentKnowledgeBasesResponse;

public class ListAgentKnowledgeBasesIterable
implements SdkIterable<ListAgentKnowledgeBasesResponse> {
    private final BedrockAgentClient client;
    private final ListAgentKnowledgeBasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAgentKnowledgeBasesIterable(BedrockAgentClient client, ListAgentKnowledgeBasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAgentKnowledgeBasesResponseFetcher();
    }

    public Iterator<ListAgentKnowledgeBasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AgentKnowledgeBaseSummary> agentKnowledgeBaseSummaries() {
        Function<ListAgentKnowledgeBasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.agentKnowledgeBaseSummaries() != null) {
                return response.agentKnowledgeBaseSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAgentKnowledgeBasesResponseFetcher
    implements SyncPageFetcher<ListAgentKnowledgeBasesResponse> {
        private ListAgentKnowledgeBasesResponseFetcher() {
        }

        public boolean hasNextPage(ListAgentKnowledgeBasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAgentKnowledgeBasesResponse nextPage(ListAgentKnowledgeBasesResponse previousPage) {
            if (previousPage == null) {
                return ListAgentKnowledgeBasesIterable.this.client.listAgentKnowledgeBases(ListAgentKnowledgeBasesIterable.this.firstRequest);
            }
            return ListAgentKnowledgeBasesIterable.this.client.listAgentKnowledgeBases((ListAgentKnowledgeBasesRequest)((Object)ListAgentKnowledgeBasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

