/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentAsyncClient;
import software.amazon.awssdk.services.bedrockagent.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagent.model.FlowVersionSummary;
import software.amazon.awssdk.services.bedrockagent.model.ListFlowVersionsRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListFlowVersionsResponse;

public class ListFlowVersionsPublisher
implements SdkPublisher<ListFlowVersionsResponse> {
    private final BedrockAgentAsyncClient client;
    private final ListFlowVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFlowVersionsPublisher(BedrockAgentAsyncClient client, ListFlowVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFlowVersionsPublisher(BedrockAgentAsyncClient client, ListFlowVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFlowVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFlowVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FlowVersionSummary> flowVersionSummaries() {
        Function<ListFlowVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.flowVersionSummaries() != null) {
                return response.flowVersionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFlowVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFlowVersionsResponseFetcher
    implements AsyncPageFetcher<ListFlowVersionsResponse> {
        private ListFlowVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListFlowVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFlowVersionsResponse> nextPage(ListFlowVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListFlowVersionsPublisher.this.client.listFlowVersions(ListFlowVersionsPublisher.this.firstRequest);
            }
            return ListFlowVersionsPublisher.this.client.listFlowVersions((ListFlowVersionsRequest)((Object)ListFlowVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

