/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.GuardrailConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.KnowledgeBaseOrchestrationConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.KnowledgeBasePromptTemplate;
import software.amazon.awssdk.services.bedrockagent.model.PromptInferenceConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.VectorSearchRerankingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KnowledgeBaseFlowNodeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KnowledgeBaseFlowNodeConfiguration> {
    private static final SdkField<GuardrailConfiguration> GUARDRAIL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("guardrailConfiguration").getter(KnowledgeBaseFlowNodeConfiguration.getter(KnowledgeBaseFlowNodeConfiguration::guardrailConfiguration)).setter(KnowledgeBaseFlowNodeConfiguration.setter(Builder::guardrailConfiguration)).constructor(GuardrailConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailConfiguration").build()}).build();
    private static final SdkField<PromptInferenceConfiguration> INFERENCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inferenceConfiguration").getter(KnowledgeBaseFlowNodeConfiguration.getter(KnowledgeBaseFlowNodeConfiguration::inferenceConfiguration)).setter(KnowledgeBaseFlowNodeConfiguration.setter(Builder::inferenceConfiguration)).constructor(PromptInferenceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfiguration").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(KnowledgeBaseFlowNodeConfiguration.getter(KnowledgeBaseFlowNodeConfiguration::knowledgeBaseId)).setter(KnowledgeBaseFlowNodeConfiguration.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(KnowledgeBaseFlowNodeConfiguration.getter(KnowledgeBaseFlowNodeConfiguration::modelId)).setter(KnowledgeBaseFlowNodeConfiguration.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numberOfResults").getter(KnowledgeBaseFlowNodeConfiguration.getter(KnowledgeBaseFlowNodeConfiguration::numberOfResults)).setter(KnowledgeBaseFlowNodeConfiguration.setter(Builder::numberOfResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfResults").build()}).build();
    private static final SdkField<KnowledgeBaseOrchestrationConfiguration> ORCHESTRATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("orchestrationConfiguration").getter(KnowledgeBaseFlowNodeConfiguration.getter(KnowledgeBaseFlowNodeConfiguration::orchestrationConfiguration)).setter(KnowledgeBaseFlowNodeConfiguration.setter(Builder::orchestrationConfiguration)).constructor(KnowledgeBaseOrchestrationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orchestrationConfiguration").build()}).build();
    private static final SdkField<KnowledgeBasePromptTemplate> PROMPT_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("promptTemplate").getter(KnowledgeBaseFlowNodeConfiguration.getter(KnowledgeBaseFlowNodeConfiguration::promptTemplate)).setter(KnowledgeBaseFlowNodeConfiguration.setter(Builder::promptTemplate)).constructor(KnowledgeBasePromptTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptTemplate").build()}).build();
    private static final SdkField<VectorSearchRerankingConfiguration> RERANKING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rerankingConfiguration").getter(KnowledgeBaseFlowNodeConfiguration.getter(KnowledgeBaseFlowNodeConfiguration::rerankingConfiguration)).setter(KnowledgeBaseFlowNodeConfiguration.setter(Builder::rerankingConfiguration)).constructor(VectorSearchRerankingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rerankingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAIL_CONFIGURATION_FIELD, INFERENCE_CONFIGURATION_FIELD, KNOWLEDGE_BASE_ID_FIELD, MODEL_ID_FIELD, NUMBER_OF_RESULTS_FIELD, ORCHESTRATION_CONFIGURATION_FIELD, PROMPT_TEMPLATE_FIELD, RERANKING_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KnowledgeBaseFlowNodeConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final GuardrailConfiguration guardrailConfiguration;
    private final PromptInferenceConfiguration inferenceConfiguration;
    private final String knowledgeBaseId;
    private final String modelId;
    private final Integer numberOfResults;
    private final KnowledgeBaseOrchestrationConfiguration orchestrationConfiguration;
    private final KnowledgeBasePromptTemplate promptTemplate;
    private final VectorSearchRerankingConfiguration rerankingConfiguration;

    private KnowledgeBaseFlowNodeConfiguration(BuilderImpl builder) {
        this.guardrailConfiguration = builder.guardrailConfiguration;
        this.inferenceConfiguration = builder.inferenceConfiguration;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.modelId = builder.modelId;
        this.numberOfResults = builder.numberOfResults;
        this.orchestrationConfiguration = builder.orchestrationConfiguration;
        this.promptTemplate = builder.promptTemplate;
        this.rerankingConfiguration = builder.rerankingConfiguration;
    }

    public final GuardrailConfiguration guardrailConfiguration() {
        return this.guardrailConfiguration;
    }

    public final PromptInferenceConfiguration inferenceConfiguration() {
        return this.inferenceConfiguration;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final Integer numberOfResults() {
        return this.numberOfResults;
    }

    public final KnowledgeBaseOrchestrationConfiguration orchestrationConfiguration() {
        return this.orchestrationConfiguration;
    }

    public final KnowledgeBasePromptTemplate promptTemplate() {
        return this.promptTemplate;
    }

    public final VectorSearchRerankingConfiguration rerankingConfiguration() {
        return this.rerankingConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.orchestrationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.promptTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.rerankingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseFlowNodeConfiguration)) {
            return false;
        }
        KnowledgeBaseFlowNodeConfiguration other = (KnowledgeBaseFlowNodeConfiguration)obj;
        return Objects.equals(this.guardrailConfiguration(), other.guardrailConfiguration()) && Objects.equals(this.inferenceConfiguration(), other.inferenceConfiguration()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.numberOfResults(), other.numberOfResults()) && Objects.equals(this.orchestrationConfiguration(), other.orchestrationConfiguration()) && Objects.equals(this.promptTemplate(), other.promptTemplate()) && Objects.equals(this.rerankingConfiguration(), other.rerankingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"KnowledgeBaseFlowNodeConfiguration").add("GuardrailConfiguration", (Object)this.guardrailConfiguration()).add("InferenceConfiguration", (Object)this.inferenceConfiguration()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("ModelId", (Object)this.modelId()).add("NumberOfResults", (Object)this.numberOfResults()).add("OrchestrationConfiguration", (Object)this.orchestrationConfiguration()).add("PromptTemplate", (Object)this.promptTemplate()).add("RerankingConfiguration", (Object)this.rerankingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "guardrailConfiguration": {
                return Optional.ofNullable(clazz.cast(this.guardrailConfiguration()));
            }
            case "inferenceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inferenceConfiguration()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "numberOfResults": {
                return Optional.ofNullable(clazz.cast(this.numberOfResults()));
            }
            case "orchestrationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.orchestrationConfiguration()));
            }
            case "promptTemplate": {
                return Optional.ofNullable(clazz.cast(this.promptTemplate()));
            }
            case "rerankingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.rerankingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("guardrailConfiguration", GUARDRAIL_CONFIGURATION_FIELD);
        map.put("inferenceConfiguration", INFERENCE_CONFIGURATION_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("modelId", MODEL_ID_FIELD);
        map.put("numberOfResults", NUMBER_OF_RESULTS_FIELD);
        map.put("orchestrationConfiguration", ORCHESTRATION_CONFIGURATION_FIELD);
        map.put("promptTemplate", PROMPT_TEMPLATE_FIELD);
        map.put("rerankingConfiguration", RERANKING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseFlowNodeConfiguration, T> g) {
        return obj -> g.apply((KnowledgeBaseFlowNodeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GuardrailConfiguration guardrailConfiguration;
        private PromptInferenceConfiguration inferenceConfiguration;
        private String knowledgeBaseId;
        private String modelId;
        private Integer numberOfResults;
        private KnowledgeBaseOrchestrationConfiguration orchestrationConfiguration;
        private KnowledgeBasePromptTemplate promptTemplate;
        private VectorSearchRerankingConfiguration rerankingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseFlowNodeConfiguration model) {
            this.guardrailConfiguration(model.guardrailConfiguration);
            this.inferenceConfiguration(model.inferenceConfiguration);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.modelId(model.modelId);
            this.numberOfResults(model.numberOfResults);
            this.orchestrationConfiguration(model.orchestrationConfiguration);
            this.promptTemplate(model.promptTemplate);
            this.rerankingConfiguration(model.rerankingConfiguration);
        }

        public final GuardrailConfiguration.Builder getGuardrailConfiguration() {
            return this.guardrailConfiguration != null ? this.guardrailConfiguration.toBuilder() : null;
        }

        public final void setGuardrailConfiguration(GuardrailConfiguration.BuilderImpl guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration != null ? guardrailConfiguration.build() : null;
        }

        @Override
        public final Builder guardrailConfiguration(GuardrailConfiguration guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration;
            return this;
        }

        public final PromptInferenceConfiguration.Builder getInferenceConfiguration() {
            return this.inferenceConfiguration != null ? this.inferenceConfiguration.toBuilder() : null;
        }

        public final void setInferenceConfiguration(PromptInferenceConfiguration.BuilderImpl inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration != null ? inferenceConfiguration.build() : null;
        }

        @Override
        public final Builder inferenceConfiguration(PromptInferenceConfiguration inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final Integer getNumberOfResults() {
            return this.numberOfResults;
        }

        public final void setNumberOfResults(Integer numberOfResults) {
            this.numberOfResults = numberOfResults;
        }

        @Override
        public final Builder numberOfResults(Integer numberOfResults) {
            this.numberOfResults = numberOfResults;
            return this;
        }

        public final KnowledgeBaseOrchestrationConfiguration.Builder getOrchestrationConfiguration() {
            return this.orchestrationConfiguration != null ? this.orchestrationConfiguration.toBuilder() : null;
        }

        public final void setOrchestrationConfiguration(KnowledgeBaseOrchestrationConfiguration.BuilderImpl orchestrationConfiguration) {
            this.orchestrationConfiguration = orchestrationConfiguration != null ? orchestrationConfiguration.build() : null;
        }

        @Override
        public final Builder orchestrationConfiguration(KnowledgeBaseOrchestrationConfiguration orchestrationConfiguration) {
            this.orchestrationConfiguration = orchestrationConfiguration;
            return this;
        }

        public final KnowledgeBasePromptTemplate.Builder getPromptTemplate() {
            return this.promptTemplate != null ? this.promptTemplate.toBuilder() : null;
        }

        public final void setPromptTemplate(KnowledgeBasePromptTemplate.BuilderImpl promptTemplate) {
            this.promptTemplate = promptTemplate != null ? promptTemplate.build() : null;
        }

        @Override
        public final Builder promptTemplate(KnowledgeBasePromptTemplate promptTemplate) {
            this.promptTemplate = promptTemplate;
            return this;
        }

        public final VectorSearchRerankingConfiguration.Builder getRerankingConfiguration() {
            return this.rerankingConfiguration != null ? this.rerankingConfiguration.toBuilder() : null;
        }

        public final void setRerankingConfiguration(VectorSearchRerankingConfiguration.BuilderImpl rerankingConfiguration) {
            this.rerankingConfiguration = rerankingConfiguration != null ? rerankingConfiguration.build() : null;
        }

        @Override
        public final Builder rerankingConfiguration(VectorSearchRerankingConfiguration rerankingConfiguration) {
            this.rerankingConfiguration = rerankingConfiguration;
            return this;
        }

        public KnowledgeBaseFlowNodeConfiguration build() {
            return new KnowledgeBaseFlowNodeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KnowledgeBaseFlowNodeConfiguration> {
        public Builder guardrailConfiguration(GuardrailConfiguration var1);

        default public Builder guardrailConfiguration(Consumer<GuardrailConfiguration.Builder> guardrailConfiguration) {
            return this.guardrailConfiguration((GuardrailConfiguration)((GuardrailConfiguration.Builder)GuardrailConfiguration.builder().applyMutation(guardrailConfiguration)).build());
        }

        public Builder inferenceConfiguration(PromptInferenceConfiguration var1);

        default public Builder inferenceConfiguration(Consumer<PromptInferenceConfiguration.Builder> inferenceConfiguration) {
            return this.inferenceConfiguration((PromptInferenceConfiguration)((PromptInferenceConfiguration.Builder)PromptInferenceConfiguration.builder().applyMutation(inferenceConfiguration)).build());
        }

        public Builder knowledgeBaseId(String var1);

        public Builder modelId(String var1);

        public Builder numberOfResults(Integer var1);

        public Builder orchestrationConfiguration(KnowledgeBaseOrchestrationConfiguration var1);

        default public Builder orchestrationConfiguration(Consumer<KnowledgeBaseOrchestrationConfiguration.Builder> orchestrationConfiguration) {
            return this.orchestrationConfiguration((KnowledgeBaseOrchestrationConfiguration)((KnowledgeBaseOrchestrationConfiguration.Builder)KnowledgeBaseOrchestrationConfiguration.builder().applyMutation(orchestrationConfiguration)).build());
        }

        public Builder promptTemplate(KnowledgeBasePromptTemplate var1);

        default public Builder promptTemplate(Consumer<KnowledgeBasePromptTemplate.Builder> promptTemplate) {
            return this.promptTemplate((KnowledgeBasePromptTemplate)((KnowledgeBasePromptTemplate.Builder)KnowledgeBasePromptTemplate.builder().applyMutation(promptTemplate)).build());
        }

        public Builder rerankingConfiguration(VectorSearchRerankingConfiguration var1);

        default public Builder rerankingConfiguration(Consumer<VectorSearchRerankingConfiguration.Builder> rerankingConfiguration) {
            return this.rerankingConfiguration((VectorSearchRerankingConfiguration)((VectorSearchRerankingConfiguration.Builder)VectorSearchRerankingConfiguration.builder().applyMutation(rerankingConfiguration)).build());
        }
    }
}

