/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The vector configuration details for the Bedrock embeddings model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BedrockEmbeddingModelConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BedrockEmbeddingModelConfiguration.Builder, BedrockEmbeddingModelConfiguration> {
    private static final SdkField<Integer> DIMENSIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("dimensions").getter(getter(BedrockEmbeddingModelConfiguration::dimensions))
            .setter(setter(Builder::dimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimensions").build()).build();

    private static final SdkField<String> EMBEDDING_DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("embeddingDataType").getter(getter(BedrockEmbeddingModelConfiguration::embeddingDataTypeAsString))
            .setter(setter(Builder::embeddingDataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("embeddingDataType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD,
            EMBEDDING_DATA_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer dimensions;

    private final String embeddingDataType;

    private BedrockEmbeddingModelConfiguration(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.embeddingDataType = builder.embeddingDataType;
    }

    /**
     * <p>
     * The dimensions details for the vector configuration used on the Bedrock embeddings model.
     * </p>
     * 
     * @return The dimensions details for the vector configuration used on the Bedrock embeddings model.
     */
    public final Integer dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The data type for the vectors when using a model to convert text into vector embeddings. The model must support
     * the specified data type for vector embeddings. Floating-point (float32) is the default data type, and is
     * supported by most models for vector embeddings. See <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-supported.html">Supported embeddings
     * models</a> for information on the available models and their vector data types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #embeddingDataType}
     * will return {@link EmbeddingDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #embeddingDataTypeAsString}.
     * </p>
     * 
     * @return The data type for the vectors when using a model to convert text into vector embeddings. The model must
     *         support the specified data type for vector embeddings. Floating-point (float32) is the default data type,
     *         and is supported by most models for vector embeddings. See <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-supported.html">Supported
     *         embeddings models</a> for information on the available models and their vector data types.
     * @see EmbeddingDataType
     */
    public final EmbeddingDataType embeddingDataType() {
        return EmbeddingDataType.fromValue(embeddingDataType);
    }

    /**
     * <p>
     * The data type for the vectors when using a model to convert text into vector embeddings. The model must support
     * the specified data type for vector embeddings. Floating-point (float32) is the default data type, and is
     * supported by most models for vector embeddings. See <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-supported.html">Supported embeddings
     * models</a> for information on the available models and their vector data types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #embeddingDataType}
     * will return {@link EmbeddingDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #embeddingDataTypeAsString}.
     * </p>
     * 
     * @return The data type for the vectors when using a model to convert text into vector embeddings. The model must
     *         support the specified data type for vector embeddings. Floating-point (float32) is the default data type,
     *         and is supported by most models for vector embeddings. See <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-supported.html">Supported
     *         embeddings models</a> for information on the available models and their vector data types.
     * @see EmbeddingDataType
     */
    public final String embeddingDataTypeAsString() {
        return embeddingDataType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(embeddingDataTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BedrockEmbeddingModelConfiguration)) {
            return false;
        }
        BedrockEmbeddingModelConfiguration other = (BedrockEmbeddingModelConfiguration) obj;
        return Objects.equals(dimensions(), other.dimensions())
                && Objects.equals(embeddingDataTypeAsString(), other.embeddingDataTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BedrockEmbeddingModelConfiguration").add("Dimensions", dimensions())
                .add("EmbeddingDataType", embeddingDataTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "embeddingDataType":
            return Optional.ofNullable(clazz.cast(embeddingDataTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dimensions", DIMENSIONS_FIELD);
        map.put("embeddingDataType", EMBEDDING_DATA_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BedrockEmbeddingModelConfiguration, T> g) {
        return obj -> g.apply((BedrockEmbeddingModelConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BedrockEmbeddingModelConfiguration> {
        /**
         * <p>
         * The dimensions details for the vector configuration used on the Bedrock embeddings model.
         * </p>
         * 
         * @param dimensions
         *        The dimensions details for the vector configuration used on the Bedrock embeddings model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Integer dimensions);

        /**
         * <p>
         * The data type for the vectors when using a model to convert text into vector embeddings. The model must
         * support the specified data type for vector embeddings. Floating-point (float32) is the default data type, and
         * is supported by most models for vector embeddings. See <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-supported.html">Supported
         * embeddings models</a> for information on the available models and their vector data types.
         * </p>
         * 
         * @param embeddingDataType
         *        The data type for the vectors when using a model to convert text into vector embeddings. The model
         *        must support the specified data type for vector embeddings. Floating-point (float32) is the default
         *        data type, and is supported by most models for vector embeddings. See <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-supported.html">Supported
         *        embeddings models</a> for information on the available models and their vector data types.
         * @see EmbeddingDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmbeddingDataType
         */
        Builder embeddingDataType(String embeddingDataType);

        /**
         * <p>
         * The data type for the vectors when using a model to convert text into vector embeddings. The model must
         * support the specified data type for vector embeddings. Floating-point (float32) is the default data type, and
         * is supported by most models for vector embeddings. See <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-supported.html">Supported
         * embeddings models</a> for information on the available models and their vector data types.
         * </p>
         * 
         * @param embeddingDataType
         *        The data type for the vectors when using a model to convert text into vector embeddings. The model
         *        must support the specified data type for vector embeddings. Floating-point (float32) is the default
         *        data type, and is supported by most models for vector embeddings. See <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-supported.html">Supported
         *        embeddings models</a> for information on the available models and their vector data types.
         * @see EmbeddingDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmbeddingDataType
         */
        Builder embeddingDataType(EmbeddingDataType embeddingDataType);
    }

    static final class BuilderImpl implements Builder {
        private Integer dimensions;

        private String embeddingDataType;

        private BuilderImpl() {
        }

        private BuilderImpl(BedrockEmbeddingModelConfiguration model) {
            dimensions(model.dimensions);
            embeddingDataType(model.embeddingDataType);
        }

        public final Integer getDimensions() {
            return dimensions;
        }

        public final void setDimensions(Integer dimensions) {
            this.dimensions = dimensions;
        }

        @Override
        public final Builder dimensions(Integer dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final String getEmbeddingDataType() {
            return embeddingDataType;
        }

        public final void setEmbeddingDataType(String embeddingDataType) {
            this.embeddingDataType = embeddingDataType;
        }

        @Override
        public final Builder embeddingDataType(String embeddingDataType) {
            this.embeddingDataType = embeddingDataType;
            return this;
        }

        @Override
        public final Builder embeddingDataType(EmbeddingDataType embeddingDataType) {
            this.embeddingDataType(embeddingDataType == null ? null : embeddingDataType.toString());
            return this;
        }

        @Override
        public BedrockEmbeddingModelConfiguration build() {
            return new BedrockEmbeddingModelConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
