/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFlowAliasRequest extends BedrockAgentRequest implements
        ToCopyableBuilder<CreateFlowAliasRequest.Builder, CreateFlowAliasRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateFlowAliasRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<FlowAliasConcurrencyConfiguration> CONCURRENCY_CONFIGURATION_FIELD = SdkField
            .<FlowAliasConcurrencyConfiguration> builder(MarshallingType.SDK_POJO).memberName("concurrencyConfiguration")
            .getter(getter(CreateFlowAliasRequest::concurrencyConfiguration)).setter(setter(Builder::concurrencyConfiguration))
            .constructor(FlowAliasConcurrencyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("concurrencyConfiguration").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateFlowAliasRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> FLOW_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowIdentifier").getter(getter(CreateFlowAliasRequest::flowIdentifier))
            .setter(setter(Builder::flowIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowIdentifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateFlowAliasRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<FlowAliasRoutingConfigurationListItem>> ROUTING_CONFIGURATION_FIELD = SdkField
            .<List<FlowAliasRoutingConfigurationListItem>> builder(MarshallingType.LIST)
            .memberName("routingConfiguration")
            .getter(getter(CreateFlowAliasRequest::routingConfiguration))
            .setter(setter(Builder::routingConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FlowAliasRoutingConfigurationListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(FlowAliasRoutingConfigurationListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateFlowAliasRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            CONCURRENCY_CONFIGURATION_FIELD, DESCRIPTION_FIELD, FLOW_IDENTIFIER_FIELD, NAME_FIELD, ROUTING_CONFIGURATION_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final FlowAliasConcurrencyConfiguration concurrencyConfiguration;

    private final String description;

    private final String flowIdentifier;

    private final String name;

    private final List<FlowAliasRoutingConfigurationListItem> routingConfiguration;

    private final Map<String, String> tags;

    private CreateFlowAliasRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.concurrencyConfiguration = builder.concurrencyConfiguration;
        this.description = builder.description;
        this.flowIdentifier = builder.flowIdentifier;
        this.name = builder.name;
        this.routingConfiguration = builder.routingConfiguration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token
     * matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
     *         this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The configuration that specifies how nodes in the flow are executed in parallel.
     * </p>
     * 
     * @return The configuration that specifies how nodes in the flow are executed in parallel.
     */
    public final FlowAliasConcurrencyConfiguration concurrencyConfiguration() {
        return concurrencyConfiguration;
    }

    /**
     * <p>
     * A description for the alias.
     * </p>
     * 
     * @return A description for the alias.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier of the flow for which to create an alias.
     * </p>
     * 
     * @return The unique identifier of the flow for which to create an alias.
     */
    public final String flowIdentifier() {
        return flowIdentifier;
    }

    /**
     * <p>
     * A name for the alias.
     * </p>
     * 
     * @return A name for the alias.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the RoutingConfiguration property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRoutingConfiguration() {
        return routingConfiguration != null && !(routingConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information about the version to which to map the alias.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutingConfiguration} method.
     * </p>
     * 
     * @return Contains information about the version to which to map the alias.
     */
    public final List<FlowAliasRoutingConfigurationListItem> routingConfiguration() {
        return routingConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Any tags that you want to attach to the alias of the flow. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging resources in Amazon Bedrock</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Any tags that you want to attach to the alias of the flow. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging resources in Amazon
     *         Bedrock</a>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(concurrencyConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(flowIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutingConfiguration() ? routingConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFlowAliasRequest)) {
            return false;
        }
        CreateFlowAliasRequest other = (CreateFlowAliasRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(concurrencyConfiguration(), other.concurrencyConfiguration())
                && Objects.equals(description(), other.description()) && Objects.equals(flowIdentifier(), other.flowIdentifier())
                && Objects.equals(name(), other.name()) && hasRoutingConfiguration() == other.hasRoutingConfiguration()
                && Objects.equals(routingConfiguration(), other.routingConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFlowAliasRequest").add("ClientToken", clientToken())
                .add("ConcurrencyConfiguration", concurrencyConfiguration()).add("Description", description())
                .add("FlowIdentifier", flowIdentifier()).add("Name", name())
                .add("RoutingConfiguration", hasRoutingConfiguration() ? routingConfiguration() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "concurrencyConfiguration":
            return Optional.ofNullable(clazz.cast(concurrencyConfiguration()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "flowIdentifier":
            return Optional.ofNullable(clazz.cast(flowIdentifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "routingConfiguration":
            return Optional.ofNullable(clazz.cast(routingConfiguration()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("concurrencyConfiguration", CONCURRENCY_CONFIGURATION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("flowIdentifier", FLOW_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("routingConfiguration", ROUTING_CONFIGURATION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFlowAliasRequest, T> g) {
        return obj -> g.apply((CreateFlowAliasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFlowAliasRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this
         * token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
         *        this token matches a previous request, Amazon Bedrock ignores the request, but does not return an
         *        error. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The configuration that specifies how nodes in the flow are executed in parallel.
         * </p>
         * 
         * @param concurrencyConfiguration
         *        The configuration that specifies how nodes in the flow are executed in parallel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder concurrencyConfiguration(FlowAliasConcurrencyConfiguration concurrencyConfiguration);

        /**
         * <p>
         * The configuration that specifies how nodes in the flow are executed in parallel.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link FlowAliasConcurrencyConfiguration.Builder} avoiding the need to create one manually via
         * {@link FlowAliasConcurrencyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowAliasConcurrencyConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #concurrencyConfiguration(FlowAliasConcurrencyConfiguration)}.
         * 
         * @param concurrencyConfiguration
         *        a consumer that will call methods on {@link FlowAliasConcurrencyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #concurrencyConfiguration(FlowAliasConcurrencyConfiguration)
         */
        default Builder concurrencyConfiguration(Consumer<FlowAliasConcurrencyConfiguration.Builder> concurrencyConfiguration) {
            return concurrencyConfiguration(FlowAliasConcurrencyConfiguration.builder().applyMutation(concurrencyConfiguration)
                    .build());
        }

        /**
         * <p>
         * A description for the alias.
         * </p>
         * 
         * @param description
         *        A description for the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier of the flow for which to create an alias.
         * </p>
         * 
         * @param flowIdentifier
         *        The unique identifier of the flow for which to create an alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowIdentifier(String flowIdentifier);

        /**
         * <p>
         * A name for the alias.
         * </p>
         * 
         * @param name
         *        A name for the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Contains information about the version to which to map the alias.
         * </p>
         * 
         * @param routingConfiguration
         *        Contains information about the version to which to map the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingConfiguration(Collection<FlowAliasRoutingConfigurationListItem> routingConfiguration);

        /**
         * <p>
         * Contains information about the version to which to map the alias.
         * </p>
         * 
         * @param routingConfiguration
         *        Contains information about the version to which to map the alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingConfiguration(FlowAliasRoutingConfigurationListItem... routingConfiguration);

        /**
         * <p>
         * Contains information about the version to which to map the alias.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.FlowAliasRoutingConfigurationListItem.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.FlowAliasRoutingConfigurationListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.FlowAliasRoutingConfigurationListItem.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #routingConfiguration(List<FlowAliasRoutingConfigurationListItem>)}.
         * 
         * @param routingConfiguration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.FlowAliasRoutingConfigurationListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routingConfiguration(java.util.Collection<FlowAliasRoutingConfigurationListItem>)
         */
        Builder routingConfiguration(Consumer<FlowAliasRoutingConfigurationListItem.Builder>... routingConfiguration);

        /**
         * <p>
         * Any tags that you want to attach to the alias of the flow. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging resources in Amazon
         * Bedrock</a>.
         * </p>
         * 
         * @param tags
         *        Any tags that you want to attach to the alias of the flow. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging resources in Amazon
         *        Bedrock</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRequest.BuilderImpl implements Builder {
        private String clientToken;

        private FlowAliasConcurrencyConfiguration concurrencyConfiguration;

        private String description;

        private String flowIdentifier;

        private String name;

        private List<FlowAliasRoutingConfigurationListItem> routingConfiguration = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFlowAliasRequest model) {
            super(model);
            clientToken(model.clientToken);
            concurrencyConfiguration(model.concurrencyConfiguration);
            description(model.description);
            flowIdentifier(model.flowIdentifier);
            name(model.name);
            routingConfiguration(model.routingConfiguration);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final FlowAliasConcurrencyConfiguration.Builder getConcurrencyConfiguration() {
            return concurrencyConfiguration != null ? concurrencyConfiguration.toBuilder() : null;
        }

        public final void setConcurrencyConfiguration(FlowAliasConcurrencyConfiguration.BuilderImpl concurrencyConfiguration) {
            this.concurrencyConfiguration = concurrencyConfiguration != null ? concurrencyConfiguration.build() : null;
        }

        @Override
        public final Builder concurrencyConfiguration(FlowAliasConcurrencyConfiguration concurrencyConfiguration) {
            this.concurrencyConfiguration = concurrencyConfiguration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFlowIdentifier() {
            return flowIdentifier;
        }

        public final void setFlowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
        }

        @Override
        public final Builder flowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<FlowAliasRoutingConfigurationListItem.Builder> getRoutingConfiguration() {
            List<FlowAliasRoutingConfigurationListItem.Builder> result = FlowAliasRoutingConfigurationCopier
                    .copyToBuilder(this.routingConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutingConfiguration(
                Collection<FlowAliasRoutingConfigurationListItem.BuilderImpl> routingConfiguration) {
            this.routingConfiguration = FlowAliasRoutingConfigurationCopier.copyFromBuilder(routingConfiguration);
        }

        @Override
        public final Builder routingConfiguration(Collection<FlowAliasRoutingConfigurationListItem> routingConfiguration) {
            this.routingConfiguration = FlowAliasRoutingConfigurationCopier.copy(routingConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(FlowAliasRoutingConfigurationListItem... routingConfiguration) {
            routingConfiguration(Arrays.asList(routingConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(Consumer<FlowAliasRoutingConfigurationListItem.Builder>... routingConfiguration) {
            routingConfiguration(Stream.of(routingConfiguration)
                    .map(c -> FlowAliasRoutingConfigurationListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFlowAliasRequest build() {
            return new CreateFlowAliasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
