/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAgentCollaboratorRequest extends BedrockAgentRequest implements
        ToCopyableBuilder<GetAgentCollaboratorRequest.Builder, GetAgentCollaboratorRequest> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(GetAgentCollaboratorRequest::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentId").build()).build();

    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentVersion").getter(getter(GetAgentCollaboratorRequest::agentVersion))
            .setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentVersion").build()).build();

    private static final SdkField<String> COLLABORATOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaboratorId").getter(getter(GetAgentCollaboratorRequest::collaboratorId))
            .setter(setter(Builder::collaboratorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("collaboratorId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD,
            AGENT_VERSION_FIELD, COLLABORATOR_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String agentId;

    private final String agentVersion;

    private final String collaboratorId;

    private GetAgentCollaboratorRequest(BuilderImpl builder) {
        super(builder);
        this.agentId = builder.agentId;
        this.agentVersion = builder.agentVersion;
        this.collaboratorId = builder.collaboratorId;
    }

    /**
     * <p>
     * The agent's ID.
     * </p>
     * 
     * @return The agent's ID.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * The agent's version.
     * </p>
     * 
     * @return The agent's version.
     */
    public final String agentVersion() {
        return agentVersion;
    }

    /**
     * <p>
     * The collaborator's ID.
     * </p>
     * 
     * @return The collaborator's ID.
     */
    public final String collaboratorId() {
        return collaboratorId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(collaboratorId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAgentCollaboratorRequest)) {
            return false;
        }
        GetAgentCollaboratorRequest other = (GetAgentCollaboratorRequest) obj;
        return Objects.equals(agentId(), other.agentId()) && Objects.equals(agentVersion(), other.agentVersion())
                && Objects.equals(collaboratorId(), other.collaboratorId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAgentCollaboratorRequest").add("AgentId", agentId()).add("AgentVersion", agentVersion())
                .add("CollaboratorId", collaboratorId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "agentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        case "collaboratorId":
            return Optional.ofNullable(clazz.cast(collaboratorId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentId", AGENT_ID_FIELD);
        map.put("agentVersion", AGENT_VERSION_FIELD);
        map.put("collaboratorId", COLLABORATOR_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAgentCollaboratorRequest, T> g) {
        return obj -> g.apply((GetAgentCollaboratorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetAgentCollaboratorRequest> {
        /**
         * <p>
         * The agent's ID.
         * </p>
         * 
         * @param agentId
         *        The agent's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * The agent's version.
         * </p>
         * 
         * @param agentVersion
         *        The agent's version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        /**
         * <p>
         * The collaborator's ID.
         * </p>
         * 
         * @param collaboratorId
         *        The collaborator's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaboratorId(String collaboratorId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRequest.BuilderImpl implements Builder {
        private String agentId;

        private String agentVersion;

        private String collaboratorId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAgentCollaboratorRequest model) {
            super(model);
            agentId(model.agentId);
            agentVersion(model.agentVersion);
            collaboratorId(model.collaboratorId);
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getCollaboratorId() {
            return collaboratorId;
        }

        public final void setCollaboratorId(String collaboratorId) {
            this.collaboratorId = collaboratorId;
        }

        @Override
        public final Builder collaboratorId(String collaboratorId) {
            this.collaboratorId = collaboratorId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAgentCollaboratorRequest build() {
            return new GetAgentCollaboratorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
