/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAgentVersionsResponse extends BedrockAgentResponse implements
        ToCopyableBuilder<ListAgentVersionsResponse.Builder, ListAgentVersionsResponse> {
    private static final SdkField<List<AgentVersionSummary>> AGENT_VERSION_SUMMARIES_FIELD = SdkField
            .<List<AgentVersionSummary>> builder(MarshallingType.LIST)
            .memberName("agentVersionSummaries")
            .getter(getter(ListAgentVersionsResponse::agentVersionSummaries))
            .setter(setter(Builder::agentVersionSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentVersionSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AgentVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AgentVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAgentVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_VERSION_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AgentVersionSummary> agentVersionSummaries;

    private final String nextToken;

    private ListAgentVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.agentVersionSummaries = builder.agentVersionSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AgentVersionSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAgentVersionSummaries() {
        return agentVersionSummaries != null && !(agentVersionSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects, each of which contains information about a version of the agent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentVersionSummaries} method.
     * </p>
     * 
     * @return A list of objects, each of which contains information about a version of the agent.
     */
    public final List<AgentVersionSummary> agentVersionSummaries() {
        return agentVersionSummaries;
    }

    /**
     * <p>
     * If the total number of results is greater than the <code>maxResults</code> value provided in the request, use
     * this token when making another request in the <code>nextToken</code> field to return the next batch of results.
     * </p>
     * 
     * @return If the total number of results is greater than the <code>maxResults</code> value provided in the request,
     *         use this token when making another request in the <code>nextToken</code> field to return the next batch
     *         of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentVersionSummaries() ? agentVersionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAgentVersionsResponse)) {
            return false;
        }
        ListAgentVersionsResponse other = (ListAgentVersionsResponse) obj;
        return hasAgentVersionSummaries() == other.hasAgentVersionSummaries()
                && Objects.equals(agentVersionSummaries(), other.agentVersionSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAgentVersionsResponse")
                .add("AgentVersionSummaries", hasAgentVersionSummaries() ? agentVersionSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentVersionSummaries":
            return Optional.ofNullable(clazz.cast(agentVersionSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentVersionSummaries", AGENT_VERSION_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAgentVersionsResponse, T> g) {
        return obj -> g.apply((ListAgentVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAgentVersionsResponse> {
        /**
         * <p>
         * A list of objects, each of which contains information about a version of the agent.
         * </p>
         * 
         * @param agentVersionSummaries
         *        A list of objects, each of which contains information about a version of the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersionSummaries(Collection<AgentVersionSummary> agentVersionSummaries);

        /**
         * <p>
         * A list of objects, each of which contains information about a version of the agent.
         * </p>
         * 
         * @param agentVersionSummaries
         *        A list of objects, each of which contains information about a version of the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersionSummaries(AgentVersionSummary... agentVersionSummaries);

        /**
         * <p>
         * A list of objects, each of which contains information about a version of the agent.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.AgentVersionSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.AgentVersionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.AgentVersionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #agentVersionSummaries(List<AgentVersionSummary>)}.
         * 
         * @param agentVersionSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.AgentVersionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentVersionSummaries(java.util.Collection<AgentVersionSummary>)
         */
        Builder agentVersionSummaries(Consumer<AgentVersionSummary.Builder>... agentVersionSummaries);

        /**
         * <p>
         * If the total number of results is greater than the <code>maxResults</code> value provided in the request, use
         * this token when making another request in the <code>nextToken</code> field to return the next batch of
         * results.
         * </p>
         * 
         * @param nextToken
         *        If the total number of results is greater than the <code>maxResults</code> value provided in the
         *        request, use this token when making another request in the <code>nextToken</code> field to return the
         *        next batch of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BedrockAgentResponse.BuilderImpl implements Builder {
        private List<AgentVersionSummary> agentVersionSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAgentVersionsResponse model) {
            super(model);
            agentVersionSummaries(model.agentVersionSummaries);
            nextToken(model.nextToken);
        }

        public final List<AgentVersionSummary.Builder> getAgentVersionSummaries() {
            List<AgentVersionSummary.Builder> result = AgentVersionSummariesCopier.copyToBuilder(this.agentVersionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgentVersionSummaries(Collection<AgentVersionSummary.BuilderImpl> agentVersionSummaries) {
            this.agentVersionSummaries = AgentVersionSummariesCopier.copyFromBuilder(agentVersionSummaries);
        }

        @Override
        public final Builder agentVersionSummaries(Collection<AgentVersionSummary> agentVersionSummaries) {
            this.agentVersionSummaries = AgentVersionSummariesCopier.copy(agentVersionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentVersionSummaries(AgentVersionSummary... agentVersionSummaries) {
            agentVersionSummaries(Arrays.asList(agentVersionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentVersionSummaries(Consumer<AgentVersionSummary.Builder>... agentVersionSummaries) {
            agentVersionSummaries(Stream.of(agentVersionSummaries)
                    .map(c -> AgentVersionSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAgentVersionsResponse build() {
            return new ListAgentVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
