/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a flow that contains multiple <code>LoopInput</code> nodes in a DoWhile loop.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultipleLoopInputNodesFlowValidationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<MultipleLoopInputNodesFlowValidationDetails.Builder, MultipleLoopInputNodesFlowValidationDetails> {
    private static final SdkField<String> LOOP_NODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("loopNode").getter(getter(MultipleLoopInputNodesFlowValidationDetails::loopNode))
            .setter(setter(Builder::loopNode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loopNode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOOP_NODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String loopNode;

    private MultipleLoopInputNodesFlowValidationDetails(BuilderImpl builder) {
        this.loopNode = builder.loopNode;
    }

    /**
     * <p>
     * The DoWhile loop in a flow that contains multiple <code>LoopInput</code> nodes.
     * </p>
     * 
     * @return The DoWhile loop in a flow that contains multiple <code>LoopInput</code> nodes.
     */
    public final String loopNode() {
        return loopNode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(loopNode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultipleLoopInputNodesFlowValidationDetails)) {
            return false;
        }
        MultipleLoopInputNodesFlowValidationDetails other = (MultipleLoopInputNodesFlowValidationDetails) obj;
        return Objects.equals(loopNode(), other.loopNode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MultipleLoopInputNodesFlowValidationDetails").add("LoopNode", loopNode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "loopNode":
            return Optional.ofNullable(clazz.cast(loopNode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("loopNode", LOOP_NODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MultipleLoopInputNodesFlowValidationDetails, T> g) {
        return obj -> g.apply((MultipleLoopInputNodesFlowValidationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultipleLoopInputNodesFlowValidationDetails> {
        /**
         * <p>
         * The DoWhile loop in a flow that contains multiple <code>LoopInput</code> nodes.
         * </p>
         * 
         * @param loopNode
         *        The DoWhile loop in a flow that contains multiple <code>LoopInput</code> nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loopNode(String loopNode);
    }

    static final class BuilderImpl implements Builder {
        private String loopNode;

        private BuilderImpl() {
        }

        private BuilderImpl(MultipleLoopInputNodesFlowValidationDetails model) {
            loopNode(model.loopNode);
        }

        public final String getLoopNode() {
            return loopNode;
        }

        public final void setLoopNode(String loopNode) {
            this.loopNode = loopNode;
        }

        @Override
        public final Builder loopNode(String loopNode) {
            this.loopNode = loopNode;
            return this;
        }

        @Override
        public MultipleLoopInputNodesFlowValidationDetails build() {
            return new MultipleLoopInputNodesFlowValidationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
