/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for a prompt node in the flow. You can use a prompt from Prompt management or you can define
 * one in this node. If the prompt contains variables, the inputs into this node will fill in the variables. The output
 * from this node is the response generated by the model. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in a flow</a> in the Amazon
 * Bedrock User Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PromptFlowNodeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PromptFlowNodeConfiguration.Builder, PromptFlowNodeConfiguration> {
    private static final SdkField<GuardrailConfiguration> GUARDRAIL_CONFIGURATION_FIELD = SdkField
            .<GuardrailConfiguration> builder(MarshallingType.SDK_POJO).memberName("guardrailConfiguration")
            .getter(getter(PromptFlowNodeConfiguration::guardrailConfiguration)).setter(setter(Builder::guardrailConfiguration))
            .constructor(GuardrailConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailConfiguration").build())
            .build();

    private static final SdkField<PromptFlowNodeSourceConfiguration> SOURCE_CONFIGURATION_FIELD = SdkField
            .<PromptFlowNodeSourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("sourceConfiguration")
            .getter(getter(PromptFlowNodeConfiguration::sourceConfiguration)).setter(setter(Builder::sourceConfiguration))
            .constructor(PromptFlowNodeSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAIL_CONFIGURATION_FIELD,
            SOURCE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GuardrailConfiguration guardrailConfiguration;

    private final PromptFlowNodeSourceConfiguration sourceConfiguration;

    private PromptFlowNodeConfiguration(BuilderImpl builder) {
        this.guardrailConfiguration = builder.guardrailConfiguration;
        this.sourceConfiguration = builder.sourceConfiguration;
    }

    /**
     * <p>
     * Contains configurations for a guardrail to apply to the prompt in this node and the response generated from it.
     * </p>
     * 
     * @return Contains configurations for a guardrail to apply to the prompt in this node and the response generated
     *         from it.
     */
    public final GuardrailConfiguration guardrailConfiguration() {
        return guardrailConfiguration;
    }

    /**
     * <p>
     * Specifies whether the prompt is from Prompt management or defined inline.
     * </p>
     * 
     * @return Specifies whether the prompt is from Prompt management or defined inline.
     */
    public final PromptFlowNodeSourceConfiguration sourceConfiguration() {
        return sourceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(guardrailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(sourceConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PromptFlowNodeConfiguration)) {
            return false;
        }
        PromptFlowNodeConfiguration other = (PromptFlowNodeConfiguration) obj;
        return Objects.equals(guardrailConfiguration(), other.guardrailConfiguration())
                && Objects.equals(sourceConfiguration(), other.sourceConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PromptFlowNodeConfiguration").add("GuardrailConfiguration", guardrailConfiguration())
                .add("SourceConfiguration", sourceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "guardrailConfiguration":
            return Optional.ofNullable(clazz.cast(guardrailConfiguration()));
        case "sourceConfiguration":
            return Optional.ofNullable(clazz.cast(sourceConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("guardrailConfiguration", GUARDRAIL_CONFIGURATION_FIELD);
        map.put("sourceConfiguration", SOURCE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PromptFlowNodeConfiguration, T> g) {
        return obj -> g.apply((PromptFlowNodeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PromptFlowNodeConfiguration> {
        /**
         * <p>
         * Contains configurations for a guardrail to apply to the prompt in this node and the response generated from
         * it.
         * </p>
         * 
         * @param guardrailConfiguration
         *        Contains configurations for a guardrail to apply to the prompt in this node and the response generated
         *        from it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailConfiguration(GuardrailConfiguration guardrailConfiguration);

        /**
         * <p>
         * Contains configurations for a guardrail to apply to the prompt in this node and the response generated from
         * it.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailConfiguration.Builder} avoiding
         * the need to create one manually via {@link GuardrailConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #guardrailConfiguration(GuardrailConfiguration)}.
         * 
         * @param guardrailConfiguration
         *        a consumer that will call methods on {@link GuardrailConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #guardrailConfiguration(GuardrailConfiguration)
         */
        default Builder guardrailConfiguration(Consumer<GuardrailConfiguration.Builder> guardrailConfiguration) {
            return guardrailConfiguration(GuardrailConfiguration.builder().applyMutation(guardrailConfiguration).build());
        }

        /**
         * <p>
         * Specifies whether the prompt is from Prompt management or defined inline.
         * </p>
         * 
         * @param sourceConfiguration
         *        Specifies whether the prompt is from Prompt management or defined inline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceConfiguration(PromptFlowNodeSourceConfiguration sourceConfiguration);

        /**
         * <p>
         * Specifies whether the prompt is from Prompt management or defined inline.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link PromptFlowNodeSourceConfiguration.Builder} avoiding the need to create one manually via
         * {@link PromptFlowNodeSourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptFlowNodeSourceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceConfiguration(PromptFlowNodeSourceConfiguration)}.
         * 
         * @param sourceConfiguration
         *        a consumer that will call methods on {@link PromptFlowNodeSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceConfiguration(PromptFlowNodeSourceConfiguration)
         */
        default Builder sourceConfiguration(Consumer<PromptFlowNodeSourceConfiguration.Builder> sourceConfiguration) {
            return sourceConfiguration(PromptFlowNodeSourceConfiguration.builder().applyMutation(sourceConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GuardrailConfiguration guardrailConfiguration;

        private PromptFlowNodeSourceConfiguration sourceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PromptFlowNodeConfiguration model) {
            guardrailConfiguration(model.guardrailConfiguration);
            sourceConfiguration(model.sourceConfiguration);
        }

        public final GuardrailConfiguration.Builder getGuardrailConfiguration() {
            return guardrailConfiguration != null ? guardrailConfiguration.toBuilder() : null;
        }

        public final void setGuardrailConfiguration(GuardrailConfiguration.BuilderImpl guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration != null ? guardrailConfiguration.build() : null;
        }

        @Override
        public final Builder guardrailConfiguration(GuardrailConfiguration guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration;
            return this;
        }

        public final PromptFlowNodeSourceConfiguration.Builder getSourceConfiguration() {
            return sourceConfiguration != null ? sourceConfiguration.toBuilder() : null;
        }

        public final void setSourceConfiguration(PromptFlowNodeSourceConfiguration.BuilderImpl sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration != null ? sourceConfiguration.build() : null;
        }

        @Override
        public final Builder sourceConfiguration(PromptFlowNodeSourceConfiguration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        @Override
        public PromptFlowNodeConfiguration build() {
            return new PromptFlowNodeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
