/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains specifications for a generative AI resource with which to use the prompt. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-create.html">Create a prompt using
 * Prompt management</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PromptGenAiResource implements SdkPojo, Serializable,
        ToCopyableBuilder<PromptGenAiResource.Builder, PromptGenAiResource> {
    private static final SdkField<PromptAgentResource> AGENT_FIELD = SdkField
            .<PromptAgentResource> builder(MarshallingType.SDK_POJO).memberName("agent")
            .getter(getter(PromptGenAiResource::agent)).setter(setter(Builder::agent)).constructor(PromptAgentResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PromptAgentResource agent;

    private final Type type;

    private PromptGenAiResource(BuilderImpl builder) {
        this.agent = builder.agent;
        this.type = builder.type;
    }

    /**
     * <p>
     * Specifies an Amazon Bedrock agent with which to use the prompt.
     * </p>
     * 
     * @return Specifies an Amazon Bedrock agent with which to use the prompt.
     */
    public final PromptAgentResource agent() {
        return agent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PromptGenAiResource)) {
            return false;
        }
        PromptGenAiResource other = (PromptGenAiResource) obj;
        return Objects.equals(agent(), other.agent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PromptGenAiResource").add("Agent", agent() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agent":
            return Optional.ofNullable(clazz.cast(agent()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #agent()} initialized to the given value.
     *
     * <p>
     * Specifies an Amazon Bedrock agent with which to use the prompt.
     * </p>
     * 
     * @param agent
     *        Specifies an Amazon Bedrock agent with which to use the prompt.
     */
    public static PromptGenAiResource fromAgent(PromptAgentResource agent) {
        return builder().agent(agent).build();
    }

    /**
     * Create an instance of this class with {@link #agent()} initialized to the given value.
     *
     * <p>
     * Specifies an Amazon Bedrock agent with which to use the prompt.
     * </p>
     * 
     * @param agent
     *        Specifies an Amazon Bedrock agent with which to use the prompt.
     */
    public static PromptGenAiResource fromAgent(Consumer<PromptAgentResource.Builder> agent) {
        PromptAgentResource.Builder builder = PromptAgentResource.builder();
        agent.accept(builder);
        return fromAgent(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agent", AGENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PromptGenAiResource, T> g) {
        return obj -> g.apply((PromptGenAiResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PromptGenAiResource> {
        /**
         * <p>
         * Specifies an Amazon Bedrock agent with which to use the prompt.
         * </p>
         * 
         * @param agent
         *        Specifies an Amazon Bedrock agent with which to use the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agent(PromptAgentResource agent);

        /**
         * <p>
         * Specifies an Amazon Bedrock agent with which to use the prompt.
         * </p>
         * This is a convenience method that creates an instance of the {@link PromptAgentResource.Builder} avoiding the
         * need to create one manually via {@link PromptAgentResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptAgentResource.Builder#build()} is called immediately and
         * its result is passed to {@link #agent(PromptAgentResource)}.
         * 
         * @param agent
         *        a consumer that will call methods on {@link PromptAgentResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agent(PromptAgentResource)
         */
        default Builder agent(Consumer<PromptAgentResource.Builder> agent) {
            return agent(PromptAgentResource.builder().applyMutation(agent).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PromptAgentResource agent;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PromptGenAiResource model) {
            agent(model.agent);
        }

        public final PromptAgentResource.Builder getAgent() {
            return agent != null ? agent.toBuilder() : null;
        }

        public final void setAgent(PromptAgentResource.BuilderImpl agent) {
            Object oldValue = this.agent;
            this.agent = agent != null ? agent.build() : null;
            handleUnionValueChange(Type.AGENT, oldValue, this.agent);
        }

        @Override
        public final Builder agent(PromptAgentResource agent) {
            Object oldValue = this.agent;
            this.agent = agent;
            handleUnionValueChange(Type.AGENT, oldValue, this.agent);
            return this;
        }

        @Override
        public PromptGenAiResource build() {
            return new PromptGenAiResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see PromptGenAiResource#type()
     */
    public enum Type {
        AGENT,

        UNKNOWN_TO_SDK_VERSION
    }
}
