/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for a Retrieval node in a flow. This node retrieves data from the Amazon S3 location that you
 * specify and returns it as the output.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrievalFlowNodeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RetrievalFlowNodeConfiguration.Builder, RetrievalFlowNodeConfiguration> {
    private static final SdkField<RetrievalFlowNodeServiceConfiguration> SERVICE_CONFIGURATION_FIELD = SdkField
            .<RetrievalFlowNodeServiceConfiguration> builder(MarshallingType.SDK_POJO).memberName("serviceConfiguration")
            .getter(getter(RetrievalFlowNodeConfiguration::serviceConfiguration)).setter(setter(Builder::serviceConfiguration))
            .constructor(RetrievalFlowNodeServiceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RetrievalFlowNodeServiceConfiguration serviceConfiguration;

    private RetrievalFlowNodeConfiguration(BuilderImpl builder) {
        this.serviceConfiguration = builder.serviceConfiguration;
    }

    /**
     * <p>
     * Contains configurations for the service to use for retrieving data to return as the output from the node.
     * </p>
     * 
     * @return Contains configurations for the service to use for retrieving data to return as the output from the node.
     */
    public final RetrievalFlowNodeServiceConfiguration serviceConfiguration() {
        return serviceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrievalFlowNodeConfiguration)) {
            return false;
        }
        RetrievalFlowNodeConfiguration other = (RetrievalFlowNodeConfiguration) obj;
        return Objects.equals(serviceConfiguration(), other.serviceConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrievalFlowNodeConfiguration").add("ServiceConfiguration", serviceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceConfiguration":
            return Optional.ofNullable(clazz.cast(serviceConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceConfiguration", SERVICE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrievalFlowNodeConfiguration, T> g) {
        return obj -> g.apply((RetrievalFlowNodeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetrievalFlowNodeConfiguration> {
        /**
         * <p>
         * Contains configurations for the service to use for retrieving data to return as the output from the node.
         * </p>
         * 
         * @param serviceConfiguration
         *        Contains configurations for the service to use for retrieving data to return as the output from the
         *        node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceConfiguration(RetrievalFlowNodeServiceConfiguration serviceConfiguration);

        /**
         * <p>
         * Contains configurations for the service to use for retrieving data to return as the output from the node.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RetrievalFlowNodeServiceConfiguration.Builder} avoiding the need to create one manually via
         * {@link RetrievalFlowNodeServiceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetrievalFlowNodeServiceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceConfiguration(RetrievalFlowNodeServiceConfiguration)}.
         * 
         * @param serviceConfiguration
         *        a consumer that will call methods on {@link RetrievalFlowNodeServiceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceConfiguration(RetrievalFlowNodeServiceConfiguration)
         */
        default Builder serviceConfiguration(Consumer<RetrievalFlowNodeServiceConfiguration.Builder> serviceConfiguration) {
            return serviceConfiguration(RetrievalFlowNodeServiceConfiguration.builder().applyMutation(serviceConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RetrievalFlowNodeServiceConfiguration serviceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrievalFlowNodeConfiguration model) {
            serviceConfiguration(model.serviceConfiguration);
        }

        public final RetrievalFlowNodeServiceConfiguration.Builder getServiceConfiguration() {
            return serviceConfiguration != null ? serviceConfiguration.toBuilder() : null;
        }

        public final void setServiceConfiguration(RetrievalFlowNodeServiceConfiguration.BuilderImpl serviceConfiguration) {
            this.serviceConfiguration = serviceConfiguration != null ? serviceConfiguration.build() : null;
        }

        @Override
        public final Builder serviceConfiguration(RetrievalFlowNodeServiceConfiguration serviceConfiguration) {
            this.serviceConfiguration = serviceConfiguration;
            return this;
        }

        @Override
        public RetrievalFlowNodeConfiguration build() {
            return new RetrievalFlowNodeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
