/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopIngestionJobRequest extends BedrockAgentRequest implements
        ToCopyableBuilder<StopIngestionJobRequest.Builder, StopIngestionJobRequest> {
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceId").getter(getter(StopIngestionJobRequest::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("dataSourceId").build()).build();

    private static final SdkField<String> INGESTION_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ingestionJobId").getter(getter(StopIngestionJobRequest::ingestionJobId))
            .setter(setter(Builder::ingestionJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ingestionJobId").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(StopIngestionJobRequest::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ID_FIELD,
            INGESTION_JOB_ID_FIELD, KNOWLEDGE_BASE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dataSourceId;

    private final String ingestionJobId;

    private final String knowledgeBaseId;

    private StopIngestionJobRequest(BuilderImpl builder) {
        super(builder);
        this.dataSourceId = builder.dataSourceId;
        this.ingestionJobId = builder.ingestionJobId;
        this.knowledgeBaseId = builder.knowledgeBaseId;
    }

    /**
     * <p>
     * The unique identifier of the data source for the data ingestion job you want to stop.
     * </p>
     * 
     * @return The unique identifier of the data source for the data ingestion job you want to stop.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * The unique identifier of the data ingestion job you want to stop.
     * </p>
     * 
     * @return The unique identifier of the data ingestion job you want to stop.
     */
    public final String ingestionJobId() {
        return ingestionJobId;
    }

    /**
     * <p>
     * The unique identifier of the knowledge base for the data ingestion job you want to stop.
     * </p>
     * 
     * @return The unique identifier of the knowledge base for the data ingestion job you want to stop.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionJobId());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopIngestionJobRequest)) {
            return false;
        }
        StopIngestionJobRequest other = (StopIngestionJobRequest) obj;
        return Objects.equals(dataSourceId(), other.dataSourceId()) && Objects.equals(ingestionJobId(), other.ingestionJobId())
                && Objects.equals(knowledgeBaseId(), other.knowledgeBaseId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopIngestionJobRequest").add("DataSourceId", dataSourceId())
                .add("IngestionJobId", ingestionJobId()).add("KnowledgeBaseId", knowledgeBaseId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "ingestionJobId":
            return Optional.ofNullable(clazz.cast(ingestionJobId()));
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataSourceId", DATA_SOURCE_ID_FIELD);
        map.put("ingestionJobId", INGESTION_JOB_ID_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopIngestionJobRequest, T> g) {
        return obj -> g.apply((StopIngestionJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentRequest.Builder, SdkPojo, CopyableBuilder<Builder, StopIngestionJobRequest> {
        /**
         * <p>
         * The unique identifier of the data source for the data ingestion job you want to stop.
         * </p>
         * 
         * @param dataSourceId
         *        The unique identifier of the data source for the data ingestion job you want to stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * The unique identifier of the data ingestion job you want to stop.
         * </p>
         * 
         * @param ingestionJobId
         *        The unique identifier of the data ingestion job you want to stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionJobId(String ingestionJobId);

        /**
         * <p>
         * The unique identifier of the knowledge base for the data ingestion job you want to stop.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The unique identifier of the knowledge base for the data ingestion job you want to stop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRequest.BuilderImpl implements Builder {
        private String dataSourceId;

        private String ingestionJobId;

        private String knowledgeBaseId;

        private BuilderImpl() {
        }

        private BuilderImpl(StopIngestionJobRequest model) {
            super(model);
            dataSourceId(model.dataSourceId);
            ingestionJobId(model.ingestionJobId);
            knowledgeBaseId(model.knowledgeBaseId);
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getIngestionJobId() {
            return ingestionJobId;
        }

        public final void setIngestionJobId(String ingestionJobId) {
            this.ingestionJobId = ingestionJobId;
        }

        @Override
        public final Builder ingestionJobId(String ingestionJobId) {
            this.ingestionJobId = ingestionJobId;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopIngestionJobRequest build() {
            return new StopIngestionJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
