/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The definition of the nodes and connections between nodes in the flow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowDefinition implements SdkPojo, Serializable, ToCopyableBuilder<FlowDefinition.Builder, FlowDefinition> {
    private static final SdkField<List<FlowConnection>> CONNECTIONS_FIELD = SdkField
            .<List<FlowConnection>> builder(MarshallingType.LIST)
            .memberName("connections")
            .getter(getter(FlowDefinition::connections))
            .setter(setter(Builder::connections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FlowConnection> builder(MarshallingType.SDK_POJO)
                                            .constructor(FlowConnection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FlowNode>> NODES_FIELD = SdkField
            .<List<FlowNode>> builder(MarshallingType.LIST)
            .memberName("nodes")
            .getter(getter(FlowDefinition::nodes))
            .setter(setter(Builder::nodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FlowNode> builder(MarshallingType.SDK_POJO)
                                            .constructor(FlowNode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CONNECTIONS_FIELD, NODES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<FlowConnection> connections;

    private final List<FlowNode> nodes;

    private FlowDefinition(BuilderImpl builder) {
        this.connections = builder.connections;
        this.nodes = builder.nodes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Connections property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConnections() {
        return connections != null && !(connections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of connection definitions in the flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnections} method.
     * </p>
     * 
     * @return An array of connection definitions in the flow.
     */
    public final List<FlowConnection> connections() {
        return connections;
    }

    /**
     * For responses, this returns true if the service returned a value for the Nodes property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasNodes() {
        return nodes != null && !(nodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of node definitions in the flow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodes} method.
     * </p>
     * 
     * @return An array of node definitions in the flow.
     */
    public final List<FlowNode> nodes() {
        return nodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasConnections() ? connections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNodes() ? nodes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowDefinition)) {
            return false;
        }
        FlowDefinition other = (FlowDefinition) obj;
        return hasConnections() == other.hasConnections() && Objects.equals(connections(), other.connections())
                && hasNodes() == other.hasNodes() && Objects.equals(nodes(), other.nodes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowDefinition").add("Connections", hasConnections() ? connections() : null)
                .add("Nodes", hasNodes() ? nodes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connections":
            return Optional.ofNullable(clazz.cast(connections()));
        case "nodes":
            return Optional.ofNullable(clazz.cast(nodes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connections", CONNECTIONS_FIELD);
        map.put("nodes", NODES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowDefinition, T> g) {
        return obj -> g.apply((FlowDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowDefinition> {
        /**
         * <p>
         * An array of connection definitions in the flow.
         * </p>
         * 
         * @param connections
         *        An array of connection definitions in the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connections(Collection<FlowConnection> connections);

        /**
         * <p>
         * An array of connection definitions in the flow.
         * </p>
         * 
         * @param connections
         *        An array of connection definitions in the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connections(FlowConnection... connections);

        /**
         * <p>
         * An array of connection definitions in the flow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.FlowConnection.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.bedrockagent.model.FlowConnection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.FlowConnection.Builder#build()} is called
         * immediately and its result is passed to {@link #connections(List<FlowConnection>)}.
         * 
         * @param connections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.FlowConnection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connections(java.util.Collection<FlowConnection>)
         */
        Builder connections(Consumer<FlowConnection.Builder>... connections);

        /**
         * <p>
         * An array of node definitions in the flow.
         * </p>
         * 
         * @param nodes
         *        An array of node definitions in the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodes(Collection<FlowNode> nodes);

        /**
         * <p>
         * An array of node definitions in the flow.
         * </p>
         * 
         * @param nodes
         *        An array of node definitions in the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodes(FlowNode... nodes);

        /**
         * <p>
         * An array of node definitions in the flow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.FlowNode.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.bedrockagent.model.FlowNode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.FlowNode.Builder#build()} is called immediately and
         * its result is passed to {@link #nodes(List<FlowNode>)}.
         * 
         * @param nodes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.FlowNode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodes(java.util.Collection<FlowNode>)
         */
        Builder nodes(Consumer<FlowNode.Builder>... nodes);
    }

    static final class BuilderImpl implements Builder {
        private List<FlowConnection> connections = DefaultSdkAutoConstructList.getInstance();

        private List<FlowNode> nodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FlowDefinition model) {
            connections(model.connections);
            nodes(model.nodes);
        }

        public final List<FlowConnection.Builder> getConnections() {
            List<FlowConnection.Builder> result = FlowConnectionsCopier.copyToBuilder(this.connections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnections(Collection<FlowConnection.BuilderImpl> connections) {
            this.connections = FlowConnectionsCopier.copyFromBuilder(connections);
        }

        @Override
        public final Builder connections(Collection<FlowConnection> connections) {
            this.connections = FlowConnectionsCopier.copy(connections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(FlowConnection... connections) {
            connections(Arrays.asList(connections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(Consumer<FlowConnection.Builder>... connections) {
            connections(Stream.of(connections).map(c -> FlowConnection.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<FlowNode.Builder> getNodes() {
            List<FlowNode.Builder> result = FlowNodesCopier.copyToBuilder(this.nodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodes(Collection<FlowNode.BuilderImpl> nodes) {
            this.nodes = FlowNodesCopier.copyFromBuilder(nodes);
        }

        @Override
        public final Builder nodes(Collection<FlowNode> nodes) {
            this.nodes = FlowNodesCopier.copy(nodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(FlowNode... nodes) {
            nodes(Arrays.asList(nodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(Consumer<FlowNode.Builder>... nodes) {
            nodes(Stream.of(nodes).map(c -> FlowNode.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public FlowDefinition build() {
            return new FlowDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
