/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about content defined inline to ingest into a data source. Choose a <code>type</code> and
 * include the field that corresponds to it.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InlineContent implements SdkPojo, Serializable, ToCopyableBuilder<InlineContent.Builder, InlineContent> {
    private static final SdkField<ByteContentDoc> BYTE_CONTENT_FIELD = SdkField
            .<ByteContentDoc> builder(MarshallingType.SDK_POJO).memberName("byteContent")
            .getter(getter(InlineContent::byteContent)).setter(setter(Builder::byteContent)).constructor(ByteContentDoc::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("byteContent").build()).build();

    private static final SdkField<TextContentDoc> TEXT_CONTENT_FIELD = SdkField
            .<TextContentDoc> builder(MarshallingType.SDK_POJO).memberName("textContent")
            .getter(getter(InlineContent::textContent)).setter(setter(Builder::textContent)).constructor(TextContentDoc::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textContent").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(InlineContent::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTE_CONTENT_FIELD,
            TEXT_CONTENT_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ByteContentDoc byteContent;

    private final TextContentDoc textContent;

    private final String type;

    private InlineContent(BuilderImpl builder) {
        this.byteContent = builder.byteContent;
        this.textContent = builder.textContent;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains information about content defined inline in bytes.
     * </p>
     * 
     * @return Contains information about content defined inline in bytes.
     */
    public final ByteContentDoc byteContent() {
        return byteContent;
    }

    /**
     * <p>
     * Contains information about content defined inline in text.
     * </p>
     * 
     * @return Contains information about content defined inline in text.
     */
    public final TextContentDoc textContent() {
        return textContent;
    }

    /**
     * <p>
     * The type of inline content to define.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InlineContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of inline content to define.
     * @see InlineContentType
     */
    public final InlineContentType type() {
        return InlineContentType.fromValue(type);
    }

    /**
     * <p>
     * The type of inline content to define.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link InlineContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of inline content to define.
     * @see InlineContentType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(byteContent());
        hashCode = 31 * hashCode + Objects.hashCode(textContent());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InlineContent)) {
            return false;
        }
        InlineContent other = (InlineContent) obj;
        return Objects.equals(byteContent(), other.byteContent()) && Objects.equals(textContent(), other.textContent())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InlineContent").add("ByteContent", byteContent()).add("TextContent", textContent())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "byteContent":
            return Optional.ofNullable(clazz.cast(byteContent()));
        case "textContent":
            return Optional.ofNullable(clazz.cast(textContent()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("byteContent", BYTE_CONTENT_FIELD);
        map.put("textContent", TEXT_CONTENT_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InlineContent, T> g) {
        return obj -> g.apply((InlineContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InlineContent> {
        /**
         * <p>
         * Contains information about content defined inline in bytes.
         * </p>
         * 
         * @param byteContent
         *        Contains information about content defined inline in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byteContent(ByteContentDoc byteContent);

        /**
         * <p>
         * Contains information about content defined inline in bytes.
         * </p>
         * This is a convenience method that creates an instance of the {@link ByteContentDoc.Builder} avoiding the need
         * to create one manually via {@link ByteContentDoc#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ByteContentDoc.Builder#build()} is called immediately and its
         * result is passed to {@link #byteContent(ByteContentDoc)}.
         * 
         * @param byteContent
         *        a consumer that will call methods on {@link ByteContentDoc.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #byteContent(ByteContentDoc)
         */
        default Builder byteContent(Consumer<ByteContentDoc.Builder> byteContent) {
            return byteContent(ByteContentDoc.builder().applyMutation(byteContent).build());
        }

        /**
         * <p>
         * Contains information about content defined inline in text.
         * </p>
         * 
         * @param textContent
         *        Contains information about content defined inline in text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textContent(TextContentDoc textContent);

        /**
         * <p>
         * Contains information about content defined inline in text.
         * </p>
         * This is a convenience method that creates an instance of the {@link TextContentDoc.Builder} avoiding the need
         * to create one manually via {@link TextContentDoc#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextContentDoc.Builder#build()} is called immediately and its
         * result is passed to {@link #textContent(TextContentDoc)}.
         * 
         * @param textContent
         *        a consumer that will call methods on {@link TextContentDoc.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textContent(TextContentDoc)
         */
        default Builder textContent(Consumer<TextContentDoc.Builder> textContent) {
            return textContent(TextContentDoc.builder().applyMutation(textContent).build());
        }

        /**
         * <p>
         * The type of inline content to define.
         * </p>
         * 
         * @param type
         *        The type of inline content to define.
         * @see InlineContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InlineContentType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of inline content to define.
         * </p>
         * 
         * @param type
         *        The type of inline content to define.
         * @see InlineContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InlineContentType
         */
        Builder type(InlineContentType type);
    }

    static final class BuilderImpl implements Builder {
        private ByteContentDoc byteContent;

        private TextContentDoc textContent;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(InlineContent model) {
            byteContent(model.byteContent);
            textContent(model.textContent);
            type(model.type);
        }

        public final ByteContentDoc.Builder getByteContent() {
            return byteContent != null ? byteContent.toBuilder() : null;
        }

        public final void setByteContent(ByteContentDoc.BuilderImpl byteContent) {
            this.byteContent = byteContent != null ? byteContent.build() : null;
        }

        @Override
        public final Builder byteContent(ByteContentDoc byteContent) {
            this.byteContent = byteContent;
            return this;
        }

        public final TextContentDoc.Builder getTextContent() {
            return textContent != null ? textContent.toBuilder() : null;
        }

        public final void setTextContent(TextContentDoc.BuilderImpl textContent) {
            this.textContent = textContent != null ? textContent.build() : null;
        }

        @Override
        public final Builder textContent(TextContentDoc textContent) {
            this.textContent = textContent;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InlineContentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public InlineContent build() {
            return new InlineContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
