/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIngestionJobsRequest extends BedrockAgentRequest implements
        ToCopyableBuilder<ListIngestionJobsRequest.Builder, ListIngestionJobsRequest> {
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceId").getter(getter(ListIngestionJobsRequest::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("dataSourceId").build()).build();

    private static final SdkField<List<IngestionJobFilter>> FILTERS_FIELD = SdkField
            .<List<IngestionJobFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(ListIngestionJobsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IngestionJobFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(IngestionJobFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(ListIngestionJobsRequest::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListIngestionJobsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListIngestionJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<IngestionJobSortBy> SORT_BY_FIELD = SdkField
            .<IngestionJobSortBy> builder(MarshallingType.SDK_POJO).memberName("sortBy")
            .getter(getter(ListIngestionJobsRequest::sortBy)).setter(setter(Builder::sortBy))
            .constructor(IngestionJobSortBy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ID_FIELD,
            FILTERS_FIELD, KNOWLEDGE_BASE_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dataSourceId;

    private final List<IngestionJobFilter> filters;

    private final String knowledgeBaseId;

    private final Integer maxResults;

    private final String nextToken;

    private final IngestionJobSortBy sortBy;

    private ListIngestionJobsRequest(BuilderImpl builder) {
        super(builder);
        this.dataSourceId = builder.dataSourceId;
        this.filters = builder.filters;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortBy = builder.sortBy;
    }

    /**
     * <p>
     * The unique identifier of the data source for the list of data ingestion jobs.
     * </p>
     * 
     * @return The unique identifier of the data source for the list of data ingestion jobs.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains information about the filters for filtering the data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Contains information about the filters for filtering the data.
     */
    public final List<IngestionJobFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The unique identifier of the knowledge base for the list of data ingestion jobs.
     * </p>
     * 
     * @return The unique identifier of the knowledge base for the list of data ingestion jobs.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The maximum number of results to return in the response. If the total number of results is greater than this
     * value, use the token returned in the response in the <code>nextToken</code> field when making another request to
     * return the next batch of results.
     * </p>
     * 
     * @return The maximum number of results to return in the response. If the total number of results is greater than
     *         this value, use the token returned in the response in the <code>nextToken</code> field when making
     *         another request to return the next batch of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the total number of results is greater than the <code>maxResults</code> value provided in the request, enter
     * the token returned in the <code>nextToken</code> field in the response in this field to return the next batch of
     * results.
     * </p>
     * 
     * @return If the total number of results is greater than the <code>maxResults</code> value provided in the request,
     *         enter the token returned in the <code>nextToken</code> field in the response in this field to return the
     *         next batch of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Contains details about how to sort the data.
     * </p>
     * 
     * @return Contains details about how to sort the data.
     */
    public final IngestionJobSortBy sortBy() {
        return sortBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sortBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIngestionJobsRequest)) {
            return false;
        }
        ListIngestionJobsRequest other = (ListIngestionJobsRequest) obj;
        return Objects.equals(dataSourceId(), other.dataSourceId()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(knowledgeBaseId(), other.knowledgeBaseId())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(sortBy(), other.sortBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIngestionJobsRequest").add("DataSourceId", dataSourceId())
                .add("Filters", hasFilters() ? filters() : null).add("KnowledgeBaseId", knowledgeBaseId())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("SortBy", sortBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataSourceId", DATA_SOURCE_ID_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIngestionJobsRequest, T> g) {
        return obj -> g.apply((ListIngestionJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListIngestionJobsRequest> {
        /**
         * <p>
         * The unique identifier of the data source for the list of data ingestion jobs.
         * </p>
         * 
         * @param dataSourceId
         *        The unique identifier of the data source for the list of data ingestion jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * Contains information about the filters for filtering the data.
         * </p>
         * 
         * @param filters
         *        Contains information about the filters for filtering the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<IngestionJobFilter> filters);

        /**
         * <p>
         * Contains information about the filters for filtering the data.
         * </p>
         * 
         * @param filters
         *        Contains information about the filters for filtering the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(IngestionJobFilter... filters);

        /**
         * <p>
         * Contains information about the filters for filtering the data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.IngestionJobFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.IngestionJobFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.IngestionJobFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<IngestionJobFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.IngestionJobFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<IngestionJobFilter>)
         */
        Builder filters(Consumer<IngestionJobFilter.Builder>... filters);

        /**
         * <p>
         * The unique identifier of the knowledge base for the list of data ingestion jobs.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The unique identifier of the knowledge base for the list of data ingestion jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The maximum number of results to return in the response. If the total number of results is greater than this
         * value, use the token returned in the response in the <code>nextToken</code> field when making another request
         * to return the next batch of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in the response. If the total number of results is greater
         *        than this value, use the token returned in the response in the <code>nextToken</code> field when
         *        making another request to return the next batch of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the total number of results is greater than the <code>maxResults</code> value provided in the request,
         * enter the token returned in the <code>nextToken</code> field in the response in this field to return the next
         * batch of results.
         * </p>
         * 
         * @param nextToken
         *        If the total number of results is greater than the <code>maxResults</code> value provided in the
         *        request, enter the token returned in the <code>nextToken</code> field in the response in this field to
         *        return the next batch of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Contains details about how to sort the data.
         * </p>
         * 
         * @param sortBy
         *        Contains details about how to sort the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(IngestionJobSortBy sortBy);

        /**
         * <p>
         * Contains details about how to sort the data.
         * </p>
         * This is a convenience method that creates an instance of the {@link IngestionJobSortBy.Builder} avoiding the
         * need to create one manually via {@link IngestionJobSortBy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IngestionJobSortBy.Builder#build()} is called immediately and its
         * result is passed to {@link #sortBy(IngestionJobSortBy)}.
         * 
         * @param sortBy
         *        a consumer that will call methods on {@link IngestionJobSortBy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortBy(IngestionJobSortBy)
         */
        default Builder sortBy(Consumer<IngestionJobSortBy.Builder> sortBy) {
            return sortBy(IngestionJobSortBy.builder().applyMutation(sortBy).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRequest.BuilderImpl implements Builder {
        private String dataSourceId;

        private List<IngestionJobFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private String knowledgeBaseId;

        private Integer maxResults;

        private String nextToken;

        private IngestionJobSortBy sortBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIngestionJobsRequest model) {
            super(model);
            dataSourceId(model.dataSourceId);
            filters(model.filters);
            knowledgeBaseId(model.knowledgeBaseId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            sortBy(model.sortBy);
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final List<IngestionJobFilter.Builder> getFilters() {
            List<IngestionJobFilter.Builder> result = IngestionJobFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<IngestionJobFilter.BuilderImpl> filters) {
            this.filters = IngestionJobFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<IngestionJobFilter> filters) {
            this.filters = IngestionJobFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(IngestionJobFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<IngestionJobFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> IngestionJobFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final IngestionJobSortBy.Builder getSortBy() {
            return sortBy != null ? sortBy.toBuilder() : null;
        }

        public final void setSortBy(IngestionJobSortBy.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        public final Builder sortBy(IngestionJobSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListIngestionJobsRequest build() {
            return new ListIngestionJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
