/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a flow that contains an incompatible node in a DoWhile loop.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoopIncompatibleNodeTypeFlowValidationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<LoopIncompatibleNodeTypeFlowValidationDetails.Builder, LoopIncompatibleNodeTypeFlowValidationDetails> {
    private static final SdkField<String> INCOMPATIBLE_NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("incompatibleNodeName")
            .getter(getter(LoopIncompatibleNodeTypeFlowValidationDetails::incompatibleNodeName))
            .setter(setter(Builder::incompatibleNodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incompatibleNodeName").build())
            .build();

    private static final SdkField<String> INCOMPATIBLE_NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("incompatibleNodeType")
            .getter(getter(LoopIncompatibleNodeTypeFlowValidationDetails::incompatibleNodeTypeAsString))
            .setter(setter(Builder::incompatibleNodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incompatibleNodeType").build())
            .build();

    private static final SdkField<String> NODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("node")
            .getter(getter(LoopIncompatibleNodeTypeFlowValidationDetails::node)).setter(setter(Builder::node))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("node").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCOMPATIBLE_NODE_NAME_FIELD,
            INCOMPATIBLE_NODE_TYPE_FIELD, NODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String incompatibleNodeName;

    private final String incompatibleNodeType;

    private final String node;

    private LoopIncompatibleNodeTypeFlowValidationDetails(BuilderImpl builder) {
        this.incompatibleNodeName = builder.incompatibleNodeName;
        this.incompatibleNodeType = builder.incompatibleNodeType;
        this.node = builder.node;
    }

    /**
     * <p>
     * The node that's incompatible in the DoWhile loop.
     * </p>
     * 
     * @return The node that's incompatible in the DoWhile loop.
     */
    public final String incompatibleNodeName() {
        return incompatibleNodeName;
    }

    /**
     * <p>
     * The node type of the incompatible node in the DoWhile loop. Some node types, like a condition node, aren't
     * allowed in a DoWhile loop.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #incompatibleNodeType} will return {@link IncompatibleLoopNodeType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #incompatibleNodeTypeAsString}.
     * </p>
     * 
     * @return The node type of the incompatible node in the DoWhile loop. Some node types, like a condition node,
     *         aren't allowed in a DoWhile loop.
     * @see IncompatibleLoopNodeType
     */
    public final IncompatibleLoopNodeType incompatibleNodeType() {
        return IncompatibleLoopNodeType.fromValue(incompatibleNodeType);
    }

    /**
     * <p>
     * The node type of the incompatible node in the DoWhile loop. Some node types, like a condition node, aren't
     * allowed in a DoWhile loop.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #incompatibleNodeType} will return {@link IncompatibleLoopNodeType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #incompatibleNodeTypeAsString}.
     * </p>
     * 
     * @return The node type of the incompatible node in the DoWhile loop. Some node types, like a condition node,
     *         aren't allowed in a DoWhile loop.
     * @see IncompatibleLoopNodeType
     */
    public final String incompatibleNodeTypeAsString() {
        return incompatibleNodeType;
    }

    /**
     * <p>
     * The <code>Loop</code> container node that contains an incompatible node.
     * </p>
     * 
     * @return The <code>Loop</code> container node that contains an incompatible node.
     */
    public final String node() {
        return node;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(incompatibleNodeName());
        hashCode = 31 * hashCode + Objects.hashCode(incompatibleNodeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(node());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoopIncompatibleNodeTypeFlowValidationDetails)) {
            return false;
        }
        LoopIncompatibleNodeTypeFlowValidationDetails other = (LoopIncompatibleNodeTypeFlowValidationDetails) obj;
        return Objects.equals(incompatibleNodeName(), other.incompatibleNodeName())
                && Objects.equals(incompatibleNodeTypeAsString(), other.incompatibleNodeTypeAsString())
                && Objects.equals(node(), other.node());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoopIncompatibleNodeTypeFlowValidationDetails")
                .add("IncompatibleNodeName", incompatibleNodeName()).add("IncompatibleNodeType", incompatibleNodeTypeAsString())
                .add("Node", node()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "incompatibleNodeName":
            return Optional.ofNullable(clazz.cast(incompatibleNodeName()));
        case "incompatibleNodeType":
            return Optional.ofNullable(clazz.cast(incompatibleNodeTypeAsString()));
        case "node":
            return Optional.ofNullable(clazz.cast(node()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("incompatibleNodeName", INCOMPATIBLE_NODE_NAME_FIELD);
        map.put("incompatibleNodeType", INCOMPATIBLE_NODE_TYPE_FIELD);
        map.put("node", NODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoopIncompatibleNodeTypeFlowValidationDetails, T> g) {
        return obj -> g.apply((LoopIncompatibleNodeTypeFlowValidationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoopIncompatibleNodeTypeFlowValidationDetails> {
        /**
         * <p>
         * The node that's incompatible in the DoWhile loop.
         * </p>
         * 
         * @param incompatibleNodeName
         *        The node that's incompatible in the DoWhile loop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incompatibleNodeName(String incompatibleNodeName);

        /**
         * <p>
         * The node type of the incompatible node in the DoWhile loop. Some node types, like a condition node, aren't
         * allowed in a DoWhile loop.
         * </p>
         * 
         * @param incompatibleNodeType
         *        The node type of the incompatible node in the DoWhile loop. Some node types, like a condition node,
         *        aren't allowed in a DoWhile loop.
         * @see IncompatibleLoopNodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncompatibleLoopNodeType
         */
        Builder incompatibleNodeType(String incompatibleNodeType);

        /**
         * <p>
         * The node type of the incompatible node in the DoWhile loop. Some node types, like a condition node, aren't
         * allowed in a DoWhile loop.
         * </p>
         * 
         * @param incompatibleNodeType
         *        The node type of the incompatible node in the DoWhile loop. Some node types, like a condition node,
         *        aren't allowed in a DoWhile loop.
         * @see IncompatibleLoopNodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncompatibleLoopNodeType
         */
        Builder incompatibleNodeType(IncompatibleLoopNodeType incompatibleNodeType);

        /**
         * <p>
         * The <code>Loop</code> container node that contains an incompatible node.
         * </p>
         * 
         * @param node
         *        The <code>Loop</code> container node that contains an incompatible node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder node(String node);
    }

    static final class BuilderImpl implements Builder {
        private String incompatibleNodeName;

        private String incompatibleNodeType;

        private String node;

        private BuilderImpl() {
        }

        private BuilderImpl(LoopIncompatibleNodeTypeFlowValidationDetails model) {
            incompatibleNodeName(model.incompatibleNodeName);
            incompatibleNodeType(model.incompatibleNodeType);
            node(model.node);
        }

        public final String getIncompatibleNodeName() {
            return incompatibleNodeName;
        }

        public final void setIncompatibleNodeName(String incompatibleNodeName) {
            this.incompatibleNodeName = incompatibleNodeName;
        }

        @Override
        public final Builder incompatibleNodeName(String incompatibleNodeName) {
            this.incompatibleNodeName = incompatibleNodeName;
            return this;
        }

        public final String getIncompatibleNodeType() {
            return incompatibleNodeType;
        }

        public final void setIncompatibleNodeType(String incompatibleNodeType) {
            this.incompatibleNodeType = incompatibleNodeType;
        }

        @Override
        public final Builder incompatibleNodeType(String incompatibleNodeType) {
            this.incompatibleNodeType = incompatibleNodeType;
            return this;
        }

        @Override
        public final Builder incompatibleNodeType(IncompatibleLoopNodeType incompatibleNodeType) {
            this.incompatibleNodeType(incompatibleNodeType == null ? null : incompatibleNodeType.toString());
            return this;
        }

        public final String getNode() {
            return node;
        }

        public final void setNode(String node) {
            this.node = node;
        }

        @Override
        public final Builder node(String node) {
            this.node = node;
            return this;
        }

        @Override
        public LoopIncompatibleNodeTypeFlowValidationDetails build() {
            return new LoopIncompatibleNodeTypeFlowValidationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
