/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the memory configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemoryConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MemoryConfiguration.Builder, MemoryConfiguration> {
    private static final SdkField<List<String>> ENABLED_MEMORY_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("enabledMemoryTypes")
            .getter(getter(MemoryConfiguration::enabledMemoryTypesAsStrings))
            .setter(setter(Builder::enabledMemoryTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledMemoryTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SessionSummaryConfiguration> SESSION_SUMMARY_CONFIGURATION_FIELD = SdkField
            .<SessionSummaryConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("sessionSummaryConfiguration")
            .getter(getter(MemoryConfiguration::sessionSummaryConfiguration))
            .setter(setter(Builder::sessionSummaryConfiguration))
            .constructor(SessionSummaryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionSummaryConfiguration")
                    .build()).build();

    private static final SdkField<Integer> STORAGE_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("storageDays").getter(getter(MemoryConfiguration::storageDays)).setter(setter(Builder::storageDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageDays").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_MEMORY_TYPES_FIELD,
            SESSION_SUMMARY_CONFIGURATION_FIELD, STORAGE_DAYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> enabledMemoryTypes;

    private final SessionSummaryConfiguration sessionSummaryConfiguration;

    private final Integer storageDays;

    private MemoryConfiguration(BuilderImpl builder) {
        this.enabledMemoryTypes = builder.enabledMemoryTypes;
        this.sessionSummaryConfiguration = builder.sessionSummaryConfiguration;
        this.storageDays = builder.storageDays;
    }

    /**
     * <p>
     * The type of memory that is stored.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledMemoryTypes} method.
     * </p>
     * 
     * @return The type of memory that is stored.
     */
    public final List<MemoryType> enabledMemoryTypes() {
        return EnabledMemoryTypesCopier.copyStringToEnum(enabledMemoryTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the EnabledMemoryTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnabledMemoryTypes() {
        return enabledMemoryTypes != null && !(enabledMemoryTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of memory that is stored.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledMemoryTypes} method.
     * </p>
     * 
     * @return The type of memory that is stored.
     */
    public final List<String> enabledMemoryTypesAsStrings() {
        return enabledMemoryTypes;
    }

    /**
     * <p>
     * Contains the configuration for SESSION_SUMMARY memory type enabled for the agent.
     * </p>
     * 
     * @return Contains the configuration for SESSION_SUMMARY memory type enabled for the agent.
     */
    public final SessionSummaryConfiguration sessionSummaryConfiguration() {
        return sessionSummaryConfiguration;
    }

    /**
     * <p>
     * The number of days the agent is configured to retain the conversational context.
     * </p>
     * 
     * @return The number of days the agent is configured to retain the conversational context.
     */
    public final Integer storageDays() {
        return storageDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEnabledMemoryTypes() ? enabledMemoryTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sessionSummaryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(storageDays());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemoryConfiguration)) {
            return false;
        }
        MemoryConfiguration other = (MemoryConfiguration) obj;
        return hasEnabledMemoryTypes() == other.hasEnabledMemoryTypes()
                && Objects.equals(enabledMemoryTypesAsStrings(), other.enabledMemoryTypesAsStrings())
                && Objects.equals(sessionSummaryConfiguration(), other.sessionSummaryConfiguration())
                && Objects.equals(storageDays(), other.storageDays());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MemoryConfiguration")
                .add("EnabledMemoryTypes", hasEnabledMemoryTypes() ? enabledMemoryTypesAsStrings() : null)
                .add("SessionSummaryConfiguration", sessionSummaryConfiguration()).add("StorageDays", storageDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabledMemoryTypes":
            return Optional.ofNullable(clazz.cast(enabledMemoryTypesAsStrings()));
        case "sessionSummaryConfiguration":
            return Optional.ofNullable(clazz.cast(sessionSummaryConfiguration()));
        case "storageDays":
            return Optional.ofNullable(clazz.cast(storageDays()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enabledMemoryTypes", ENABLED_MEMORY_TYPES_FIELD);
        map.put("sessionSummaryConfiguration", SESSION_SUMMARY_CONFIGURATION_FIELD);
        map.put("storageDays", STORAGE_DAYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MemoryConfiguration, T> g) {
        return obj -> g.apply((MemoryConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemoryConfiguration> {
        /**
         * <p>
         * The type of memory that is stored.
         * </p>
         * 
         * @param enabledMemoryTypes
         *        The type of memory that is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledMemoryTypesWithStrings(Collection<String> enabledMemoryTypes);

        /**
         * <p>
         * The type of memory that is stored.
         * </p>
         * 
         * @param enabledMemoryTypes
         *        The type of memory that is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledMemoryTypesWithStrings(String... enabledMemoryTypes);

        /**
         * <p>
         * The type of memory that is stored.
         * </p>
         * 
         * @param enabledMemoryTypes
         *        The type of memory that is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledMemoryTypes(Collection<MemoryType> enabledMemoryTypes);

        /**
         * <p>
         * The type of memory that is stored.
         * </p>
         * 
         * @param enabledMemoryTypes
         *        The type of memory that is stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledMemoryTypes(MemoryType... enabledMemoryTypes);

        /**
         * <p>
         * Contains the configuration for SESSION_SUMMARY memory type enabled for the agent.
         * </p>
         * 
         * @param sessionSummaryConfiguration
         *        Contains the configuration for SESSION_SUMMARY memory type enabled for the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionSummaryConfiguration(SessionSummaryConfiguration sessionSummaryConfiguration);

        /**
         * <p>
         * Contains the configuration for SESSION_SUMMARY memory type enabled for the agent.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionSummaryConfiguration.Builder}
         * avoiding the need to create one manually via {@link SessionSummaryConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionSummaryConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sessionSummaryConfiguration(SessionSummaryConfiguration)}.
         * 
         * @param sessionSummaryConfiguration
         *        a consumer that will call methods on {@link SessionSummaryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionSummaryConfiguration(SessionSummaryConfiguration)
         */
        default Builder sessionSummaryConfiguration(Consumer<SessionSummaryConfiguration.Builder> sessionSummaryConfiguration) {
            return sessionSummaryConfiguration(SessionSummaryConfiguration.builder().applyMutation(sessionSummaryConfiguration)
                    .build());
        }

        /**
         * <p>
         * The number of days the agent is configured to retain the conversational context.
         * </p>
         * 
         * @param storageDays
         *        The number of days the agent is configured to retain the conversational context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageDays(Integer storageDays);
    }

    static final class BuilderImpl implements Builder {
        private List<String> enabledMemoryTypes = DefaultSdkAutoConstructList.getInstance();

        private SessionSummaryConfiguration sessionSummaryConfiguration;

        private Integer storageDays;

        private BuilderImpl() {
        }

        private BuilderImpl(MemoryConfiguration model) {
            enabledMemoryTypesWithStrings(model.enabledMemoryTypes);
            sessionSummaryConfiguration(model.sessionSummaryConfiguration);
            storageDays(model.storageDays);
        }

        public final Collection<String> getEnabledMemoryTypes() {
            if (enabledMemoryTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return enabledMemoryTypes;
        }

        public final void setEnabledMemoryTypes(Collection<String> enabledMemoryTypes) {
            this.enabledMemoryTypes = EnabledMemoryTypesCopier.copy(enabledMemoryTypes);
        }

        @Override
        public final Builder enabledMemoryTypesWithStrings(Collection<String> enabledMemoryTypes) {
            this.enabledMemoryTypes = EnabledMemoryTypesCopier.copy(enabledMemoryTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledMemoryTypesWithStrings(String... enabledMemoryTypes) {
            enabledMemoryTypesWithStrings(Arrays.asList(enabledMemoryTypes));
            return this;
        }

        @Override
        public final Builder enabledMemoryTypes(Collection<MemoryType> enabledMemoryTypes) {
            this.enabledMemoryTypes = EnabledMemoryTypesCopier.copyEnumToString(enabledMemoryTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledMemoryTypes(MemoryType... enabledMemoryTypes) {
            enabledMemoryTypes(Arrays.asList(enabledMemoryTypes));
            return this;
        }

        public final SessionSummaryConfiguration.Builder getSessionSummaryConfiguration() {
            return sessionSummaryConfiguration != null ? sessionSummaryConfiguration.toBuilder() : null;
        }

        public final void setSessionSummaryConfiguration(SessionSummaryConfiguration.BuilderImpl sessionSummaryConfiguration) {
            this.sessionSummaryConfiguration = sessionSummaryConfiguration != null ? sessionSummaryConfiguration.build() : null;
        }

        @Override
        public final Builder sessionSummaryConfiguration(SessionSummaryConfiguration sessionSummaryConfiguration) {
            this.sessionSummaryConfiguration = sessionSummaryConfiguration;
            return this;
        }

        public final Integer getStorageDays() {
            return storageDays;
        }

        public final void setStorageDays(Integer storageDays) {
            this.storageDays = storageDays;
        }

        @Override
        public final Builder storageDays(Integer storageDays) {
            this.storageDays = storageDays;
            return this;
        }

        @Override
        public MemoryConfiguration build() {
            return new MemoryConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
