/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for parsing document contents. If you exclude this field, the default parser converts the contents of each
 * document into text before splitting it into chunks. Specify the parsing strategy to use in the
 * <code>parsingStrategy</code> field and include the relevant configuration, or omit it to use the Amazon Bedrock
 * default parser. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-advanced-parsing.html">Parsing options for your data
 * source</a>.
 * </p>
 * <note>
 * <p>
 * If you specify <code>BEDROCK_DATA_AUTOMATION</code> or <code>BEDROCK_FOUNDATION_MODEL</code> and it fails to parse a
 * file, the Amazon Bedrock default parser will be used instead.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParsingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ParsingConfiguration.Builder, ParsingConfiguration> {
    private static final SdkField<BedrockDataAutomationConfiguration> BEDROCK_DATA_AUTOMATION_CONFIGURATION_FIELD = SdkField
            .<BedrockDataAutomationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("bedrockDataAutomationConfiguration")
            .getter(getter(ParsingConfiguration::bedrockDataAutomationConfiguration))
            .setter(setter(Builder::bedrockDataAutomationConfiguration))
            .constructor(BedrockDataAutomationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockDataAutomationConfiguration")
                    .build()).build();

    private static final SdkField<BedrockFoundationModelConfiguration> BEDROCK_FOUNDATION_MODEL_CONFIGURATION_FIELD = SdkField
            .<BedrockFoundationModelConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("bedrockFoundationModelConfiguration")
            .getter(getter(ParsingConfiguration::bedrockFoundationModelConfiguration))
            .setter(setter(Builder::bedrockFoundationModelConfiguration))
            .constructor(BedrockFoundationModelConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("bedrockFoundationModelConfiguration").build()).build();

    private static final SdkField<String> PARSING_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parsingStrategy").getter(getter(ParsingConfiguration::parsingStrategyAsString))
            .setter(setter(Builder::parsingStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parsingStrategy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BEDROCK_DATA_AUTOMATION_CONFIGURATION_FIELD, BEDROCK_FOUNDATION_MODEL_CONFIGURATION_FIELD, PARSING_STRATEGY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final BedrockDataAutomationConfiguration bedrockDataAutomationConfiguration;

    private final BedrockFoundationModelConfiguration bedrockFoundationModelConfiguration;

    private final String parsingStrategy;

    private ParsingConfiguration(BuilderImpl builder) {
        this.bedrockDataAutomationConfiguration = builder.bedrockDataAutomationConfiguration;
        this.bedrockFoundationModelConfiguration = builder.bedrockFoundationModelConfiguration;
        this.parsingStrategy = builder.parsingStrategy;
    }

    /**
     * <p>
     * If you specify <code>BEDROCK_DATA_AUTOMATION</code> as the parsing strategy for ingesting your data source, use
     * this object to modify configurations for using the Amazon Bedrock Data Automation parser.
     * </p>
     * 
     * @return If you specify <code>BEDROCK_DATA_AUTOMATION</code> as the parsing strategy for ingesting your data
     *         source, use this object to modify configurations for using the Amazon Bedrock Data Automation parser.
     */
    public final BedrockDataAutomationConfiguration bedrockDataAutomationConfiguration() {
        return bedrockDataAutomationConfiguration;
    }

    /**
     * <p>
     * If you specify <code>BEDROCK_FOUNDATION_MODEL</code> as the parsing strategy for ingesting your data source, use
     * this object to modify configurations for using a foundation model to parse documents.
     * </p>
     * 
     * @return If you specify <code>BEDROCK_FOUNDATION_MODEL</code> as the parsing strategy for ingesting your data
     *         source, use this object to modify configurations for using a foundation model to parse documents.
     */
    public final BedrockFoundationModelConfiguration bedrockFoundationModelConfiguration() {
        return bedrockFoundationModelConfiguration;
    }

    /**
     * <p>
     * The parsing strategy for the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parsingStrategy}
     * will return {@link ParsingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #parsingStrategyAsString}.
     * </p>
     * 
     * @return The parsing strategy for the data source.
     * @see ParsingStrategy
     */
    public final ParsingStrategy parsingStrategy() {
        return ParsingStrategy.fromValue(parsingStrategy);
    }

    /**
     * <p>
     * The parsing strategy for the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parsingStrategy}
     * will return {@link ParsingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #parsingStrategyAsString}.
     * </p>
     * 
     * @return The parsing strategy for the data source.
     * @see ParsingStrategy
     */
    public final String parsingStrategyAsString() {
        return parsingStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bedrockDataAutomationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(bedrockFoundationModelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(parsingStrategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParsingConfiguration)) {
            return false;
        }
        ParsingConfiguration other = (ParsingConfiguration) obj;
        return Objects.equals(bedrockDataAutomationConfiguration(), other.bedrockDataAutomationConfiguration())
                && Objects.equals(bedrockFoundationModelConfiguration(), other.bedrockFoundationModelConfiguration())
                && Objects.equals(parsingStrategyAsString(), other.parsingStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParsingConfiguration")
                .add("BedrockDataAutomationConfiguration", bedrockDataAutomationConfiguration())
                .add("BedrockFoundationModelConfiguration", bedrockFoundationModelConfiguration())
                .add("ParsingStrategy", parsingStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bedrockDataAutomationConfiguration":
            return Optional.ofNullable(clazz.cast(bedrockDataAutomationConfiguration()));
        case "bedrockFoundationModelConfiguration":
            return Optional.ofNullable(clazz.cast(bedrockFoundationModelConfiguration()));
        case "parsingStrategy":
            return Optional.ofNullable(clazz.cast(parsingStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bedrockDataAutomationConfiguration", BEDROCK_DATA_AUTOMATION_CONFIGURATION_FIELD);
        map.put("bedrockFoundationModelConfiguration", BEDROCK_FOUNDATION_MODEL_CONFIGURATION_FIELD);
        map.put("parsingStrategy", PARSING_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParsingConfiguration, T> g) {
        return obj -> g.apply((ParsingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParsingConfiguration> {
        /**
         * <p>
         * If you specify <code>BEDROCK_DATA_AUTOMATION</code> as the parsing strategy for ingesting your data source,
         * use this object to modify configurations for using the Amazon Bedrock Data Automation parser.
         * </p>
         * 
         * @param bedrockDataAutomationConfiguration
         *        If you specify <code>BEDROCK_DATA_AUTOMATION</code> as the parsing strategy for ingesting your data
         *        source, use this object to modify configurations for using the Amazon Bedrock Data Automation parser.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bedrockDataAutomationConfiguration(BedrockDataAutomationConfiguration bedrockDataAutomationConfiguration);

        /**
         * <p>
         * If you specify <code>BEDROCK_DATA_AUTOMATION</code> as the parsing strategy for ingesting your data source,
         * use this object to modify configurations for using the Amazon Bedrock Data Automation parser.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BedrockDataAutomationConfiguration.Builder} avoiding the need to create one manually via
         * {@link BedrockDataAutomationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BedrockDataAutomationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #bedrockDataAutomationConfiguration(BedrockDataAutomationConfiguration)}.
         * 
         * @param bedrockDataAutomationConfiguration
         *        a consumer that will call methods on {@link BedrockDataAutomationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bedrockDataAutomationConfiguration(BedrockDataAutomationConfiguration)
         */
        default Builder bedrockDataAutomationConfiguration(
                Consumer<BedrockDataAutomationConfiguration.Builder> bedrockDataAutomationConfiguration) {
            return bedrockDataAutomationConfiguration(BedrockDataAutomationConfiguration.builder()
                    .applyMutation(bedrockDataAutomationConfiguration).build());
        }

        /**
         * <p>
         * If you specify <code>BEDROCK_FOUNDATION_MODEL</code> as the parsing strategy for ingesting your data source,
         * use this object to modify configurations for using a foundation model to parse documents.
         * </p>
         * 
         * @param bedrockFoundationModelConfiguration
         *        If you specify <code>BEDROCK_FOUNDATION_MODEL</code> as the parsing strategy for ingesting your data
         *        source, use this object to modify configurations for using a foundation model to parse documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bedrockFoundationModelConfiguration(BedrockFoundationModelConfiguration bedrockFoundationModelConfiguration);

        /**
         * <p>
         * If you specify <code>BEDROCK_FOUNDATION_MODEL</code> as the parsing strategy for ingesting your data source,
         * use this object to modify configurations for using a foundation model to parse documents.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BedrockFoundationModelConfiguration.Builder} avoiding the need to create one manually via
         * {@link BedrockFoundationModelConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BedrockFoundationModelConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #bedrockFoundationModelConfiguration(BedrockFoundationModelConfiguration)}.
         * 
         * @param bedrockFoundationModelConfiguration
         *        a consumer that will call methods on {@link BedrockFoundationModelConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bedrockFoundationModelConfiguration(BedrockFoundationModelConfiguration)
         */
        default Builder bedrockFoundationModelConfiguration(
                Consumer<BedrockFoundationModelConfiguration.Builder> bedrockFoundationModelConfiguration) {
            return bedrockFoundationModelConfiguration(BedrockFoundationModelConfiguration.builder()
                    .applyMutation(bedrockFoundationModelConfiguration).build());
        }

        /**
         * <p>
         * The parsing strategy for the data source.
         * </p>
         * 
         * @param parsingStrategy
         *        The parsing strategy for the data source.
         * @see ParsingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParsingStrategy
         */
        Builder parsingStrategy(String parsingStrategy);

        /**
         * <p>
         * The parsing strategy for the data source.
         * </p>
         * 
         * @param parsingStrategy
         *        The parsing strategy for the data source.
         * @see ParsingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParsingStrategy
         */
        Builder parsingStrategy(ParsingStrategy parsingStrategy);
    }

    static final class BuilderImpl implements Builder {
        private BedrockDataAutomationConfiguration bedrockDataAutomationConfiguration;

        private BedrockFoundationModelConfiguration bedrockFoundationModelConfiguration;

        private String parsingStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(ParsingConfiguration model) {
            bedrockDataAutomationConfiguration(model.bedrockDataAutomationConfiguration);
            bedrockFoundationModelConfiguration(model.bedrockFoundationModelConfiguration);
            parsingStrategy(model.parsingStrategy);
        }

        public final BedrockDataAutomationConfiguration.Builder getBedrockDataAutomationConfiguration() {
            return bedrockDataAutomationConfiguration != null ? bedrockDataAutomationConfiguration.toBuilder() : null;
        }

        public final void setBedrockDataAutomationConfiguration(
                BedrockDataAutomationConfiguration.BuilderImpl bedrockDataAutomationConfiguration) {
            this.bedrockDataAutomationConfiguration = bedrockDataAutomationConfiguration != null ? bedrockDataAutomationConfiguration
                    .build() : null;
        }

        @Override
        public final Builder bedrockDataAutomationConfiguration(
                BedrockDataAutomationConfiguration bedrockDataAutomationConfiguration) {
            this.bedrockDataAutomationConfiguration = bedrockDataAutomationConfiguration;
            return this;
        }

        public final BedrockFoundationModelConfiguration.Builder getBedrockFoundationModelConfiguration() {
            return bedrockFoundationModelConfiguration != null ? bedrockFoundationModelConfiguration.toBuilder() : null;
        }

        public final void setBedrockFoundationModelConfiguration(
                BedrockFoundationModelConfiguration.BuilderImpl bedrockFoundationModelConfiguration) {
            this.bedrockFoundationModelConfiguration = bedrockFoundationModelConfiguration != null ? bedrockFoundationModelConfiguration
                    .build() : null;
        }

        @Override
        public final Builder bedrockFoundationModelConfiguration(
                BedrockFoundationModelConfiguration bedrockFoundationModelConfiguration) {
            this.bedrockFoundationModelConfiguration = bedrockFoundationModelConfiguration;
            return this;
        }

        public final String getParsingStrategy() {
            return parsingStrategy;
        }

        public final void setParsingStrategy(String parsingStrategy) {
            this.parsingStrategy = parsingStrategy;
        }

        @Override
        public final Builder parsingStrategy(String parsingStrategy) {
            this.parsingStrategy = parsingStrategy;
            return this;
        }

        @Override
        public final Builder parsingStrategy(ParsingStrategy parsingStrategy) {
            this.parsingStrategy(parsingStrategy == null ? null : parsingStrategy.toString());
            return this;
        }

        @Override
        public ParsingConfiguration build() {
            return new ParsingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
