/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration information to connect to SharePoint as your data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SharePointDataSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SharePointDataSourceConfiguration.Builder, SharePointDataSourceConfiguration> {
    private static final SdkField<SharePointCrawlerConfiguration> CRAWLER_CONFIGURATION_FIELD = SdkField
            .<SharePointCrawlerConfiguration> builder(MarshallingType.SDK_POJO).memberName("crawlerConfiguration")
            .getter(getter(SharePointDataSourceConfiguration::crawlerConfiguration))
            .setter(setter(Builder::crawlerConfiguration)).constructor(SharePointCrawlerConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crawlerConfiguration").build())
            .build();

    private static final SdkField<SharePointSourceConfiguration> SOURCE_CONFIGURATION_FIELD = SdkField
            .<SharePointSourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("sourceConfiguration")
            .getter(getter(SharePointDataSourceConfiguration::sourceConfiguration)).setter(setter(Builder::sourceConfiguration))
            .constructor(SharePointSourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWLER_CONFIGURATION_FIELD,
            SOURCE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SharePointCrawlerConfiguration crawlerConfiguration;

    private final SharePointSourceConfiguration sourceConfiguration;

    private SharePointDataSourceConfiguration(BuilderImpl builder) {
        this.crawlerConfiguration = builder.crawlerConfiguration;
        this.sourceConfiguration = builder.sourceConfiguration;
    }

    /**
     * <p>
     * The configuration of the SharePoint content. For example, configuring specific types of SharePoint content.
     * </p>
     * 
     * @return The configuration of the SharePoint content. For example, configuring specific types of SharePoint
     *         content.
     */
    public final SharePointCrawlerConfiguration crawlerConfiguration() {
        return crawlerConfiguration;
    }

    /**
     * <p>
     * The endpoint information to connect to your SharePoint data source.
     * </p>
     * 
     * @return The endpoint information to connect to your SharePoint data source.
     */
    public final SharePointSourceConfiguration sourceConfiguration() {
        return sourceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(crawlerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(sourceConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SharePointDataSourceConfiguration)) {
            return false;
        }
        SharePointDataSourceConfiguration other = (SharePointDataSourceConfiguration) obj;
        return Objects.equals(crawlerConfiguration(), other.crawlerConfiguration())
                && Objects.equals(sourceConfiguration(), other.sourceConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SharePointDataSourceConfiguration").add("CrawlerConfiguration", crawlerConfiguration())
                .add("SourceConfiguration", sourceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "crawlerConfiguration":
            return Optional.ofNullable(clazz.cast(crawlerConfiguration()));
        case "sourceConfiguration":
            return Optional.ofNullable(clazz.cast(sourceConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("crawlerConfiguration", CRAWLER_CONFIGURATION_FIELD);
        map.put("sourceConfiguration", SOURCE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SharePointDataSourceConfiguration, T> g) {
        return obj -> g.apply((SharePointDataSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SharePointDataSourceConfiguration> {
        /**
         * <p>
         * The configuration of the SharePoint content. For example, configuring specific types of SharePoint content.
         * </p>
         * 
         * @param crawlerConfiguration
         *        The configuration of the SharePoint content. For example, configuring specific types of SharePoint
         *        content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlerConfiguration(SharePointCrawlerConfiguration crawlerConfiguration);

        /**
         * <p>
         * The configuration of the SharePoint content. For example, configuring specific types of SharePoint content.
         * </p>
         * This is a convenience method that creates an instance of the {@link SharePointCrawlerConfiguration.Builder}
         * avoiding the need to create one manually via {@link SharePointCrawlerConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SharePointCrawlerConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #crawlerConfiguration(SharePointCrawlerConfiguration)}.
         * 
         * @param crawlerConfiguration
         *        a consumer that will call methods on {@link SharePointCrawlerConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crawlerConfiguration(SharePointCrawlerConfiguration)
         */
        default Builder crawlerConfiguration(Consumer<SharePointCrawlerConfiguration.Builder> crawlerConfiguration) {
            return crawlerConfiguration(SharePointCrawlerConfiguration.builder().applyMutation(crawlerConfiguration).build());
        }

        /**
         * <p>
         * The endpoint information to connect to your SharePoint data source.
         * </p>
         * 
         * @param sourceConfiguration
         *        The endpoint information to connect to your SharePoint data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceConfiguration(SharePointSourceConfiguration sourceConfiguration);

        /**
         * <p>
         * The endpoint information to connect to your SharePoint data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link SharePointSourceConfiguration.Builder}
         * avoiding the need to create one manually via {@link SharePointSourceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SharePointSourceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceConfiguration(SharePointSourceConfiguration)}.
         * 
         * @param sourceConfiguration
         *        a consumer that will call methods on {@link SharePointSourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceConfiguration(SharePointSourceConfiguration)
         */
        default Builder sourceConfiguration(Consumer<SharePointSourceConfiguration.Builder> sourceConfiguration) {
            return sourceConfiguration(SharePointSourceConfiguration.builder().applyMutation(sourceConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SharePointCrawlerConfiguration crawlerConfiguration;

        private SharePointSourceConfiguration sourceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SharePointDataSourceConfiguration model) {
            crawlerConfiguration(model.crawlerConfiguration);
            sourceConfiguration(model.sourceConfiguration);
        }

        public final SharePointCrawlerConfiguration.Builder getCrawlerConfiguration() {
            return crawlerConfiguration != null ? crawlerConfiguration.toBuilder() : null;
        }

        public final void setCrawlerConfiguration(SharePointCrawlerConfiguration.BuilderImpl crawlerConfiguration) {
            this.crawlerConfiguration = crawlerConfiguration != null ? crawlerConfiguration.build() : null;
        }

        @Override
        public final Builder crawlerConfiguration(SharePointCrawlerConfiguration crawlerConfiguration) {
            this.crawlerConfiguration = crawlerConfiguration;
            return this;
        }

        public final SharePointSourceConfiguration.Builder getSourceConfiguration() {
            return sourceConfiguration != null ? sourceConfiguration.toBuilder() : null;
        }

        public final void setSourceConfiguration(SharePointSourceConfiguration.BuilderImpl sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration != null ? sourceConfiguration.build() : null;
        }

        @Override
        public final Builder sourceConfiguration(SharePointSourceConfiguration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        @Override
        public SharePointDataSourceConfiguration build() {
            return new SharePointDataSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
