/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The endpoint information to connect to your SharePoint data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SharePointSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SharePointSourceConfiguration.Builder, SharePointSourceConfiguration> {
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authType").getter(getter(SharePointSourceConfiguration::authTypeAsString))
            .setter(setter(Builder::authType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()).build();

    private static final SdkField<String> CREDENTIALS_SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialsSecretArn").getter(getter(SharePointSourceConfiguration::credentialsSecretArn))
            .setter(setter(Builder::credentialsSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsSecretArn").build())
            .build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(SharePointSourceConfiguration::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()).build();

    private static final SdkField<String> HOST_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostType").getter(getter(SharePointSourceConfiguration::hostTypeAsString))
            .setter(setter(Builder::hostType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostType").build()).build();

    private static final SdkField<List<String>> SITE_URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("siteUrls")
            .getter(getter(SharePointSourceConfiguration::siteUrls))
            .setter(setter(Builder::siteUrls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("siteUrls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TENANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tenantId").getter(getter(SharePointSourceConfiguration::tenantId)).setter(setter(Builder::tenantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tenantId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_TYPE_FIELD,
            CREDENTIALS_SECRET_ARN_FIELD, DOMAIN_FIELD, HOST_TYPE_FIELD, SITE_URLS_FIELD, TENANT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String authType;

    private final String credentialsSecretArn;

    private final String domain;

    private final String hostType;

    private final List<String> siteUrls;

    private final String tenantId;

    private SharePointSourceConfiguration(BuilderImpl builder) {
        this.authType = builder.authType;
        this.credentialsSecretArn = builder.credentialsSecretArn;
        this.domain = builder.domain;
        this.hostType = builder.hostType;
        this.siteUrls = builder.siteUrls;
        this.tenantId = builder.tenantId;
    }

    /**
     * <p>
     * The supported authentication type to authenticate and connect to your SharePoint site/sites.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link SharePointAuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The supported authentication type to authenticate and connect to your SharePoint site/sites.
     * @see SharePointAuthType
     */
    public final SharePointAuthType authType() {
        return SharePointAuthType.fromValue(authType);
    }

    /**
     * <p>
     * The supported authentication type to authenticate and connect to your SharePoint site/sites.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link SharePointAuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The supported authentication type to authenticate and connect to your SharePoint site/sites.
     * @see SharePointAuthType
     */
    public final String authTypeAsString() {
        return authType;
    }

    /**
     * <p>
     * The Amazon Resource Name of an Secrets Manager secret that stores your authentication credentials for your
     * SharePoint site/sites. For more information on the key-value pairs that must be included in your secret,
     * depending on your authentication type, see <a href=
     * "https://docs.aws.amazon.com/bedrock/latest/userguide/sharepoint-data-source-connector.html#configuration-sharepoint-connector"
     * >SharePoint connection configuration</a>.
     * </p>
     * 
     * @return The Amazon Resource Name of an Secrets Manager secret that stores your authentication credentials for
     *         your SharePoint site/sites. For more information on the key-value pairs that must be included in your
     *         secret, depending on your authentication type, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/sharepoint-data-source-connector.html#configuration-sharepoint-connector"
     *         >SharePoint connection configuration</a>.
     */
    public final String credentialsSecretArn() {
        return credentialsSecretArn;
    }

    /**
     * <p>
     * The domain of your SharePoint instance or site URL/URLs.
     * </p>
     * 
     * @return The domain of your SharePoint instance or site URL/URLs.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The supported host type, whether online/cloud or server/on-premises.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hostType} will
     * return {@link SharePointHostType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hostTypeAsString}.
     * </p>
     * 
     * @return The supported host type, whether online/cloud or server/on-premises.
     * @see SharePointHostType
     */
    public final SharePointHostType hostType() {
        return SharePointHostType.fromValue(hostType);
    }

    /**
     * <p>
     * The supported host type, whether online/cloud or server/on-premises.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hostType} will
     * return {@link SharePointHostType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hostTypeAsString}.
     * </p>
     * 
     * @return The supported host type, whether online/cloud or server/on-premises.
     * @see SharePointHostType
     */
    public final String hostTypeAsString() {
        return hostType;
    }

    /**
     * For responses, this returns true if the service returned a value for the SiteUrls property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSiteUrls() {
        return siteUrls != null && !(siteUrls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of one or more SharePoint site URLs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSiteUrls} method.
     * </p>
     * 
     * @return A list of one or more SharePoint site URLs.
     */
    public final List<String> siteUrls() {
        return siteUrls;
    }

    /**
     * <p>
     * The identifier of your Microsoft 365 tenant.
     * </p>
     * 
     * @return The identifier of your Microsoft 365 tenant.
     */
    public final String tenantId() {
        return tenantId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(credentialsSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(hostTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSiteUrls() ? siteUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tenantId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SharePointSourceConfiguration)) {
            return false;
        }
        SharePointSourceConfiguration other = (SharePointSourceConfiguration) obj;
        return Objects.equals(authTypeAsString(), other.authTypeAsString())
                && Objects.equals(credentialsSecretArn(), other.credentialsSecretArn())
                && Objects.equals(domain(), other.domain()) && Objects.equals(hostTypeAsString(), other.hostTypeAsString())
                && hasSiteUrls() == other.hasSiteUrls() && Objects.equals(siteUrls(), other.siteUrls())
                && Objects.equals(tenantId(), other.tenantId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SharePointSourceConfiguration").add("AuthType", authTypeAsString())
                .add("CredentialsSecretArn", credentialsSecretArn()).add("Domain", domain()).add("HostType", hostTypeAsString())
                .add("SiteUrls", hasSiteUrls() ? siteUrls() : null).add("TenantId", tenantId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authType":
            return Optional.ofNullable(clazz.cast(authTypeAsString()));
        case "credentialsSecretArn":
            return Optional.ofNullable(clazz.cast(credentialsSecretArn()));
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "hostType":
            return Optional.ofNullable(clazz.cast(hostTypeAsString()));
        case "siteUrls":
            return Optional.ofNullable(clazz.cast(siteUrls()));
        case "tenantId":
            return Optional.ofNullable(clazz.cast(tenantId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authType", AUTH_TYPE_FIELD);
        map.put("credentialsSecretArn", CREDENTIALS_SECRET_ARN_FIELD);
        map.put("domain", DOMAIN_FIELD);
        map.put("hostType", HOST_TYPE_FIELD);
        map.put("siteUrls", SITE_URLS_FIELD);
        map.put("tenantId", TENANT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SharePointSourceConfiguration, T> g) {
        return obj -> g.apply((SharePointSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SharePointSourceConfiguration> {
        /**
         * <p>
         * The supported authentication type to authenticate and connect to your SharePoint site/sites.
         * </p>
         * 
         * @param authType
         *        The supported authentication type to authenticate and connect to your SharePoint site/sites.
         * @see SharePointAuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SharePointAuthType
         */
        Builder authType(String authType);

        /**
         * <p>
         * The supported authentication type to authenticate and connect to your SharePoint site/sites.
         * </p>
         * 
         * @param authType
         *        The supported authentication type to authenticate and connect to your SharePoint site/sites.
         * @see SharePointAuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SharePointAuthType
         */
        Builder authType(SharePointAuthType authType);

        /**
         * <p>
         * The Amazon Resource Name of an Secrets Manager secret that stores your authentication credentials for your
         * SharePoint site/sites. For more information on the key-value pairs that must be included in your secret,
         * depending on your authentication type, see <a href=
         * "https://docs.aws.amazon.com/bedrock/latest/userguide/sharepoint-data-source-connector.html#configuration-sharepoint-connector"
         * >SharePoint connection configuration</a>.
         * </p>
         * 
         * @param credentialsSecretArn
         *        The Amazon Resource Name of an Secrets Manager secret that stores your authentication credentials for
         *        your SharePoint site/sites. For more information on the key-value pairs that must be included in your
         *        secret, depending on your authentication type, see <a href=
         *        "https://docs.aws.amazon.com/bedrock/latest/userguide/sharepoint-data-source-connector.html#configuration-sharepoint-connector"
         *        >SharePoint connection configuration</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsSecretArn(String credentialsSecretArn);

        /**
         * <p>
         * The domain of your SharePoint instance or site URL/URLs.
         * </p>
         * 
         * @param domain
         *        The domain of your SharePoint instance or site URL/URLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The supported host type, whether online/cloud or server/on-premises.
         * </p>
         * 
         * @param hostType
         *        The supported host type, whether online/cloud or server/on-premises.
         * @see SharePointHostType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SharePointHostType
         */
        Builder hostType(String hostType);

        /**
         * <p>
         * The supported host type, whether online/cloud or server/on-premises.
         * </p>
         * 
         * @param hostType
         *        The supported host type, whether online/cloud or server/on-premises.
         * @see SharePointHostType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SharePointHostType
         */
        Builder hostType(SharePointHostType hostType);

        /**
         * <p>
         * A list of one or more SharePoint site URLs.
         * </p>
         * 
         * @param siteUrls
         *        A list of one or more SharePoint site URLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder siteUrls(Collection<String> siteUrls);

        /**
         * <p>
         * A list of one or more SharePoint site URLs.
         * </p>
         * 
         * @param siteUrls
         *        A list of one or more SharePoint site URLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder siteUrls(String... siteUrls);

        /**
         * <p>
         * The identifier of your Microsoft 365 tenant.
         * </p>
         * 
         * @param tenantId
         *        The identifier of your Microsoft 365 tenant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenantId(String tenantId);
    }

    static final class BuilderImpl implements Builder {
        private String authType;

        private String credentialsSecretArn;

        private String domain;

        private String hostType;

        private List<String> siteUrls = DefaultSdkAutoConstructList.getInstance();

        private String tenantId;

        private BuilderImpl() {
        }

        private BuilderImpl(SharePointSourceConfiguration model) {
            authType(model.authType);
            credentialsSecretArn(model.credentialsSecretArn);
            domain(model.domain);
            hostType(model.hostType);
            siteUrls(model.siteUrls);
            tenantId(model.tenantId);
        }

        public final String getAuthType() {
            return authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(SharePointAuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final String getCredentialsSecretArn() {
            return credentialsSecretArn;
        }

        public final void setCredentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
        }

        @Override
        public final Builder credentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getHostType() {
            return hostType;
        }

        public final void setHostType(String hostType) {
            this.hostType = hostType;
        }

        @Override
        public final Builder hostType(String hostType) {
            this.hostType = hostType;
            return this;
        }

        @Override
        public final Builder hostType(SharePointHostType hostType) {
            this.hostType(hostType == null ? null : hostType.toString());
            return this;
        }

        public final Collection<String> getSiteUrls() {
            if (siteUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return siteUrls;
        }

        public final void setSiteUrls(Collection<String> siteUrls) {
            this.siteUrls = SharePointSiteUrlsCopier.copy(siteUrls);
        }

        @Override
        public final Builder siteUrls(Collection<String> siteUrls) {
            this.siteUrls = SharePointSiteUrlsCopier.copy(siteUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder siteUrls(String... siteUrls) {
            siteUrls(Arrays.asList(siteUrls));
            return this;
        }

        public final String getTenantId() {
            return tenantId;
        }

        public final void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        @Override
        public final Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Override
        public SharePointSourceConfiguration build() {
            return new SharePointSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
