/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures the Amazon Bedrock reranker model to improve the relevance of retrieved results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VectorSearchBedrockRerankingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VectorSearchBedrockRerankingConfiguration.Builder, VectorSearchBedrockRerankingConfiguration> {
    private static final SdkField<MetadataConfigurationForReranking> METADATA_CONFIGURATION_FIELD = SdkField
            .<MetadataConfigurationForReranking> builder(MarshallingType.SDK_POJO).memberName("metadataConfiguration")
            .getter(getter(VectorSearchBedrockRerankingConfiguration::metadataConfiguration))
            .setter(setter(Builder::metadataConfiguration)).constructor(MetadataConfigurationForReranking::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataConfiguration").build())
            .build();

    private static final SdkField<VectorSearchBedrockRerankingModelConfiguration> MODEL_CONFIGURATION_FIELD = SdkField
            .<VectorSearchBedrockRerankingModelConfiguration> builder(MarshallingType.SDK_POJO).memberName("modelConfiguration")
            .getter(getter(VectorSearchBedrockRerankingConfiguration::modelConfiguration))
            .setter(setter(Builder::modelConfiguration)).constructor(VectorSearchBedrockRerankingModelConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelConfiguration").build())
            .build();

    private static final SdkField<Integer> NUMBER_OF_RERANKED_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfRerankedResults")
            .getter(getter(VectorSearchBedrockRerankingConfiguration::numberOfRerankedResults))
            .setter(setter(Builder::numberOfRerankedResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRerankedResults").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_CONFIGURATION_FIELD,
            MODEL_CONFIGURATION_FIELD, NUMBER_OF_RERANKED_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MetadataConfigurationForReranking metadataConfiguration;

    private final VectorSearchBedrockRerankingModelConfiguration modelConfiguration;

    private final Integer numberOfRerankedResults;

    private VectorSearchBedrockRerankingConfiguration(BuilderImpl builder) {
        this.metadataConfiguration = builder.metadataConfiguration;
        this.modelConfiguration = builder.modelConfiguration;
        this.numberOfRerankedResults = builder.numberOfRerankedResults;
    }

    /**
     * <p>
     * Specifies how metadata fields should be handled during the reranking process.
     * </p>
     * 
     * @return Specifies how metadata fields should be handled during the reranking process.
     */
    public final MetadataConfigurationForReranking metadataConfiguration() {
        return metadataConfiguration;
    }

    /**
     * <p>
     * Specifies the configuration for the Amazon Bedrock reranker model.
     * </p>
     * 
     * @return Specifies the configuration for the Amazon Bedrock reranker model.
     */
    public final VectorSearchBedrockRerankingModelConfiguration modelConfiguration() {
        return modelConfiguration;
    }

    /**
     * <p>
     * Specifies the number of results to return after reranking.
     * </p>
     * 
     * @return Specifies the number of results to return after reranking.
     */
    public final Integer numberOfRerankedResults() {
        return numberOfRerankedResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metadataConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(modelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfRerankedResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VectorSearchBedrockRerankingConfiguration)) {
            return false;
        }
        VectorSearchBedrockRerankingConfiguration other = (VectorSearchBedrockRerankingConfiguration) obj;
        return Objects.equals(metadataConfiguration(), other.metadataConfiguration())
                && Objects.equals(modelConfiguration(), other.modelConfiguration())
                && Objects.equals(numberOfRerankedResults(), other.numberOfRerankedResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VectorSearchBedrockRerankingConfiguration")
                .add("MetadataConfiguration", metadataConfiguration()).add("ModelConfiguration", modelConfiguration())
                .add("NumberOfRerankedResults", numberOfRerankedResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metadataConfiguration":
            return Optional.ofNullable(clazz.cast(metadataConfiguration()));
        case "modelConfiguration":
            return Optional.ofNullable(clazz.cast(modelConfiguration()));
        case "numberOfRerankedResults":
            return Optional.ofNullable(clazz.cast(numberOfRerankedResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("metadataConfiguration", METADATA_CONFIGURATION_FIELD);
        map.put("modelConfiguration", MODEL_CONFIGURATION_FIELD);
        map.put("numberOfRerankedResults", NUMBER_OF_RERANKED_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VectorSearchBedrockRerankingConfiguration, T> g) {
        return obj -> g.apply((VectorSearchBedrockRerankingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VectorSearchBedrockRerankingConfiguration> {
        /**
         * <p>
         * Specifies how metadata fields should be handled during the reranking process.
         * </p>
         * 
         * @param metadataConfiguration
         *        Specifies how metadata fields should be handled during the reranking process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataConfiguration(MetadataConfigurationForReranking metadataConfiguration);

        /**
         * <p>
         * Specifies how metadata fields should be handled during the reranking process.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MetadataConfigurationForReranking.Builder} avoiding the need to create one manually via
         * {@link MetadataConfigurationForReranking#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetadataConfigurationForReranking.Builder#build()} is called
         * immediately and its result is passed to {@link #metadataConfiguration(MetadataConfigurationForReranking)}.
         * 
         * @param metadataConfiguration
         *        a consumer that will call methods on {@link MetadataConfigurationForReranking.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataConfiguration(MetadataConfigurationForReranking)
         */
        default Builder metadataConfiguration(Consumer<MetadataConfigurationForReranking.Builder> metadataConfiguration) {
            return metadataConfiguration(MetadataConfigurationForReranking.builder().applyMutation(metadataConfiguration).build());
        }

        /**
         * <p>
         * Specifies the configuration for the Amazon Bedrock reranker model.
         * </p>
         * 
         * @param modelConfiguration
         *        Specifies the configuration for the Amazon Bedrock reranker model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelConfiguration(VectorSearchBedrockRerankingModelConfiguration modelConfiguration);

        /**
         * <p>
         * Specifies the configuration for the Amazon Bedrock reranker model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link VectorSearchBedrockRerankingModelConfiguration.Builder} avoiding the need to create one manually via
         * {@link VectorSearchBedrockRerankingModelConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VectorSearchBedrockRerankingModelConfiguration.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #modelConfiguration(VectorSearchBedrockRerankingModelConfiguration)}.
         * 
         * @param modelConfiguration
         *        a consumer that will call methods on {@link VectorSearchBedrockRerankingModelConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelConfiguration(VectorSearchBedrockRerankingModelConfiguration)
         */
        default Builder modelConfiguration(Consumer<VectorSearchBedrockRerankingModelConfiguration.Builder> modelConfiguration) {
            return modelConfiguration(VectorSearchBedrockRerankingModelConfiguration.builder().applyMutation(modelConfiguration)
                    .build());
        }

        /**
         * <p>
         * Specifies the number of results to return after reranking.
         * </p>
         * 
         * @param numberOfRerankedResults
         *        Specifies the number of results to return after reranking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfRerankedResults(Integer numberOfRerankedResults);
    }

    static final class BuilderImpl implements Builder {
        private MetadataConfigurationForReranking metadataConfiguration;

        private VectorSearchBedrockRerankingModelConfiguration modelConfiguration;

        private Integer numberOfRerankedResults;

        private BuilderImpl() {
        }

        private BuilderImpl(VectorSearchBedrockRerankingConfiguration model) {
            metadataConfiguration(model.metadataConfiguration);
            modelConfiguration(model.modelConfiguration);
            numberOfRerankedResults(model.numberOfRerankedResults);
        }

        public final MetadataConfigurationForReranking.Builder getMetadataConfiguration() {
            return metadataConfiguration != null ? metadataConfiguration.toBuilder() : null;
        }

        public final void setMetadataConfiguration(MetadataConfigurationForReranking.BuilderImpl metadataConfiguration) {
            this.metadataConfiguration = metadataConfiguration != null ? metadataConfiguration.build() : null;
        }

        @Override
        public final Builder metadataConfiguration(MetadataConfigurationForReranking metadataConfiguration) {
            this.metadataConfiguration = metadataConfiguration;
            return this;
        }

        public final VectorSearchBedrockRerankingModelConfiguration.Builder getModelConfiguration() {
            return modelConfiguration != null ? modelConfiguration.toBuilder() : null;
        }

        public final void setModelConfiguration(VectorSearchBedrockRerankingModelConfiguration.BuilderImpl modelConfiguration) {
            this.modelConfiguration = modelConfiguration != null ? modelConfiguration.build() : null;
        }

        @Override
        public final Builder modelConfiguration(VectorSearchBedrockRerankingModelConfiguration modelConfiguration) {
            this.modelConfiguration = modelConfiguration;
            return this;
        }

        public final Integer getNumberOfRerankedResults() {
            return numberOfRerankedResults;
        }

        public final void setNumberOfRerankedResults(Integer numberOfRerankedResults) {
            this.numberOfRerankedResults = numberOfRerankedResults;
        }

        @Override
        public final Builder numberOfRerankedResults(Integer numberOfRerankedResults) {
            this.numberOfRerankedResults = numberOfRerankedResults;
            return this;
        }

        @Override
        public VectorSearchBedrockRerankingConfiguration build() {
            return new VectorSearchBedrockRerankingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
