/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures the Amazon Bedrock model used for reranking retrieved results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VectorSearchBedrockRerankingModelConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VectorSearchBedrockRerankingModelConfiguration.Builder, VectorSearchBedrockRerankingModelConfiguration> {
    private static final SdkField<Map<String, Document>> ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD = SdkField
            .<Map<String, Document>> builder(MarshallingType.MAP)
            .memberName("additionalModelRequestFields")
            .getter(getter(VectorSearchBedrockRerankingModelConfiguration::additionalModelRequestFields))
            .setter(setter(Builder::additionalModelRequestFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalModelRequestFields")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Document> builder(MarshallingType.DOCUMENT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelArn").getter(getter(VectorSearchBedrockRerankingModelConfiguration::modelArn))
            .setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD, MODEL_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, Document> additionalModelRequestFields;

    private final String modelArn;

    private VectorSearchBedrockRerankingModelConfiguration(BuilderImpl builder) {
        this.additionalModelRequestFields = builder.additionalModelRequestFields;
        this.modelArn = builder.modelArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalModelRequestFields property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalModelRequestFields() {
        return additionalModelRequestFields != null && !(additionalModelRequestFields instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies additional model-specific request parameters as key-value pairs that are included in the request to the
     * Amazon Bedrock reranker model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalModelRequestFields} method.
     * </p>
     * 
     * @return Specifies additional model-specific request parameters as key-value pairs that are included in the
     *         request to the Amazon Bedrock reranker model.
     */
    public final Map<String, Document> additionalModelRequestFields() {
        return additionalModelRequestFields;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Bedrock reranker model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Bedrock reranker model.
     */
    public final String modelArn() {
        return modelArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalModelRequestFields() ? additionalModelRequestFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VectorSearchBedrockRerankingModelConfiguration)) {
            return false;
        }
        VectorSearchBedrockRerankingModelConfiguration other = (VectorSearchBedrockRerankingModelConfiguration) obj;
        return hasAdditionalModelRequestFields() == other.hasAdditionalModelRequestFields()
                && Objects.equals(additionalModelRequestFields(), other.additionalModelRequestFields())
                && Objects.equals(modelArn(), other.modelArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VectorSearchBedrockRerankingModelConfiguration")
                .add("AdditionalModelRequestFields", hasAdditionalModelRequestFields() ? additionalModelRequestFields() : null)
                .add("ModelArn", modelArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "additionalModelRequestFields":
            return Optional.ofNullable(clazz.cast(additionalModelRequestFields()));
        case "modelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("additionalModelRequestFields", ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD);
        map.put("modelArn", MODEL_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VectorSearchBedrockRerankingModelConfiguration, T> g) {
        return obj -> g.apply((VectorSearchBedrockRerankingModelConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VectorSearchBedrockRerankingModelConfiguration> {
        /**
         * <p>
         * Specifies additional model-specific request parameters as key-value pairs that are included in the request to
         * the Amazon Bedrock reranker model.
         * </p>
         * 
         * @param additionalModelRequestFields
         *        Specifies additional model-specific request parameters as key-value pairs that are included in the
         *        request to the Amazon Bedrock reranker model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalModelRequestFields(Map<String, Document> additionalModelRequestFields);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Bedrock reranker model.
         * </p>
         * 
         * @param modelArn
         *        The Amazon Resource Name (ARN) of the Amazon Bedrock reranker model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, Document> additionalModelRequestFields = DefaultSdkAutoConstructMap.getInstance();

        private String modelArn;

        private BuilderImpl() {
        }

        private BuilderImpl(VectorSearchBedrockRerankingModelConfiguration model) {
            additionalModelRequestFields(model.additionalModelRequestFields);
            modelArn(model.modelArn);
        }

        public final Map<String, Document> getAdditionalModelRequestFields() {
            if (additionalModelRequestFields instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalModelRequestFields;
        }

        public final void setAdditionalModelRequestFields(Map<String, Document> additionalModelRequestFields) {
            this.additionalModelRequestFields = AdditionalModelRequestFieldsCopier.copy(additionalModelRequestFields);
        }

        @Override
        public final Builder additionalModelRequestFields(Map<String, Document> additionalModelRequestFields) {
            this.additionalModelRequestFields = AdditionalModelRequestFieldsCopier.copy(additionalModelRequestFields);
            return this;
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        @Override
        public VectorSearchBedrockRerankingModelConfiguration build() {
            return new VectorSearchBedrockRerankingModelConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
