/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteFlowAliasRequest
extends BedrockAgentRequest
implements ToCopyableBuilder<Builder, DeleteFlowAliasRequest> {
    private static final SdkField<String> ALIAS_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aliasIdentifier").getter(DeleteFlowAliasRequest.getter(DeleteFlowAliasRequest::aliasIdentifier)).setter(DeleteFlowAliasRequest.setter(Builder::aliasIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("aliasIdentifier").build()}).build();
    private static final SdkField<String> FLOW_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowIdentifier").getter(DeleteFlowAliasRequest.getter(DeleteFlowAliasRequest::flowIdentifier)).setter(DeleteFlowAliasRequest.setter(Builder::flowIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("flowIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_IDENTIFIER_FIELD, FLOW_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteFlowAliasRequest.memberNameToFieldInitializer();
    private final String aliasIdentifier;
    private final String flowIdentifier;

    private DeleteFlowAliasRequest(BuilderImpl builder) {
        super(builder);
        this.aliasIdentifier = builder.aliasIdentifier;
        this.flowIdentifier = builder.flowIdentifier;
    }

    public final String aliasIdentifier() {
        return this.aliasIdentifier;
    }

    public final String flowIdentifier() {
        return this.flowIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFlowAliasRequest)) {
            return false;
        }
        DeleteFlowAliasRequest other = (DeleteFlowAliasRequest)((Object)obj);
        return Objects.equals(this.aliasIdentifier(), other.aliasIdentifier()) && Objects.equals(this.flowIdentifier(), other.flowIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteFlowAliasRequest").add("AliasIdentifier", (Object)this.aliasIdentifier()).add("FlowIdentifier", (Object)this.flowIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "aliasIdentifier": {
                return Optional.ofNullable(clazz.cast(this.aliasIdentifier()));
            }
            case "flowIdentifier": {
                return Optional.ofNullable(clazz.cast(this.flowIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("aliasIdentifier", ALIAS_IDENTIFIER_FIELD);
        map.put("flowIdentifier", FLOW_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteFlowAliasRequest, T> g) {
        return obj -> g.apply((DeleteFlowAliasRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRequest.BuilderImpl
    implements Builder {
        private String aliasIdentifier;
        private String flowIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFlowAliasRequest model) {
            super(model);
            this.aliasIdentifier(model.aliasIdentifier);
            this.flowIdentifier(model.flowIdentifier);
        }

        public final String getAliasIdentifier() {
            return this.aliasIdentifier;
        }

        public final void setAliasIdentifier(String aliasIdentifier) {
            this.aliasIdentifier = aliasIdentifier;
        }

        @Override
        public final Builder aliasIdentifier(String aliasIdentifier) {
            this.aliasIdentifier = aliasIdentifier;
            return this;
        }

        public final String getFlowIdentifier() {
            return this.flowIdentifier;
        }

        public final void setFlowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
        }

        @Override
        public final Builder flowIdentifier(String flowIdentifier) {
            this.flowIdentifier = flowIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteFlowAliasRequest build() {
            return new DeleteFlowAliasRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteFlowAliasRequest> {
        public Builder aliasIdentifier(String var1);

        public Builder flowIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

