/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.QueryGenerationConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.RedshiftQueryEngineConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.RedshiftQueryEngineStorageConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.RedshiftQueryEngineStorageConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftConfiguration> {
    private static final SdkField<RedshiftQueryEngineConfiguration> QUERY_ENGINE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("queryEngineConfiguration").getter(RedshiftConfiguration.getter(RedshiftConfiguration::queryEngineConfiguration)).setter(RedshiftConfiguration.setter(Builder::queryEngineConfiguration)).constructor(RedshiftQueryEngineConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryEngineConfiguration").build()}).build();
    private static final SdkField<QueryGenerationConfiguration> QUERY_GENERATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("queryGenerationConfiguration").getter(RedshiftConfiguration.getter(RedshiftConfiguration::queryGenerationConfiguration)).setter(RedshiftConfiguration.setter(Builder::queryGenerationConfiguration)).constructor(QueryGenerationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryGenerationConfiguration").build()}).build();
    private static final SdkField<List<RedshiftQueryEngineStorageConfiguration>> STORAGE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("storageConfigurations").getter(RedshiftConfiguration.getter(RedshiftConfiguration::storageConfigurations)).setter(RedshiftConfiguration.setter(Builder::storageConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RedshiftQueryEngineStorageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ENGINE_CONFIGURATION_FIELD, QUERY_GENERATION_CONFIGURATION_FIELD, STORAGE_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RedshiftConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RedshiftQueryEngineConfiguration queryEngineConfiguration;
    private final QueryGenerationConfiguration queryGenerationConfiguration;
    private final List<RedshiftQueryEngineStorageConfiguration> storageConfigurations;

    private RedshiftConfiguration(BuilderImpl builder) {
        this.queryEngineConfiguration = builder.queryEngineConfiguration;
        this.queryGenerationConfiguration = builder.queryGenerationConfiguration;
        this.storageConfigurations = builder.storageConfigurations;
    }

    public final RedshiftQueryEngineConfiguration queryEngineConfiguration() {
        return this.queryEngineConfiguration;
    }

    public final QueryGenerationConfiguration queryGenerationConfiguration() {
        return this.queryGenerationConfiguration;
    }

    public final boolean hasStorageConfigurations() {
        return this.storageConfigurations != null && !(this.storageConfigurations instanceof SdkAutoConstructList);
    }

    public final List<RedshiftQueryEngineStorageConfiguration> storageConfigurations() {
        return this.storageConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryEngineConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryGenerationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorageConfigurations() ? this.storageConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftConfiguration)) {
            return false;
        }
        RedshiftConfiguration other = (RedshiftConfiguration)obj;
        return Objects.equals(this.queryEngineConfiguration(), other.queryEngineConfiguration()) && Objects.equals(this.queryGenerationConfiguration(), other.queryGenerationConfiguration()) && this.hasStorageConfigurations() == other.hasStorageConfigurations() && Objects.equals(this.storageConfigurations(), other.storageConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftConfiguration").add("QueryEngineConfiguration", (Object)this.queryEngineConfiguration()).add("QueryGenerationConfiguration", (Object)this.queryGenerationConfiguration()).add("StorageConfigurations", this.hasStorageConfigurations() ? this.storageConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "queryEngineConfiguration": {
                return Optional.ofNullable(clazz.cast(this.queryEngineConfiguration()));
            }
            case "queryGenerationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.queryGenerationConfiguration()));
            }
            case "storageConfigurations": {
                return Optional.ofNullable(clazz.cast(this.storageConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("queryEngineConfiguration", QUERY_ENGINE_CONFIGURATION_FIELD);
        map.put("queryGenerationConfiguration", QUERY_GENERATION_CONFIGURATION_FIELD);
        map.put("storageConfigurations", STORAGE_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftConfiguration, T> g) {
        return obj -> g.apply((RedshiftConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RedshiftQueryEngineConfiguration queryEngineConfiguration;
        private QueryGenerationConfiguration queryGenerationConfiguration;
        private List<RedshiftQueryEngineStorageConfiguration> storageConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftConfiguration model) {
            this.queryEngineConfiguration(model.queryEngineConfiguration);
            this.queryGenerationConfiguration(model.queryGenerationConfiguration);
            this.storageConfigurations(model.storageConfigurations);
        }

        public final RedshiftQueryEngineConfiguration.Builder getQueryEngineConfiguration() {
            return this.queryEngineConfiguration != null ? this.queryEngineConfiguration.toBuilder() : null;
        }

        public final void setQueryEngineConfiguration(RedshiftQueryEngineConfiguration.BuilderImpl queryEngineConfiguration) {
            this.queryEngineConfiguration = queryEngineConfiguration != null ? queryEngineConfiguration.build() : null;
        }

        @Override
        public final Builder queryEngineConfiguration(RedshiftQueryEngineConfiguration queryEngineConfiguration) {
            this.queryEngineConfiguration = queryEngineConfiguration;
            return this;
        }

        public final QueryGenerationConfiguration.Builder getQueryGenerationConfiguration() {
            return this.queryGenerationConfiguration != null ? this.queryGenerationConfiguration.toBuilder() : null;
        }

        public final void setQueryGenerationConfiguration(QueryGenerationConfiguration.BuilderImpl queryGenerationConfiguration) {
            this.queryGenerationConfiguration = queryGenerationConfiguration != null ? queryGenerationConfiguration.build() : null;
        }

        @Override
        public final Builder queryGenerationConfiguration(QueryGenerationConfiguration queryGenerationConfiguration) {
            this.queryGenerationConfiguration = queryGenerationConfiguration;
            return this;
        }

        public final List<RedshiftQueryEngineStorageConfiguration.Builder> getStorageConfigurations() {
            List<RedshiftQueryEngineStorageConfiguration.Builder> result = RedshiftQueryEngineStorageConfigurationsCopier.copyToBuilder(this.storageConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageConfigurations(Collection<RedshiftQueryEngineStorageConfiguration.BuilderImpl> storageConfigurations) {
            this.storageConfigurations = RedshiftQueryEngineStorageConfigurationsCopier.copyFromBuilder(storageConfigurations);
        }

        @Override
        public final Builder storageConfigurations(Collection<RedshiftQueryEngineStorageConfiguration> storageConfigurations) {
            this.storageConfigurations = RedshiftQueryEngineStorageConfigurationsCopier.copy(storageConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConfigurations(RedshiftQueryEngineStorageConfiguration ... storageConfigurations) {
            this.storageConfigurations(Arrays.asList(storageConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConfigurations(Consumer<RedshiftQueryEngineStorageConfiguration.Builder> ... storageConfigurations) {
            this.storageConfigurations(Stream.of(storageConfigurations).map(c -> (RedshiftQueryEngineStorageConfiguration)((RedshiftQueryEngineStorageConfiguration.Builder)RedshiftQueryEngineStorageConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RedshiftConfiguration build() {
            return new RedshiftConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftConfiguration> {
        public Builder queryEngineConfiguration(RedshiftQueryEngineConfiguration var1);

        default public Builder queryEngineConfiguration(Consumer<RedshiftQueryEngineConfiguration.Builder> queryEngineConfiguration) {
            return this.queryEngineConfiguration((RedshiftQueryEngineConfiguration)((RedshiftQueryEngineConfiguration.Builder)RedshiftQueryEngineConfiguration.builder().applyMutation(queryEngineConfiguration)).build());
        }

        public Builder queryGenerationConfiguration(QueryGenerationConfiguration var1);

        default public Builder queryGenerationConfiguration(Consumer<QueryGenerationConfiguration.Builder> queryGenerationConfiguration) {
            return this.queryGenerationConfiguration((QueryGenerationConfiguration)((QueryGenerationConfiguration.Builder)QueryGenerationConfiguration.builder().applyMutation(queryGenerationConfiguration)).build());
        }

        public Builder storageConfigurations(Collection<RedshiftQueryEngineStorageConfiguration> var1);

        public Builder storageConfigurations(RedshiftQueryEngineStorageConfiguration ... var1);

        public Builder storageConfigurations(Consumer<RedshiftQueryEngineStorageConfiguration.Builder> ... var1);
    }
}

