/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.AgentDescriptor;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.RelayConversationHistory;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateAgentCollaboratorRequest
extends BedrockAgentRequest
implements ToCopyableBuilder<Builder, AssociateAgentCollaboratorRequest> {
    private static final SdkField<AgentDescriptor> AGENT_DESCRIPTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("agentDescriptor").getter(AssociateAgentCollaboratorRequest.getter(AssociateAgentCollaboratorRequest::agentDescriptor)).setter(AssociateAgentCollaboratorRequest.setter(Builder::agentDescriptor)).constructor(AgentDescriptor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentDescriptor").build()}).build();
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(AssociateAgentCollaboratorRequest.getter(AssociateAgentCollaboratorRequest::agentId)).setter(AssociateAgentCollaboratorRequest.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentId").build()}).build();
    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentVersion").getter(AssociateAgentCollaboratorRequest.getter(AssociateAgentCollaboratorRequest::agentVersion)).setter(AssociateAgentCollaboratorRequest.setter(Builder::agentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentVersion").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(AssociateAgentCollaboratorRequest.getter(AssociateAgentCollaboratorRequest::clientToken)).setter(AssociateAgentCollaboratorRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> COLLABORATION_INSTRUCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationInstruction").getter(AssociateAgentCollaboratorRequest.getter(AssociateAgentCollaboratorRequest::collaborationInstruction)).setter(AssociateAgentCollaboratorRequest.setter(Builder::collaborationInstruction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationInstruction").build()}).build();
    private static final SdkField<String> COLLABORATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaboratorName").getter(AssociateAgentCollaboratorRequest.getter(AssociateAgentCollaboratorRequest::collaboratorName)).setter(AssociateAgentCollaboratorRequest.setter(Builder::collaboratorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaboratorName").build()}).build();
    private static final SdkField<String> RELAY_CONVERSATION_HISTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relayConversationHistory").getter(AssociateAgentCollaboratorRequest.getter(AssociateAgentCollaboratorRequest::relayConversationHistoryAsString)).setter(AssociateAgentCollaboratorRequest.setter(Builder::relayConversationHistory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relayConversationHistory").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_DESCRIPTOR_FIELD, AGENT_ID_FIELD, AGENT_VERSION_FIELD, CLIENT_TOKEN_FIELD, COLLABORATION_INSTRUCTION_FIELD, COLLABORATOR_NAME_FIELD, RELAY_CONVERSATION_HISTORY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateAgentCollaboratorRequest.memberNameToFieldInitializer();
    private final AgentDescriptor agentDescriptor;
    private final String agentId;
    private final String agentVersion;
    private final String clientToken;
    private final String collaborationInstruction;
    private final String collaboratorName;
    private final String relayConversationHistory;

    private AssociateAgentCollaboratorRequest(BuilderImpl builder) {
        super(builder);
        this.agentDescriptor = builder.agentDescriptor;
        this.agentId = builder.agentId;
        this.agentVersion = builder.agentVersion;
        this.clientToken = builder.clientToken;
        this.collaborationInstruction = builder.collaborationInstruction;
        this.collaboratorName = builder.collaboratorName;
        this.relayConversationHistory = builder.relayConversationHistory;
    }

    public final AgentDescriptor agentDescriptor() {
        return this.agentDescriptor;
    }

    public final String agentId() {
        return this.agentId;
    }

    public final String agentVersion() {
        return this.agentVersion;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String collaborationInstruction() {
        return this.collaborationInstruction;
    }

    public final String collaboratorName() {
        return this.collaboratorName;
    }

    public final RelayConversationHistory relayConversationHistory() {
        return RelayConversationHistory.fromValue(this.relayConversationHistory);
    }

    public final String relayConversationHistoryAsString() {
        return this.relayConversationHistory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agentDescriptor());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationInstruction());
        hashCode = 31 * hashCode + Objects.hashCode(this.collaboratorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.relayConversationHistoryAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateAgentCollaboratorRequest)) {
            return false;
        }
        AssociateAgentCollaboratorRequest other = (AssociateAgentCollaboratorRequest)((Object)obj);
        return Objects.equals(this.agentDescriptor(), other.agentDescriptor()) && Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.agentVersion(), other.agentVersion()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.collaborationInstruction(), other.collaborationInstruction()) && Objects.equals(this.collaboratorName(), other.collaboratorName()) && Objects.equals(this.relayConversationHistoryAsString(), other.relayConversationHistoryAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateAgentCollaboratorRequest").add("AgentDescriptor", (Object)this.agentDescriptor()).add("AgentId", (Object)this.agentId()).add("AgentVersion", (Object)this.agentVersion()).add("ClientToken", (Object)this.clientToken()).add("CollaborationInstruction", (Object)(this.collaborationInstruction() == null ? null : "*** Sensitive Data Redacted ***")).add("CollaboratorName", (Object)this.collaboratorName()).add("RelayConversationHistory", (Object)this.relayConversationHistoryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentDescriptor": {
                return Optional.ofNullable(clazz.cast(this.agentDescriptor()));
            }
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "agentVersion": {
                return Optional.ofNullable(clazz.cast(this.agentVersion()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "collaborationInstruction": {
                return Optional.ofNullable(clazz.cast(this.collaborationInstruction()));
            }
            case "collaboratorName": {
                return Optional.ofNullable(clazz.cast(this.collaboratorName()));
            }
            case "relayConversationHistory": {
                return Optional.ofNullable(clazz.cast(this.relayConversationHistoryAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("agentDescriptor", AGENT_DESCRIPTOR_FIELD);
        map.put("agentId", AGENT_ID_FIELD);
        map.put("agentVersion", AGENT_VERSION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("collaborationInstruction", COLLABORATION_INSTRUCTION_FIELD);
        map.put("collaboratorName", COLLABORATOR_NAME_FIELD);
        map.put("relayConversationHistory", RELAY_CONVERSATION_HISTORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateAgentCollaboratorRequest, T> g) {
        return obj -> g.apply((AssociateAgentCollaboratorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRequest.BuilderImpl
    implements Builder {
        private AgentDescriptor agentDescriptor;
        private String agentId;
        private String agentVersion;
        private String clientToken;
        private String collaborationInstruction;
        private String collaboratorName;
        private String relayConversationHistory;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateAgentCollaboratorRequest model) {
            super(model);
            this.agentDescriptor(model.agentDescriptor);
            this.agentId(model.agentId);
            this.agentVersion(model.agentVersion);
            this.clientToken(model.clientToken);
            this.collaborationInstruction(model.collaborationInstruction);
            this.collaboratorName(model.collaboratorName);
            this.relayConversationHistory(model.relayConversationHistory);
        }

        public final AgentDescriptor.Builder getAgentDescriptor() {
            return this.agentDescriptor != null ? this.agentDescriptor.toBuilder() : null;
        }

        public final void setAgentDescriptor(AgentDescriptor.BuilderImpl agentDescriptor) {
            this.agentDescriptor = agentDescriptor != null ? agentDescriptor.build() : null;
        }

        @Override
        public final Builder agentDescriptor(AgentDescriptor agentDescriptor) {
            this.agentDescriptor = agentDescriptor;
            return this;
        }

        public final String getAgentId() {
            return this.agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getCollaborationInstruction() {
            return this.collaborationInstruction;
        }

        public final void setCollaborationInstruction(String collaborationInstruction) {
            this.collaborationInstruction = collaborationInstruction;
        }

        @Override
        public final Builder collaborationInstruction(String collaborationInstruction) {
            this.collaborationInstruction = collaborationInstruction;
            return this;
        }

        public final String getCollaboratorName() {
            return this.collaboratorName;
        }

        public final void setCollaboratorName(String collaboratorName) {
            this.collaboratorName = collaboratorName;
        }

        @Override
        public final Builder collaboratorName(String collaboratorName) {
            this.collaboratorName = collaboratorName;
            return this;
        }

        public final String getRelayConversationHistory() {
            return this.relayConversationHistory;
        }

        public final void setRelayConversationHistory(String relayConversationHistory) {
            this.relayConversationHistory = relayConversationHistory;
        }

        @Override
        public final Builder relayConversationHistory(String relayConversationHistory) {
            this.relayConversationHistory = relayConversationHistory;
            return this;
        }

        @Override
        public final Builder relayConversationHistory(RelayConversationHistory relayConversationHistory) {
            this.relayConversationHistory(relayConversationHistory == null ? null : relayConversationHistory.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateAgentCollaboratorRequest build() {
            return new AssociateAgentCollaboratorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateAgentCollaboratorRequest> {
        public Builder agentDescriptor(AgentDescriptor var1);

        default public Builder agentDescriptor(Consumer<AgentDescriptor.Builder> agentDescriptor) {
            return this.agentDescriptor((AgentDescriptor)((AgentDescriptor.Builder)AgentDescriptor.builder().applyMutation(agentDescriptor)).build());
        }

        public Builder agentId(String var1);

        public Builder agentVersion(String var1);

        public Builder clientToken(String var1);

        public Builder collaborationInstruction(String var1);

        public Builder collaboratorName(String var1);

        public Builder relayConversationHistory(String var1);

        public Builder relayConversationHistory(RelayConversationHistory var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

