/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.ByteContentDoc;
import software.amazon.awssdk.services.bedrockagent.model.InlineContentType;
import software.amazon.awssdk.services.bedrockagent.model.TextContentDoc;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InlineContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InlineContent> {
    private static final SdkField<ByteContentDoc> BYTE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("byteContent").getter(InlineContent.getter(InlineContent::byteContent)).setter(InlineContent.setter(Builder::byteContent)).constructor(ByteContentDoc::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("byteContent").build()}).build();
    private static final SdkField<TextContentDoc> TEXT_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("textContent").getter(InlineContent.getter(InlineContent::textContent)).setter(InlineContent.setter(Builder::textContent)).constructor(TextContentDoc::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textContent").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(InlineContent.getter(InlineContent::typeAsString)).setter(InlineContent.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTE_CONTENT_FIELD, TEXT_CONTENT_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InlineContent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ByteContentDoc byteContent;
    private final TextContentDoc textContent;
    private final String type;

    private InlineContent(BuilderImpl builder) {
        this.byteContent = builder.byteContent;
        this.textContent = builder.textContent;
        this.type = builder.type;
    }

    public final ByteContentDoc byteContent() {
        return this.byteContent;
    }

    public final TextContentDoc textContent() {
        return this.textContent;
    }

    public final InlineContentType type() {
        return InlineContentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.byteContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.textContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InlineContent)) {
            return false;
        }
        InlineContent other = (InlineContent)obj;
        return Objects.equals(this.byteContent(), other.byteContent()) && Objects.equals(this.textContent(), other.textContent()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InlineContent").add("ByteContent", (Object)this.byteContent()).add("TextContent", (Object)this.textContent()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "byteContent": {
                return Optional.ofNullable(clazz.cast(this.byteContent()));
            }
            case "textContent": {
                return Optional.ofNullable(clazz.cast(this.textContent()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("byteContent", BYTE_CONTENT_FIELD);
        map.put("textContent", TEXT_CONTENT_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InlineContent, T> g) {
        return obj -> g.apply((InlineContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ByteContentDoc byteContent;
        private TextContentDoc textContent;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(InlineContent model) {
            this.byteContent(model.byteContent);
            this.textContent(model.textContent);
            this.type(model.type);
        }

        public final ByteContentDoc.Builder getByteContent() {
            return this.byteContent != null ? this.byteContent.toBuilder() : null;
        }

        public final void setByteContent(ByteContentDoc.BuilderImpl byteContent) {
            this.byteContent = byteContent != null ? byteContent.build() : null;
        }

        @Override
        public final Builder byteContent(ByteContentDoc byteContent) {
            this.byteContent = byteContent;
            return this;
        }

        public final TextContentDoc.Builder getTextContent() {
            return this.textContent != null ? this.textContent.toBuilder() : null;
        }

        public final void setTextContent(TextContentDoc.BuilderImpl textContent) {
            this.textContent = textContent != null ? textContent.build() : null;
        }

        @Override
        public final Builder textContent(TextContentDoc textContent) {
            this.textContent = textContent;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InlineContentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public InlineContent build() {
            return new InlineContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InlineContent> {
        public Builder byteContent(ByteContentDoc var1);

        default public Builder byteContent(Consumer<ByteContentDoc.Builder> byteContent) {
            return this.byteContent((ByteContentDoc)((ByteContentDoc.Builder)ByteContentDoc.builder().applyMutation(byteContent)).build());
        }

        public Builder textContent(TextContentDoc var1);

        default public Builder textContent(Consumer<TextContentDoc.Builder> textContent) {
            return this.textContent((TextContentDoc)((TextContentDoc.Builder)TextContentDoc.builder().applyMutation(textContent)).build());
        }

        public Builder type(String var1);

        public Builder type(InlineContentType var1);
    }
}

