/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.PromptInferenceConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.PromptTemplateConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.PromptTemplateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PromptFlowNodeInlineConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PromptFlowNodeInlineConfiguration> {
    private static final SdkField<Document> ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("additionalModelRequestFields").getter(PromptFlowNodeInlineConfiguration.getter(PromptFlowNodeInlineConfiguration::additionalModelRequestFields)).setter(PromptFlowNodeInlineConfiguration.setter(Builder::additionalModelRequestFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalModelRequestFields").build()}).build();
    private static final SdkField<PromptInferenceConfiguration> INFERENCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inferenceConfiguration").getter(PromptFlowNodeInlineConfiguration.getter(PromptFlowNodeInlineConfiguration::inferenceConfiguration)).setter(PromptFlowNodeInlineConfiguration.setter(Builder::inferenceConfiguration)).constructor(PromptInferenceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfiguration").build()}).build();
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(PromptFlowNodeInlineConfiguration.getter(PromptFlowNodeInlineConfiguration::modelId)).setter(PromptFlowNodeInlineConfiguration.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<PromptTemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("templateConfiguration").getter(PromptFlowNodeInlineConfiguration.getter(PromptFlowNodeInlineConfiguration::templateConfiguration)).setter(PromptFlowNodeInlineConfiguration.setter(Builder::templateConfiguration)).constructor(PromptTemplateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateConfiguration").build()}).build();
    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateType").getter(PromptFlowNodeInlineConfiguration.getter(PromptFlowNodeInlineConfiguration::templateTypeAsString)).setter(PromptFlowNodeInlineConfiguration.setter(Builder::templateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD, INFERENCE_CONFIGURATION_FIELD, MODEL_ID_FIELD, TEMPLATE_CONFIGURATION_FIELD, TEMPLATE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PromptFlowNodeInlineConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Document additionalModelRequestFields;
    private final PromptInferenceConfiguration inferenceConfiguration;
    private final String modelId;
    private final PromptTemplateConfiguration templateConfiguration;
    private final String templateType;

    private PromptFlowNodeInlineConfiguration(BuilderImpl builder) {
        this.additionalModelRequestFields = builder.additionalModelRequestFields;
        this.inferenceConfiguration = builder.inferenceConfiguration;
        this.modelId = builder.modelId;
        this.templateConfiguration = builder.templateConfiguration;
        this.templateType = builder.templateType;
    }

    public final Document additionalModelRequestFields() {
        return this.additionalModelRequestFields;
    }

    public final PromptInferenceConfiguration inferenceConfiguration() {
        return this.inferenceConfiguration;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final PromptTemplateConfiguration templateConfiguration() {
        return this.templateConfiguration;
    }

    public final PromptTemplateType templateType() {
        return PromptTemplateType.fromValue(this.templateType);
    }

    public final String templateTypeAsString() {
        return this.templateType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalModelRequestFields());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PromptFlowNodeInlineConfiguration)) {
            return false;
        }
        PromptFlowNodeInlineConfiguration other = (PromptFlowNodeInlineConfiguration)obj;
        return Objects.equals(this.additionalModelRequestFields(), other.additionalModelRequestFields()) && Objects.equals(this.inferenceConfiguration(), other.inferenceConfiguration()) && Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.templateConfiguration(), other.templateConfiguration()) && Objects.equals(this.templateTypeAsString(), other.templateTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PromptFlowNodeInlineConfiguration").add("AdditionalModelRequestFields", (Object)this.additionalModelRequestFields()).add("InferenceConfiguration", (Object)this.inferenceConfiguration()).add("ModelId", (Object)this.modelId()).add("TemplateConfiguration", (Object)this.templateConfiguration()).add("TemplateType", (Object)this.templateTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "additionalModelRequestFields": {
                return Optional.ofNullable(clazz.cast(this.additionalModelRequestFields()));
            }
            case "inferenceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inferenceConfiguration()));
            }
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "templateConfiguration": {
                return Optional.ofNullable(clazz.cast(this.templateConfiguration()));
            }
            case "templateType": {
                return Optional.ofNullable(clazz.cast(this.templateTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("additionalModelRequestFields", ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD);
        map.put("inferenceConfiguration", INFERENCE_CONFIGURATION_FIELD);
        map.put("modelId", MODEL_ID_FIELD);
        map.put("templateConfiguration", TEMPLATE_CONFIGURATION_FIELD);
        map.put("templateType", TEMPLATE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PromptFlowNodeInlineConfiguration, T> g) {
        return obj -> g.apply((PromptFlowNodeInlineConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Document additionalModelRequestFields;
        private PromptInferenceConfiguration inferenceConfiguration;
        private String modelId;
        private PromptTemplateConfiguration templateConfiguration;
        private String templateType;

        private BuilderImpl() {
        }

        private BuilderImpl(PromptFlowNodeInlineConfiguration model) {
            this.additionalModelRequestFields(model.additionalModelRequestFields);
            this.inferenceConfiguration(model.inferenceConfiguration);
            this.modelId(model.modelId);
            this.templateConfiguration(model.templateConfiguration);
            this.templateType(model.templateType);
        }

        public final Document getAdditionalModelRequestFields() {
            return this.additionalModelRequestFields;
        }

        public final void setAdditionalModelRequestFields(Document additionalModelRequestFields) {
            this.additionalModelRequestFields = additionalModelRequestFields;
        }

        @Override
        public final Builder additionalModelRequestFields(Document additionalModelRequestFields) {
            this.additionalModelRequestFields = additionalModelRequestFields;
            return this;
        }

        public final PromptInferenceConfiguration.Builder getInferenceConfiguration() {
            return this.inferenceConfiguration != null ? this.inferenceConfiguration.toBuilder() : null;
        }

        public final void setInferenceConfiguration(PromptInferenceConfiguration.BuilderImpl inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration != null ? inferenceConfiguration.build() : null;
        }

        @Override
        public final Builder inferenceConfiguration(PromptInferenceConfiguration inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration;
            return this;
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final PromptTemplateConfiguration.Builder getTemplateConfiguration() {
            return this.templateConfiguration != null ? this.templateConfiguration.toBuilder() : null;
        }

        public final void setTemplateConfiguration(PromptTemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        @Override
        public final Builder templateConfiguration(PromptTemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        public final String getTemplateType() {
            return this.templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public final Builder templateType(PromptTemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        public PromptFlowNodeInlineConfiguration build() {
            return new PromptFlowNodeInlineConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PromptFlowNodeInlineConfiguration> {
        public Builder additionalModelRequestFields(Document var1);

        public Builder inferenceConfiguration(PromptInferenceConfiguration var1);

        default public Builder inferenceConfiguration(Consumer<PromptInferenceConfiguration.Builder> inferenceConfiguration) {
            return this.inferenceConfiguration((PromptInferenceConfiguration)((PromptInferenceConfiguration.Builder)PromptInferenceConfiguration.builder().applyMutation(inferenceConfiguration)).build());
        }

        public Builder modelId(String var1);

        public Builder templateConfiguration(PromptTemplateConfiguration var1);

        default public Builder templateConfiguration(Consumer<PromptTemplateConfiguration.Builder> templateConfiguration) {
            return this.templateConfiguration((PromptTemplateConfiguration)((PromptTemplateConfiguration.Builder)PromptTemplateConfiguration.builder().applyMutation(templateConfiguration)).build());
        }

        public Builder templateType(String var1);

        public Builder templateType(PromptTemplateType var1);
    }
}

