/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3VectorsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3VectorsConfiguration> {
    private static final SdkField<String> INDEX_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexArn").getter(S3VectorsConfiguration.getter(S3VectorsConfiguration::indexArn)).setter(S3VectorsConfiguration.setter(Builder::indexArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexArn").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("indexName").getter(S3VectorsConfiguration.getter(S3VectorsConfiguration::indexName)).setter(S3VectorsConfiguration.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()}).build();
    private static final SdkField<String> VECTOR_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vectorBucketArn").getter(S3VectorsConfiguration.getter(S3VectorsConfiguration::vectorBucketArn)).setter(S3VectorsConfiguration.setter(Builder::vectorBucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorBucketArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ARN_FIELD, INDEX_NAME_FIELD, VECTOR_BUCKET_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3VectorsConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String indexArn;
    private final String indexName;
    private final String vectorBucketArn;

    private S3VectorsConfiguration(BuilderImpl builder) {
        this.indexArn = builder.indexArn;
        this.indexName = builder.indexName;
        this.vectorBucketArn = builder.vectorBucketArn;
    }

    public final String indexArn() {
        return this.indexArn;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final String vectorBucketArn() {
        return this.vectorBucketArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indexArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vectorBucketArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3VectorsConfiguration)) {
            return false;
        }
        S3VectorsConfiguration other = (S3VectorsConfiguration)obj;
        return Objects.equals(this.indexArn(), other.indexArn()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.vectorBucketArn(), other.vectorBucketArn());
    }

    public final String toString() {
        return ToString.builder((String)"S3VectorsConfiguration").add("IndexArn", (Object)(this.indexArn() == null ? null : "*** Sensitive Data Redacted ***")).add("IndexName", (Object)(this.indexName() == null ? null : "*** Sensitive Data Redacted ***")).add("VectorBucketArn", (Object)(this.vectorBucketArn() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "indexArn": {
                return Optional.ofNullable(clazz.cast(this.indexArn()));
            }
            case "indexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "vectorBucketArn": {
                return Optional.ofNullable(clazz.cast(this.vectorBucketArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("indexArn", INDEX_ARN_FIELD);
        map.put("indexName", INDEX_NAME_FIELD);
        map.put("vectorBucketArn", VECTOR_BUCKET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3VectorsConfiguration, T> g) {
        return obj -> g.apply((S3VectorsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String indexArn;
        private String indexName;
        private String vectorBucketArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3VectorsConfiguration model) {
            this.indexArn(model.indexArn);
            this.indexName(model.indexName);
            this.vectorBucketArn(model.vectorBucketArn);
        }

        public final String getIndexArn() {
            return this.indexArn;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getVectorBucketArn() {
            return this.vectorBucketArn;
        }

        public final void setVectorBucketArn(String vectorBucketArn) {
            this.vectorBucketArn = vectorBucketArn;
        }

        @Override
        public final Builder vectorBucketArn(String vectorBucketArn) {
            this.vectorBucketArn = vectorBucketArn;
            return this;
        }

        public S3VectorsConfiguration build() {
            return new S3VectorsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3VectorsConfiguration> {
        public Builder indexArn(String var1);

        public Builder indexName(String var1);

        public Builder vectorBucketArn(String var1);
    }
}

