/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.PromptVariant;
import software.amazon.awssdk.services.bedrockagent.model.PromptVariantListCopier;
import software.amazon.awssdk.services.bedrockagent.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePromptRequest
extends BedrockAgentRequest
implements ToCopyableBuilder<Builder, CreatePromptRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreatePromptRequest.getter(CreatePromptRequest::name)).setter(CreatePromptRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreatePromptRequest.getter(CreatePromptRequest::description)).setter(CreatePromptRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> CUSTOMER_ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerEncryptionKeyArn").getter(CreatePromptRequest.getter(CreatePromptRequest::customerEncryptionKeyArn)).setter(CreatePromptRequest.setter(Builder::customerEncryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerEncryptionKeyArn").build()}).build();
    private static final SdkField<String> DEFAULT_VARIANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultVariant").getter(CreatePromptRequest.getter(CreatePromptRequest::defaultVariant)).setter(CreatePromptRequest.setter(Builder::defaultVariant)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVariant").build()}).build();
    private static final SdkField<List<PromptVariant>> VARIANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("variants").getter(CreatePromptRequest.getter(CreatePromptRequest::variants)).setter(CreatePromptRequest.setter(Builder::variants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PromptVariant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreatePromptRequest.getter(CreatePromptRequest::clientToken)).setter(CreatePromptRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreatePromptRequest.getter(CreatePromptRequest::tags)).setter(CreatePromptRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, CUSTOMER_ENCRYPTION_KEY_ARN_FIELD, DEFAULT_VARIANT_FIELD, VARIANTS_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePromptRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String customerEncryptionKeyArn;
    private final String defaultVariant;
    private final List<PromptVariant> variants;
    private final String clientToken;
    private final Map<String, String> tags;

    private CreatePromptRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.customerEncryptionKeyArn = builder.customerEncryptionKeyArn;
        this.defaultVariant = builder.defaultVariant;
        this.variants = builder.variants;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String customerEncryptionKeyArn() {
        return this.customerEncryptionKeyArn;
    }

    public final String defaultVariant() {
        return this.defaultVariant;
    }

    public final boolean hasVariants() {
        return this.variants != null && !(this.variants instanceof SdkAutoConstructList);
    }

    public final List<PromptVariant> variants() {
        return this.variants;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerEncryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVariant());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariants() ? this.variants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePromptRequest)) {
            return false;
        }
        CreatePromptRequest other = (CreatePromptRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.customerEncryptionKeyArn(), other.customerEncryptionKeyArn()) && Objects.equals(this.defaultVariant(), other.defaultVariant()) && this.hasVariants() == other.hasVariants() && Objects.equals(this.variants(), other.variants()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePromptRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("CustomerEncryptionKeyArn", (Object)this.customerEncryptionKeyArn()).add("DefaultVariant", (Object)this.defaultVariant()).add("Variants", (Object)(this.variants() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "customerEncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.customerEncryptionKeyArn()));
            }
            case "defaultVariant": {
                return Optional.ofNullable(clazz.cast(this.defaultVariant()));
            }
            case "variants": {
                return Optional.ofNullable(clazz.cast(this.variants()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("customerEncryptionKeyArn", CUSTOMER_ENCRYPTION_KEY_ARN_FIELD);
        map.put("defaultVariant", DEFAULT_VARIANT_FIELD);
        map.put("variants", VARIANTS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePromptRequest, T> g) {
        return obj -> g.apply((CreatePromptRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String customerEncryptionKeyArn;
        private String defaultVariant;
        private List<PromptVariant> variants = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePromptRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.customerEncryptionKeyArn(model.customerEncryptionKeyArn);
            this.defaultVariant(model.defaultVariant);
            this.variants(model.variants);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCustomerEncryptionKeyArn() {
            return this.customerEncryptionKeyArn;
        }

        public final void setCustomerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
        }

        @Override
        public final Builder customerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
            return this;
        }

        public final String getDefaultVariant() {
            return this.defaultVariant;
        }

        public final void setDefaultVariant(String defaultVariant) {
            this.defaultVariant = defaultVariant;
        }

        @Override
        public final Builder defaultVariant(String defaultVariant) {
            this.defaultVariant = defaultVariant;
            return this;
        }

        public final List<PromptVariant.Builder> getVariants() {
            List<PromptVariant.Builder> result = PromptVariantListCopier.copyToBuilder(this.variants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariants(Collection<PromptVariant.BuilderImpl> variants) {
            this.variants = PromptVariantListCopier.copyFromBuilder(variants);
        }

        @Override
        public final Builder variants(Collection<PromptVariant> variants) {
            this.variants = PromptVariantListCopier.copy(variants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variants(PromptVariant ... variants) {
            this.variants(Arrays.asList(variants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variants(Consumer<PromptVariant.Builder> ... variants) {
            this.variants(Stream.of(variants).map(c -> (PromptVariant)((PromptVariant.Builder)PromptVariant.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePromptRequest build() {
            return new CreatePromptRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePromptRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder customerEncryptionKeyArn(String var1);

        public Builder defaultVariant(String var1);

        public Builder variants(Collection<PromptVariant> var1);

        public Builder variants(PromptVariant ... var1);

        public Builder variants(Consumer<PromptVariant.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

