/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about a knowledge base that is associated with an agent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentKnowledgeBase implements SdkPojo, Serializable,
        ToCopyableBuilder<AgentKnowledgeBase.Builder, AgentKnowledgeBase> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(AgentKnowledgeBase::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()).build();

    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentVersion").getter(getter(AgentKnowledgeBase::agentVersion)).setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentVersion").build()).build();

    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(AgentKnowledgeBase::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AgentKnowledgeBase::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(AgentKnowledgeBase::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(AgentKnowledgeBase::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> KNOWLEDGE_BASE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseState").getter(getter(AgentKnowledgeBase::knowledgeBaseStateAsString))
            .setter(setter(Builder::knowledgeBaseState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseState").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD,
            AGENT_VERSION_FIELD, KNOWLEDGE_BASE_ID_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD,
            KNOWLEDGE_BASE_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String agentId;

    private final String agentVersion;

    private final String knowledgeBaseId;

    private final String description;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String knowledgeBaseState;

    private AgentKnowledgeBase(BuilderImpl builder) {
        this.agentId = builder.agentId;
        this.agentVersion = builder.agentVersion;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.knowledgeBaseState = builder.knowledgeBaseState;
    }

    /**
     * <p>
     * The unique identifier of the agent with which the knowledge base is associated.
     * </p>
     * 
     * @return The unique identifier of the agent with which the knowledge base is associated.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * The version of the agent with which the knowledge base is associated.
     * </p>
     * 
     * @return The version of the agent with which the knowledge base is associated.
     */
    public final String agentVersion() {
        return agentVersion;
    }

    /**
     * <p>
     * The unique identifier of the association between the agent and the knowledge base.
     * </p>
     * 
     * @return The unique identifier of the association between the agent and the knowledge base.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The description of the association between the agent and the knowledge base.
     * </p>
     * 
     * @return The description of the association between the agent and the knowledge base.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The time at which the association between the agent and the knowledge base was created.
     * </p>
     * 
     * @return The time at which the association between the agent and the knowledge base was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time at which the association between the agent and the knowledge base was last updated.
     * </p>
     * 
     * @return The time at which the association between the agent and the knowledge base was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * Specifies whether to use the knowledge base or not when sending an <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a>
     * request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #knowledgeBaseState} will return {@link KnowledgeBaseState#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #knowledgeBaseStateAsString}.
     * </p>
     * 
     * @return Specifies whether to use the knowledge base or not when sending an <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html"
     *         >InvokeAgent</a> request.
     * @see KnowledgeBaseState
     */
    public final KnowledgeBaseState knowledgeBaseState() {
        return KnowledgeBaseState.fromValue(knowledgeBaseState);
    }

    /**
     * <p>
     * Specifies whether to use the knowledge base or not when sending an <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a>
     * request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #knowledgeBaseState} will return {@link KnowledgeBaseState#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #knowledgeBaseStateAsString}.
     * </p>
     * 
     * @return Specifies whether to use the knowledge base or not when sending an <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html"
     *         >InvokeAgent</a> request.
     * @see KnowledgeBaseState
     */
    public final String knowledgeBaseStateAsString() {
        return knowledgeBaseState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentKnowledgeBase)) {
            return false;
        }
        AgentKnowledgeBase other = (AgentKnowledgeBase) obj;
        return Objects.equals(agentId(), other.agentId()) && Objects.equals(agentVersion(), other.agentVersion())
                && Objects.equals(knowledgeBaseId(), other.knowledgeBaseId())
                && Objects.equals(description(), other.description()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(knowledgeBaseStateAsString(), other.knowledgeBaseStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentKnowledgeBase").add("AgentId", agentId()).add("AgentVersion", agentVersion())
                .add("KnowledgeBaseId", knowledgeBaseId()).add("Description", description()).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).add("KnowledgeBaseState", knowledgeBaseStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "agentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "knowledgeBaseState":
            return Optional.ofNullable(clazz.cast(knowledgeBaseStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentId", AGENT_ID_FIELD);
        map.put("agentVersion", AGENT_VERSION_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("knowledgeBaseState", KNOWLEDGE_BASE_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentKnowledgeBase, T> g) {
        return obj -> g.apply((AgentKnowledgeBase) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentKnowledgeBase> {
        /**
         * <p>
         * The unique identifier of the agent with which the knowledge base is associated.
         * </p>
         * 
         * @param agentId
         *        The unique identifier of the agent with which the knowledge base is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * The version of the agent with which the knowledge base is associated.
         * </p>
         * 
         * @param agentVersion
         *        The version of the agent with which the knowledge base is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        /**
         * <p>
         * The unique identifier of the association between the agent and the knowledge base.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The unique identifier of the association between the agent and the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The description of the association between the agent and the knowledge base.
         * </p>
         * 
         * @param description
         *        The description of the association between the agent and the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The time at which the association between the agent and the knowledge base was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the association between the agent and the knowledge base was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time at which the association between the agent and the knowledge base was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The time at which the association between the agent and the knowledge base was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * Specifies whether to use the knowledge base or not when sending an <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html"
         * >InvokeAgent</a> request.
         * </p>
         * 
         * @param knowledgeBaseState
         *        Specifies whether to use the knowledge base or not when sending an <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html"
         *        >InvokeAgent</a> request.
         * @see KnowledgeBaseState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseState
         */
        Builder knowledgeBaseState(String knowledgeBaseState);

        /**
         * <p>
         * Specifies whether to use the knowledge base or not when sending an <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html"
         * >InvokeAgent</a> request.
         * </p>
         * 
         * @param knowledgeBaseState
         *        Specifies whether to use the knowledge base or not when sending an <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html"
         *        >InvokeAgent</a> request.
         * @see KnowledgeBaseState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseState
         */
        Builder knowledgeBaseState(KnowledgeBaseState knowledgeBaseState);
    }

    static final class BuilderImpl implements Builder {
        private String agentId;

        private String agentVersion;

        private String knowledgeBaseId;

        private String description;

        private Instant createdAt;

        private Instant updatedAt;

        private String knowledgeBaseState;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentKnowledgeBase model) {
            agentId(model.agentId);
            agentVersion(model.agentVersion);
            knowledgeBaseId(model.knowledgeBaseId);
            description(model.description);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            knowledgeBaseState(model.knowledgeBaseState);
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getKnowledgeBaseState() {
            return knowledgeBaseState;
        }

        public final void setKnowledgeBaseState(String knowledgeBaseState) {
            this.knowledgeBaseState = knowledgeBaseState;
        }

        @Override
        public final Builder knowledgeBaseState(String knowledgeBaseState) {
            this.knowledgeBaseState = knowledgeBaseState;
            return this;
        }

        @Override
        public final Builder knowledgeBaseState(KnowledgeBaseState knowledgeBaseState) {
            this.knowledgeBaseState(knowledgeBaseState == null ? null : knowledgeBaseState.toString());
            return this;
        }

        @Override
        public AgentKnowledgeBase build() {
            return new AgentKnowledgeBase(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
