/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations about a node in the flow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowNode implements SdkPojo, Serializable, ToCopyableBuilder<FlowNode.Builder, FlowNode> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(FlowNode::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(FlowNode::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<FlowNodeConfiguration> CONFIGURATION_FIELD = SdkField
            .<FlowNodeConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(FlowNode::configuration)).setter(setter(Builder::configuration))
            .constructor(FlowNodeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<List<FlowNodeInput>> INPUTS_FIELD = SdkField
            .<List<FlowNodeInput>> builder(MarshallingType.LIST)
            .memberName("inputs")
            .getter(getter(FlowNode::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FlowNodeInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(FlowNodeInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FlowNodeOutput>> OUTPUTS_FIELD = SdkField
            .<List<FlowNodeOutput>> builder(MarshallingType.LIST)
            .memberName("outputs")
            .getter(getter(FlowNode::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FlowNodeOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(FlowNodeOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            CONFIGURATION_FIELD, INPUTS_FIELD, OUTPUTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private final FlowNodeConfiguration configuration;

    private final List<FlowNodeInput> inputs;

    private final List<FlowNodeOutput> outputs;

    private FlowNode(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.configuration = builder.configuration;
        this.inputs = builder.inputs;
        this.outputs = builder.outputs;
    }

    /**
     * <p>
     * A name for the node.
     * </p>
     * 
     * @return A name for the node.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of node. This value must match the name of the key that you provide in the configuration you provide in
     * the <code>FlowNodeConfiguration</code> field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FlowNodeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of node. This value must match the name of the key that you provide in the configuration you
     *         provide in the <code>FlowNodeConfiguration</code> field.
     * @see FlowNodeType
     */
    public final FlowNodeType type() {
        return FlowNodeType.fromValue(type);
    }

    /**
     * <p>
     * The type of node. This value must match the name of the key that you provide in the configuration you provide in
     * the <code>FlowNodeConfiguration</code> field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FlowNodeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of node. This value must match the name of the key that you provide in the configuration you
     *         provide in the <code>FlowNodeConfiguration</code> field.
     * @see FlowNodeType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Contains configurations for the node.
     * </p>
     * 
     * @return Contains configurations for the node.
     */
    public final FlowNodeConfiguration configuration() {
        return configuration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, each of which contains information about an input into the node.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return An array of objects, each of which contains information about an input into the node.
     */
    public final List<FlowNodeInput> inputs() {
        return inputs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects, each of which contains information about an output from the node.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return A list of objects, each of which contains information about an output from the node.
     */
    public final List<FlowNodeOutput> outputs() {
        return outputs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowNode)) {
            return false;
        }
        FlowNode other = (FlowNode) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(configuration(), other.configuration()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs()) && hasOutputs() == other.hasOutputs()
                && Objects.equals(outputs(), other.outputs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowNode").add("Name", name()).add("Type", typeAsString()).add("Configuration", configuration())
                .add("Inputs", hasInputs() ? inputs() : null).add("Outputs", hasOutputs() ? outputs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("inputs", INPUTS_FIELD);
        map.put("outputs", OUTPUTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowNode, T> g) {
        return obj -> g.apply((FlowNode) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowNode> {
        /**
         * <p>
         * A name for the node.
         * </p>
         * 
         * @param name
         *        A name for the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of node. This value must match the name of the key that you provide in the configuration you provide
         * in the <code>FlowNodeConfiguration</code> field.
         * </p>
         * 
         * @param type
         *        The type of node. This value must match the name of the key that you provide in the configuration you
         *        provide in the <code>FlowNodeConfiguration</code> field.
         * @see FlowNodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowNodeType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of node. This value must match the name of the key that you provide in the configuration you provide
         * in the <code>FlowNodeConfiguration</code> field.
         * </p>
         * 
         * @param type
         *        The type of node. This value must match the name of the key that you provide in the configuration you
         *        provide in the <code>FlowNodeConfiguration</code> field.
         * @see FlowNodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowNodeType
         */
        Builder type(FlowNodeType type);

        /**
         * <p>
         * Contains configurations for the node.
         * </p>
         * 
         * @param configuration
         *        Contains configurations for the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(FlowNodeConfiguration configuration);

        /**
         * <p>
         * Contains configurations for the node.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowNodeConfiguration.Builder} avoiding
         * the need to create one manually via {@link FlowNodeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowNodeConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #configuration(FlowNodeConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link FlowNodeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(FlowNodeConfiguration)
         */
        default Builder configuration(Consumer<FlowNodeConfiguration.Builder> configuration) {
            return configuration(FlowNodeConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * An array of objects, each of which contains information about an input into the node.
         * </p>
         * 
         * @param inputs
         *        An array of objects, each of which contains information about an input into the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<FlowNodeInput> inputs);

        /**
         * <p>
         * An array of objects, each of which contains information about an input into the node.
         * </p>
         * 
         * @param inputs
         *        An array of objects, each of which contains information about an input into the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(FlowNodeInput... inputs);

        /**
         * <p>
         * An array of objects, each of which contains information about an input into the node.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.FlowNodeInput.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.bedrockagent.model.FlowNodeInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.FlowNodeInput.Builder#build()} is called
         * immediately and its result is passed to {@link #inputs(List<FlowNodeInput>)}.
         * 
         * @param inputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.FlowNodeInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputs(java.util.Collection<FlowNodeInput>)
         */
        Builder inputs(Consumer<FlowNodeInput.Builder>... inputs);

        /**
         * <p>
         * A list of objects, each of which contains information about an output from the node.
         * </p>
         * 
         * @param outputs
         *        A list of objects, each of which contains information about an output from the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<FlowNodeOutput> outputs);

        /**
         * <p>
         * A list of objects, each of which contains information about an output from the node.
         * </p>
         * 
         * @param outputs
         *        A list of objects, each of which contains information about an output from the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(FlowNodeOutput... outputs);

        /**
         * <p>
         * A list of objects, each of which contains information about an output from the node.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.FlowNodeOutput.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.bedrockagent.model.FlowNodeOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.FlowNodeOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #outputs(List<FlowNodeOutput>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.FlowNodeOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(java.util.Collection<FlowNodeOutput>)
         */
        Builder outputs(Consumer<FlowNodeOutput.Builder>... outputs);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private FlowNodeConfiguration configuration;

        private List<FlowNodeInput> inputs = DefaultSdkAutoConstructList.getInstance();

        private List<FlowNodeOutput> outputs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FlowNode model) {
            name(model.name);
            type(model.type);
            configuration(model.configuration);
            inputs(model.inputs);
            outputs(model.outputs);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FlowNodeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final FlowNodeConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(FlowNodeConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(FlowNodeConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final List<FlowNodeInput.Builder> getInputs() {
            List<FlowNodeInput.Builder> result = FlowNodeInputsCopier.copyToBuilder(this.inputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputs(Collection<FlowNodeInput.BuilderImpl> inputs) {
            this.inputs = FlowNodeInputsCopier.copyFromBuilder(inputs);
        }

        @Override
        public final Builder inputs(Collection<FlowNodeInput> inputs) {
            this.inputs = FlowNodeInputsCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(FlowNodeInput... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<FlowNodeInput.Builder>... inputs) {
            inputs(Stream.of(inputs).map(c -> FlowNodeInput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FlowNodeOutput.Builder> getOutputs() {
            List<FlowNodeOutput.Builder> result = FlowNodeOutputsCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<FlowNodeOutput.BuilderImpl> outputs) {
            this.outputs = FlowNodeOutputsCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<FlowNodeOutput> outputs) {
            this.outputs = FlowNodeOutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(FlowNodeOutput... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<FlowNodeOutput.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> FlowNodeOutput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public FlowNode build() {
            return new FlowNode(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
