/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A union type containing various possible validation issues in the flow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowValidationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowValidationDetails.Builder, FlowValidationDetails> {
    private static final SdkField<CyclicConnectionFlowValidationDetails> CYCLIC_CONNECTION_FIELD = SdkField
            .<CyclicConnectionFlowValidationDetails> builder(MarshallingType.SDK_POJO).memberName("cyclicConnection")
            .getter(getter(FlowValidationDetails::cyclicConnection)).setter(setter(Builder::cyclicConnection))
            .constructor(CyclicConnectionFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cyclicConnection").build()).build();

    private static final SdkField<DuplicateConnectionsFlowValidationDetails> DUPLICATE_CONNECTIONS_FIELD = SdkField
            .<DuplicateConnectionsFlowValidationDetails> builder(MarshallingType.SDK_POJO).memberName("duplicateConnections")
            .getter(getter(FlowValidationDetails::duplicateConnections)).setter(setter(Builder::duplicateConnections))
            .constructor(DuplicateConnectionsFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duplicateConnections").build())
            .build();

    private static final SdkField<DuplicateConditionExpressionFlowValidationDetails> DUPLICATE_CONDITION_EXPRESSION_FIELD = SdkField
            .<DuplicateConditionExpressionFlowValidationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("duplicateConditionExpression")
            .getter(getter(FlowValidationDetails::duplicateConditionExpression))
            .setter(setter(Builder::duplicateConditionExpression))
            .constructor(DuplicateConditionExpressionFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duplicateConditionExpression")
                    .build()).build();

    private static final SdkField<UnreachableNodeFlowValidationDetails> UNREACHABLE_NODE_FIELD = SdkField
            .<UnreachableNodeFlowValidationDetails> builder(MarshallingType.SDK_POJO).memberName("unreachableNode")
            .getter(getter(FlowValidationDetails::unreachableNode)).setter(setter(Builder::unreachableNode))
            .constructor(UnreachableNodeFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unreachableNode").build()).build();

    private static final SdkField<UnknownConnectionSourceFlowValidationDetails> UNKNOWN_CONNECTION_SOURCE_FIELD = SdkField
            .<UnknownConnectionSourceFlowValidationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("unknownConnectionSource").getter(getter(FlowValidationDetails::unknownConnectionSource))
            .setter(setter(Builder::unknownConnectionSource)).constructor(UnknownConnectionSourceFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unknownConnectionSource").build())
            .build();

    private static final SdkField<UnknownConnectionSourceOutputFlowValidationDetails> UNKNOWN_CONNECTION_SOURCE_OUTPUT_FIELD = SdkField
            .<UnknownConnectionSourceOutputFlowValidationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("unknownConnectionSourceOutput")
            .getter(getter(FlowValidationDetails::unknownConnectionSourceOutput))
            .setter(setter(Builder::unknownConnectionSourceOutput))
            .constructor(UnknownConnectionSourceOutputFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unknownConnectionSourceOutput")
                    .build()).build();

    private static final SdkField<UnknownConnectionTargetFlowValidationDetails> UNKNOWN_CONNECTION_TARGET_FIELD = SdkField
            .<UnknownConnectionTargetFlowValidationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("unknownConnectionTarget").getter(getter(FlowValidationDetails::unknownConnectionTarget))
            .setter(setter(Builder::unknownConnectionTarget)).constructor(UnknownConnectionTargetFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unknownConnectionTarget").build())
            .build();

    private static final SdkField<UnknownConnectionTargetInputFlowValidationDetails> UNKNOWN_CONNECTION_TARGET_INPUT_FIELD = SdkField
            .<UnknownConnectionTargetInputFlowValidationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("unknownConnectionTargetInput")
            .getter(getter(FlowValidationDetails::unknownConnectionTargetInput))
            .setter(setter(Builder::unknownConnectionTargetInput))
            .constructor(UnknownConnectionTargetInputFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unknownConnectionTargetInput")
                    .build()).build();

    private static final SdkField<UnknownConnectionConditionFlowValidationDetails> UNKNOWN_CONNECTION_CONDITION_FIELD = SdkField
            .<UnknownConnectionConditionFlowValidationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("unknownConnectionCondition")
            .getter(getter(FlowValidationDetails::unknownConnectionCondition))
            .setter(setter(Builder::unknownConnectionCondition))
            .constructor(UnknownConnectionConditionFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unknownConnectionCondition").build())
            .build();

    private static final SdkField<MalformedConditionExpressionFlowValidationDetails> MALFORMED_CONDITION_EXPRESSION_FIELD = SdkField
            .<MalformedConditionExpressionFlowValidationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("malformedConditionExpression")
            .getter(getter(FlowValidationDetails::malformedConditionExpression))
            .setter(setter(Builder::malformedConditionExpression))
            .constructor(MalformedConditionExpressionFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("malformedConditionExpression")
                    .build()).build();

    private static final SdkField<MalformedNodeInputExpressionFlowValidationDetails> MALFORMED_NODE_INPUT_EXPRESSION_FIELD = SdkField
            .<MalformedNodeInputExpressionFlowValidationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("malformedNodeInputExpression")
            .getter(getter(FlowValidationDetails::malformedNodeInputExpression))
            .setter(setter(Builder::malformedNodeInputExpression))
            .constructor(MalformedNodeInputExpressionFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("malformedNodeInputExpression")
                    .build()).build();

    private static final SdkField<MismatchedNodeInputTypeFlowValidationDetails> MISMATCHED_NODE_INPUT_TYPE_FIELD = SdkField
            .<MismatchedNodeInputTypeFlowValidationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("mismatchedNodeInputType").getter(getter(FlowValidationDetails::mismatchedNodeInputType))
            .setter(setter(Builder::mismatchedNodeInputType)).constructor(MismatchedNodeInputTypeFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mismatchedNodeInputType").build())
            .build();

    private static final SdkField<MismatchedNodeOutputTypeFlowValidationDetails> MISMATCHED_NODE_OUTPUT_TYPE_FIELD = SdkField
            .<MismatchedNodeOutputTypeFlowValidationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("mismatchedNodeOutputType").getter(getter(FlowValidationDetails::mismatchedNodeOutputType))
            .setter(setter(Builder::mismatchedNodeOutputType))
            .constructor(MismatchedNodeOutputTypeFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mismatchedNodeOutputType").build())
            .build();

    private static final SdkField<IncompatibleConnectionDataTypeFlowValidationDetails> INCOMPATIBLE_CONNECTION_DATA_TYPE_FIELD = SdkField
            .<IncompatibleConnectionDataTypeFlowValidationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("incompatibleConnectionDataType")
            .getter(getter(FlowValidationDetails::incompatibleConnectionDataType))
            .setter(setter(Builder::incompatibleConnectionDataType))
            .constructor(IncompatibleConnectionDataTypeFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incompatibleConnectionDataType")
                    .build()).build();

    private static final SdkField<MissingConnectionConfigurationFlowValidationDetails> MISSING_CONNECTION_CONFIGURATION_FIELD = SdkField
            .<MissingConnectionConfigurationFlowValidationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("missingConnectionConfiguration")
            .getter(getter(FlowValidationDetails::missingConnectionConfiguration))
            .setter(setter(Builder::missingConnectionConfiguration))
            .constructor(MissingConnectionConfigurationFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missingConnectionConfiguration")
                    .build()).build();

    private static final SdkField<MissingDefaultConditionFlowValidationDetails> MISSING_DEFAULT_CONDITION_FIELD = SdkField
            .<MissingDefaultConditionFlowValidationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("missingDefaultCondition").getter(getter(FlowValidationDetails::missingDefaultCondition))
            .setter(setter(Builder::missingDefaultCondition)).constructor(MissingDefaultConditionFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missingDefaultCondition").build())
            .build();

    private static final SdkField<MissingEndingNodesFlowValidationDetails> MISSING_ENDING_NODES_FIELD = SdkField
            .<MissingEndingNodesFlowValidationDetails> builder(MarshallingType.SDK_POJO).memberName("missingEndingNodes")
            .getter(getter(FlowValidationDetails::missingEndingNodes)).setter(setter(Builder::missingEndingNodes))
            .constructor(MissingEndingNodesFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missingEndingNodes").build())
            .build();

    private static final SdkField<MissingNodeConfigurationFlowValidationDetails> MISSING_NODE_CONFIGURATION_FIELD = SdkField
            .<MissingNodeConfigurationFlowValidationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("missingNodeConfiguration").getter(getter(FlowValidationDetails::missingNodeConfiguration))
            .setter(setter(Builder::missingNodeConfiguration))
            .constructor(MissingNodeConfigurationFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missingNodeConfiguration").build())
            .build();

    private static final SdkField<MissingNodeInputFlowValidationDetails> MISSING_NODE_INPUT_FIELD = SdkField
            .<MissingNodeInputFlowValidationDetails> builder(MarshallingType.SDK_POJO).memberName("missingNodeInput")
            .getter(getter(FlowValidationDetails::missingNodeInput)).setter(setter(Builder::missingNodeInput))
            .constructor(MissingNodeInputFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missingNodeInput").build()).build();

    private static final SdkField<MissingNodeOutputFlowValidationDetails> MISSING_NODE_OUTPUT_FIELD = SdkField
            .<MissingNodeOutputFlowValidationDetails> builder(MarshallingType.SDK_POJO).memberName("missingNodeOutput")
            .getter(getter(FlowValidationDetails::missingNodeOutput)).setter(setter(Builder::missingNodeOutput))
            .constructor(MissingNodeOutputFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missingNodeOutput").build()).build();

    private static final SdkField<MissingStartingNodesFlowValidationDetails> MISSING_STARTING_NODES_FIELD = SdkField
            .<MissingStartingNodesFlowValidationDetails> builder(MarshallingType.SDK_POJO).memberName("missingStartingNodes")
            .getter(getter(FlowValidationDetails::missingStartingNodes)).setter(setter(Builder::missingStartingNodes))
            .constructor(MissingStartingNodesFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missingStartingNodes").build())
            .build();

    private static final SdkField<MultipleNodeInputConnectionsFlowValidationDetails> MULTIPLE_NODE_INPUT_CONNECTIONS_FIELD = SdkField
            .<MultipleNodeInputConnectionsFlowValidationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("multipleNodeInputConnections")
            .getter(getter(FlowValidationDetails::multipleNodeInputConnections))
            .setter(setter(Builder::multipleNodeInputConnections))
            .constructor(MultipleNodeInputConnectionsFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multipleNodeInputConnections")
                    .build()).build();

    private static final SdkField<UnfulfilledNodeInputFlowValidationDetails> UNFULFILLED_NODE_INPUT_FIELD = SdkField
            .<UnfulfilledNodeInputFlowValidationDetails> builder(MarshallingType.SDK_POJO).memberName("unfulfilledNodeInput")
            .getter(getter(FlowValidationDetails::unfulfilledNodeInput)).setter(setter(Builder::unfulfilledNodeInput))
            .constructor(UnfulfilledNodeInputFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unfulfilledNodeInput").build())
            .build();

    private static final SdkField<UnsatisfiedConnectionConditionsFlowValidationDetails> UNSATISFIED_CONNECTION_CONDITIONS_FIELD = SdkField
            .<UnsatisfiedConnectionConditionsFlowValidationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("unsatisfiedConnectionConditions")
            .getter(getter(FlowValidationDetails::unsatisfiedConnectionConditions))
            .setter(setter(Builder::unsatisfiedConnectionConditions))
            .constructor(UnsatisfiedConnectionConditionsFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unsatisfiedConnectionConditions")
                    .build()).build();

    private static final SdkField<UnspecifiedFlowValidationDetails> UNSPECIFIED_FIELD = SdkField
            .<UnspecifiedFlowValidationDetails> builder(MarshallingType.SDK_POJO).memberName("unspecified")
            .getter(getter(FlowValidationDetails::unspecified)).setter(setter(Builder::unspecified))
            .constructor(UnspecifiedFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unspecified").build()).build();

    private static final SdkField<UnknownNodeInputFlowValidationDetails> UNKNOWN_NODE_INPUT_FIELD = SdkField
            .<UnknownNodeInputFlowValidationDetails> builder(MarshallingType.SDK_POJO).memberName("unknownNodeInput")
            .getter(getter(FlowValidationDetails::unknownNodeInput)).setter(setter(Builder::unknownNodeInput))
            .constructor(UnknownNodeInputFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unknownNodeInput").build()).build();

    private static final SdkField<UnknownNodeOutputFlowValidationDetails> UNKNOWN_NODE_OUTPUT_FIELD = SdkField
            .<UnknownNodeOutputFlowValidationDetails> builder(MarshallingType.SDK_POJO).memberName("unknownNodeOutput")
            .getter(getter(FlowValidationDetails::unknownNodeOutput)).setter(setter(Builder::unknownNodeOutput))
            .constructor(UnknownNodeOutputFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unknownNodeOutput").build()).build();

    private static final SdkField<MissingLoopInputNodeFlowValidationDetails> MISSING_LOOP_INPUT_NODE_FIELD = SdkField
            .<MissingLoopInputNodeFlowValidationDetails> builder(MarshallingType.SDK_POJO).memberName("missingLoopInputNode")
            .getter(getter(FlowValidationDetails::missingLoopInputNode)).setter(setter(Builder::missingLoopInputNode))
            .constructor(MissingLoopInputNodeFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missingLoopInputNode").build())
            .build();

    private static final SdkField<MissingLoopControllerNodeFlowValidationDetails> MISSING_LOOP_CONTROLLER_NODE_FIELD = SdkField
            .<MissingLoopControllerNodeFlowValidationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("missingLoopControllerNode").getter(getter(FlowValidationDetails::missingLoopControllerNode))
            .setter(setter(Builder::missingLoopControllerNode))
            .constructor(MissingLoopControllerNodeFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missingLoopControllerNode").build())
            .build();

    private static final SdkField<MultipleLoopInputNodesFlowValidationDetails> MULTIPLE_LOOP_INPUT_NODES_FIELD = SdkField
            .<MultipleLoopInputNodesFlowValidationDetails> builder(MarshallingType.SDK_POJO).memberName("multipleLoopInputNodes")
            .getter(getter(FlowValidationDetails::multipleLoopInputNodes)).setter(setter(Builder::multipleLoopInputNodes))
            .constructor(MultipleLoopInputNodesFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multipleLoopInputNodes").build())
            .build();

    private static final SdkField<MultipleLoopControllerNodesFlowValidationDetails> MULTIPLE_LOOP_CONTROLLER_NODES_FIELD = SdkField
            .<MultipleLoopControllerNodesFlowValidationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("multipleLoopControllerNodes")
            .getter(getter(FlowValidationDetails::multipleLoopControllerNodes))
            .setter(setter(Builder::multipleLoopControllerNodes))
            .constructor(MultipleLoopControllerNodesFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multipleLoopControllerNodes")
                    .build()).build();

    private static final SdkField<LoopIncompatibleNodeTypeFlowValidationDetails> LOOP_INCOMPATIBLE_NODE_TYPE_FIELD = SdkField
            .<LoopIncompatibleNodeTypeFlowValidationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("loopIncompatibleNodeType").getter(getter(FlowValidationDetails::loopIncompatibleNodeType))
            .setter(setter(Builder::loopIncompatibleNodeType))
            .constructor(LoopIncompatibleNodeTypeFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loopIncompatibleNodeType").build())
            .build();

    private static final SdkField<InvalidLoopBoundaryFlowValidationDetails> INVALID_LOOP_BOUNDARY_FIELD = SdkField
            .<InvalidLoopBoundaryFlowValidationDetails> builder(MarshallingType.SDK_POJO).memberName("invalidLoopBoundary")
            .getter(getter(FlowValidationDetails::invalidLoopBoundary)).setter(setter(Builder::invalidLoopBoundary))
            .constructor(InvalidLoopBoundaryFlowValidationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invalidLoopBoundary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CYCLIC_CONNECTION_FIELD,
            DUPLICATE_CONNECTIONS_FIELD, DUPLICATE_CONDITION_EXPRESSION_FIELD, UNREACHABLE_NODE_FIELD,
            UNKNOWN_CONNECTION_SOURCE_FIELD, UNKNOWN_CONNECTION_SOURCE_OUTPUT_FIELD, UNKNOWN_CONNECTION_TARGET_FIELD,
            UNKNOWN_CONNECTION_TARGET_INPUT_FIELD, UNKNOWN_CONNECTION_CONDITION_FIELD, MALFORMED_CONDITION_EXPRESSION_FIELD,
            MALFORMED_NODE_INPUT_EXPRESSION_FIELD, MISMATCHED_NODE_INPUT_TYPE_FIELD, MISMATCHED_NODE_OUTPUT_TYPE_FIELD,
            INCOMPATIBLE_CONNECTION_DATA_TYPE_FIELD, MISSING_CONNECTION_CONFIGURATION_FIELD, MISSING_DEFAULT_CONDITION_FIELD,
            MISSING_ENDING_NODES_FIELD, MISSING_NODE_CONFIGURATION_FIELD, MISSING_NODE_INPUT_FIELD, MISSING_NODE_OUTPUT_FIELD,
            MISSING_STARTING_NODES_FIELD, MULTIPLE_NODE_INPUT_CONNECTIONS_FIELD, UNFULFILLED_NODE_INPUT_FIELD,
            UNSATISFIED_CONNECTION_CONDITIONS_FIELD, UNSPECIFIED_FIELD, UNKNOWN_NODE_INPUT_FIELD, UNKNOWN_NODE_OUTPUT_FIELD,
            MISSING_LOOP_INPUT_NODE_FIELD, MISSING_LOOP_CONTROLLER_NODE_FIELD, MULTIPLE_LOOP_INPUT_NODES_FIELD,
            MULTIPLE_LOOP_CONTROLLER_NODES_FIELD, LOOP_INCOMPATIBLE_NODE_TYPE_FIELD, INVALID_LOOP_BOUNDARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CyclicConnectionFlowValidationDetails cyclicConnection;

    private final DuplicateConnectionsFlowValidationDetails duplicateConnections;

    private final DuplicateConditionExpressionFlowValidationDetails duplicateConditionExpression;

    private final UnreachableNodeFlowValidationDetails unreachableNode;

    private final UnknownConnectionSourceFlowValidationDetails unknownConnectionSource;

    private final UnknownConnectionSourceOutputFlowValidationDetails unknownConnectionSourceOutput;

    private final UnknownConnectionTargetFlowValidationDetails unknownConnectionTarget;

    private final UnknownConnectionTargetInputFlowValidationDetails unknownConnectionTargetInput;

    private final UnknownConnectionConditionFlowValidationDetails unknownConnectionCondition;

    private final MalformedConditionExpressionFlowValidationDetails malformedConditionExpression;

    private final MalformedNodeInputExpressionFlowValidationDetails malformedNodeInputExpression;

    private final MismatchedNodeInputTypeFlowValidationDetails mismatchedNodeInputType;

    private final MismatchedNodeOutputTypeFlowValidationDetails mismatchedNodeOutputType;

    private final IncompatibleConnectionDataTypeFlowValidationDetails incompatibleConnectionDataType;

    private final MissingConnectionConfigurationFlowValidationDetails missingConnectionConfiguration;

    private final MissingDefaultConditionFlowValidationDetails missingDefaultCondition;

    private final MissingEndingNodesFlowValidationDetails missingEndingNodes;

    private final MissingNodeConfigurationFlowValidationDetails missingNodeConfiguration;

    private final MissingNodeInputFlowValidationDetails missingNodeInput;

    private final MissingNodeOutputFlowValidationDetails missingNodeOutput;

    private final MissingStartingNodesFlowValidationDetails missingStartingNodes;

    private final MultipleNodeInputConnectionsFlowValidationDetails multipleNodeInputConnections;

    private final UnfulfilledNodeInputFlowValidationDetails unfulfilledNodeInput;

    private final UnsatisfiedConnectionConditionsFlowValidationDetails unsatisfiedConnectionConditions;

    private final UnspecifiedFlowValidationDetails unspecified;

    private final UnknownNodeInputFlowValidationDetails unknownNodeInput;

    private final UnknownNodeOutputFlowValidationDetails unknownNodeOutput;

    private final MissingLoopInputNodeFlowValidationDetails missingLoopInputNode;

    private final MissingLoopControllerNodeFlowValidationDetails missingLoopControllerNode;

    private final MultipleLoopInputNodesFlowValidationDetails multipleLoopInputNodes;

    private final MultipleLoopControllerNodesFlowValidationDetails multipleLoopControllerNodes;

    private final LoopIncompatibleNodeTypeFlowValidationDetails loopIncompatibleNodeType;

    private final InvalidLoopBoundaryFlowValidationDetails invalidLoopBoundary;

    private final Type type;

    private FlowValidationDetails(BuilderImpl builder) {
        this.cyclicConnection = builder.cyclicConnection;
        this.duplicateConnections = builder.duplicateConnections;
        this.duplicateConditionExpression = builder.duplicateConditionExpression;
        this.unreachableNode = builder.unreachableNode;
        this.unknownConnectionSource = builder.unknownConnectionSource;
        this.unknownConnectionSourceOutput = builder.unknownConnectionSourceOutput;
        this.unknownConnectionTarget = builder.unknownConnectionTarget;
        this.unknownConnectionTargetInput = builder.unknownConnectionTargetInput;
        this.unknownConnectionCondition = builder.unknownConnectionCondition;
        this.malformedConditionExpression = builder.malformedConditionExpression;
        this.malformedNodeInputExpression = builder.malformedNodeInputExpression;
        this.mismatchedNodeInputType = builder.mismatchedNodeInputType;
        this.mismatchedNodeOutputType = builder.mismatchedNodeOutputType;
        this.incompatibleConnectionDataType = builder.incompatibleConnectionDataType;
        this.missingConnectionConfiguration = builder.missingConnectionConfiguration;
        this.missingDefaultCondition = builder.missingDefaultCondition;
        this.missingEndingNodes = builder.missingEndingNodes;
        this.missingNodeConfiguration = builder.missingNodeConfiguration;
        this.missingNodeInput = builder.missingNodeInput;
        this.missingNodeOutput = builder.missingNodeOutput;
        this.missingStartingNodes = builder.missingStartingNodes;
        this.multipleNodeInputConnections = builder.multipleNodeInputConnections;
        this.unfulfilledNodeInput = builder.unfulfilledNodeInput;
        this.unsatisfiedConnectionConditions = builder.unsatisfiedConnectionConditions;
        this.unspecified = builder.unspecified;
        this.unknownNodeInput = builder.unknownNodeInput;
        this.unknownNodeOutput = builder.unknownNodeOutput;
        this.missingLoopInputNode = builder.missingLoopInputNode;
        this.missingLoopControllerNode = builder.missingLoopControllerNode;
        this.multipleLoopInputNodes = builder.multipleLoopInputNodes;
        this.multipleLoopControllerNodes = builder.multipleLoopControllerNodes;
        this.loopIncompatibleNodeType = builder.loopIncompatibleNodeType;
        this.invalidLoopBoundary = builder.invalidLoopBoundary;
        this.type = builder.type;
    }

    /**
     * <p>
     * Details about a cyclic connection in the flow.
     * </p>
     * 
     * @return Details about a cyclic connection in the flow.
     */
    public final CyclicConnectionFlowValidationDetails cyclicConnection() {
        return cyclicConnection;
    }

    /**
     * <p>
     * Details about duplicate connections between nodes.
     * </p>
     * 
     * @return Details about duplicate connections between nodes.
     */
    public final DuplicateConnectionsFlowValidationDetails duplicateConnections() {
        return duplicateConnections;
    }

    /**
     * <p>
     * Details about duplicate condition expressions in a node.
     * </p>
     * 
     * @return Details about duplicate condition expressions in a node.
     */
    public final DuplicateConditionExpressionFlowValidationDetails duplicateConditionExpression() {
        return duplicateConditionExpression;
    }

    /**
     * <p>
     * Details about an unreachable node in the flow.
     * </p>
     * 
     * @return Details about an unreachable node in the flow.
     */
    public final UnreachableNodeFlowValidationDetails unreachableNode() {
        return unreachableNode;
    }

    /**
     * <p>
     * Details about an unknown source node for a connection.
     * </p>
     * 
     * @return Details about an unknown source node for a connection.
     */
    public final UnknownConnectionSourceFlowValidationDetails unknownConnectionSource() {
        return unknownConnectionSource;
    }

    /**
     * <p>
     * Details about an unknown source output for a connection.
     * </p>
     * 
     * @return Details about an unknown source output for a connection.
     */
    public final UnknownConnectionSourceOutputFlowValidationDetails unknownConnectionSourceOutput() {
        return unknownConnectionSourceOutput;
    }

    /**
     * <p>
     * Details about an unknown target node for a connection.
     * </p>
     * 
     * @return Details about an unknown target node for a connection.
     */
    public final UnknownConnectionTargetFlowValidationDetails unknownConnectionTarget() {
        return unknownConnectionTarget;
    }

    /**
     * <p>
     * Details about an unknown target input for a connection.
     * </p>
     * 
     * @return Details about an unknown target input for a connection.
     */
    public final UnknownConnectionTargetInputFlowValidationDetails unknownConnectionTargetInput() {
        return unknownConnectionTargetInput;
    }

    /**
     * <p>
     * Details about an unknown condition for a connection.
     * </p>
     * 
     * @return Details about an unknown condition for a connection.
     */
    public final UnknownConnectionConditionFlowValidationDetails unknownConnectionCondition() {
        return unknownConnectionCondition;
    }

    /**
     * <p>
     * Details about a malformed condition expression in a node.
     * </p>
     * 
     * @return Details about a malformed condition expression in a node.
     */
    public final MalformedConditionExpressionFlowValidationDetails malformedConditionExpression() {
        return malformedConditionExpression;
    }

    /**
     * <p>
     * Details about a malformed input expression in a node.
     * </p>
     * 
     * @return Details about a malformed input expression in a node.
     */
    public final MalformedNodeInputExpressionFlowValidationDetails malformedNodeInputExpression() {
        return malformedNodeInputExpression;
    }

    /**
     * <p>
     * Details about mismatched input data types in a node.
     * </p>
     * 
     * @return Details about mismatched input data types in a node.
     */
    public final MismatchedNodeInputTypeFlowValidationDetails mismatchedNodeInputType() {
        return mismatchedNodeInputType;
    }

    /**
     * <p>
     * Details about mismatched output data types in a node.
     * </p>
     * 
     * @return Details about mismatched output data types in a node.
     */
    public final MismatchedNodeOutputTypeFlowValidationDetails mismatchedNodeOutputType() {
        return mismatchedNodeOutputType;
    }

    /**
     * <p>
     * Details about incompatible data types in a connection.
     * </p>
     * 
     * @return Details about incompatible data types in a connection.
     */
    public final IncompatibleConnectionDataTypeFlowValidationDetails incompatibleConnectionDataType() {
        return incompatibleConnectionDataType;
    }

    /**
     * <p>
     * Details about missing configuration for a connection.
     * </p>
     * 
     * @return Details about missing configuration for a connection.
     */
    public final MissingConnectionConfigurationFlowValidationDetails missingConnectionConfiguration() {
        return missingConnectionConfiguration;
    }

    /**
     * <p>
     * Details about a missing default condition in a conditional node.
     * </p>
     * 
     * @return Details about a missing default condition in a conditional node.
     */
    public final MissingDefaultConditionFlowValidationDetails missingDefaultCondition() {
        return missingDefaultCondition;
    }

    /**
     * <p>
     * Details about missing ending nodes in the flow.
     * </p>
     * 
     * @return Details about missing ending nodes in the flow.
     */
    public final MissingEndingNodesFlowValidationDetails missingEndingNodes() {
        return missingEndingNodes;
    }

    /**
     * <p>
     * Details about missing configuration for a node.
     * </p>
     * 
     * @return Details about missing configuration for a node.
     */
    public final MissingNodeConfigurationFlowValidationDetails missingNodeConfiguration() {
        return missingNodeConfiguration;
    }

    /**
     * <p>
     * Details about a missing required input in a node.
     * </p>
     * 
     * @return Details about a missing required input in a node.
     */
    public final MissingNodeInputFlowValidationDetails missingNodeInput() {
        return missingNodeInput;
    }

    /**
     * <p>
     * Details about a missing required output in a node.
     * </p>
     * 
     * @return Details about a missing required output in a node.
     */
    public final MissingNodeOutputFlowValidationDetails missingNodeOutput() {
        return missingNodeOutput;
    }

    /**
     * <p>
     * Details about missing starting nodes in the flow.
     * </p>
     * 
     * @return Details about missing starting nodes in the flow.
     */
    public final MissingStartingNodesFlowValidationDetails missingStartingNodes() {
        return missingStartingNodes;
    }

    /**
     * <p>
     * Details about multiple connections to a single node input.
     * </p>
     * 
     * @return Details about multiple connections to a single node input.
     */
    public final MultipleNodeInputConnectionsFlowValidationDetails multipleNodeInputConnections() {
        return multipleNodeInputConnections;
    }

    /**
     * <p>
     * Details about an unfulfilled node input with no valid connections.
     * </p>
     * 
     * @return Details about an unfulfilled node input with no valid connections.
     */
    public final UnfulfilledNodeInputFlowValidationDetails unfulfilledNodeInput() {
        return unfulfilledNodeInput;
    }

    /**
     * <p>
     * Details about unsatisfied conditions for a connection.
     * </p>
     * 
     * @return Details about unsatisfied conditions for a connection.
     */
    public final UnsatisfiedConnectionConditionsFlowValidationDetails unsatisfiedConnectionConditions() {
        return unsatisfiedConnectionConditions;
    }

    /**
     * <p>
     * Details about an unspecified validation.
     * </p>
     * 
     * @return Details about an unspecified validation.
     */
    public final UnspecifiedFlowValidationDetails unspecified() {
        return unspecified;
    }

    /**
     * <p>
     * Details about an unknown input for a node.
     * </p>
     * 
     * @return Details about an unknown input for a node.
     */
    public final UnknownNodeInputFlowValidationDetails unknownNodeInput() {
        return unknownNodeInput;
    }

    /**
     * <p>
     * Details about an unknown output for a node.
     * </p>
     * 
     * @return Details about an unknown output for a node.
     */
    public final UnknownNodeOutputFlowValidationDetails unknownNodeOutput() {
        return unknownNodeOutput;
    }

    /**
     * <p>
     * Details about a flow that's missing a required <code>LoopInput</code> node in a DoWhile loop.
     * </p>
     * 
     * @return Details about a flow that's missing a required <code>LoopInput</code> node in a DoWhile loop.
     */
    public final MissingLoopInputNodeFlowValidationDetails missingLoopInputNode() {
        return missingLoopInputNode;
    }

    /**
     * <p>
     * Details about a flow that's missing a required <code>LoopController</code> node in a DoWhile loop.
     * </p>
     * 
     * @return Details about a flow that's missing a required <code>LoopController</code> node in a DoWhile loop.
     */
    public final MissingLoopControllerNodeFlowValidationDetails missingLoopControllerNode() {
        return missingLoopControllerNode;
    }

    /**
     * <p>
     * Details about a flow that contains multiple <code>LoopInput</code> nodes in a DoWhile loop.
     * </p>
     * 
     * @return Details about a flow that contains multiple <code>LoopInput</code> nodes in a DoWhile loop.
     */
    public final MultipleLoopInputNodesFlowValidationDetails multipleLoopInputNodes() {
        return multipleLoopInputNodes;
    }

    /**
     * <p>
     * Details about a flow that contains multiple <code>LoopController</code> nodes in a DoWhile loop.
     * </p>
     * 
     * @return Details about a flow that contains multiple <code>LoopController</code> nodes in a DoWhile loop.
     */
    public final MultipleLoopControllerNodesFlowValidationDetails multipleLoopControllerNodes() {
        return multipleLoopControllerNodes;
    }

    /**
     * <p>
     * Details about a flow that includes incompatible node types in a DoWhile loop.
     * </p>
     * 
     * @return Details about a flow that includes incompatible node types in a DoWhile loop.
     */
    public final LoopIncompatibleNodeTypeFlowValidationDetails loopIncompatibleNodeType() {
        return loopIncompatibleNodeType;
    }

    /**
     * <p>
     * Details about a flow that includes connections that violate loop boundary rules.
     * </p>
     * 
     * @return Details about a flow that includes connections that violate loop boundary rules.
     */
    public final InvalidLoopBoundaryFlowValidationDetails invalidLoopBoundary() {
        return invalidLoopBoundary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cyclicConnection());
        hashCode = 31 * hashCode + Objects.hashCode(duplicateConnections());
        hashCode = 31 * hashCode + Objects.hashCode(duplicateConditionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(unreachableNode());
        hashCode = 31 * hashCode + Objects.hashCode(unknownConnectionSource());
        hashCode = 31 * hashCode + Objects.hashCode(unknownConnectionSourceOutput());
        hashCode = 31 * hashCode + Objects.hashCode(unknownConnectionTarget());
        hashCode = 31 * hashCode + Objects.hashCode(unknownConnectionTargetInput());
        hashCode = 31 * hashCode + Objects.hashCode(unknownConnectionCondition());
        hashCode = 31 * hashCode + Objects.hashCode(malformedConditionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(malformedNodeInputExpression());
        hashCode = 31 * hashCode + Objects.hashCode(mismatchedNodeInputType());
        hashCode = 31 * hashCode + Objects.hashCode(mismatchedNodeOutputType());
        hashCode = 31 * hashCode + Objects.hashCode(incompatibleConnectionDataType());
        hashCode = 31 * hashCode + Objects.hashCode(missingConnectionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(missingDefaultCondition());
        hashCode = 31 * hashCode + Objects.hashCode(missingEndingNodes());
        hashCode = 31 * hashCode + Objects.hashCode(missingNodeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(missingNodeInput());
        hashCode = 31 * hashCode + Objects.hashCode(missingNodeOutput());
        hashCode = 31 * hashCode + Objects.hashCode(missingStartingNodes());
        hashCode = 31 * hashCode + Objects.hashCode(multipleNodeInputConnections());
        hashCode = 31 * hashCode + Objects.hashCode(unfulfilledNodeInput());
        hashCode = 31 * hashCode + Objects.hashCode(unsatisfiedConnectionConditions());
        hashCode = 31 * hashCode + Objects.hashCode(unspecified());
        hashCode = 31 * hashCode + Objects.hashCode(unknownNodeInput());
        hashCode = 31 * hashCode + Objects.hashCode(unknownNodeOutput());
        hashCode = 31 * hashCode + Objects.hashCode(missingLoopInputNode());
        hashCode = 31 * hashCode + Objects.hashCode(missingLoopControllerNode());
        hashCode = 31 * hashCode + Objects.hashCode(multipleLoopInputNodes());
        hashCode = 31 * hashCode + Objects.hashCode(multipleLoopControllerNodes());
        hashCode = 31 * hashCode + Objects.hashCode(loopIncompatibleNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(invalidLoopBoundary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowValidationDetails)) {
            return false;
        }
        FlowValidationDetails other = (FlowValidationDetails) obj;
        return Objects.equals(cyclicConnection(), other.cyclicConnection())
                && Objects.equals(duplicateConnections(), other.duplicateConnections())
                && Objects.equals(duplicateConditionExpression(), other.duplicateConditionExpression())
                && Objects.equals(unreachableNode(), other.unreachableNode())
                && Objects.equals(unknownConnectionSource(), other.unknownConnectionSource())
                && Objects.equals(unknownConnectionSourceOutput(), other.unknownConnectionSourceOutput())
                && Objects.equals(unknownConnectionTarget(), other.unknownConnectionTarget())
                && Objects.equals(unknownConnectionTargetInput(), other.unknownConnectionTargetInput())
                && Objects.equals(unknownConnectionCondition(), other.unknownConnectionCondition())
                && Objects.equals(malformedConditionExpression(), other.malformedConditionExpression())
                && Objects.equals(malformedNodeInputExpression(), other.malformedNodeInputExpression())
                && Objects.equals(mismatchedNodeInputType(), other.mismatchedNodeInputType())
                && Objects.equals(mismatchedNodeOutputType(), other.mismatchedNodeOutputType())
                && Objects.equals(incompatibleConnectionDataType(), other.incompatibleConnectionDataType())
                && Objects.equals(missingConnectionConfiguration(), other.missingConnectionConfiguration())
                && Objects.equals(missingDefaultCondition(), other.missingDefaultCondition())
                && Objects.equals(missingEndingNodes(), other.missingEndingNodes())
                && Objects.equals(missingNodeConfiguration(), other.missingNodeConfiguration())
                && Objects.equals(missingNodeInput(), other.missingNodeInput())
                && Objects.equals(missingNodeOutput(), other.missingNodeOutput())
                && Objects.equals(missingStartingNodes(), other.missingStartingNodes())
                && Objects.equals(multipleNodeInputConnections(), other.multipleNodeInputConnections())
                && Objects.equals(unfulfilledNodeInput(), other.unfulfilledNodeInput())
                && Objects.equals(unsatisfiedConnectionConditions(), other.unsatisfiedConnectionConditions())
                && Objects.equals(unspecified(), other.unspecified())
                && Objects.equals(unknownNodeInput(), other.unknownNodeInput())
                && Objects.equals(unknownNodeOutput(), other.unknownNodeOutput())
                && Objects.equals(missingLoopInputNode(), other.missingLoopInputNode())
                && Objects.equals(missingLoopControllerNode(), other.missingLoopControllerNode())
                && Objects.equals(multipleLoopInputNodes(), other.multipleLoopInputNodes())
                && Objects.equals(multipleLoopControllerNodes(), other.multipleLoopControllerNodes())
                && Objects.equals(loopIncompatibleNodeType(), other.loopIncompatibleNodeType())
                && Objects.equals(invalidLoopBoundary(), other.invalidLoopBoundary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowValidationDetails").add("CyclicConnection", cyclicConnection())
                .add("DuplicateConnections", duplicateConnections())
                .add("DuplicateConditionExpression", duplicateConditionExpression()).add("UnreachableNode", unreachableNode())
                .add("UnknownConnectionSource", unknownConnectionSource())
                .add("UnknownConnectionSourceOutput", unknownConnectionSourceOutput())
                .add("UnknownConnectionTarget", unknownConnectionTarget())
                .add("UnknownConnectionTargetInput", unknownConnectionTargetInput())
                .add("UnknownConnectionCondition", unknownConnectionCondition())
                .add("MalformedConditionExpression", malformedConditionExpression())
                .add("MalformedNodeInputExpression", malformedNodeInputExpression())
                .add("MismatchedNodeInputType", mismatchedNodeInputType())
                .add("MismatchedNodeOutputType", mismatchedNodeOutputType())
                .add("IncompatibleConnectionDataType", incompatibleConnectionDataType())
                .add("MissingConnectionConfiguration", missingConnectionConfiguration())
                .add("MissingDefaultCondition", missingDefaultCondition()).add("MissingEndingNodes", missingEndingNodes())
                .add("MissingNodeConfiguration", missingNodeConfiguration()).add("MissingNodeInput", missingNodeInput())
                .add("MissingNodeOutput", missingNodeOutput()).add("MissingStartingNodes", missingStartingNodes())
                .add("MultipleNodeInputConnections", multipleNodeInputConnections())
                .add("UnfulfilledNodeInput", unfulfilledNodeInput())
                .add("UnsatisfiedConnectionConditions", unsatisfiedConnectionConditions()).add("Unspecified", unspecified())
                .add("UnknownNodeInput", unknownNodeInput()).add("UnknownNodeOutput", unknownNodeOutput())
                .add("MissingLoopInputNode", missingLoopInputNode())
                .add("MissingLoopControllerNode", missingLoopControllerNode())
                .add("MultipleLoopInputNodes", multipleLoopInputNodes())
                .add("MultipleLoopControllerNodes", multipleLoopControllerNodes())
                .add("LoopIncompatibleNodeType", loopIncompatibleNodeType()).add("InvalidLoopBoundary", invalidLoopBoundary())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cyclicConnection":
            return Optional.ofNullable(clazz.cast(cyclicConnection()));
        case "duplicateConnections":
            return Optional.ofNullable(clazz.cast(duplicateConnections()));
        case "duplicateConditionExpression":
            return Optional.ofNullable(clazz.cast(duplicateConditionExpression()));
        case "unreachableNode":
            return Optional.ofNullable(clazz.cast(unreachableNode()));
        case "unknownConnectionSource":
            return Optional.ofNullable(clazz.cast(unknownConnectionSource()));
        case "unknownConnectionSourceOutput":
            return Optional.ofNullable(clazz.cast(unknownConnectionSourceOutput()));
        case "unknownConnectionTarget":
            return Optional.ofNullable(clazz.cast(unknownConnectionTarget()));
        case "unknownConnectionTargetInput":
            return Optional.ofNullable(clazz.cast(unknownConnectionTargetInput()));
        case "unknownConnectionCondition":
            return Optional.ofNullable(clazz.cast(unknownConnectionCondition()));
        case "malformedConditionExpression":
            return Optional.ofNullable(clazz.cast(malformedConditionExpression()));
        case "malformedNodeInputExpression":
            return Optional.ofNullable(clazz.cast(malformedNodeInputExpression()));
        case "mismatchedNodeInputType":
            return Optional.ofNullable(clazz.cast(mismatchedNodeInputType()));
        case "mismatchedNodeOutputType":
            return Optional.ofNullable(clazz.cast(mismatchedNodeOutputType()));
        case "incompatibleConnectionDataType":
            return Optional.ofNullable(clazz.cast(incompatibleConnectionDataType()));
        case "missingConnectionConfiguration":
            return Optional.ofNullable(clazz.cast(missingConnectionConfiguration()));
        case "missingDefaultCondition":
            return Optional.ofNullable(clazz.cast(missingDefaultCondition()));
        case "missingEndingNodes":
            return Optional.ofNullable(clazz.cast(missingEndingNodes()));
        case "missingNodeConfiguration":
            return Optional.ofNullable(clazz.cast(missingNodeConfiguration()));
        case "missingNodeInput":
            return Optional.ofNullable(clazz.cast(missingNodeInput()));
        case "missingNodeOutput":
            return Optional.ofNullable(clazz.cast(missingNodeOutput()));
        case "missingStartingNodes":
            return Optional.ofNullable(clazz.cast(missingStartingNodes()));
        case "multipleNodeInputConnections":
            return Optional.ofNullable(clazz.cast(multipleNodeInputConnections()));
        case "unfulfilledNodeInput":
            return Optional.ofNullable(clazz.cast(unfulfilledNodeInput()));
        case "unsatisfiedConnectionConditions":
            return Optional.ofNullable(clazz.cast(unsatisfiedConnectionConditions()));
        case "unspecified":
            return Optional.ofNullable(clazz.cast(unspecified()));
        case "unknownNodeInput":
            return Optional.ofNullable(clazz.cast(unknownNodeInput()));
        case "unknownNodeOutput":
            return Optional.ofNullable(clazz.cast(unknownNodeOutput()));
        case "missingLoopInputNode":
            return Optional.ofNullable(clazz.cast(missingLoopInputNode()));
        case "missingLoopControllerNode":
            return Optional.ofNullable(clazz.cast(missingLoopControllerNode()));
        case "multipleLoopInputNodes":
            return Optional.ofNullable(clazz.cast(multipleLoopInputNodes()));
        case "multipleLoopControllerNodes":
            return Optional.ofNullable(clazz.cast(multipleLoopControllerNodes()));
        case "loopIncompatibleNodeType":
            return Optional.ofNullable(clazz.cast(loopIncompatibleNodeType()));
        case "invalidLoopBoundary":
            return Optional.ofNullable(clazz.cast(invalidLoopBoundary()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #cyclicConnection()} initialized to the given value.
     *
     * <p>
     * Details about a cyclic connection in the flow.
     * </p>
     * 
     * @param cyclicConnection
     *        Details about a cyclic connection in the flow.
     */
    public static FlowValidationDetails fromCyclicConnection(CyclicConnectionFlowValidationDetails cyclicConnection) {
        return builder().cyclicConnection(cyclicConnection).build();
    }

    /**
     * Create an instance of this class with {@link #cyclicConnection()} initialized to the given value.
     *
     * <p>
     * Details about a cyclic connection in the flow.
     * </p>
     * 
     * @param cyclicConnection
     *        Details about a cyclic connection in the flow.
     */
    public static FlowValidationDetails fromCyclicConnection(
            Consumer<CyclicConnectionFlowValidationDetails.Builder> cyclicConnection) {
        CyclicConnectionFlowValidationDetails.Builder builder = CyclicConnectionFlowValidationDetails.builder();
        cyclicConnection.accept(builder);
        return fromCyclicConnection(builder.build());
    }

    /**
     * Create an instance of this class with {@link #duplicateConnections()} initialized to the given value.
     *
     * <p>
     * Details about duplicate connections between nodes.
     * </p>
     * 
     * @param duplicateConnections
     *        Details about duplicate connections between nodes.
     */
    public static FlowValidationDetails fromDuplicateConnections(DuplicateConnectionsFlowValidationDetails duplicateConnections) {
        return builder().duplicateConnections(duplicateConnections).build();
    }

    /**
     * Create an instance of this class with {@link #duplicateConnections()} initialized to the given value.
     *
     * <p>
     * Details about duplicate connections between nodes.
     * </p>
     * 
     * @param duplicateConnections
     *        Details about duplicate connections between nodes.
     */
    public static FlowValidationDetails fromDuplicateConnections(
            Consumer<DuplicateConnectionsFlowValidationDetails.Builder> duplicateConnections) {
        DuplicateConnectionsFlowValidationDetails.Builder builder = DuplicateConnectionsFlowValidationDetails.builder();
        duplicateConnections.accept(builder);
        return fromDuplicateConnections(builder.build());
    }

    /**
     * Create an instance of this class with {@link #duplicateConditionExpression()} initialized to the given value.
     *
     * <p>
     * Details about duplicate condition expressions in a node.
     * </p>
     * 
     * @param duplicateConditionExpression
     *        Details about duplicate condition expressions in a node.
     */
    public static FlowValidationDetails fromDuplicateConditionExpression(
            DuplicateConditionExpressionFlowValidationDetails duplicateConditionExpression) {
        return builder().duplicateConditionExpression(duplicateConditionExpression).build();
    }

    /**
     * Create an instance of this class with {@link #duplicateConditionExpression()} initialized to the given value.
     *
     * <p>
     * Details about duplicate condition expressions in a node.
     * </p>
     * 
     * @param duplicateConditionExpression
     *        Details about duplicate condition expressions in a node.
     */
    public static FlowValidationDetails fromDuplicateConditionExpression(
            Consumer<DuplicateConditionExpressionFlowValidationDetails.Builder> duplicateConditionExpression) {
        DuplicateConditionExpressionFlowValidationDetails.Builder builder = DuplicateConditionExpressionFlowValidationDetails
                .builder();
        duplicateConditionExpression.accept(builder);
        return fromDuplicateConditionExpression(builder.build());
    }

    /**
     * Create an instance of this class with {@link #unreachableNode()} initialized to the given value.
     *
     * <p>
     * Details about an unreachable node in the flow.
     * </p>
     * 
     * @param unreachableNode
     *        Details about an unreachable node in the flow.
     */
    public static FlowValidationDetails fromUnreachableNode(UnreachableNodeFlowValidationDetails unreachableNode) {
        return builder().unreachableNode(unreachableNode).build();
    }

    /**
     * Create an instance of this class with {@link #unreachableNode()} initialized to the given value.
     *
     * <p>
     * Details about an unreachable node in the flow.
     * </p>
     * 
     * @param unreachableNode
     *        Details about an unreachable node in the flow.
     */
    public static FlowValidationDetails fromUnreachableNode(Consumer<UnreachableNodeFlowValidationDetails.Builder> unreachableNode) {
        UnreachableNodeFlowValidationDetails.Builder builder = UnreachableNodeFlowValidationDetails.builder();
        unreachableNode.accept(builder);
        return fromUnreachableNode(builder.build());
    }

    /**
     * Create an instance of this class with {@link #unknownConnectionSource()} initialized to the given value.
     *
     * <p>
     * Details about an unknown source node for a connection.
     * </p>
     * 
     * @param unknownConnectionSource
     *        Details about an unknown source node for a connection.
     */
    public static FlowValidationDetails fromUnknownConnectionSource(
            UnknownConnectionSourceFlowValidationDetails unknownConnectionSource) {
        return builder().unknownConnectionSource(unknownConnectionSource).build();
    }

    /**
     * Create an instance of this class with {@link #unknownConnectionSource()} initialized to the given value.
     *
     * <p>
     * Details about an unknown source node for a connection.
     * </p>
     * 
     * @param unknownConnectionSource
     *        Details about an unknown source node for a connection.
     */
    public static FlowValidationDetails fromUnknownConnectionSource(
            Consumer<UnknownConnectionSourceFlowValidationDetails.Builder> unknownConnectionSource) {
        UnknownConnectionSourceFlowValidationDetails.Builder builder = UnknownConnectionSourceFlowValidationDetails.builder();
        unknownConnectionSource.accept(builder);
        return fromUnknownConnectionSource(builder.build());
    }

    /**
     * Create an instance of this class with {@link #unknownConnectionSourceOutput()} initialized to the given value.
     *
     * <p>
     * Details about an unknown source output for a connection.
     * </p>
     * 
     * @param unknownConnectionSourceOutput
     *        Details about an unknown source output for a connection.
     */
    public static FlowValidationDetails fromUnknownConnectionSourceOutput(
            UnknownConnectionSourceOutputFlowValidationDetails unknownConnectionSourceOutput) {
        return builder().unknownConnectionSourceOutput(unknownConnectionSourceOutput).build();
    }

    /**
     * Create an instance of this class with {@link #unknownConnectionSourceOutput()} initialized to the given value.
     *
     * <p>
     * Details about an unknown source output for a connection.
     * </p>
     * 
     * @param unknownConnectionSourceOutput
     *        Details about an unknown source output for a connection.
     */
    public static FlowValidationDetails fromUnknownConnectionSourceOutput(
            Consumer<UnknownConnectionSourceOutputFlowValidationDetails.Builder> unknownConnectionSourceOutput) {
        UnknownConnectionSourceOutputFlowValidationDetails.Builder builder = UnknownConnectionSourceOutputFlowValidationDetails
                .builder();
        unknownConnectionSourceOutput.accept(builder);
        return fromUnknownConnectionSourceOutput(builder.build());
    }

    /**
     * Create an instance of this class with {@link #unknownConnectionTarget()} initialized to the given value.
     *
     * <p>
     * Details about an unknown target node for a connection.
     * </p>
     * 
     * @param unknownConnectionTarget
     *        Details about an unknown target node for a connection.
     */
    public static FlowValidationDetails fromUnknownConnectionTarget(
            UnknownConnectionTargetFlowValidationDetails unknownConnectionTarget) {
        return builder().unknownConnectionTarget(unknownConnectionTarget).build();
    }

    /**
     * Create an instance of this class with {@link #unknownConnectionTarget()} initialized to the given value.
     *
     * <p>
     * Details about an unknown target node for a connection.
     * </p>
     * 
     * @param unknownConnectionTarget
     *        Details about an unknown target node for a connection.
     */
    public static FlowValidationDetails fromUnknownConnectionTarget(
            Consumer<UnknownConnectionTargetFlowValidationDetails.Builder> unknownConnectionTarget) {
        UnknownConnectionTargetFlowValidationDetails.Builder builder = UnknownConnectionTargetFlowValidationDetails.builder();
        unknownConnectionTarget.accept(builder);
        return fromUnknownConnectionTarget(builder.build());
    }

    /**
     * Create an instance of this class with {@link #unknownConnectionTargetInput()} initialized to the given value.
     *
     * <p>
     * Details about an unknown target input for a connection.
     * </p>
     * 
     * @param unknownConnectionTargetInput
     *        Details about an unknown target input for a connection.
     */
    public static FlowValidationDetails fromUnknownConnectionTargetInput(
            UnknownConnectionTargetInputFlowValidationDetails unknownConnectionTargetInput) {
        return builder().unknownConnectionTargetInput(unknownConnectionTargetInput).build();
    }

    /**
     * Create an instance of this class with {@link #unknownConnectionTargetInput()} initialized to the given value.
     *
     * <p>
     * Details about an unknown target input for a connection.
     * </p>
     * 
     * @param unknownConnectionTargetInput
     *        Details about an unknown target input for a connection.
     */
    public static FlowValidationDetails fromUnknownConnectionTargetInput(
            Consumer<UnknownConnectionTargetInputFlowValidationDetails.Builder> unknownConnectionTargetInput) {
        UnknownConnectionTargetInputFlowValidationDetails.Builder builder = UnknownConnectionTargetInputFlowValidationDetails
                .builder();
        unknownConnectionTargetInput.accept(builder);
        return fromUnknownConnectionTargetInput(builder.build());
    }

    /**
     * Create an instance of this class with {@link #unknownConnectionCondition()} initialized to the given value.
     *
     * <p>
     * Details about an unknown condition for a connection.
     * </p>
     * 
     * @param unknownConnectionCondition
     *        Details about an unknown condition for a connection.
     */
    public static FlowValidationDetails fromUnknownConnectionCondition(
            UnknownConnectionConditionFlowValidationDetails unknownConnectionCondition) {
        return builder().unknownConnectionCondition(unknownConnectionCondition).build();
    }

    /**
     * Create an instance of this class with {@link #unknownConnectionCondition()} initialized to the given value.
     *
     * <p>
     * Details about an unknown condition for a connection.
     * </p>
     * 
     * @param unknownConnectionCondition
     *        Details about an unknown condition for a connection.
     */
    public static FlowValidationDetails fromUnknownConnectionCondition(
            Consumer<UnknownConnectionConditionFlowValidationDetails.Builder> unknownConnectionCondition) {
        UnknownConnectionConditionFlowValidationDetails.Builder builder = UnknownConnectionConditionFlowValidationDetails
                .builder();
        unknownConnectionCondition.accept(builder);
        return fromUnknownConnectionCondition(builder.build());
    }

    /**
     * Create an instance of this class with {@link #malformedConditionExpression()} initialized to the given value.
     *
     * <p>
     * Details about a malformed condition expression in a node.
     * </p>
     * 
     * @param malformedConditionExpression
     *        Details about a malformed condition expression in a node.
     */
    public static FlowValidationDetails fromMalformedConditionExpression(
            MalformedConditionExpressionFlowValidationDetails malformedConditionExpression) {
        return builder().malformedConditionExpression(malformedConditionExpression).build();
    }

    /**
     * Create an instance of this class with {@link #malformedConditionExpression()} initialized to the given value.
     *
     * <p>
     * Details about a malformed condition expression in a node.
     * </p>
     * 
     * @param malformedConditionExpression
     *        Details about a malformed condition expression in a node.
     */
    public static FlowValidationDetails fromMalformedConditionExpression(
            Consumer<MalformedConditionExpressionFlowValidationDetails.Builder> malformedConditionExpression) {
        MalformedConditionExpressionFlowValidationDetails.Builder builder = MalformedConditionExpressionFlowValidationDetails
                .builder();
        malformedConditionExpression.accept(builder);
        return fromMalformedConditionExpression(builder.build());
    }

    /**
     * Create an instance of this class with {@link #malformedNodeInputExpression()} initialized to the given value.
     *
     * <p>
     * Details about a malformed input expression in a node.
     * </p>
     * 
     * @param malformedNodeInputExpression
     *        Details about a malformed input expression in a node.
     */
    public static FlowValidationDetails fromMalformedNodeInputExpression(
            MalformedNodeInputExpressionFlowValidationDetails malformedNodeInputExpression) {
        return builder().malformedNodeInputExpression(malformedNodeInputExpression).build();
    }

    /**
     * Create an instance of this class with {@link #malformedNodeInputExpression()} initialized to the given value.
     *
     * <p>
     * Details about a malformed input expression in a node.
     * </p>
     * 
     * @param malformedNodeInputExpression
     *        Details about a malformed input expression in a node.
     */
    public static FlowValidationDetails fromMalformedNodeInputExpression(
            Consumer<MalformedNodeInputExpressionFlowValidationDetails.Builder> malformedNodeInputExpression) {
        MalformedNodeInputExpressionFlowValidationDetails.Builder builder = MalformedNodeInputExpressionFlowValidationDetails
                .builder();
        malformedNodeInputExpression.accept(builder);
        return fromMalformedNodeInputExpression(builder.build());
    }

    /**
     * Create an instance of this class with {@link #mismatchedNodeInputType()} initialized to the given value.
     *
     * <p>
     * Details about mismatched input data types in a node.
     * </p>
     * 
     * @param mismatchedNodeInputType
     *        Details about mismatched input data types in a node.
     */
    public static FlowValidationDetails fromMismatchedNodeInputType(
            MismatchedNodeInputTypeFlowValidationDetails mismatchedNodeInputType) {
        return builder().mismatchedNodeInputType(mismatchedNodeInputType).build();
    }

    /**
     * Create an instance of this class with {@link #mismatchedNodeInputType()} initialized to the given value.
     *
     * <p>
     * Details about mismatched input data types in a node.
     * </p>
     * 
     * @param mismatchedNodeInputType
     *        Details about mismatched input data types in a node.
     */
    public static FlowValidationDetails fromMismatchedNodeInputType(
            Consumer<MismatchedNodeInputTypeFlowValidationDetails.Builder> mismatchedNodeInputType) {
        MismatchedNodeInputTypeFlowValidationDetails.Builder builder = MismatchedNodeInputTypeFlowValidationDetails.builder();
        mismatchedNodeInputType.accept(builder);
        return fromMismatchedNodeInputType(builder.build());
    }

    /**
     * Create an instance of this class with {@link #mismatchedNodeOutputType()} initialized to the given value.
     *
     * <p>
     * Details about mismatched output data types in a node.
     * </p>
     * 
     * @param mismatchedNodeOutputType
     *        Details about mismatched output data types in a node.
     */
    public static FlowValidationDetails fromMismatchedNodeOutputType(
            MismatchedNodeOutputTypeFlowValidationDetails mismatchedNodeOutputType) {
        return builder().mismatchedNodeOutputType(mismatchedNodeOutputType).build();
    }

    /**
     * Create an instance of this class with {@link #mismatchedNodeOutputType()} initialized to the given value.
     *
     * <p>
     * Details about mismatched output data types in a node.
     * </p>
     * 
     * @param mismatchedNodeOutputType
     *        Details about mismatched output data types in a node.
     */
    public static FlowValidationDetails fromMismatchedNodeOutputType(
            Consumer<MismatchedNodeOutputTypeFlowValidationDetails.Builder> mismatchedNodeOutputType) {
        MismatchedNodeOutputTypeFlowValidationDetails.Builder builder = MismatchedNodeOutputTypeFlowValidationDetails.builder();
        mismatchedNodeOutputType.accept(builder);
        return fromMismatchedNodeOutputType(builder.build());
    }

    /**
     * Create an instance of this class with {@link #incompatibleConnectionDataType()} initialized to the given value.
     *
     * <p>
     * Details about incompatible data types in a connection.
     * </p>
     * 
     * @param incompatibleConnectionDataType
     *        Details about incompatible data types in a connection.
     */
    public static FlowValidationDetails fromIncompatibleConnectionDataType(
            IncompatibleConnectionDataTypeFlowValidationDetails incompatibleConnectionDataType) {
        return builder().incompatibleConnectionDataType(incompatibleConnectionDataType).build();
    }

    /**
     * Create an instance of this class with {@link #incompatibleConnectionDataType()} initialized to the given value.
     *
     * <p>
     * Details about incompatible data types in a connection.
     * </p>
     * 
     * @param incompatibleConnectionDataType
     *        Details about incompatible data types in a connection.
     */
    public static FlowValidationDetails fromIncompatibleConnectionDataType(
            Consumer<IncompatibleConnectionDataTypeFlowValidationDetails.Builder> incompatibleConnectionDataType) {
        IncompatibleConnectionDataTypeFlowValidationDetails.Builder builder = IncompatibleConnectionDataTypeFlowValidationDetails
                .builder();
        incompatibleConnectionDataType.accept(builder);
        return fromIncompatibleConnectionDataType(builder.build());
    }

    /**
     * Create an instance of this class with {@link #missingConnectionConfiguration()} initialized to the given value.
     *
     * <p>
     * Details about missing configuration for a connection.
     * </p>
     * 
     * @param missingConnectionConfiguration
     *        Details about missing configuration for a connection.
     */
    public static FlowValidationDetails fromMissingConnectionConfiguration(
            MissingConnectionConfigurationFlowValidationDetails missingConnectionConfiguration) {
        return builder().missingConnectionConfiguration(missingConnectionConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #missingConnectionConfiguration()} initialized to the given value.
     *
     * <p>
     * Details about missing configuration for a connection.
     * </p>
     * 
     * @param missingConnectionConfiguration
     *        Details about missing configuration for a connection.
     */
    public static FlowValidationDetails fromMissingConnectionConfiguration(
            Consumer<MissingConnectionConfigurationFlowValidationDetails.Builder> missingConnectionConfiguration) {
        MissingConnectionConfigurationFlowValidationDetails.Builder builder = MissingConnectionConfigurationFlowValidationDetails
                .builder();
        missingConnectionConfiguration.accept(builder);
        return fromMissingConnectionConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #missingDefaultCondition()} initialized to the given value.
     *
     * <p>
     * Details about a missing default condition in a conditional node.
     * </p>
     * 
     * @param missingDefaultCondition
     *        Details about a missing default condition in a conditional node.
     */
    public static FlowValidationDetails fromMissingDefaultCondition(
            MissingDefaultConditionFlowValidationDetails missingDefaultCondition) {
        return builder().missingDefaultCondition(missingDefaultCondition).build();
    }

    /**
     * Create an instance of this class with {@link #missingDefaultCondition()} initialized to the given value.
     *
     * <p>
     * Details about a missing default condition in a conditional node.
     * </p>
     * 
     * @param missingDefaultCondition
     *        Details about a missing default condition in a conditional node.
     */
    public static FlowValidationDetails fromMissingDefaultCondition(
            Consumer<MissingDefaultConditionFlowValidationDetails.Builder> missingDefaultCondition) {
        MissingDefaultConditionFlowValidationDetails.Builder builder = MissingDefaultConditionFlowValidationDetails.builder();
        missingDefaultCondition.accept(builder);
        return fromMissingDefaultCondition(builder.build());
    }

    /**
     * Create an instance of this class with {@link #missingEndingNodes()} initialized to the given value.
     *
     * <p>
     * Details about missing ending nodes in the flow.
     * </p>
     * 
     * @param missingEndingNodes
     *        Details about missing ending nodes in the flow.
     */
    public static FlowValidationDetails fromMissingEndingNodes(MissingEndingNodesFlowValidationDetails missingEndingNodes) {
        return builder().missingEndingNodes(missingEndingNodes).build();
    }

    /**
     * Create an instance of this class with {@link #missingEndingNodes()} initialized to the given value.
     *
     * <p>
     * Details about missing ending nodes in the flow.
     * </p>
     * 
     * @param missingEndingNodes
     *        Details about missing ending nodes in the flow.
     */
    public static FlowValidationDetails fromMissingEndingNodes(
            Consumer<MissingEndingNodesFlowValidationDetails.Builder> missingEndingNodes) {
        MissingEndingNodesFlowValidationDetails.Builder builder = MissingEndingNodesFlowValidationDetails.builder();
        missingEndingNodes.accept(builder);
        return fromMissingEndingNodes(builder.build());
    }

    /**
     * Create an instance of this class with {@link #missingNodeConfiguration()} initialized to the given value.
     *
     * <p>
     * Details about missing configuration for a node.
     * </p>
     * 
     * @param missingNodeConfiguration
     *        Details about missing configuration for a node.
     */
    public static FlowValidationDetails fromMissingNodeConfiguration(
            MissingNodeConfigurationFlowValidationDetails missingNodeConfiguration) {
        return builder().missingNodeConfiguration(missingNodeConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #missingNodeConfiguration()} initialized to the given value.
     *
     * <p>
     * Details about missing configuration for a node.
     * </p>
     * 
     * @param missingNodeConfiguration
     *        Details about missing configuration for a node.
     */
    public static FlowValidationDetails fromMissingNodeConfiguration(
            Consumer<MissingNodeConfigurationFlowValidationDetails.Builder> missingNodeConfiguration) {
        MissingNodeConfigurationFlowValidationDetails.Builder builder = MissingNodeConfigurationFlowValidationDetails.builder();
        missingNodeConfiguration.accept(builder);
        return fromMissingNodeConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #missingNodeInput()} initialized to the given value.
     *
     * <p>
     * Details about a missing required input in a node.
     * </p>
     * 
     * @param missingNodeInput
     *        Details about a missing required input in a node.
     */
    public static FlowValidationDetails fromMissingNodeInput(MissingNodeInputFlowValidationDetails missingNodeInput) {
        return builder().missingNodeInput(missingNodeInput).build();
    }

    /**
     * Create an instance of this class with {@link #missingNodeInput()} initialized to the given value.
     *
     * <p>
     * Details about a missing required input in a node.
     * </p>
     * 
     * @param missingNodeInput
     *        Details about a missing required input in a node.
     */
    public static FlowValidationDetails fromMissingNodeInput(
            Consumer<MissingNodeInputFlowValidationDetails.Builder> missingNodeInput) {
        MissingNodeInputFlowValidationDetails.Builder builder = MissingNodeInputFlowValidationDetails.builder();
        missingNodeInput.accept(builder);
        return fromMissingNodeInput(builder.build());
    }

    /**
     * Create an instance of this class with {@link #missingNodeOutput()} initialized to the given value.
     *
     * <p>
     * Details about a missing required output in a node.
     * </p>
     * 
     * @param missingNodeOutput
     *        Details about a missing required output in a node.
     */
    public static FlowValidationDetails fromMissingNodeOutput(MissingNodeOutputFlowValidationDetails missingNodeOutput) {
        return builder().missingNodeOutput(missingNodeOutput).build();
    }

    /**
     * Create an instance of this class with {@link #missingNodeOutput()} initialized to the given value.
     *
     * <p>
     * Details about a missing required output in a node.
     * </p>
     * 
     * @param missingNodeOutput
     *        Details about a missing required output in a node.
     */
    public static FlowValidationDetails fromMissingNodeOutput(
            Consumer<MissingNodeOutputFlowValidationDetails.Builder> missingNodeOutput) {
        MissingNodeOutputFlowValidationDetails.Builder builder = MissingNodeOutputFlowValidationDetails.builder();
        missingNodeOutput.accept(builder);
        return fromMissingNodeOutput(builder.build());
    }

    /**
     * Create an instance of this class with {@link #missingStartingNodes()} initialized to the given value.
     *
     * <p>
     * Details about missing starting nodes in the flow.
     * </p>
     * 
     * @param missingStartingNodes
     *        Details about missing starting nodes in the flow.
     */
    public static FlowValidationDetails fromMissingStartingNodes(MissingStartingNodesFlowValidationDetails missingStartingNodes) {
        return builder().missingStartingNodes(missingStartingNodes).build();
    }

    /**
     * Create an instance of this class with {@link #missingStartingNodes()} initialized to the given value.
     *
     * <p>
     * Details about missing starting nodes in the flow.
     * </p>
     * 
     * @param missingStartingNodes
     *        Details about missing starting nodes in the flow.
     */
    public static FlowValidationDetails fromMissingStartingNodes(
            Consumer<MissingStartingNodesFlowValidationDetails.Builder> missingStartingNodes) {
        MissingStartingNodesFlowValidationDetails.Builder builder = MissingStartingNodesFlowValidationDetails.builder();
        missingStartingNodes.accept(builder);
        return fromMissingStartingNodes(builder.build());
    }

    /**
     * Create an instance of this class with {@link #multipleNodeInputConnections()} initialized to the given value.
     *
     * <p>
     * Details about multiple connections to a single node input.
     * </p>
     * 
     * @param multipleNodeInputConnections
     *        Details about multiple connections to a single node input.
     */
    public static FlowValidationDetails fromMultipleNodeInputConnections(
            MultipleNodeInputConnectionsFlowValidationDetails multipleNodeInputConnections) {
        return builder().multipleNodeInputConnections(multipleNodeInputConnections).build();
    }

    /**
     * Create an instance of this class with {@link #multipleNodeInputConnections()} initialized to the given value.
     *
     * <p>
     * Details about multiple connections to a single node input.
     * </p>
     * 
     * @param multipleNodeInputConnections
     *        Details about multiple connections to a single node input.
     */
    public static FlowValidationDetails fromMultipleNodeInputConnections(
            Consumer<MultipleNodeInputConnectionsFlowValidationDetails.Builder> multipleNodeInputConnections) {
        MultipleNodeInputConnectionsFlowValidationDetails.Builder builder = MultipleNodeInputConnectionsFlowValidationDetails
                .builder();
        multipleNodeInputConnections.accept(builder);
        return fromMultipleNodeInputConnections(builder.build());
    }

    /**
     * Create an instance of this class with {@link #unfulfilledNodeInput()} initialized to the given value.
     *
     * <p>
     * Details about an unfulfilled node input with no valid connections.
     * </p>
     * 
     * @param unfulfilledNodeInput
     *        Details about an unfulfilled node input with no valid connections.
     */
    public static FlowValidationDetails fromUnfulfilledNodeInput(UnfulfilledNodeInputFlowValidationDetails unfulfilledNodeInput) {
        return builder().unfulfilledNodeInput(unfulfilledNodeInput).build();
    }

    /**
     * Create an instance of this class with {@link #unfulfilledNodeInput()} initialized to the given value.
     *
     * <p>
     * Details about an unfulfilled node input with no valid connections.
     * </p>
     * 
     * @param unfulfilledNodeInput
     *        Details about an unfulfilled node input with no valid connections.
     */
    public static FlowValidationDetails fromUnfulfilledNodeInput(
            Consumer<UnfulfilledNodeInputFlowValidationDetails.Builder> unfulfilledNodeInput) {
        UnfulfilledNodeInputFlowValidationDetails.Builder builder = UnfulfilledNodeInputFlowValidationDetails.builder();
        unfulfilledNodeInput.accept(builder);
        return fromUnfulfilledNodeInput(builder.build());
    }

    /**
     * Create an instance of this class with {@link #unsatisfiedConnectionConditions()} initialized to the given value.
     *
     * <p>
     * Details about unsatisfied conditions for a connection.
     * </p>
     * 
     * @param unsatisfiedConnectionConditions
     *        Details about unsatisfied conditions for a connection.
     */
    public static FlowValidationDetails fromUnsatisfiedConnectionConditions(
            UnsatisfiedConnectionConditionsFlowValidationDetails unsatisfiedConnectionConditions) {
        return builder().unsatisfiedConnectionConditions(unsatisfiedConnectionConditions).build();
    }

    /**
     * Create an instance of this class with {@link #unsatisfiedConnectionConditions()} initialized to the given value.
     *
     * <p>
     * Details about unsatisfied conditions for a connection.
     * </p>
     * 
     * @param unsatisfiedConnectionConditions
     *        Details about unsatisfied conditions for a connection.
     */
    public static FlowValidationDetails fromUnsatisfiedConnectionConditions(
            Consumer<UnsatisfiedConnectionConditionsFlowValidationDetails.Builder> unsatisfiedConnectionConditions) {
        UnsatisfiedConnectionConditionsFlowValidationDetails.Builder builder = UnsatisfiedConnectionConditionsFlowValidationDetails
                .builder();
        unsatisfiedConnectionConditions.accept(builder);
        return fromUnsatisfiedConnectionConditions(builder.build());
    }

    /**
     * Create an instance of this class with {@link #unspecified()} initialized to the given value.
     *
     * <p>
     * Details about an unspecified validation.
     * </p>
     * 
     * @param unspecified
     *        Details about an unspecified validation.
     */
    public static FlowValidationDetails fromUnspecified(UnspecifiedFlowValidationDetails unspecified) {
        return builder().unspecified(unspecified).build();
    }

    /**
     * Create an instance of this class with {@link #unspecified()} initialized to the given value.
     *
     * <p>
     * Details about an unspecified validation.
     * </p>
     * 
     * @param unspecified
     *        Details about an unspecified validation.
     */
    public static FlowValidationDetails fromUnspecified(Consumer<UnspecifiedFlowValidationDetails.Builder> unspecified) {
        UnspecifiedFlowValidationDetails.Builder builder = UnspecifiedFlowValidationDetails.builder();
        unspecified.accept(builder);
        return fromUnspecified(builder.build());
    }

    /**
     * Create an instance of this class with {@link #unknownNodeInput()} initialized to the given value.
     *
     * <p>
     * Details about an unknown input for a node.
     * </p>
     * 
     * @param unknownNodeInput
     *        Details about an unknown input for a node.
     */
    public static FlowValidationDetails fromUnknownNodeInput(UnknownNodeInputFlowValidationDetails unknownNodeInput) {
        return builder().unknownNodeInput(unknownNodeInput).build();
    }

    /**
     * Create an instance of this class with {@link #unknownNodeInput()} initialized to the given value.
     *
     * <p>
     * Details about an unknown input for a node.
     * </p>
     * 
     * @param unknownNodeInput
     *        Details about an unknown input for a node.
     */
    public static FlowValidationDetails fromUnknownNodeInput(
            Consumer<UnknownNodeInputFlowValidationDetails.Builder> unknownNodeInput) {
        UnknownNodeInputFlowValidationDetails.Builder builder = UnknownNodeInputFlowValidationDetails.builder();
        unknownNodeInput.accept(builder);
        return fromUnknownNodeInput(builder.build());
    }

    /**
     * Create an instance of this class with {@link #unknownNodeOutput()} initialized to the given value.
     *
     * <p>
     * Details about an unknown output for a node.
     * </p>
     * 
     * @param unknownNodeOutput
     *        Details about an unknown output for a node.
     */
    public static FlowValidationDetails fromUnknownNodeOutput(UnknownNodeOutputFlowValidationDetails unknownNodeOutput) {
        return builder().unknownNodeOutput(unknownNodeOutput).build();
    }

    /**
     * Create an instance of this class with {@link #unknownNodeOutput()} initialized to the given value.
     *
     * <p>
     * Details about an unknown output for a node.
     * </p>
     * 
     * @param unknownNodeOutput
     *        Details about an unknown output for a node.
     */
    public static FlowValidationDetails fromUnknownNodeOutput(
            Consumer<UnknownNodeOutputFlowValidationDetails.Builder> unknownNodeOutput) {
        UnknownNodeOutputFlowValidationDetails.Builder builder = UnknownNodeOutputFlowValidationDetails.builder();
        unknownNodeOutput.accept(builder);
        return fromUnknownNodeOutput(builder.build());
    }

    /**
     * Create an instance of this class with {@link #missingLoopInputNode()} initialized to the given value.
     *
     * <p>
     * Details about a flow that's missing a required <code>LoopInput</code> node in a DoWhile loop.
     * </p>
     * 
     * @param missingLoopInputNode
     *        Details about a flow that's missing a required <code>LoopInput</code> node in a DoWhile loop.
     */
    public static FlowValidationDetails fromMissingLoopInputNode(MissingLoopInputNodeFlowValidationDetails missingLoopInputNode) {
        return builder().missingLoopInputNode(missingLoopInputNode).build();
    }

    /**
     * Create an instance of this class with {@link #missingLoopInputNode()} initialized to the given value.
     *
     * <p>
     * Details about a flow that's missing a required <code>LoopInput</code> node in a DoWhile loop.
     * </p>
     * 
     * @param missingLoopInputNode
     *        Details about a flow that's missing a required <code>LoopInput</code> node in a DoWhile loop.
     */
    public static FlowValidationDetails fromMissingLoopInputNode(
            Consumer<MissingLoopInputNodeFlowValidationDetails.Builder> missingLoopInputNode) {
        MissingLoopInputNodeFlowValidationDetails.Builder builder = MissingLoopInputNodeFlowValidationDetails.builder();
        missingLoopInputNode.accept(builder);
        return fromMissingLoopInputNode(builder.build());
    }

    /**
     * Create an instance of this class with {@link #missingLoopControllerNode()} initialized to the given value.
     *
     * <p>
     * Details about a flow that's missing a required <code>LoopController</code> node in a DoWhile loop.
     * </p>
     * 
     * @param missingLoopControllerNode
     *        Details about a flow that's missing a required <code>LoopController</code> node in a DoWhile loop.
     */
    public static FlowValidationDetails fromMissingLoopControllerNode(
            MissingLoopControllerNodeFlowValidationDetails missingLoopControllerNode) {
        return builder().missingLoopControllerNode(missingLoopControllerNode).build();
    }

    /**
     * Create an instance of this class with {@link #missingLoopControllerNode()} initialized to the given value.
     *
     * <p>
     * Details about a flow that's missing a required <code>LoopController</code> node in a DoWhile loop.
     * </p>
     * 
     * @param missingLoopControllerNode
     *        Details about a flow that's missing a required <code>LoopController</code> node in a DoWhile loop.
     */
    public static FlowValidationDetails fromMissingLoopControllerNode(
            Consumer<MissingLoopControllerNodeFlowValidationDetails.Builder> missingLoopControllerNode) {
        MissingLoopControllerNodeFlowValidationDetails.Builder builder = MissingLoopControllerNodeFlowValidationDetails.builder();
        missingLoopControllerNode.accept(builder);
        return fromMissingLoopControllerNode(builder.build());
    }

    /**
     * Create an instance of this class with {@link #multipleLoopInputNodes()} initialized to the given value.
     *
     * <p>
     * Details about a flow that contains multiple <code>LoopInput</code> nodes in a DoWhile loop.
     * </p>
     * 
     * @param multipleLoopInputNodes
     *        Details about a flow that contains multiple <code>LoopInput</code> nodes in a DoWhile loop.
     */
    public static FlowValidationDetails fromMultipleLoopInputNodes(
            MultipleLoopInputNodesFlowValidationDetails multipleLoopInputNodes) {
        return builder().multipleLoopInputNodes(multipleLoopInputNodes).build();
    }

    /**
     * Create an instance of this class with {@link #multipleLoopInputNodes()} initialized to the given value.
     *
     * <p>
     * Details about a flow that contains multiple <code>LoopInput</code> nodes in a DoWhile loop.
     * </p>
     * 
     * @param multipleLoopInputNodes
     *        Details about a flow that contains multiple <code>LoopInput</code> nodes in a DoWhile loop.
     */
    public static FlowValidationDetails fromMultipleLoopInputNodes(
            Consumer<MultipleLoopInputNodesFlowValidationDetails.Builder> multipleLoopInputNodes) {
        MultipleLoopInputNodesFlowValidationDetails.Builder builder = MultipleLoopInputNodesFlowValidationDetails.builder();
        multipleLoopInputNodes.accept(builder);
        return fromMultipleLoopInputNodes(builder.build());
    }

    /**
     * Create an instance of this class with {@link #multipleLoopControllerNodes()} initialized to the given value.
     *
     * <p>
     * Details about a flow that contains multiple <code>LoopController</code> nodes in a DoWhile loop.
     * </p>
     * 
     * @param multipleLoopControllerNodes
     *        Details about a flow that contains multiple <code>LoopController</code> nodes in a DoWhile loop.
     */
    public static FlowValidationDetails fromMultipleLoopControllerNodes(
            MultipleLoopControllerNodesFlowValidationDetails multipleLoopControllerNodes) {
        return builder().multipleLoopControllerNodes(multipleLoopControllerNodes).build();
    }

    /**
     * Create an instance of this class with {@link #multipleLoopControllerNodes()} initialized to the given value.
     *
     * <p>
     * Details about a flow that contains multiple <code>LoopController</code> nodes in a DoWhile loop.
     * </p>
     * 
     * @param multipleLoopControllerNodes
     *        Details about a flow that contains multiple <code>LoopController</code> nodes in a DoWhile loop.
     */
    public static FlowValidationDetails fromMultipleLoopControllerNodes(
            Consumer<MultipleLoopControllerNodesFlowValidationDetails.Builder> multipleLoopControllerNodes) {
        MultipleLoopControllerNodesFlowValidationDetails.Builder builder = MultipleLoopControllerNodesFlowValidationDetails
                .builder();
        multipleLoopControllerNodes.accept(builder);
        return fromMultipleLoopControllerNodes(builder.build());
    }

    /**
     * Create an instance of this class with {@link #loopIncompatibleNodeType()} initialized to the given value.
     *
     * <p>
     * Details about a flow that includes incompatible node types in a DoWhile loop.
     * </p>
     * 
     * @param loopIncompatibleNodeType
     *        Details about a flow that includes incompatible node types in a DoWhile loop.
     */
    public static FlowValidationDetails fromLoopIncompatibleNodeType(
            LoopIncompatibleNodeTypeFlowValidationDetails loopIncompatibleNodeType) {
        return builder().loopIncompatibleNodeType(loopIncompatibleNodeType).build();
    }

    /**
     * Create an instance of this class with {@link #loopIncompatibleNodeType()} initialized to the given value.
     *
     * <p>
     * Details about a flow that includes incompatible node types in a DoWhile loop.
     * </p>
     * 
     * @param loopIncompatibleNodeType
     *        Details about a flow that includes incompatible node types in a DoWhile loop.
     */
    public static FlowValidationDetails fromLoopIncompatibleNodeType(
            Consumer<LoopIncompatibleNodeTypeFlowValidationDetails.Builder> loopIncompatibleNodeType) {
        LoopIncompatibleNodeTypeFlowValidationDetails.Builder builder = LoopIncompatibleNodeTypeFlowValidationDetails.builder();
        loopIncompatibleNodeType.accept(builder);
        return fromLoopIncompatibleNodeType(builder.build());
    }

    /**
     * Create an instance of this class with {@link #invalidLoopBoundary()} initialized to the given value.
     *
     * <p>
     * Details about a flow that includes connections that violate loop boundary rules.
     * </p>
     * 
     * @param invalidLoopBoundary
     *        Details about a flow that includes connections that violate loop boundary rules.
     */
    public static FlowValidationDetails fromInvalidLoopBoundary(InvalidLoopBoundaryFlowValidationDetails invalidLoopBoundary) {
        return builder().invalidLoopBoundary(invalidLoopBoundary).build();
    }

    /**
     * Create an instance of this class with {@link #invalidLoopBoundary()} initialized to the given value.
     *
     * <p>
     * Details about a flow that includes connections that violate loop boundary rules.
     * </p>
     * 
     * @param invalidLoopBoundary
     *        Details about a flow that includes connections that violate loop boundary rules.
     */
    public static FlowValidationDetails fromInvalidLoopBoundary(
            Consumer<InvalidLoopBoundaryFlowValidationDetails.Builder> invalidLoopBoundary) {
        InvalidLoopBoundaryFlowValidationDetails.Builder builder = InvalidLoopBoundaryFlowValidationDetails.builder();
        invalidLoopBoundary.accept(builder);
        return fromInvalidLoopBoundary(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cyclicConnection", CYCLIC_CONNECTION_FIELD);
        map.put("duplicateConnections", DUPLICATE_CONNECTIONS_FIELD);
        map.put("duplicateConditionExpression", DUPLICATE_CONDITION_EXPRESSION_FIELD);
        map.put("unreachableNode", UNREACHABLE_NODE_FIELD);
        map.put("unknownConnectionSource", UNKNOWN_CONNECTION_SOURCE_FIELD);
        map.put("unknownConnectionSourceOutput", UNKNOWN_CONNECTION_SOURCE_OUTPUT_FIELD);
        map.put("unknownConnectionTarget", UNKNOWN_CONNECTION_TARGET_FIELD);
        map.put("unknownConnectionTargetInput", UNKNOWN_CONNECTION_TARGET_INPUT_FIELD);
        map.put("unknownConnectionCondition", UNKNOWN_CONNECTION_CONDITION_FIELD);
        map.put("malformedConditionExpression", MALFORMED_CONDITION_EXPRESSION_FIELD);
        map.put("malformedNodeInputExpression", MALFORMED_NODE_INPUT_EXPRESSION_FIELD);
        map.put("mismatchedNodeInputType", MISMATCHED_NODE_INPUT_TYPE_FIELD);
        map.put("mismatchedNodeOutputType", MISMATCHED_NODE_OUTPUT_TYPE_FIELD);
        map.put("incompatibleConnectionDataType", INCOMPATIBLE_CONNECTION_DATA_TYPE_FIELD);
        map.put("missingConnectionConfiguration", MISSING_CONNECTION_CONFIGURATION_FIELD);
        map.put("missingDefaultCondition", MISSING_DEFAULT_CONDITION_FIELD);
        map.put("missingEndingNodes", MISSING_ENDING_NODES_FIELD);
        map.put("missingNodeConfiguration", MISSING_NODE_CONFIGURATION_FIELD);
        map.put("missingNodeInput", MISSING_NODE_INPUT_FIELD);
        map.put("missingNodeOutput", MISSING_NODE_OUTPUT_FIELD);
        map.put("missingStartingNodes", MISSING_STARTING_NODES_FIELD);
        map.put("multipleNodeInputConnections", MULTIPLE_NODE_INPUT_CONNECTIONS_FIELD);
        map.put("unfulfilledNodeInput", UNFULFILLED_NODE_INPUT_FIELD);
        map.put("unsatisfiedConnectionConditions", UNSATISFIED_CONNECTION_CONDITIONS_FIELD);
        map.put("unspecified", UNSPECIFIED_FIELD);
        map.put("unknownNodeInput", UNKNOWN_NODE_INPUT_FIELD);
        map.put("unknownNodeOutput", UNKNOWN_NODE_OUTPUT_FIELD);
        map.put("missingLoopInputNode", MISSING_LOOP_INPUT_NODE_FIELD);
        map.put("missingLoopControllerNode", MISSING_LOOP_CONTROLLER_NODE_FIELD);
        map.put("multipleLoopInputNodes", MULTIPLE_LOOP_INPUT_NODES_FIELD);
        map.put("multipleLoopControllerNodes", MULTIPLE_LOOP_CONTROLLER_NODES_FIELD);
        map.put("loopIncompatibleNodeType", LOOP_INCOMPATIBLE_NODE_TYPE_FIELD);
        map.put("invalidLoopBoundary", INVALID_LOOP_BOUNDARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowValidationDetails, T> g) {
        return obj -> g.apply((FlowValidationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowValidationDetails> {
        /**
         * <p>
         * Details about a cyclic connection in the flow.
         * </p>
         * 
         * @param cyclicConnection
         *        Details about a cyclic connection in the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cyclicConnection(CyclicConnectionFlowValidationDetails cyclicConnection);

        /**
         * <p>
         * Details about a cyclic connection in the flow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CyclicConnectionFlowValidationDetails.Builder} avoiding the need to create one manually via
         * {@link CyclicConnectionFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CyclicConnectionFlowValidationDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #cyclicConnection(CyclicConnectionFlowValidationDetails)}.
         * 
         * @param cyclicConnection
         *        a consumer that will call methods on {@link CyclicConnectionFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cyclicConnection(CyclicConnectionFlowValidationDetails)
         */
        default Builder cyclicConnection(Consumer<CyclicConnectionFlowValidationDetails.Builder> cyclicConnection) {
            return cyclicConnection(CyclicConnectionFlowValidationDetails.builder().applyMutation(cyclicConnection).build());
        }

        /**
         * <p>
         * Details about duplicate connections between nodes.
         * </p>
         * 
         * @param duplicateConnections
         *        Details about duplicate connections between nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duplicateConnections(DuplicateConnectionsFlowValidationDetails duplicateConnections);

        /**
         * <p>
         * Details about duplicate connections between nodes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DuplicateConnectionsFlowValidationDetails.Builder} avoiding the need to create one manually via
         * {@link DuplicateConnectionsFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DuplicateConnectionsFlowValidationDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #duplicateConnections(DuplicateConnectionsFlowValidationDetails)}.
         * 
         * @param duplicateConnections
         *        a consumer that will call methods on {@link DuplicateConnectionsFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #duplicateConnections(DuplicateConnectionsFlowValidationDetails)
         */
        default Builder duplicateConnections(Consumer<DuplicateConnectionsFlowValidationDetails.Builder> duplicateConnections) {
            return duplicateConnections(DuplicateConnectionsFlowValidationDetails.builder().applyMutation(duplicateConnections)
                    .build());
        }

        /**
         * <p>
         * Details about duplicate condition expressions in a node.
         * </p>
         * 
         * @param duplicateConditionExpression
         *        Details about duplicate condition expressions in a node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duplicateConditionExpression(DuplicateConditionExpressionFlowValidationDetails duplicateConditionExpression);

        /**
         * <p>
         * Details about duplicate condition expressions in a node.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DuplicateConditionExpressionFlowValidationDetails.Builder} avoiding the need to create one manually
         * via {@link DuplicateConditionExpressionFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link DuplicateConditionExpressionFlowValidationDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #duplicateConditionExpression(DuplicateConditionExpressionFlowValidationDetails)}.
         * 
         * @param duplicateConditionExpression
         *        a consumer that will call methods on {@link DuplicateConditionExpressionFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #duplicateConditionExpression(DuplicateConditionExpressionFlowValidationDetails)
         */
        default Builder duplicateConditionExpression(
                Consumer<DuplicateConditionExpressionFlowValidationDetails.Builder> duplicateConditionExpression) {
            return duplicateConditionExpression(DuplicateConditionExpressionFlowValidationDetails.builder()
                    .applyMutation(duplicateConditionExpression).build());
        }

        /**
         * <p>
         * Details about an unreachable node in the flow.
         * </p>
         * 
         * @param unreachableNode
         *        Details about an unreachable node in the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unreachableNode(UnreachableNodeFlowValidationDetails unreachableNode);

        /**
         * <p>
         * Details about an unreachable node in the flow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UnreachableNodeFlowValidationDetails.Builder} avoiding the need to create one manually via
         * {@link UnreachableNodeFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UnreachableNodeFlowValidationDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #unreachableNode(UnreachableNodeFlowValidationDetails)}.
         * 
         * @param unreachableNode
         *        a consumer that will call methods on {@link UnreachableNodeFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unreachableNode(UnreachableNodeFlowValidationDetails)
         */
        default Builder unreachableNode(Consumer<UnreachableNodeFlowValidationDetails.Builder> unreachableNode) {
            return unreachableNode(UnreachableNodeFlowValidationDetails.builder().applyMutation(unreachableNode).build());
        }

        /**
         * <p>
         * Details about an unknown source node for a connection.
         * </p>
         * 
         * @param unknownConnectionSource
         *        Details about an unknown source node for a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unknownConnectionSource(UnknownConnectionSourceFlowValidationDetails unknownConnectionSource);

        /**
         * <p>
         * Details about an unknown source node for a connection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UnknownConnectionSourceFlowValidationDetails.Builder} avoiding the need to create one manually via
         * {@link UnknownConnectionSourceFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UnknownConnectionSourceFlowValidationDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #unknownConnectionSource(UnknownConnectionSourceFlowValidationDetails)}.
         * 
         * @param unknownConnectionSource
         *        a consumer that will call methods on {@link UnknownConnectionSourceFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unknownConnectionSource(UnknownConnectionSourceFlowValidationDetails)
         */
        default Builder unknownConnectionSource(
                Consumer<UnknownConnectionSourceFlowValidationDetails.Builder> unknownConnectionSource) {
            return unknownConnectionSource(UnknownConnectionSourceFlowValidationDetails.builder()
                    .applyMutation(unknownConnectionSource).build());
        }

        /**
         * <p>
         * Details about an unknown source output for a connection.
         * </p>
         * 
         * @param unknownConnectionSourceOutput
         *        Details about an unknown source output for a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unknownConnectionSourceOutput(UnknownConnectionSourceOutputFlowValidationDetails unknownConnectionSourceOutput);

        /**
         * <p>
         * Details about an unknown source output for a connection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UnknownConnectionSourceOutputFlowValidationDetails.Builder} avoiding the need to create one manually
         * via {@link UnknownConnectionSourceOutputFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link UnknownConnectionSourceOutputFlowValidationDetails.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #unknownConnectionSourceOutput(UnknownConnectionSourceOutputFlowValidationDetails)}.
         * 
         * @param unknownConnectionSourceOutput
         *        a consumer that will call methods on
         *        {@link UnknownConnectionSourceOutputFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unknownConnectionSourceOutput(UnknownConnectionSourceOutputFlowValidationDetails)
         */
        default Builder unknownConnectionSourceOutput(
                Consumer<UnknownConnectionSourceOutputFlowValidationDetails.Builder> unknownConnectionSourceOutput) {
            return unknownConnectionSourceOutput(UnknownConnectionSourceOutputFlowValidationDetails.builder()
                    .applyMutation(unknownConnectionSourceOutput).build());
        }

        /**
         * <p>
         * Details about an unknown target node for a connection.
         * </p>
         * 
         * @param unknownConnectionTarget
         *        Details about an unknown target node for a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unknownConnectionTarget(UnknownConnectionTargetFlowValidationDetails unknownConnectionTarget);

        /**
         * <p>
         * Details about an unknown target node for a connection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UnknownConnectionTargetFlowValidationDetails.Builder} avoiding the need to create one manually via
         * {@link UnknownConnectionTargetFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UnknownConnectionTargetFlowValidationDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #unknownConnectionTarget(UnknownConnectionTargetFlowValidationDetails)}.
         * 
         * @param unknownConnectionTarget
         *        a consumer that will call methods on {@link UnknownConnectionTargetFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unknownConnectionTarget(UnknownConnectionTargetFlowValidationDetails)
         */
        default Builder unknownConnectionTarget(
                Consumer<UnknownConnectionTargetFlowValidationDetails.Builder> unknownConnectionTarget) {
            return unknownConnectionTarget(UnknownConnectionTargetFlowValidationDetails.builder()
                    .applyMutation(unknownConnectionTarget).build());
        }

        /**
         * <p>
         * Details about an unknown target input for a connection.
         * </p>
         * 
         * @param unknownConnectionTargetInput
         *        Details about an unknown target input for a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unknownConnectionTargetInput(UnknownConnectionTargetInputFlowValidationDetails unknownConnectionTargetInput);

        /**
         * <p>
         * Details about an unknown target input for a connection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UnknownConnectionTargetInputFlowValidationDetails.Builder} avoiding the need to create one manually
         * via {@link UnknownConnectionTargetInputFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link UnknownConnectionTargetInputFlowValidationDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #unknownConnectionTargetInput(UnknownConnectionTargetInputFlowValidationDetails)}.
         * 
         * @param unknownConnectionTargetInput
         *        a consumer that will call methods on {@link UnknownConnectionTargetInputFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unknownConnectionTargetInput(UnknownConnectionTargetInputFlowValidationDetails)
         */
        default Builder unknownConnectionTargetInput(
                Consumer<UnknownConnectionTargetInputFlowValidationDetails.Builder> unknownConnectionTargetInput) {
            return unknownConnectionTargetInput(UnknownConnectionTargetInputFlowValidationDetails.builder()
                    .applyMutation(unknownConnectionTargetInput).build());
        }

        /**
         * <p>
         * Details about an unknown condition for a connection.
         * </p>
         * 
         * @param unknownConnectionCondition
         *        Details about an unknown condition for a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unknownConnectionCondition(UnknownConnectionConditionFlowValidationDetails unknownConnectionCondition);

        /**
         * <p>
         * Details about an unknown condition for a connection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UnknownConnectionConditionFlowValidationDetails.Builder} avoiding the need to create one manually via
         * {@link UnknownConnectionConditionFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UnknownConnectionConditionFlowValidationDetails.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #unknownConnectionCondition(UnknownConnectionConditionFlowValidationDetails)}.
         * 
         * @param unknownConnectionCondition
         *        a consumer that will call methods on {@link UnknownConnectionConditionFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unknownConnectionCondition(UnknownConnectionConditionFlowValidationDetails)
         */
        default Builder unknownConnectionCondition(
                Consumer<UnknownConnectionConditionFlowValidationDetails.Builder> unknownConnectionCondition) {
            return unknownConnectionCondition(UnknownConnectionConditionFlowValidationDetails.builder()
                    .applyMutation(unknownConnectionCondition).build());
        }

        /**
         * <p>
         * Details about a malformed condition expression in a node.
         * </p>
         * 
         * @param malformedConditionExpression
         *        Details about a malformed condition expression in a node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder malformedConditionExpression(MalformedConditionExpressionFlowValidationDetails malformedConditionExpression);

        /**
         * <p>
         * Details about a malformed condition expression in a node.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MalformedConditionExpressionFlowValidationDetails.Builder} avoiding the need to create one manually
         * via {@link MalformedConditionExpressionFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link MalformedConditionExpressionFlowValidationDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #malformedConditionExpression(MalformedConditionExpressionFlowValidationDetails)}.
         * 
         * @param malformedConditionExpression
         *        a consumer that will call methods on {@link MalformedConditionExpressionFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #malformedConditionExpression(MalformedConditionExpressionFlowValidationDetails)
         */
        default Builder malformedConditionExpression(
                Consumer<MalformedConditionExpressionFlowValidationDetails.Builder> malformedConditionExpression) {
            return malformedConditionExpression(MalformedConditionExpressionFlowValidationDetails.builder()
                    .applyMutation(malformedConditionExpression).build());
        }

        /**
         * <p>
         * Details about a malformed input expression in a node.
         * </p>
         * 
         * @param malformedNodeInputExpression
         *        Details about a malformed input expression in a node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder malformedNodeInputExpression(MalformedNodeInputExpressionFlowValidationDetails malformedNodeInputExpression);

        /**
         * <p>
         * Details about a malformed input expression in a node.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MalformedNodeInputExpressionFlowValidationDetails.Builder} avoiding the need to create one manually
         * via {@link MalformedNodeInputExpressionFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link MalformedNodeInputExpressionFlowValidationDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #malformedNodeInputExpression(MalformedNodeInputExpressionFlowValidationDetails)}.
         * 
         * @param malformedNodeInputExpression
         *        a consumer that will call methods on {@link MalformedNodeInputExpressionFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #malformedNodeInputExpression(MalformedNodeInputExpressionFlowValidationDetails)
         */
        default Builder malformedNodeInputExpression(
                Consumer<MalformedNodeInputExpressionFlowValidationDetails.Builder> malformedNodeInputExpression) {
            return malformedNodeInputExpression(MalformedNodeInputExpressionFlowValidationDetails.builder()
                    .applyMutation(malformedNodeInputExpression).build());
        }

        /**
         * <p>
         * Details about mismatched input data types in a node.
         * </p>
         * 
         * @param mismatchedNodeInputType
         *        Details about mismatched input data types in a node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mismatchedNodeInputType(MismatchedNodeInputTypeFlowValidationDetails mismatchedNodeInputType);

        /**
         * <p>
         * Details about mismatched input data types in a node.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MismatchedNodeInputTypeFlowValidationDetails.Builder} avoiding the need to create one manually via
         * {@link MismatchedNodeInputTypeFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MismatchedNodeInputTypeFlowValidationDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #mismatchedNodeInputType(MismatchedNodeInputTypeFlowValidationDetails)}.
         * 
         * @param mismatchedNodeInputType
         *        a consumer that will call methods on {@link MismatchedNodeInputTypeFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mismatchedNodeInputType(MismatchedNodeInputTypeFlowValidationDetails)
         */
        default Builder mismatchedNodeInputType(
                Consumer<MismatchedNodeInputTypeFlowValidationDetails.Builder> mismatchedNodeInputType) {
            return mismatchedNodeInputType(MismatchedNodeInputTypeFlowValidationDetails.builder()
                    .applyMutation(mismatchedNodeInputType).build());
        }

        /**
         * <p>
         * Details about mismatched output data types in a node.
         * </p>
         * 
         * @param mismatchedNodeOutputType
         *        Details about mismatched output data types in a node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mismatchedNodeOutputType(MismatchedNodeOutputTypeFlowValidationDetails mismatchedNodeOutputType);

        /**
         * <p>
         * Details about mismatched output data types in a node.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MismatchedNodeOutputTypeFlowValidationDetails.Builder} avoiding the need to create one manually via
         * {@link MismatchedNodeOutputTypeFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MismatchedNodeOutputTypeFlowValidationDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #mismatchedNodeOutputType(MismatchedNodeOutputTypeFlowValidationDetails)}.
         * 
         * @param mismatchedNodeOutputType
         *        a consumer that will call methods on {@link MismatchedNodeOutputTypeFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mismatchedNodeOutputType(MismatchedNodeOutputTypeFlowValidationDetails)
         */
        default Builder mismatchedNodeOutputType(
                Consumer<MismatchedNodeOutputTypeFlowValidationDetails.Builder> mismatchedNodeOutputType) {
            return mismatchedNodeOutputType(MismatchedNodeOutputTypeFlowValidationDetails.builder()
                    .applyMutation(mismatchedNodeOutputType).build());
        }

        /**
         * <p>
         * Details about incompatible data types in a connection.
         * </p>
         * 
         * @param incompatibleConnectionDataType
         *        Details about incompatible data types in a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incompatibleConnectionDataType(IncompatibleConnectionDataTypeFlowValidationDetails incompatibleConnectionDataType);

        /**
         * <p>
         * Details about incompatible data types in a connection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link IncompatibleConnectionDataTypeFlowValidationDetails.Builder} avoiding the need to create one manually
         * via {@link IncompatibleConnectionDataTypeFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link IncompatibleConnectionDataTypeFlowValidationDetails.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #incompatibleConnectionDataType(IncompatibleConnectionDataTypeFlowValidationDetails)}.
         * 
         * @param incompatibleConnectionDataType
         *        a consumer that will call methods on
         *        {@link IncompatibleConnectionDataTypeFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incompatibleConnectionDataType(IncompatibleConnectionDataTypeFlowValidationDetails)
         */
        default Builder incompatibleConnectionDataType(
                Consumer<IncompatibleConnectionDataTypeFlowValidationDetails.Builder> incompatibleConnectionDataType) {
            return incompatibleConnectionDataType(IncompatibleConnectionDataTypeFlowValidationDetails.builder()
                    .applyMutation(incompatibleConnectionDataType).build());
        }

        /**
         * <p>
         * Details about missing configuration for a connection.
         * </p>
         * 
         * @param missingConnectionConfiguration
         *        Details about missing configuration for a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingConnectionConfiguration(MissingConnectionConfigurationFlowValidationDetails missingConnectionConfiguration);

        /**
         * <p>
         * Details about missing configuration for a connection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MissingConnectionConfigurationFlowValidationDetails.Builder} avoiding the need to create one manually
         * via {@link MissingConnectionConfigurationFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link MissingConnectionConfigurationFlowValidationDetails.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #missingConnectionConfiguration(MissingConnectionConfigurationFlowValidationDetails)}.
         * 
         * @param missingConnectionConfiguration
         *        a consumer that will call methods on
         *        {@link MissingConnectionConfigurationFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #missingConnectionConfiguration(MissingConnectionConfigurationFlowValidationDetails)
         */
        default Builder missingConnectionConfiguration(
                Consumer<MissingConnectionConfigurationFlowValidationDetails.Builder> missingConnectionConfiguration) {
            return missingConnectionConfiguration(MissingConnectionConfigurationFlowValidationDetails.builder()
                    .applyMutation(missingConnectionConfiguration).build());
        }

        /**
         * <p>
         * Details about a missing default condition in a conditional node.
         * </p>
         * 
         * @param missingDefaultCondition
         *        Details about a missing default condition in a conditional node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingDefaultCondition(MissingDefaultConditionFlowValidationDetails missingDefaultCondition);

        /**
         * <p>
         * Details about a missing default condition in a conditional node.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MissingDefaultConditionFlowValidationDetails.Builder} avoiding the need to create one manually via
         * {@link MissingDefaultConditionFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MissingDefaultConditionFlowValidationDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #missingDefaultCondition(MissingDefaultConditionFlowValidationDetails)}.
         * 
         * @param missingDefaultCondition
         *        a consumer that will call methods on {@link MissingDefaultConditionFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #missingDefaultCondition(MissingDefaultConditionFlowValidationDetails)
         */
        default Builder missingDefaultCondition(
                Consumer<MissingDefaultConditionFlowValidationDetails.Builder> missingDefaultCondition) {
            return missingDefaultCondition(MissingDefaultConditionFlowValidationDetails.builder()
                    .applyMutation(missingDefaultCondition).build());
        }

        /**
         * <p>
         * Details about missing ending nodes in the flow.
         * </p>
         * 
         * @param missingEndingNodes
         *        Details about missing ending nodes in the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingEndingNodes(MissingEndingNodesFlowValidationDetails missingEndingNodes);

        /**
         * <p>
         * Details about missing ending nodes in the flow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MissingEndingNodesFlowValidationDetails.Builder} avoiding the need to create one manually via
         * {@link MissingEndingNodesFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MissingEndingNodesFlowValidationDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #missingEndingNodes(MissingEndingNodesFlowValidationDetails)}.
         * 
         * @param missingEndingNodes
         *        a consumer that will call methods on {@link MissingEndingNodesFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #missingEndingNodes(MissingEndingNodesFlowValidationDetails)
         */
        default Builder missingEndingNodes(Consumer<MissingEndingNodesFlowValidationDetails.Builder> missingEndingNodes) {
            return missingEndingNodes(MissingEndingNodesFlowValidationDetails.builder().applyMutation(missingEndingNodes).build());
        }

        /**
         * <p>
         * Details about missing configuration for a node.
         * </p>
         * 
         * @param missingNodeConfiguration
         *        Details about missing configuration for a node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingNodeConfiguration(MissingNodeConfigurationFlowValidationDetails missingNodeConfiguration);

        /**
         * <p>
         * Details about missing configuration for a node.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MissingNodeConfigurationFlowValidationDetails.Builder} avoiding the need to create one manually via
         * {@link MissingNodeConfigurationFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MissingNodeConfigurationFlowValidationDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #missingNodeConfiguration(MissingNodeConfigurationFlowValidationDetails)}.
         * 
         * @param missingNodeConfiguration
         *        a consumer that will call methods on {@link MissingNodeConfigurationFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #missingNodeConfiguration(MissingNodeConfigurationFlowValidationDetails)
         */
        default Builder missingNodeConfiguration(
                Consumer<MissingNodeConfigurationFlowValidationDetails.Builder> missingNodeConfiguration) {
            return missingNodeConfiguration(MissingNodeConfigurationFlowValidationDetails.builder()
                    .applyMutation(missingNodeConfiguration).build());
        }

        /**
         * <p>
         * Details about a missing required input in a node.
         * </p>
         * 
         * @param missingNodeInput
         *        Details about a missing required input in a node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingNodeInput(MissingNodeInputFlowValidationDetails missingNodeInput);

        /**
         * <p>
         * Details about a missing required input in a node.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MissingNodeInputFlowValidationDetails.Builder} avoiding the need to create one manually via
         * {@link MissingNodeInputFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MissingNodeInputFlowValidationDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #missingNodeInput(MissingNodeInputFlowValidationDetails)}.
         * 
         * @param missingNodeInput
         *        a consumer that will call methods on {@link MissingNodeInputFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #missingNodeInput(MissingNodeInputFlowValidationDetails)
         */
        default Builder missingNodeInput(Consumer<MissingNodeInputFlowValidationDetails.Builder> missingNodeInput) {
            return missingNodeInput(MissingNodeInputFlowValidationDetails.builder().applyMutation(missingNodeInput).build());
        }

        /**
         * <p>
         * Details about a missing required output in a node.
         * </p>
         * 
         * @param missingNodeOutput
         *        Details about a missing required output in a node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingNodeOutput(MissingNodeOutputFlowValidationDetails missingNodeOutput);

        /**
         * <p>
         * Details about a missing required output in a node.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MissingNodeOutputFlowValidationDetails.Builder} avoiding the need to create one manually via
         * {@link MissingNodeOutputFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MissingNodeOutputFlowValidationDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #missingNodeOutput(MissingNodeOutputFlowValidationDetails)}.
         * 
         * @param missingNodeOutput
         *        a consumer that will call methods on {@link MissingNodeOutputFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #missingNodeOutput(MissingNodeOutputFlowValidationDetails)
         */
        default Builder missingNodeOutput(Consumer<MissingNodeOutputFlowValidationDetails.Builder> missingNodeOutput) {
            return missingNodeOutput(MissingNodeOutputFlowValidationDetails.builder().applyMutation(missingNodeOutput).build());
        }

        /**
         * <p>
         * Details about missing starting nodes in the flow.
         * </p>
         * 
         * @param missingStartingNodes
         *        Details about missing starting nodes in the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingStartingNodes(MissingStartingNodesFlowValidationDetails missingStartingNodes);

        /**
         * <p>
         * Details about missing starting nodes in the flow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MissingStartingNodesFlowValidationDetails.Builder} avoiding the need to create one manually via
         * {@link MissingStartingNodesFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MissingStartingNodesFlowValidationDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #missingStartingNodes(MissingStartingNodesFlowValidationDetails)}.
         * 
         * @param missingStartingNodes
         *        a consumer that will call methods on {@link MissingStartingNodesFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #missingStartingNodes(MissingStartingNodesFlowValidationDetails)
         */
        default Builder missingStartingNodes(Consumer<MissingStartingNodesFlowValidationDetails.Builder> missingStartingNodes) {
            return missingStartingNodes(MissingStartingNodesFlowValidationDetails.builder().applyMutation(missingStartingNodes)
                    .build());
        }

        /**
         * <p>
         * Details about multiple connections to a single node input.
         * </p>
         * 
         * @param multipleNodeInputConnections
         *        Details about multiple connections to a single node input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multipleNodeInputConnections(MultipleNodeInputConnectionsFlowValidationDetails multipleNodeInputConnections);

        /**
         * <p>
         * Details about multiple connections to a single node input.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MultipleNodeInputConnectionsFlowValidationDetails.Builder} avoiding the need to create one manually
         * via {@link MultipleNodeInputConnectionsFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link MultipleNodeInputConnectionsFlowValidationDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #multipleNodeInputConnections(MultipleNodeInputConnectionsFlowValidationDetails)}.
         * 
         * @param multipleNodeInputConnections
         *        a consumer that will call methods on {@link MultipleNodeInputConnectionsFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multipleNodeInputConnections(MultipleNodeInputConnectionsFlowValidationDetails)
         */
        default Builder multipleNodeInputConnections(
                Consumer<MultipleNodeInputConnectionsFlowValidationDetails.Builder> multipleNodeInputConnections) {
            return multipleNodeInputConnections(MultipleNodeInputConnectionsFlowValidationDetails.builder()
                    .applyMutation(multipleNodeInputConnections).build());
        }

        /**
         * <p>
         * Details about an unfulfilled node input with no valid connections.
         * </p>
         * 
         * @param unfulfilledNodeInput
         *        Details about an unfulfilled node input with no valid connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unfulfilledNodeInput(UnfulfilledNodeInputFlowValidationDetails unfulfilledNodeInput);

        /**
         * <p>
         * Details about an unfulfilled node input with no valid connections.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UnfulfilledNodeInputFlowValidationDetails.Builder} avoiding the need to create one manually via
         * {@link UnfulfilledNodeInputFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UnfulfilledNodeInputFlowValidationDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #unfulfilledNodeInput(UnfulfilledNodeInputFlowValidationDetails)}.
         * 
         * @param unfulfilledNodeInput
         *        a consumer that will call methods on {@link UnfulfilledNodeInputFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unfulfilledNodeInput(UnfulfilledNodeInputFlowValidationDetails)
         */
        default Builder unfulfilledNodeInput(Consumer<UnfulfilledNodeInputFlowValidationDetails.Builder> unfulfilledNodeInput) {
            return unfulfilledNodeInput(UnfulfilledNodeInputFlowValidationDetails.builder().applyMutation(unfulfilledNodeInput)
                    .build());
        }

        /**
         * <p>
         * Details about unsatisfied conditions for a connection.
         * </p>
         * 
         * @param unsatisfiedConnectionConditions
         *        Details about unsatisfied conditions for a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsatisfiedConnectionConditions(
                UnsatisfiedConnectionConditionsFlowValidationDetails unsatisfiedConnectionConditions);

        /**
         * <p>
         * Details about unsatisfied conditions for a connection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UnsatisfiedConnectionConditionsFlowValidationDetails.Builder} avoiding the need to create one manually
         * via {@link UnsatisfiedConnectionConditionsFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link UnsatisfiedConnectionConditionsFlowValidationDetails.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #unsatisfiedConnectionConditions(UnsatisfiedConnectionConditionsFlowValidationDetails)}.
         * 
         * @param unsatisfiedConnectionConditions
         *        a consumer that will call methods on
         *        {@link UnsatisfiedConnectionConditionsFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unsatisfiedConnectionConditions(UnsatisfiedConnectionConditionsFlowValidationDetails)
         */
        default Builder unsatisfiedConnectionConditions(
                Consumer<UnsatisfiedConnectionConditionsFlowValidationDetails.Builder> unsatisfiedConnectionConditions) {
            return unsatisfiedConnectionConditions(UnsatisfiedConnectionConditionsFlowValidationDetails.builder()
                    .applyMutation(unsatisfiedConnectionConditions).build());
        }

        /**
         * <p>
         * Details about an unspecified validation.
         * </p>
         * 
         * @param unspecified
         *        Details about an unspecified validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unspecified(UnspecifiedFlowValidationDetails unspecified);

        /**
         * <p>
         * Details about an unspecified validation.
         * </p>
         * This is a convenience method that creates an instance of the {@link UnspecifiedFlowValidationDetails.Builder}
         * avoiding the need to create one manually via {@link UnspecifiedFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UnspecifiedFlowValidationDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #unspecified(UnspecifiedFlowValidationDetails)}.
         * 
         * @param unspecified
         *        a consumer that will call methods on {@link UnspecifiedFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unspecified(UnspecifiedFlowValidationDetails)
         */
        default Builder unspecified(Consumer<UnspecifiedFlowValidationDetails.Builder> unspecified) {
            return unspecified(UnspecifiedFlowValidationDetails.builder().applyMutation(unspecified).build());
        }

        /**
         * <p>
         * Details about an unknown input for a node.
         * </p>
         * 
         * @param unknownNodeInput
         *        Details about an unknown input for a node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unknownNodeInput(UnknownNodeInputFlowValidationDetails unknownNodeInput);

        /**
         * <p>
         * Details about an unknown input for a node.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UnknownNodeInputFlowValidationDetails.Builder} avoiding the need to create one manually via
         * {@link UnknownNodeInputFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UnknownNodeInputFlowValidationDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #unknownNodeInput(UnknownNodeInputFlowValidationDetails)}.
         * 
         * @param unknownNodeInput
         *        a consumer that will call methods on {@link UnknownNodeInputFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unknownNodeInput(UnknownNodeInputFlowValidationDetails)
         */
        default Builder unknownNodeInput(Consumer<UnknownNodeInputFlowValidationDetails.Builder> unknownNodeInput) {
            return unknownNodeInput(UnknownNodeInputFlowValidationDetails.builder().applyMutation(unknownNodeInput).build());
        }

        /**
         * <p>
         * Details about an unknown output for a node.
         * </p>
         * 
         * @param unknownNodeOutput
         *        Details about an unknown output for a node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unknownNodeOutput(UnknownNodeOutputFlowValidationDetails unknownNodeOutput);

        /**
         * <p>
         * Details about an unknown output for a node.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UnknownNodeOutputFlowValidationDetails.Builder} avoiding the need to create one manually via
         * {@link UnknownNodeOutputFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UnknownNodeOutputFlowValidationDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #unknownNodeOutput(UnknownNodeOutputFlowValidationDetails)}.
         * 
         * @param unknownNodeOutput
         *        a consumer that will call methods on {@link UnknownNodeOutputFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unknownNodeOutput(UnknownNodeOutputFlowValidationDetails)
         */
        default Builder unknownNodeOutput(Consumer<UnknownNodeOutputFlowValidationDetails.Builder> unknownNodeOutput) {
            return unknownNodeOutput(UnknownNodeOutputFlowValidationDetails.builder().applyMutation(unknownNodeOutput).build());
        }

        /**
         * <p>
         * Details about a flow that's missing a required <code>LoopInput</code> node in a DoWhile loop.
         * </p>
         * 
         * @param missingLoopInputNode
         *        Details about a flow that's missing a required <code>LoopInput</code> node in a DoWhile loop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingLoopInputNode(MissingLoopInputNodeFlowValidationDetails missingLoopInputNode);

        /**
         * <p>
         * Details about a flow that's missing a required <code>LoopInput</code> node in a DoWhile loop.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MissingLoopInputNodeFlowValidationDetails.Builder} avoiding the need to create one manually via
         * {@link MissingLoopInputNodeFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MissingLoopInputNodeFlowValidationDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #missingLoopInputNode(MissingLoopInputNodeFlowValidationDetails)}.
         * 
         * @param missingLoopInputNode
         *        a consumer that will call methods on {@link MissingLoopInputNodeFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #missingLoopInputNode(MissingLoopInputNodeFlowValidationDetails)
         */
        default Builder missingLoopInputNode(Consumer<MissingLoopInputNodeFlowValidationDetails.Builder> missingLoopInputNode) {
            return missingLoopInputNode(MissingLoopInputNodeFlowValidationDetails.builder().applyMutation(missingLoopInputNode)
                    .build());
        }

        /**
         * <p>
         * Details about a flow that's missing a required <code>LoopController</code> node in a DoWhile loop.
         * </p>
         * 
         * @param missingLoopControllerNode
         *        Details about a flow that's missing a required <code>LoopController</code> node in a DoWhile loop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingLoopControllerNode(MissingLoopControllerNodeFlowValidationDetails missingLoopControllerNode);

        /**
         * <p>
         * Details about a flow that's missing a required <code>LoopController</code> node in a DoWhile loop.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MissingLoopControllerNodeFlowValidationDetails.Builder} avoiding the need to create one manually via
         * {@link MissingLoopControllerNodeFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MissingLoopControllerNodeFlowValidationDetails.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #missingLoopControllerNode(MissingLoopControllerNodeFlowValidationDetails)}.
         * 
         * @param missingLoopControllerNode
         *        a consumer that will call methods on {@link MissingLoopControllerNodeFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #missingLoopControllerNode(MissingLoopControllerNodeFlowValidationDetails)
         */
        default Builder missingLoopControllerNode(
                Consumer<MissingLoopControllerNodeFlowValidationDetails.Builder> missingLoopControllerNode) {
            return missingLoopControllerNode(MissingLoopControllerNodeFlowValidationDetails.builder()
                    .applyMutation(missingLoopControllerNode).build());
        }

        /**
         * <p>
         * Details about a flow that contains multiple <code>LoopInput</code> nodes in a DoWhile loop.
         * </p>
         * 
         * @param multipleLoopInputNodes
         *        Details about a flow that contains multiple <code>LoopInput</code> nodes in a DoWhile loop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multipleLoopInputNodes(MultipleLoopInputNodesFlowValidationDetails multipleLoopInputNodes);

        /**
         * <p>
         * Details about a flow that contains multiple <code>LoopInput</code> nodes in a DoWhile loop.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MultipleLoopInputNodesFlowValidationDetails.Builder} avoiding the need to create one manually via
         * {@link MultipleLoopInputNodesFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MultipleLoopInputNodesFlowValidationDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #multipleLoopInputNodes(MultipleLoopInputNodesFlowValidationDetails)}.
         * 
         * @param multipleLoopInputNodes
         *        a consumer that will call methods on {@link MultipleLoopInputNodesFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multipleLoopInputNodes(MultipleLoopInputNodesFlowValidationDetails)
         */
        default Builder multipleLoopInputNodes(
                Consumer<MultipleLoopInputNodesFlowValidationDetails.Builder> multipleLoopInputNodes) {
            return multipleLoopInputNodes(MultipleLoopInputNodesFlowValidationDetails.builder()
                    .applyMutation(multipleLoopInputNodes).build());
        }

        /**
         * <p>
         * Details about a flow that contains multiple <code>LoopController</code> nodes in a DoWhile loop.
         * </p>
         * 
         * @param multipleLoopControllerNodes
         *        Details about a flow that contains multiple <code>LoopController</code> nodes in a DoWhile loop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multipleLoopControllerNodes(MultipleLoopControllerNodesFlowValidationDetails multipleLoopControllerNodes);

        /**
         * <p>
         * Details about a flow that contains multiple <code>LoopController</code> nodes in a DoWhile loop.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MultipleLoopControllerNodesFlowValidationDetails.Builder} avoiding the need to create one manually via
         * {@link MultipleLoopControllerNodesFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MultipleLoopControllerNodesFlowValidationDetails.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #multipleLoopControllerNodes(MultipleLoopControllerNodesFlowValidationDetails)}.
         * 
         * @param multipleLoopControllerNodes
         *        a consumer that will call methods on {@link MultipleLoopControllerNodesFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multipleLoopControllerNodes(MultipleLoopControllerNodesFlowValidationDetails)
         */
        default Builder multipleLoopControllerNodes(
                Consumer<MultipleLoopControllerNodesFlowValidationDetails.Builder> multipleLoopControllerNodes) {
            return multipleLoopControllerNodes(MultipleLoopControllerNodesFlowValidationDetails.builder()
                    .applyMutation(multipleLoopControllerNodes).build());
        }

        /**
         * <p>
         * Details about a flow that includes incompatible node types in a DoWhile loop.
         * </p>
         * 
         * @param loopIncompatibleNodeType
         *        Details about a flow that includes incompatible node types in a DoWhile loop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loopIncompatibleNodeType(LoopIncompatibleNodeTypeFlowValidationDetails loopIncompatibleNodeType);

        /**
         * <p>
         * Details about a flow that includes incompatible node types in a DoWhile loop.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link LoopIncompatibleNodeTypeFlowValidationDetails.Builder} avoiding the need to create one manually via
         * {@link LoopIncompatibleNodeTypeFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoopIncompatibleNodeTypeFlowValidationDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #loopIncompatibleNodeType(LoopIncompatibleNodeTypeFlowValidationDetails)}.
         * 
         * @param loopIncompatibleNodeType
         *        a consumer that will call methods on {@link LoopIncompatibleNodeTypeFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loopIncompatibleNodeType(LoopIncompatibleNodeTypeFlowValidationDetails)
         */
        default Builder loopIncompatibleNodeType(
                Consumer<LoopIncompatibleNodeTypeFlowValidationDetails.Builder> loopIncompatibleNodeType) {
            return loopIncompatibleNodeType(LoopIncompatibleNodeTypeFlowValidationDetails.builder()
                    .applyMutation(loopIncompatibleNodeType).build());
        }

        /**
         * <p>
         * Details about a flow that includes connections that violate loop boundary rules.
         * </p>
         * 
         * @param invalidLoopBoundary
         *        Details about a flow that includes connections that violate loop boundary rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidLoopBoundary(InvalidLoopBoundaryFlowValidationDetails invalidLoopBoundary);

        /**
         * <p>
         * Details about a flow that includes connections that violate loop boundary rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InvalidLoopBoundaryFlowValidationDetails.Builder} avoiding the need to create one manually via
         * {@link InvalidLoopBoundaryFlowValidationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InvalidLoopBoundaryFlowValidationDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #invalidLoopBoundary(InvalidLoopBoundaryFlowValidationDetails)}.
         * 
         * @param invalidLoopBoundary
         *        a consumer that will call methods on {@link InvalidLoopBoundaryFlowValidationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invalidLoopBoundary(InvalidLoopBoundaryFlowValidationDetails)
         */
        default Builder invalidLoopBoundary(Consumer<InvalidLoopBoundaryFlowValidationDetails.Builder> invalidLoopBoundary) {
            return invalidLoopBoundary(InvalidLoopBoundaryFlowValidationDetails.builder().applyMutation(invalidLoopBoundary)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CyclicConnectionFlowValidationDetails cyclicConnection;

        private DuplicateConnectionsFlowValidationDetails duplicateConnections;

        private DuplicateConditionExpressionFlowValidationDetails duplicateConditionExpression;

        private UnreachableNodeFlowValidationDetails unreachableNode;

        private UnknownConnectionSourceFlowValidationDetails unknownConnectionSource;

        private UnknownConnectionSourceOutputFlowValidationDetails unknownConnectionSourceOutput;

        private UnknownConnectionTargetFlowValidationDetails unknownConnectionTarget;

        private UnknownConnectionTargetInputFlowValidationDetails unknownConnectionTargetInput;

        private UnknownConnectionConditionFlowValidationDetails unknownConnectionCondition;

        private MalformedConditionExpressionFlowValidationDetails malformedConditionExpression;

        private MalformedNodeInputExpressionFlowValidationDetails malformedNodeInputExpression;

        private MismatchedNodeInputTypeFlowValidationDetails mismatchedNodeInputType;

        private MismatchedNodeOutputTypeFlowValidationDetails mismatchedNodeOutputType;

        private IncompatibleConnectionDataTypeFlowValidationDetails incompatibleConnectionDataType;

        private MissingConnectionConfigurationFlowValidationDetails missingConnectionConfiguration;

        private MissingDefaultConditionFlowValidationDetails missingDefaultCondition;

        private MissingEndingNodesFlowValidationDetails missingEndingNodes;

        private MissingNodeConfigurationFlowValidationDetails missingNodeConfiguration;

        private MissingNodeInputFlowValidationDetails missingNodeInput;

        private MissingNodeOutputFlowValidationDetails missingNodeOutput;

        private MissingStartingNodesFlowValidationDetails missingStartingNodes;

        private MultipleNodeInputConnectionsFlowValidationDetails multipleNodeInputConnections;

        private UnfulfilledNodeInputFlowValidationDetails unfulfilledNodeInput;

        private UnsatisfiedConnectionConditionsFlowValidationDetails unsatisfiedConnectionConditions;

        private UnspecifiedFlowValidationDetails unspecified;

        private UnknownNodeInputFlowValidationDetails unknownNodeInput;

        private UnknownNodeOutputFlowValidationDetails unknownNodeOutput;

        private MissingLoopInputNodeFlowValidationDetails missingLoopInputNode;

        private MissingLoopControllerNodeFlowValidationDetails missingLoopControllerNode;

        private MultipleLoopInputNodesFlowValidationDetails multipleLoopInputNodes;

        private MultipleLoopControllerNodesFlowValidationDetails multipleLoopControllerNodes;

        private LoopIncompatibleNodeTypeFlowValidationDetails loopIncompatibleNodeType;

        private InvalidLoopBoundaryFlowValidationDetails invalidLoopBoundary;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FlowValidationDetails model) {
            cyclicConnection(model.cyclicConnection);
            duplicateConnections(model.duplicateConnections);
            duplicateConditionExpression(model.duplicateConditionExpression);
            unreachableNode(model.unreachableNode);
            unknownConnectionSource(model.unknownConnectionSource);
            unknownConnectionSourceOutput(model.unknownConnectionSourceOutput);
            unknownConnectionTarget(model.unknownConnectionTarget);
            unknownConnectionTargetInput(model.unknownConnectionTargetInput);
            unknownConnectionCondition(model.unknownConnectionCondition);
            malformedConditionExpression(model.malformedConditionExpression);
            malformedNodeInputExpression(model.malformedNodeInputExpression);
            mismatchedNodeInputType(model.mismatchedNodeInputType);
            mismatchedNodeOutputType(model.mismatchedNodeOutputType);
            incompatibleConnectionDataType(model.incompatibleConnectionDataType);
            missingConnectionConfiguration(model.missingConnectionConfiguration);
            missingDefaultCondition(model.missingDefaultCondition);
            missingEndingNodes(model.missingEndingNodes);
            missingNodeConfiguration(model.missingNodeConfiguration);
            missingNodeInput(model.missingNodeInput);
            missingNodeOutput(model.missingNodeOutput);
            missingStartingNodes(model.missingStartingNodes);
            multipleNodeInputConnections(model.multipleNodeInputConnections);
            unfulfilledNodeInput(model.unfulfilledNodeInput);
            unsatisfiedConnectionConditions(model.unsatisfiedConnectionConditions);
            unspecified(model.unspecified);
            unknownNodeInput(model.unknownNodeInput);
            unknownNodeOutput(model.unknownNodeOutput);
            missingLoopInputNode(model.missingLoopInputNode);
            missingLoopControllerNode(model.missingLoopControllerNode);
            multipleLoopInputNodes(model.multipleLoopInputNodes);
            multipleLoopControllerNodes(model.multipleLoopControllerNodes);
            loopIncompatibleNodeType(model.loopIncompatibleNodeType);
            invalidLoopBoundary(model.invalidLoopBoundary);
        }

        public final CyclicConnectionFlowValidationDetails.Builder getCyclicConnection() {
            return cyclicConnection != null ? cyclicConnection.toBuilder() : null;
        }

        public final void setCyclicConnection(CyclicConnectionFlowValidationDetails.BuilderImpl cyclicConnection) {
            Object oldValue = this.cyclicConnection;
            this.cyclicConnection = cyclicConnection != null ? cyclicConnection.build() : null;
            handleUnionValueChange(Type.CYCLIC_CONNECTION, oldValue, this.cyclicConnection);
        }

        @Override
        public final Builder cyclicConnection(CyclicConnectionFlowValidationDetails cyclicConnection) {
            Object oldValue = this.cyclicConnection;
            this.cyclicConnection = cyclicConnection;
            handleUnionValueChange(Type.CYCLIC_CONNECTION, oldValue, this.cyclicConnection);
            return this;
        }

        public final DuplicateConnectionsFlowValidationDetails.Builder getDuplicateConnections() {
            return duplicateConnections != null ? duplicateConnections.toBuilder() : null;
        }

        public final void setDuplicateConnections(DuplicateConnectionsFlowValidationDetails.BuilderImpl duplicateConnections) {
            Object oldValue = this.duplicateConnections;
            this.duplicateConnections = duplicateConnections != null ? duplicateConnections.build() : null;
            handleUnionValueChange(Type.DUPLICATE_CONNECTIONS, oldValue, this.duplicateConnections);
        }

        @Override
        public final Builder duplicateConnections(DuplicateConnectionsFlowValidationDetails duplicateConnections) {
            Object oldValue = this.duplicateConnections;
            this.duplicateConnections = duplicateConnections;
            handleUnionValueChange(Type.DUPLICATE_CONNECTIONS, oldValue, this.duplicateConnections);
            return this;
        }

        public final DuplicateConditionExpressionFlowValidationDetails.Builder getDuplicateConditionExpression() {
            return duplicateConditionExpression != null ? duplicateConditionExpression.toBuilder() : null;
        }

        public final void setDuplicateConditionExpression(
                DuplicateConditionExpressionFlowValidationDetails.BuilderImpl duplicateConditionExpression) {
            Object oldValue = this.duplicateConditionExpression;
            this.duplicateConditionExpression = duplicateConditionExpression != null ? duplicateConditionExpression.build()
                    : null;
            handleUnionValueChange(Type.DUPLICATE_CONDITION_EXPRESSION, oldValue, this.duplicateConditionExpression);
        }

        @Override
        public final Builder duplicateConditionExpression(
                DuplicateConditionExpressionFlowValidationDetails duplicateConditionExpression) {
            Object oldValue = this.duplicateConditionExpression;
            this.duplicateConditionExpression = duplicateConditionExpression;
            handleUnionValueChange(Type.DUPLICATE_CONDITION_EXPRESSION, oldValue, this.duplicateConditionExpression);
            return this;
        }

        public final UnreachableNodeFlowValidationDetails.Builder getUnreachableNode() {
            return unreachableNode != null ? unreachableNode.toBuilder() : null;
        }

        public final void setUnreachableNode(UnreachableNodeFlowValidationDetails.BuilderImpl unreachableNode) {
            Object oldValue = this.unreachableNode;
            this.unreachableNode = unreachableNode != null ? unreachableNode.build() : null;
            handleUnionValueChange(Type.UNREACHABLE_NODE, oldValue, this.unreachableNode);
        }

        @Override
        public final Builder unreachableNode(UnreachableNodeFlowValidationDetails unreachableNode) {
            Object oldValue = this.unreachableNode;
            this.unreachableNode = unreachableNode;
            handleUnionValueChange(Type.UNREACHABLE_NODE, oldValue, this.unreachableNode);
            return this;
        }

        public final UnknownConnectionSourceFlowValidationDetails.Builder getUnknownConnectionSource() {
            return unknownConnectionSource != null ? unknownConnectionSource.toBuilder() : null;
        }

        public final void setUnknownConnectionSource(
                UnknownConnectionSourceFlowValidationDetails.BuilderImpl unknownConnectionSource) {
            Object oldValue = this.unknownConnectionSource;
            this.unknownConnectionSource = unknownConnectionSource != null ? unknownConnectionSource.build() : null;
            handleUnionValueChange(Type.UNKNOWN_CONNECTION_SOURCE, oldValue, this.unknownConnectionSource);
        }

        @Override
        public final Builder unknownConnectionSource(UnknownConnectionSourceFlowValidationDetails unknownConnectionSource) {
            Object oldValue = this.unknownConnectionSource;
            this.unknownConnectionSource = unknownConnectionSource;
            handleUnionValueChange(Type.UNKNOWN_CONNECTION_SOURCE, oldValue, this.unknownConnectionSource);
            return this;
        }

        public final UnknownConnectionSourceOutputFlowValidationDetails.Builder getUnknownConnectionSourceOutput() {
            return unknownConnectionSourceOutput != null ? unknownConnectionSourceOutput.toBuilder() : null;
        }

        public final void setUnknownConnectionSourceOutput(
                UnknownConnectionSourceOutputFlowValidationDetails.BuilderImpl unknownConnectionSourceOutput) {
            Object oldValue = this.unknownConnectionSourceOutput;
            this.unknownConnectionSourceOutput = unknownConnectionSourceOutput != null ? unknownConnectionSourceOutput.build()
                    : null;
            handleUnionValueChange(Type.UNKNOWN_CONNECTION_SOURCE_OUTPUT, oldValue, this.unknownConnectionSourceOutput);
        }

        @Override
        public final Builder unknownConnectionSourceOutput(
                UnknownConnectionSourceOutputFlowValidationDetails unknownConnectionSourceOutput) {
            Object oldValue = this.unknownConnectionSourceOutput;
            this.unknownConnectionSourceOutput = unknownConnectionSourceOutput;
            handleUnionValueChange(Type.UNKNOWN_CONNECTION_SOURCE_OUTPUT, oldValue, this.unknownConnectionSourceOutput);
            return this;
        }

        public final UnknownConnectionTargetFlowValidationDetails.Builder getUnknownConnectionTarget() {
            return unknownConnectionTarget != null ? unknownConnectionTarget.toBuilder() : null;
        }

        public final void setUnknownConnectionTarget(
                UnknownConnectionTargetFlowValidationDetails.BuilderImpl unknownConnectionTarget) {
            Object oldValue = this.unknownConnectionTarget;
            this.unknownConnectionTarget = unknownConnectionTarget != null ? unknownConnectionTarget.build() : null;
            handleUnionValueChange(Type.UNKNOWN_CONNECTION_TARGET, oldValue, this.unknownConnectionTarget);
        }

        @Override
        public final Builder unknownConnectionTarget(UnknownConnectionTargetFlowValidationDetails unknownConnectionTarget) {
            Object oldValue = this.unknownConnectionTarget;
            this.unknownConnectionTarget = unknownConnectionTarget;
            handleUnionValueChange(Type.UNKNOWN_CONNECTION_TARGET, oldValue, this.unknownConnectionTarget);
            return this;
        }

        public final UnknownConnectionTargetInputFlowValidationDetails.Builder getUnknownConnectionTargetInput() {
            return unknownConnectionTargetInput != null ? unknownConnectionTargetInput.toBuilder() : null;
        }

        public final void setUnknownConnectionTargetInput(
                UnknownConnectionTargetInputFlowValidationDetails.BuilderImpl unknownConnectionTargetInput) {
            Object oldValue = this.unknownConnectionTargetInput;
            this.unknownConnectionTargetInput = unknownConnectionTargetInput != null ? unknownConnectionTargetInput.build()
                    : null;
            handleUnionValueChange(Type.UNKNOWN_CONNECTION_TARGET_INPUT, oldValue, this.unknownConnectionTargetInput);
        }

        @Override
        public final Builder unknownConnectionTargetInput(
                UnknownConnectionTargetInputFlowValidationDetails unknownConnectionTargetInput) {
            Object oldValue = this.unknownConnectionTargetInput;
            this.unknownConnectionTargetInput = unknownConnectionTargetInput;
            handleUnionValueChange(Type.UNKNOWN_CONNECTION_TARGET_INPUT, oldValue, this.unknownConnectionTargetInput);
            return this;
        }

        public final UnknownConnectionConditionFlowValidationDetails.Builder getUnknownConnectionCondition() {
            return unknownConnectionCondition != null ? unknownConnectionCondition.toBuilder() : null;
        }

        public final void setUnknownConnectionCondition(
                UnknownConnectionConditionFlowValidationDetails.BuilderImpl unknownConnectionCondition) {
            Object oldValue = this.unknownConnectionCondition;
            this.unknownConnectionCondition = unknownConnectionCondition != null ? unknownConnectionCondition.build() : null;
            handleUnionValueChange(Type.UNKNOWN_CONNECTION_CONDITION, oldValue, this.unknownConnectionCondition);
        }

        @Override
        public final Builder unknownConnectionCondition(UnknownConnectionConditionFlowValidationDetails unknownConnectionCondition) {
            Object oldValue = this.unknownConnectionCondition;
            this.unknownConnectionCondition = unknownConnectionCondition;
            handleUnionValueChange(Type.UNKNOWN_CONNECTION_CONDITION, oldValue, this.unknownConnectionCondition);
            return this;
        }

        public final MalformedConditionExpressionFlowValidationDetails.Builder getMalformedConditionExpression() {
            return malformedConditionExpression != null ? malformedConditionExpression.toBuilder() : null;
        }

        public final void setMalformedConditionExpression(
                MalformedConditionExpressionFlowValidationDetails.BuilderImpl malformedConditionExpression) {
            Object oldValue = this.malformedConditionExpression;
            this.malformedConditionExpression = malformedConditionExpression != null ? malformedConditionExpression.build()
                    : null;
            handleUnionValueChange(Type.MALFORMED_CONDITION_EXPRESSION, oldValue, this.malformedConditionExpression);
        }

        @Override
        public final Builder malformedConditionExpression(
                MalformedConditionExpressionFlowValidationDetails malformedConditionExpression) {
            Object oldValue = this.malformedConditionExpression;
            this.malformedConditionExpression = malformedConditionExpression;
            handleUnionValueChange(Type.MALFORMED_CONDITION_EXPRESSION, oldValue, this.malformedConditionExpression);
            return this;
        }

        public final MalformedNodeInputExpressionFlowValidationDetails.Builder getMalformedNodeInputExpression() {
            return malformedNodeInputExpression != null ? malformedNodeInputExpression.toBuilder() : null;
        }

        public final void setMalformedNodeInputExpression(
                MalformedNodeInputExpressionFlowValidationDetails.BuilderImpl malformedNodeInputExpression) {
            Object oldValue = this.malformedNodeInputExpression;
            this.malformedNodeInputExpression = malformedNodeInputExpression != null ? malformedNodeInputExpression.build()
                    : null;
            handleUnionValueChange(Type.MALFORMED_NODE_INPUT_EXPRESSION, oldValue, this.malformedNodeInputExpression);
        }

        @Override
        public final Builder malformedNodeInputExpression(
                MalformedNodeInputExpressionFlowValidationDetails malformedNodeInputExpression) {
            Object oldValue = this.malformedNodeInputExpression;
            this.malformedNodeInputExpression = malformedNodeInputExpression;
            handleUnionValueChange(Type.MALFORMED_NODE_INPUT_EXPRESSION, oldValue, this.malformedNodeInputExpression);
            return this;
        }

        public final MismatchedNodeInputTypeFlowValidationDetails.Builder getMismatchedNodeInputType() {
            return mismatchedNodeInputType != null ? mismatchedNodeInputType.toBuilder() : null;
        }

        public final void setMismatchedNodeInputType(
                MismatchedNodeInputTypeFlowValidationDetails.BuilderImpl mismatchedNodeInputType) {
            Object oldValue = this.mismatchedNodeInputType;
            this.mismatchedNodeInputType = mismatchedNodeInputType != null ? mismatchedNodeInputType.build() : null;
            handleUnionValueChange(Type.MISMATCHED_NODE_INPUT_TYPE, oldValue, this.mismatchedNodeInputType);
        }

        @Override
        public final Builder mismatchedNodeInputType(MismatchedNodeInputTypeFlowValidationDetails mismatchedNodeInputType) {
            Object oldValue = this.mismatchedNodeInputType;
            this.mismatchedNodeInputType = mismatchedNodeInputType;
            handleUnionValueChange(Type.MISMATCHED_NODE_INPUT_TYPE, oldValue, this.mismatchedNodeInputType);
            return this;
        }

        public final MismatchedNodeOutputTypeFlowValidationDetails.Builder getMismatchedNodeOutputType() {
            return mismatchedNodeOutputType != null ? mismatchedNodeOutputType.toBuilder() : null;
        }

        public final void setMismatchedNodeOutputType(
                MismatchedNodeOutputTypeFlowValidationDetails.BuilderImpl mismatchedNodeOutputType) {
            Object oldValue = this.mismatchedNodeOutputType;
            this.mismatchedNodeOutputType = mismatchedNodeOutputType != null ? mismatchedNodeOutputType.build() : null;
            handleUnionValueChange(Type.MISMATCHED_NODE_OUTPUT_TYPE, oldValue, this.mismatchedNodeOutputType);
        }

        @Override
        public final Builder mismatchedNodeOutputType(MismatchedNodeOutputTypeFlowValidationDetails mismatchedNodeOutputType) {
            Object oldValue = this.mismatchedNodeOutputType;
            this.mismatchedNodeOutputType = mismatchedNodeOutputType;
            handleUnionValueChange(Type.MISMATCHED_NODE_OUTPUT_TYPE, oldValue, this.mismatchedNodeOutputType);
            return this;
        }

        public final IncompatibleConnectionDataTypeFlowValidationDetails.Builder getIncompatibleConnectionDataType() {
            return incompatibleConnectionDataType != null ? incompatibleConnectionDataType.toBuilder() : null;
        }

        public final void setIncompatibleConnectionDataType(
                IncompatibleConnectionDataTypeFlowValidationDetails.BuilderImpl incompatibleConnectionDataType) {
            Object oldValue = this.incompatibleConnectionDataType;
            this.incompatibleConnectionDataType = incompatibleConnectionDataType != null ? incompatibleConnectionDataType.build()
                    : null;
            handleUnionValueChange(Type.INCOMPATIBLE_CONNECTION_DATA_TYPE, oldValue, this.incompatibleConnectionDataType);
        }

        @Override
        public final Builder incompatibleConnectionDataType(
                IncompatibleConnectionDataTypeFlowValidationDetails incompatibleConnectionDataType) {
            Object oldValue = this.incompatibleConnectionDataType;
            this.incompatibleConnectionDataType = incompatibleConnectionDataType;
            handleUnionValueChange(Type.INCOMPATIBLE_CONNECTION_DATA_TYPE, oldValue, this.incompatibleConnectionDataType);
            return this;
        }

        public final MissingConnectionConfigurationFlowValidationDetails.Builder getMissingConnectionConfiguration() {
            return missingConnectionConfiguration != null ? missingConnectionConfiguration.toBuilder() : null;
        }

        public final void setMissingConnectionConfiguration(
                MissingConnectionConfigurationFlowValidationDetails.BuilderImpl missingConnectionConfiguration) {
            Object oldValue = this.missingConnectionConfiguration;
            this.missingConnectionConfiguration = missingConnectionConfiguration != null ? missingConnectionConfiguration.build()
                    : null;
            handleUnionValueChange(Type.MISSING_CONNECTION_CONFIGURATION, oldValue, this.missingConnectionConfiguration);
        }

        @Override
        public final Builder missingConnectionConfiguration(
                MissingConnectionConfigurationFlowValidationDetails missingConnectionConfiguration) {
            Object oldValue = this.missingConnectionConfiguration;
            this.missingConnectionConfiguration = missingConnectionConfiguration;
            handleUnionValueChange(Type.MISSING_CONNECTION_CONFIGURATION, oldValue, this.missingConnectionConfiguration);
            return this;
        }

        public final MissingDefaultConditionFlowValidationDetails.Builder getMissingDefaultCondition() {
            return missingDefaultCondition != null ? missingDefaultCondition.toBuilder() : null;
        }

        public final void setMissingDefaultCondition(
                MissingDefaultConditionFlowValidationDetails.BuilderImpl missingDefaultCondition) {
            Object oldValue = this.missingDefaultCondition;
            this.missingDefaultCondition = missingDefaultCondition != null ? missingDefaultCondition.build() : null;
            handleUnionValueChange(Type.MISSING_DEFAULT_CONDITION, oldValue, this.missingDefaultCondition);
        }

        @Override
        public final Builder missingDefaultCondition(MissingDefaultConditionFlowValidationDetails missingDefaultCondition) {
            Object oldValue = this.missingDefaultCondition;
            this.missingDefaultCondition = missingDefaultCondition;
            handleUnionValueChange(Type.MISSING_DEFAULT_CONDITION, oldValue, this.missingDefaultCondition);
            return this;
        }

        public final MissingEndingNodesFlowValidationDetails.Builder getMissingEndingNodes() {
            return missingEndingNodes != null ? missingEndingNodes.toBuilder() : null;
        }

        public final void setMissingEndingNodes(MissingEndingNodesFlowValidationDetails.BuilderImpl missingEndingNodes) {
            Object oldValue = this.missingEndingNodes;
            this.missingEndingNodes = missingEndingNodes != null ? missingEndingNodes.build() : null;
            handleUnionValueChange(Type.MISSING_ENDING_NODES, oldValue, this.missingEndingNodes);
        }

        @Override
        public final Builder missingEndingNodes(MissingEndingNodesFlowValidationDetails missingEndingNodes) {
            Object oldValue = this.missingEndingNodes;
            this.missingEndingNodes = missingEndingNodes;
            handleUnionValueChange(Type.MISSING_ENDING_NODES, oldValue, this.missingEndingNodes);
            return this;
        }

        public final MissingNodeConfigurationFlowValidationDetails.Builder getMissingNodeConfiguration() {
            return missingNodeConfiguration != null ? missingNodeConfiguration.toBuilder() : null;
        }

        public final void setMissingNodeConfiguration(
                MissingNodeConfigurationFlowValidationDetails.BuilderImpl missingNodeConfiguration) {
            Object oldValue = this.missingNodeConfiguration;
            this.missingNodeConfiguration = missingNodeConfiguration != null ? missingNodeConfiguration.build() : null;
            handleUnionValueChange(Type.MISSING_NODE_CONFIGURATION, oldValue, this.missingNodeConfiguration);
        }

        @Override
        public final Builder missingNodeConfiguration(MissingNodeConfigurationFlowValidationDetails missingNodeConfiguration) {
            Object oldValue = this.missingNodeConfiguration;
            this.missingNodeConfiguration = missingNodeConfiguration;
            handleUnionValueChange(Type.MISSING_NODE_CONFIGURATION, oldValue, this.missingNodeConfiguration);
            return this;
        }

        public final MissingNodeInputFlowValidationDetails.Builder getMissingNodeInput() {
            return missingNodeInput != null ? missingNodeInput.toBuilder() : null;
        }

        public final void setMissingNodeInput(MissingNodeInputFlowValidationDetails.BuilderImpl missingNodeInput) {
            Object oldValue = this.missingNodeInput;
            this.missingNodeInput = missingNodeInput != null ? missingNodeInput.build() : null;
            handleUnionValueChange(Type.MISSING_NODE_INPUT, oldValue, this.missingNodeInput);
        }

        @Override
        public final Builder missingNodeInput(MissingNodeInputFlowValidationDetails missingNodeInput) {
            Object oldValue = this.missingNodeInput;
            this.missingNodeInput = missingNodeInput;
            handleUnionValueChange(Type.MISSING_NODE_INPUT, oldValue, this.missingNodeInput);
            return this;
        }

        public final MissingNodeOutputFlowValidationDetails.Builder getMissingNodeOutput() {
            return missingNodeOutput != null ? missingNodeOutput.toBuilder() : null;
        }

        public final void setMissingNodeOutput(MissingNodeOutputFlowValidationDetails.BuilderImpl missingNodeOutput) {
            Object oldValue = this.missingNodeOutput;
            this.missingNodeOutput = missingNodeOutput != null ? missingNodeOutput.build() : null;
            handleUnionValueChange(Type.MISSING_NODE_OUTPUT, oldValue, this.missingNodeOutput);
        }

        @Override
        public final Builder missingNodeOutput(MissingNodeOutputFlowValidationDetails missingNodeOutput) {
            Object oldValue = this.missingNodeOutput;
            this.missingNodeOutput = missingNodeOutput;
            handleUnionValueChange(Type.MISSING_NODE_OUTPUT, oldValue, this.missingNodeOutput);
            return this;
        }

        public final MissingStartingNodesFlowValidationDetails.Builder getMissingStartingNodes() {
            return missingStartingNodes != null ? missingStartingNodes.toBuilder() : null;
        }

        public final void setMissingStartingNodes(MissingStartingNodesFlowValidationDetails.BuilderImpl missingStartingNodes) {
            Object oldValue = this.missingStartingNodes;
            this.missingStartingNodes = missingStartingNodes != null ? missingStartingNodes.build() : null;
            handleUnionValueChange(Type.MISSING_STARTING_NODES, oldValue, this.missingStartingNodes);
        }

        @Override
        public final Builder missingStartingNodes(MissingStartingNodesFlowValidationDetails missingStartingNodes) {
            Object oldValue = this.missingStartingNodes;
            this.missingStartingNodes = missingStartingNodes;
            handleUnionValueChange(Type.MISSING_STARTING_NODES, oldValue, this.missingStartingNodes);
            return this;
        }

        public final MultipleNodeInputConnectionsFlowValidationDetails.Builder getMultipleNodeInputConnections() {
            return multipleNodeInputConnections != null ? multipleNodeInputConnections.toBuilder() : null;
        }

        public final void setMultipleNodeInputConnections(
                MultipleNodeInputConnectionsFlowValidationDetails.BuilderImpl multipleNodeInputConnections) {
            Object oldValue = this.multipleNodeInputConnections;
            this.multipleNodeInputConnections = multipleNodeInputConnections != null ? multipleNodeInputConnections.build()
                    : null;
            handleUnionValueChange(Type.MULTIPLE_NODE_INPUT_CONNECTIONS, oldValue, this.multipleNodeInputConnections);
        }

        @Override
        public final Builder multipleNodeInputConnections(
                MultipleNodeInputConnectionsFlowValidationDetails multipleNodeInputConnections) {
            Object oldValue = this.multipleNodeInputConnections;
            this.multipleNodeInputConnections = multipleNodeInputConnections;
            handleUnionValueChange(Type.MULTIPLE_NODE_INPUT_CONNECTIONS, oldValue, this.multipleNodeInputConnections);
            return this;
        }

        public final UnfulfilledNodeInputFlowValidationDetails.Builder getUnfulfilledNodeInput() {
            return unfulfilledNodeInput != null ? unfulfilledNodeInput.toBuilder() : null;
        }

        public final void setUnfulfilledNodeInput(UnfulfilledNodeInputFlowValidationDetails.BuilderImpl unfulfilledNodeInput) {
            Object oldValue = this.unfulfilledNodeInput;
            this.unfulfilledNodeInput = unfulfilledNodeInput != null ? unfulfilledNodeInput.build() : null;
            handleUnionValueChange(Type.UNFULFILLED_NODE_INPUT, oldValue, this.unfulfilledNodeInput);
        }

        @Override
        public final Builder unfulfilledNodeInput(UnfulfilledNodeInputFlowValidationDetails unfulfilledNodeInput) {
            Object oldValue = this.unfulfilledNodeInput;
            this.unfulfilledNodeInput = unfulfilledNodeInput;
            handleUnionValueChange(Type.UNFULFILLED_NODE_INPUT, oldValue, this.unfulfilledNodeInput);
            return this;
        }

        public final UnsatisfiedConnectionConditionsFlowValidationDetails.Builder getUnsatisfiedConnectionConditions() {
            return unsatisfiedConnectionConditions != null ? unsatisfiedConnectionConditions.toBuilder() : null;
        }

        public final void setUnsatisfiedConnectionConditions(
                UnsatisfiedConnectionConditionsFlowValidationDetails.BuilderImpl unsatisfiedConnectionConditions) {
            Object oldValue = this.unsatisfiedConnectionConditions;
            this.unsatisfiedConnectionConditions = unsatisfiedConnectionConditions != null ? unsatisfiedConnectionConditions
                    .build() : null;
            handleUnionValueChange(Type.UNSATISFIED_CONNECTION_CONDITIONS, oldValue, this.unsatisfiedConnectionConditions);
        }

        @Override
        public final Builder unsatisfiedConnectionConditions(
                UnsatisfiedConnectionConditionsFlowValidationDetails unsatisfiedConnectionConditions) {
            Object oldValue = this.unsatisfiedConnectionConditions;
            this.unsatisfiedConnectionConditions = unsatisfiedConnectionConditions;
            handleUnionValueChange(Type.UNSATISFIED_CONNECTION_CONDITIONS, oldValue, this.unsatisfiedConnectionConditions);
            return this;
        }

        public final UnspecifiedFlowValidationDetails.Builder getUnspecified() {
            return unspecified != null ? unspecified.toBuilder() : null;
        }

        public final void setUnspecified(UnspecifiedFlowValidationDetails.BuilderImpl unspecified) {
            Object oldValue = this.unspecified;
            this.unspecified = unspecified != null ? unspecified.build() : null;
            handleUnionValueChange(Type.UNSPECIFIED, oldValue, this.unspecified);
        }

        @Override
        public final Builder unspecified(UnspecifiedFlowValidationDetails unspecified) {
            Object oldValue = this.unspecified;
            this.unspecified = unspecified;
            handleUnionValueChange(Type.UNSPECIFIED, oldValue, this.unspecified);
            return this;
        }

        public final UnknownNodeInputFlowValidationDetails.Builder getUnknownNodeInput() {
            return unknownNodeInput != null ? unknownNodeInput.toBuilder() : null;
        }

        public final void setUnknownNodeInput(UnknownNodeInputFlowValidationDetails.BuilderImpl unknownNodeInput) {
            Object oldValue = this.unknownNodeInput;
            this.unknownNodeInput = unknownNodeInput != null ? unknownNodeInput.build() : null;
            handleUnionValueChange(Type.UNKNOWN_NODE_INPUT, oldValue, this.unknownNodeInput);
        }

        @Override
        public final Builder unknownNodeInput(UnknownNodeInputFlowValidationDetails unknownNodeInput) {
            Object oldValue = this.unknownNodeInput;
            this.unknownNodeInput = unknownNodeInput;
            handleUnionValueChange(Type.UNKNOWN_NODE_INPUT, oldValue, this.unknownNodeInput);
            return this;
        }

        public final UnknownNodeOutputFlowValidationDetails.Builder getUnknownNodeOutput() {
            return unknownNodeOutput != null ? unknownNodeOutput.toBuilder() : null;
        }

        public final void setUnknownNodeOutput(UnknownNodeOutputFlowValidationDetails.BuilderImpl unknownNodeOutput) {
            Object oldValue = this.unknownNodeOutput;
            this.unknownNodeOutput = unknownNodeOutput != null ? unknownNodeOutput.build() : null;
            handleUnionValueChange(Type.UNKNOWN_NODE_OUTPUT, oldValue, this.unknownNodeOutput);
        }

        @Override
        public final Builder unknownNodeOutput(UnknownNodeOutputFlowValidationDetails unknownNodeOutput) {
            Object oldValue = this.unknownNodeOutput;
            this.unknownNodeOutput = unknownNodeOutput;
            handleUnionValueChange(Type.UNKNOWN_NODE_OUTPUT, oldValue, this.unknownNodeOutput);
            return this;
        }

        public final MissingLoopInputNodeFlowValidationDetails.Builder getMissingLoopInputNode() {
            return missingLoopInputNode != null ? missingLoopInputNode.toBuilder() : null;
        }

        public final void setMissingLoopInputNode(MissingLoopInputNodeFlowValidationDetails.BuilderImpl missingLoopInputNode) {
            Object oldValue = this.missingLoopInputNode;
            this.missingLoopInputNode = missingLoopInputNode != null ? missingLoopInputNode.build() : null;
            handleUnionValueChange(Type.MISSING_LOOP_INPUT_NODE, oldValue, this.missingLoopInputNode);
        }

        @Override
        public final Builder missingLoopInputNode(MissingLoopInputNodeFlowValidationDetails missingLoopInputNode) {
            Object oldValue = this.missingLoopInputNode;
            this.missingLoopInputNode = missingLoopInputNode;
            handleUnionValueChange(Type.MISSING_LOOP_INPUT_NODE, oldValue, this.missingLoopInputNode);
            return this;
        }

        public final MissingLoopControllerNodeFlowValidationDetails.Builder getMissingLoopControllerNode() {
            return missingLoopControllerNode != null ? missingLoopControllerNode.toBuilder() : null;
        }

        public final void setMissingLoopControllerNode(
                MissingLoopControllerNodeFlowValidationDetails.BuilderImpl missingLoopControllerNode) {
            Object oldValue = this.missingLoopControllerNode;
            this.missingLoopControllerNode = missingLoopControllerNode != null ? missingLoopControllerNode.build() : null;
            handleUnionValueChange(Type.MISSING_LOOP_CONTROLLER_NODE, oldValue, this.missingLoopControllerNode);
        }

        @Override
        public final Builder missingLoopControllerNode(MissingLoopControllerNodeFlowValidationDetails missingLoopControllerNode) {
            Object oldValue = this.missingLoopControllerNode;
            this.missingLoopControllerNode = missingLoopControllerNode;
            handleUnionValueChange(Type.MISSING_LOOP_CONTROLLER_NODE, oldValue, this.missingLoopControllerNode);
            return this;
        }

        public final MultipleLoopInputNodesFlowValidationDetails.Builder getMultipleLoopInputNodes() {
            return multipleLoopInputNodes != null ? multipleLoopInputNodes.toBuilder() : null;
        }

        public final void setMultipleLoopInputNodes(MultipleLoopInputNodesFlowValidationDetails.BuilderImpl multipleLoopInputNodes) {
            Object oldValue = this.multipleLoopInputNodes;
            this.multipleLoopInputNodes = multipleLoopInputNodes != null ? multipleLoopInputNodes.build() : null;
            handleUnionValueChange(Type.MULTIPLE_LOOP_INPUT_NODES, oldValue, this.multipleLoopInputNodes);
        }

        @Override
        public final Builder multipleLoopInputNodes(MultipleLoopInputNodesFlowValidationDetails multipleLoopInputNodes) {
            Object oldValue = this.multipleLoopInputNodes;
            this.multipleLoopInputNodes = multipleLoopInputNodes;
            handleUnionValueChange(Type.MULTIPLE_LOOP_INPUT_NODES, oldValue, this.multipleLoopInputNodes);
            return this;
        }

        public final MultipleLoopControllerNodesFlowValidationDetails.Builder getMultipleLoopControllerNodes() {
            return multipleLoopControllerNodes != null ? multipleLoopControllerNodes.toBuilder() : null;
        }

        public final void setMultipleLoopControllerNodes(
                MultipleLoopControllerNodesFlowValidationDetails.BuilderImpl multipleLoopControllerNodes) {
            Object oldValue = this.multipleLoopControllerNodes;
            this.multipleLoopControllerNodes = multipleLoopControllerNodes != null ? multipleLoopControllerNodes.build() : null;
            handleUnionValueChange(Type.MULTIPLE_LOOP_CONTROLLER_NODES, oldValue, this.multipleLoopControllerNodes);
        }

        @Override
        public final Builder multipleLoopControllerNodes(
                MultipleLoopControllerNodesFlowValidationDetails multipleLoopControllerNodes) {
            Object oldValue = this.multipleLoopControllerNodes;
            this.multipleLoopControllerNodes = multipleLoopControllerNodes;
            handleUnionValueChange(Type.MULTIPLE_LOOP_CONTROLLER_NODES, oldValue, this.multipleLoopControllerNodes);
            return this;
        }

        public final LoopIncompatibleNodeTypeFlowValidationDetails.Builder getLoopIncompatibleNodeType() {
            return loopIncompatibleNodeType != null ? loopIncompatibleNodeType.toBuilder() : null;
        }

        public final void setLoopIncompatibleNodeType(
                LoopIncompatibleNodeTypeFlowValidationDetails.BuilderImpl loopIncompatibleNodeType) {
            Object oldValue = this.loopIncompatibleNodeType;
            this.loopIncompatibleNodeType = loopIncompatibleNodeType != null ? loopIncompatibleNodeType.build() : null;
            handleUnionValueChange(Type.LOOP_INCOMPATIBLE_NODE_TYPE, oldValue, this.loopIncompatibleNodeType);
        }

        @Override
        public final Builder loopIncompatibleNodeType(LoopIncompatibleNodeTypeFlowValidationDetails loopIncompatibleNodeType) {
            Object oldValue = this.loopIncompatibleNodeType;
            this.loopIncompatibleNodeType = loopIncompatibleNodeType;
            handleUnionValueChange(Type.LOOP_INCOMPATIBLE_NODE_TYPE, oldValue, this.loopIncompatibleNodeType);
            return this;
        }

        public final InvalidLoopBoundaryFlowValidationDetails.Builder getInvalidLoopBoundary() {
            return invalidLoopBoundary != null ? invalidLoopBoundary.toBuilder() : null;
        }

        public final void setInvalidLoopBoundary(InvalidLoopBoundaryFlowValidationDetails.BuilderImpl invalidLoopBoundary) {
            Object oldValue = this.invalidLoopBoundary;
            this.invalidLoopBoundary = invalidLoopBoundary != null ? invalidLoopBoundary.build() : null;
            handleUnionValueChange(Type.INVALID_LOOP_BOUNDARY, oldValue, this.invalidLoopBoundary);
        }

        @Override
        public final Builder invalidLoopBoundary(InvalidLoopBoundaryFlowValidationDetails invalidLoopBoundary) {
            Object oldValue = this.invalidLoopBoundary;
            this.invalidLoopBoundary = invalidLoopBoundary;
            handleUnionValueChange(Type.INVALID_LOOP_BOUNDARY, oldValue, this.invalidLoopBoundary);
            return this;
        }

        @Override
        public FlowValidationDetails build() {
            return new FlowValidationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see FlowValidationDetails#type()
     */
    public enum Type {
        CYCLIC_CONNECTION,

        DUPLICATE_CONNECTIONS,

        DUPLICATE_CONDITION_EXPRESSION,

        UNREACHABLE_NODE,

        UNKNOWN_CONNECTION_SOURCE,

        UNKNOWN_CONNECTION_SOURCE_OUTPUT,

        UNKNOWN_CONNECTION_TARGET,

        UNKNOWN_CONNECTION_TARGET_INPUT,

        UNKNOWN_CONNECTION_CONDITION,

        MALFORMED_CONDITION_EXPRESSION,

        MALFORMED_NODE_INPUT_EXPRESSION,

        MISMATCHED_NODE_INPUT_TYPE,

        MISMATCHED_NODE_OUTPUT_TYPE,

        INCOMPATIBLE_CONNECTION_DATA_TYPE,

        MISSING_CONNECTION_CONFIGURATION,

        MISSING_DEFAULT_CONDITION,

        MISSING_ENDING_NODES,

        MISSING_NODE_CONFIGURATION,

        MISSING_NODE_INPUT,

        MISSING_NODE_OUTPUT,

        MISSING_STARTING_NODES,

        MULTIPLE_NODE_INPUT_CONNECTIONS,

        UNFULFILLED_NODE_INPUT,

        UNSATISFIED_CONNECTION_CONDITIONS,

        UNSPECIFIED,

        UNKNOWN_NODE_INPUT,

        UNKNOWN_NODE_OUTPUT,

        MISSING_LOOP_INPUT_NODE,

        MISSING_LOOP_CONTROLLER_NODE,

        MULTIPLE_LOOP_INPUT_NODES,

        MULTIPLE_LOOP_CONTROLLER_NODES,

        LOOP_INCOMPATIBLE_NODE_TYPE,

        INVALID_LOOP_BOUNDARY,

        UNKNOWN_TO_SDK_VERSION
    }
}
