/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures how the knowledge base orchestrates the retrieval and generation process, allowing for customization of
 * prompts, inference parameters, and performance settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KnowledgeBaseOrchestrationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<KnowledgeBaseOrchestrationConfiguration.Builder, KnowledgeBaseOrchestrationConfiguration> {
    private static final SdkField<KnowledgeBasePromptTemplate> PROMPT_TEMPLATE_FIELD = SdkField
            .<KnowledgeBasePromptTemplate> builder(MarshallingType.SDK_POJO).memberName("promptTemplate")
            .getter(getter(KnowledgeBaseOrchestrationConfiguration::promptTemplate)).setter(setter(Builder::promptTemplate))
            .constructor(KnowledgeBasePromptTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptTemplate").build()).build();

    private static final SdkField<PromptInferenceConfiguration> INFERENCE_CONFIG_FIELD = SdkField
            .<PromptInferenceConfiguration> builder(MarshallingType.SDK_POJO).memberName("inferenceConfig")
            .getter(getter(KnowledgeBaseOrchestrationConfiguration::inferenceConfig)).setter(setter(Builder::inferenceConfig))
            .constructor(PromptInferenceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfig").build()).build();

    private static final SdkField<Map<String, Document>> ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD = SdkField
            .<Map<String, Document>> builder(MarshallingType.MAP)
            .memberName("additionalModelRequestFields")
            .getter(getter(KnowledgeBaseOrchestrationConfiguration::additionalModelRequestFields))
            .setter(setter(Builder::additionalModelRequestFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalModelRequestFields")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Document> builder(MarshallingType.DOCUMENT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<PerformanceConfiguration> PERFORMANCE_CONFIG_FIELD = SdkField
            .<PerformanceConfiguration> builder(MarshallingType.SDK_POJO).memberName("performanceConfig")
            .getter(getter(KnowledgeBaseOrchestrationConfiguration::performanceConfig))
            .setter(setter(Builder::performanceConfig)).constructor(PerformanceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performanceConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_TEMPLATE_FIELD,
            INFERENCE_CONFIG_FIELD, ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD, PERFORMANCE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final KnowledgeBasePromptTemplate promptTemplate;

    private final PromptInferenceConfiguration inferenceConfig;

    private final Map<String, Document> additionalModelRequestFields;

    private final PerformanceConfiguration performanceConfig;

    private KnowledgeBaseOrchestrationConfiguration(BuilderImpl builder) {
        this.promptTemplate = builder.promptTemplate;
        this.inferenceConfig = builder.inferenceConfig;
        this.additionalModelRequestFields = builder.additionalModelRequestFields;
        this.performanceConfig = builder.performanceConfig;
    }

    /**
     * <p>
     * A custom prompt template for orchestrating the retrieval and generation process.
     * </p>
     * 
     * @return A custom prompt template for orchestrating the retrieval and generation process.
     */
    public final KnowledgeBasePromptTemplate promptTemplate() {
        return promptTemplate;
    }

    /**
     * <p>
     * Contains inference configurations for the prompt.
     * </p>
     * 
     * @return Contains inference configurations for the prompt.
     */
    public final PromptInferenceConfiguration inferenceConfig() {
        return inferenceConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalModelRequestFields property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalModelRequestFields() {
        return additionalModelRequestFields != null && !(additionalModelRequestFields instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The additional model-specific request parameters as key-value pairs to be included in the request to the
     * foundation model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalModelRequestFields} method.
     * </p>
     * 
     * @return The additional model-specific request parameters as key-value pairs to be included in the request to the
     *         foundation model.
     */
    public final Map<String, Document> additionalModelRequestFields() {
        return additionalModelRequestFields;
    }

    /**
     * <p>
     * The performance configuration options for the knowledge base retrieval and generation process.
     * </p>
     * 
     * @return The performance configuration options for the knowledge base retrieval and generation process.
     */
    public final PerformanceConfiguration performanceConfig() {
        return performanceConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(promptTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalModelRequestFields() ? additionalModelRequestFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(performanceConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseOrchestrationConfiguration)) {
            return false;
        }
        KnowledgeBaseOrchestrationConfiguration other = (KnowledgeBaseOrchestrationConfiguration) obj;
        return Objects.equals(promptTemplate(), other.promptTemplate())
                && Objects.equals(inferenceConfig(), other.inferenceConfig())
                && hasAdditionalModelRequestFields() == other.hasAdditionalModelRequestFields()
                && Objects.equals(additionalModelRequestFields(), other.additionalModelRequestFields())
                && Objects.equals(performanceConfig(), other.performanceConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KnowledgeBaseOrchestrationConfiguration").add("PromptTemplate", promptTemplate())
                .add("InferenceConfig", inferenceConfig())
                .add("AdditionalModelRequestFields", hasAdditionalModelRequestFields() ? additionalModelRequestFields() : null)
                .add("PerformanceConfig", performanceConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "promptTemplate":
            return Optional.ofNullable(clazz.cast(promptTemplate()));
        case "inferenceConfig":
            return Optional.ofNullable(clazz.cast(inferenceConfig()));
        case "additionalModelRequestFields":
            return Optional.ofNullable(clazz.cast(additionalModelRequestFields()));
        case "performanceConfig":
            return Optional.ofNullable(clazz.cast(performanceConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("promptTemplate", PROMPT_TEMPLATE_FIELD);
        map.put("inferenceConfig", INFERENCE_CONFIG_FIELD);
        map.put("additionalModelRequestFields", ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD);
        map.put("performanceConfig", PERFORMANCE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseOrchestrationConfiguration, T> g) {
        return obj -> g.apply((KnowledgeBaseOrchestrationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KnowledgeBaseOrchestrationConfiguration> {
        /**
         * <p>
         * A custom prompt template for orchestrating the retrieval and generation process.
         * </p>
         * 
         * @param promptTemplate
         *        A custom prompt template for orchestrating the retrieval and generation process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptTemplate(KnowledgeBasePromptTemplate promptTemplate);

        /**
         * <p>
         * A custom prompt template for orchestrating the retrieval and generation process.
         * </p>
         * This is a convenience method that creates an instance of the {@link KnowledgeBasePromptTemplate.Builder}
         * avoiding the need to create one manually via {@link KnowledgeBasePromptTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KnowledgeBasePromptTemplate.Builder#build()} is called
         * immediately and its result is passed to {@link #promptTemplate(KnowledgeBasePromptTemplate)}.
         * 
         * @param promptTemplate
         *        a consumer that will call methods on {@link KnowledgeBasePromptTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #promptTemplate(KnowledgeBasePromptTemplate)
         */
        default Builder promptTemplate(Consumer<KnowledgeBasePromptTemplate.Builder> promptTemplate) {
            return promptTemplate(KnowledgeBasePromptTemplate.builder().applyMutation(promptTemplate).build());
        }

        /**
         * <p>
         * Contains inference configurations for the prompt.
         * </p>
         * 
         * @param inferenceConfig
         *        Contains inference configurations for the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceConfig(PromptInferenceConfiguration inferenceConfig);

        /**
         * <p>
         * Contains inference configurations for the prompt.
         * </p>
         * This is a convenience method that creates an instance of the {@link PromptInferenceConfiguration.Builder}
         * avoiding the need to create one manually via {@link PromptInferenceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptInferenceConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #inferenceConfig(PromptInferenceConfiguration)}.
         * 
         * @param inferenceConfig
         *        a consumer that will call methods on {@link PromptInferenceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceConfig(PromptInferenceConfiguration)
         */
        default Builder inferenceConfig(Consumer<PromptInferenceConfiguration.Builder> inferenceConfig) {
            return inferenceConfig(PromptInferenceConfiguration.builder().applyMutation(inferenceConfig).build());
        }

        /**
         * <p>
         * The additional model-specific request parameters as key-value pairs to be included in the request to the
         * foundation model.
         * </p>
         * 
         * @param additionalModelRequestFields
         *        The additional model-specific request parameters as key-value pairs to be included in the request to
         *        the foundation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalModelRequestFields(Map<String, Document> additionalModelRequestFields);

        /**
         * <p>
         * The performance configuration options for the knowledge base retrieval and generation process.
         * </p>
         * 
         * @param performanceConfig
         *        The performance configuration options for the knowledge base retrieval and generation process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceConfig(PerformanceConfiguration performanceConfig);

        /**
         * <p>
         * The performance configuration options for the knowledge base retrieval and generation process.
         * </p>
         * This is a convenience method that creates an instance of the {@link PerformanceConfiguration.Builder}
         * avoiding the need to create one manually via {@link PerformanceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PerformanceConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #performanceConfig(PerformanceConfiguration)}.
         * 
         * @param performanceConfig
         *        a consumer that will call methods on {@link PerformanceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #performanceConfig(PerformanceConfiguration)
         */
        default Builder performanceConfig(Consumer<PerformanceConfiguration.Builder> performanceConfig) {
            return performanceConfig(PerformanceConfiguration.builder().applyMutation(performanceConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KnowledgeBasePromptTemplate promptTemplate;

        private PromptInferenceConfiguration inferenceConfig;

        private Map<String, Document> additionalModelRequestFields = DefaultSdkAutoConstructMap.getInstance();

        private PerformanceConfiguration performanceConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseOrchestrationConfiguration model) {
            promptTemplate(model.promptTemplate);
            inferenceConfig(model.inferenceConfig);
            additionalModelRequestFields(model.additionalModelRequestFields);
            performanceConfig(model.performanceConfig);
        }

        public final KnowledgeBasePromptTemplate.Builder getPromptTemplate() {
            return promptTemplate != null ? promptTemplate.toBuilder() : null;
        }

        public final void setPromptTemplate(KnowledgeBasePromptTemplate.BuilderImpl promptTemplate) {
            this.promptTemplate = promptTemplate != null ? promptTemplate.build() : null;
        }

        @Override
        public final Builder promptTemplate(KnowledgeBasePromptTemplate promptTemplate) {
            this.promptTemplate = promptTemplate;
            return this;
        }

        public final PromptInferenceConfiguration.Builder getInferenceConfig() {
            return inferenceConfig != null ? inferenceConfig.toBuilder() : null;
        }

        public final void setInferenceConfig(PromptInferenceConfiguration.BuilderImpl inferenceConfig) {
            this.inferenceConfig = inferenceConfig != null ? inferenceConfig.build() : null;
        }

        @Override
        public final Builder inferenceConfig(PromptInferenceConfiguration inferenceConfig) {
            this.inferenceConfig = inferenceConfig;
            return this;
        }

        public final Map<String, Document> getAdditionalModelRequestFields() {
            if (additionalModelRequestFields instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalModelRequestFields;
        }

        public final void setAdditionalModelRequestFields(Map<String, Document> additionalModelRequestFields) {
            this.additionalModelRequestFields = AdditionalModelRequestFieldsCopier.copy(additionalModelRequestFields);
        }

        @Override
        public final Builder additionalModelRequestFields(Map<String, Document> additionalModelRequestFields) {
            this.additionalModelRequestFields = AdditionalModelRequestFieldsCopier.copy(additionalModelRequestFields);
            return this;
        }

        public final PerformanceConfiguration.Builder getPerformanceConfig() {
            return performanceConfig != null ? performanceConfig.toBuilder() : null;
        }

        public final void setPerformanceConfig(PerformanceConfiguration.BuilderImpl performanceConfig) {
            this.performanceConfig = performanceConfig != null ? performanceConfig.build() : null;
        }

        @Override
        public final Builder performanceConfig(PerformanceConfiguration performanceConfig) {
            this.performanceConfig = performanceConfig;
            return this;
        }

        @Override
        public KnowledgeBaseOrchestrationConfiguration build() {
            return new KnowledgeBaseOrchestrationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
