/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for a Lex node in the flow. You specify a Amazon Lex bot to invoke. This node takes an
 * utterance as the input and returns as the output the intent identified by the Amazon Lex bot. For more information,
 * see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in a flow</a> in the
 * Amazon Bedrock User Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LexFlowNodeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LexFlowNodeConfiguration.Builder, LexFlowNodeConfiguration> {
    private static final SdkField<String> BOT_ALIAS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botAliasArn").getter(getter(LexFlowNodeConfiguration::botAliasArn)).setter(setter(Builder::botAliasArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botAliasArn").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(LexFlowNodeConfiguration::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ALIAS_ARN_FIELD,
            LOCALE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String botAliasArn;

    private final String localeId;

    private LexFlowNodeConfiguration(BuilderImpl builder) {
        this.botAliasArn = builder.botAliasArn;
        this.localeId = builder.localeId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Lex bot alias to invoke.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Lex bot alias to invoke.
     */
    public final String botAliasArn() {
        return botAliasArn;
    }

    /**
     * <p>
     * The Region to invoke the Amazon Lex bot in.
     * </p>
     * 
     * @return The Region to invoke the Amazon Lex bot in.
     */
    public final String localeId() {
        return localeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botAliasArn());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LexFlowNodeConfiguration)) {
            return false;
        }
        LexFlowNodeConfiguration other = (LexFlowNodeConfiguration) obj;
        return Objects.equals(botAliasArn(), other.botAliasArn()) && Objects.equals(localeId(), other.localeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LexFlowNodeConfiguration").add("BotAliasArn", botAliasArn()).add("LocaleId", localeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botAliasArn":
            return Optional.ofNullable(clazz.cast(botAliasArn()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botAliasArn", BOT_ALIAS_ARN_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LexFlowNodeConfiguration, T> g) {
        return obj -> g.apply((LexFlowNodeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LexFlowNodeConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Lex bot alias to invoke.
         * </p>
         * 
         * @param botAliasArn
         *        The Amazon Resource Name (ARN) of the Amazon Lex bot alias to invoke.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botAliasArn(String botAliasArn);

        /**
         * <p>
         * The Region to invoke the Amazon Lex bot in.
         * </p>
         * 
         * @param localeId
         *        The Region to invoke the Amazon Lex bot in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);
    }

    static final class BuilderImpl implements Builder {
        private String botAliasArn;

        private String localeId;

        private BuilderImpl() {
        }

        private BuilderImpl(LexFlowNodeConfiguration model) {
            botAliasArn(model.botAliasArn);
            localeId(model.localeId);
        }

        public final String getBotAliasArn() {
            return botAliasArn;
        }

        public final void setBotAliasArn(String botAliasArn) {
            this.botAliasArn = botAliasArn;
        }

        @Override
        public final Builder botAliasArn(String botAliasArn) {
            this.botAliasArn = botAliasArn;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        @Override
        public LexFlowNodeConfiguration build() {
            return new LexFlowNodeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
