/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for the controller node of a DoWhile loop in the flow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoopControllerFlowNodeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LoopControllerFlowNodeConfiguration.Builder, LoopControllerFlowNodeConfiguration> {
    private static final SdkField<FlowCondition> CONTINUE_CONDITION_FIELD = SdkField
            .<FlowCondition> builder(MarshallingType.SDK_POJO).memberName("continueCondition")
            .getter(getter(LoopControllerFlowNodeConfiguration::continueCondition)).setter(setter(Builder::continueCondition))
            .constructor(FlowCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continueCondition").build()).build();

    private static final SdkField<Integer> MAX_ITERATIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxIterations").getter(getter(LoopControllerFlowNodeConfiguration::maxIterations))
            .setter(setter(Builder::maxIterations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxIterations").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTINUE_CONDITION_FIELD,
            MAX_ITERATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FlowCondition continueCondition;

    private final Integer maxIterations;

    private LoopControllerFlowNodeConfiguration(BuilderImpl builder) {
        this.continueCondition = builder.continueCondition;
        this.maxIterations = builder.maxIterations;
    }

    /**
     * <p>
     * Specifies the condition that determines when the flow exits the DoWhile loop. The loop executes until this
     * condition evaluates to true.
     * </p>
     * 
     * @return Specifies the condition that determines when the flow exits the DoWhile loop. The loop executes until
     *         this condition evaluates to true.
     */
    public final FlowCondition continueCondition() {
        return continueCondition;
    }

    /**
     * <p>
     * Specifies the maximum number of times the DoWhile loop can iterate before the flow exits the loop.
     * </p>
     * 
     * @return Specifies the maximum number of times the DoWhile loop can iterate before the flow exits the loop.
     */
    public final Integer maxIterations() {
        return maxIterations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(continueCondition());
        hashCode = 31 * hashCode + Objects.hashCode(maxIterations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoopControllerFlowNodeConfiguration)) {
            return false;
        }
        LoopControllerFlowNodeConfiguration other = (LoopControllerFlowNodeConfiguration) obj;
        return Objects.equals(continueCondition(), other.continueCondition())
                && Objects.equals(maxIterations(), other.maxIterations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoopControllerFlowNodeConfiguration").add("ContinueCondition", continueCondition())
                .add("MaxIterations", maxIterations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "continueCondition":
            return Optional.ofNullable(clazz.cast(continueCondition()));
        case "maxIterations":
            return Optional.ofNullable(clazz.cast(maxIterations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("continueCondition", CONTINUE_CONDITION_FIELD);
        map.put("maxIterations", MAX_ITERATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoopControllerFlowNodeConfiguration, T> g) {
        return obj -> g.apply((LoopControllerFlowNodeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoopControllerFlowNodeConfiguration> {
        /**
         * <p>
         * Specifies the condition that determines when the flow exits the DoWhile loop. The loop executes until this
         * condition evaluates to true.
         * </p>
         * 
         * @param continueCondition
         *        Specifies the condition that determines when the flow exits the DoWhile loop. The loop executes until
         *        this condition evaluates to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continueCondition(FlowCondition continueCondition);

        /**
         * <p>
         * Specifies the condition that determines when the flow exits the DoWhile loop. The loop executes until this
         * condition evaluates to true.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowCondition.Builder} avoiding the need
         * to create one manually via {@link FlowCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #continueCondition(FlowCondition)}.
         * 
         * @param continueCondition
         *        a consumer that will call methods on {@link FlowCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #continueCondition(FlowCondition)
         */
        default Builder continueCondition(Consumer<FlowCondition.Builder> continueCondition) {
            return continueCondition(FlowCondition.builder().applyMutation(continueCondition).build());
        }

        /**
         * <p>
         * Specifies the maximum number of times the DoWhile loop can iterate before the flow exits the loop.
         * </p>
         * 
         * @param maxIterations
         *        Specifies the maximum number of times the DoWhile loop can iterate before the flow exits the loop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxIterations(Integer maxIterations);
    }

    static final class BuilderImpl implements Builder {
        private FlowCondition continueCondition;

        private Integer maxIterations;

        private BuilderImpl() {
        }

        private BuilderImpl(LoopControllerFlowNodeConfiguration model) {
            continueCondition(model.continueCondition);
            maxIterations(model.maxIterations);
        }

        public final FlowCondition.Builder getContinueCondition() {
            return continueCondition != null ? continueCondition.toBuilder() : null;
        }

        public final void setContinueCondition(FlowCondition.BuilderImpl continueCondition) {
            this.continueCondition = continueCondition != null ? continueCondition.build() : null;
        }

        @Override
        public final Builder continueCondition(FlowCondition continueCondition) {
            this.continueCondition = continueCondition;
            return this;
        }

        public final Integer getMaxIterations() {
            return maxIterations;
        }

        public final void setMaxIterations(Integer maxIterations) {
            this.maxIterations = maxIterations;
        }

        @Override
        public final Builder maxIterations(Integer maxIterations) {
            this.maxIterations = maxIterations;
            return this;
        }

        @Override
        public LoopControllerFlowNodeConfiguration build() {
            return new LoopControllerFlowNodeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
