/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for the nodes of a DoWhile loop in your flow.
 * </p>
 * <p>
 * A DoWhile loop is made up of the following nodes:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>Loop</code> - The container node that holds the loop's flow definition. This node encompasses the entire loop
 * structure.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>LoopInput</code> - The entry point node for the loop. This node receives inputs from nodes outside the loop and
 * from previous loop iterations.
 * </p>
 * </li>
 * <li>
 * <p>
 * Body nodes - The processing nodes that execute within each loop iteration. These can be nodes for handling data in
 * your flow, such as a prompt or Lambda function nodes. Some node types aren't supported inside a DoWhile loop body.
 * For more information, see <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_LoopIncompatibleNodeTypeFlowValidationDetails.html"
 * >LoopIncompatibleNodeTypeFlowValidationDetails</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>LoopController</code> - The node that evaluates whether the loop should continue or exit based on a condition.
 * </p>
 * </li>
 * </ul>
 * <p>
 * These nodes work together to create a loop that runs at least once and continues until a specified condition is met
 * or a maximum number of iterations is reached.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoopFlowNodeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LoopFlowNodeConfiguration.Builder, LoopFlowNodeConfiguration> {
    private static final SdkField<FlowDefinition> DEFINITION_FIELD = SdkField.<FlowDefinition> builder(MarshallingType.SDK_POJO)
            .memberName("definition").getter(getter(LoopFlowNodeConfiguration::definition)).setter(setter(Builder::definition))
            .constructor(FlowDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FlowDefinition definition;

    private LoopFlowNodeConfiguration(BuilderImpl builder) {
        this.definition = builder.definition;
    }

    /**
     * <p>
     * The definition of the DoWhile loop nodes and connections between nodes in the flow.
     * </p>
     * 
     * @return The definition of the DoWhile loop nodes and connections between nodes in the flow.
     */
    public final FlowDefinition definition() {
        return definition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoopFlowNodeConfiguration)) {
            return false;
        }
        LoopFlowNodeConfiguration other = (LoopFlowNodeConfiguration) obj;
        return Objects.equals(definition(), other.definition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoopFlowNodeConfiguration")
                .add("Definition", definition() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("definition", DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoopFlowNodeConfiguration, T> g) {
        return obj -> g.apply((LoopFlowNodeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoopFlowNodeConfiguration> {
        /**
         * <p>
         * The definition of the DoWhile loop nodes and connections between nodes in the flow.
         * </p>
         * 
         * @param definition
         *        The definition of the DoWhile loop nodes and connections between nodes in the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(FlowDefinition definition);

        /**
         * <p>
         * The definition of the DoWhile loop nodes and connections between nodes in the flow.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowDefinition.Builder} avoiding the need
         * to create one manually via {@link FlowDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #definition(FlowDefinition)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link FlowDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(FlowDefinition)
         */
        default Builder definition(Consumer<FlowDefinition.Builder> definition) {
            return definition(FlowDefinition.builder().applyMutation(definition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FlowDefinition definition;

        private BuilderImpl() {
        }

        private BuilderImpl(LoopFlowNodeConfiguration model) {
            definition(model.definition);
        }

        public final FlowDefinition.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(FlowDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(FlowDefinition definition) {
            this.definition = definition;
            return this;
        }

        @Override
        public LoopFlowNodeConfiguration build() {
            return new LoopFlowNodeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
