/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for an Amazon Redshift query engine. Specify the type of query engine in <code>type</code>
 * and include the corresponding field. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-build-structured.html">Build a knowledge
 * base by connecting to a structured data source</a> in the Amazon Bedrock User Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftQueryEngineConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftQueryEngineConfiguration.Builder, RedshiftQueryEngineConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(RedshiftQueryEngineConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<RedshiftServerlessConfiguration> SERVERLESS_CONFIGURATION_FIELD = SdkField
            .<RedshiftServerlessConfiguration> builder(MarshallingType.SDK_POJO).memberName("serverlessConfiguration")
            .getter(getter(RedshiftQueryEngineConfiguration::serverlessConfiguration))
            .setter(setter(Builder::serverlessConfiguration)).constructor(RedshiftServerlessConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverlessConfiguration").build())
            .build();

    private static final SdkField<RedshiftProvisionedConfiguration> PROVISIONED_CONFIGURATION_FIELD = SdkField
            .<RedshiftProvisionedConfiguration> builder(MarshallingType.SDK_POJO).memberName("provisionedConfiguration")
            .getter(getter(RedshiftQueryEngineConfiguration::provisionedConfiguration))
            .setter(setter(Builder::provisionedConfiguration)).constructor(RedshiftProvisionedConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            SERVERLESS_CONFIGURATION_FIELD, PROVISIONED_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final RedshiftServerlessConfiguration serverlessConfiguration;

    private final RedshiftProvisionedConfiguration provisionedConfiguration;

    private RedshiftQueryEngineConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.serverlessConfiguration = builder.serverlessConfiguration;
        this.provisionedConfiguration = builder.provisionedConfiguration;
    }

    /**
     * <p>
     * The type of query engine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RedshiftQueryEngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of query engine.
     * @see RedshiftQueryEngineType
     */
    public final RedshiftQueryEngineType type() {
        return RedshiftQueryEngineType.fromValue(type);
    }

    /**
     * <p>
     * The type of query engine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RedshiftQueryEngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of query engine.
     * @see RedshiftQueryEngineType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Specifies configurations for a serverless Amazon Redshift query engine.
     * </p>
     * 
     * @return Specifies configurations for a serverless Amazon Redshift query engine.
     */
    public final RedshiftServerlessConfiguration serverlessConfiguration() {
        return serverlessConfiguration;
    }

    /**
     * <p>
     * Specifies configurations for a provisioned Amazon Redshift query engine.
     * </p>
     * 
     * @return Specifies configurations for a provisioned Amazon Redshift query engine.
     */
    public final RedshiftProvisionedConfiguration provisionedConfiguration() {
        return provisionedConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serverlessConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftQueryEngineConfiguration)) {
            return false;
        }
        RedshiftQueryEngineConfiguration other = (RedshiftQueryEngineConfiguration) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(serverlessConfiguration(), other.serverlessConfiguration())
                && Objects.equals(provisionedConfiguration(), other.provisionedConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftQueryEngineConfiguration").add("Type", typeAsString())
                .add("ServerlessConfiguration", serverlessConfiguration())
                .add("ProvisionedConfiguration", provisionedConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "serverlessConfiguration":
            return Optional.ofNullable(clazz.cast(serverlessConfiguration()));
        case "provisionedConfiguration":
            return Optional.ofNullable(clazz.cast(provisionedConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("serverlessConfiguration", SERVERLESS_CONFIGURATION_FIELD);
        map.put("provisionedConfiguration", PROVISIONED_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftQueryEngineConfiguration, T> g) {
        return obj -> g.apply((RedshiftQueryEngineConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftQueryEngineConfiguration> {
        /**
         * <p>
         * The type of query engine.
         * </p>
         * 
         * @param type
         *        The type of query engine.
         * @see RedshiftQueryEngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedshiftQueryEngineType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of query engine.
         * </p>
         * 
         * @param type
         *        The type of query engine.
         * @see RedshiftQueryEngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedshiftQueryEngineType
         */
        Builder type(RedshiftQueryEngineType type);

        /**
         * <p>
         * Specifies configurations for a serverless Amazon Redshift query engine.
         * </p>
         * 
         * @param serverlessConfiguration
         *        Specifies configurations for a serverless Amazon Redshift query engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverlessConfiguration(RedshiftServerlessConfiguration serverlessConfiguration);

        /**
         * <p>
         * Specifies configurations for a serverless Amazon Redshift query engine.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftServerlessConfiguration.Builder}
         * avoiding the need to create one manually via {@link RedshiftServerlessConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftServerlessConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #serverlessConfiguration(RedshiftServerlessConfiguration)}.
         * 
         * @param serverlessConfiguration
         *        a consumer that will call methods on {@link RedshiftServerlessConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverlessConfiguration(RedshiftServerlessConfiguration)
         */
        default Builder serverlessConfiguration(Consumer<RedshiftServerlessConfiguration.Builder> serverlessConfiguration) {
            return serverlessConfiguration(RedshiftServerlessConfiguration.builder().applyMutation(serverlessConfiguration)
                    .build());
        }

        /**
         * <p>
         * Specifies configurations for a provisioned Amazon Redshift query engine.
         * </p>
         * 
         * @param provisionedConfiguration
         *        Specifies configurations for a provisioned Amazon Redshift query engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedConfiguration(RedshiftProvisionedConfiguration provisionedConfiguration);

        /**
         * <p>
         * Specifies configurations for a provisioned Amazon Redshift query engine.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftProvisionedConfiguration.Builder}
         * avoiding the need to create one manually via {@link RedshiftProvisionedConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftProvisionedConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #provisionedConfiguration(RedshiftProvisionedConfiguration)}.
         * 
         * @param provisionedConfiguration
         *        a consumer that will call methods on {@link RedshiftProvisionedConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedConfiguration(RedshiftProvisionedConfiguration)
         */
        default Builder provisionedConfiguration(Consumer<RedshiftProvisionedConfiguration.Builder> provisionedConfiguration) {
            return provisionedConfiguration(RedshiftProvisionedConfiguration.builder().applyMutation(provisionedConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private RedshiftServerlessConfiguration serverlessConfiguration;

        private RedshiftProvisionedConfiguration provisionedConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftQueryEngineConfiguration model) {
            type(model.type);
            serverlessConfiguration(model.serverlessConfiguration);
            provisionedConfiguration(model.provisionedConfiguration);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RedshiftQueryEngineType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final RedshiftServerlessConfiguration.Builder getServerlessConfiguration() {
            return serverlessConfiguration != null ? serverlessConfiguration.toBuilder() : null;
        }

        public final void setServerlessConfiguration(RedshiftServerlessConfiguration.BuilderImpl serverlessConfiguration) {
            this.serverlessConfiguration = serverlessConfiguration != null ? serverlessConfiguration.build() : null;
        }

        @Override
        public final Builder serverlessConfiguration(RedshiftServerlessConfiguration serverlessConfiguration) {
            this.serverlessConfiguration = serverlessConfiguration;
            return this;
        }

        public final RedshiftProvisionedConfiguration.Builder getProvisionedConfiguration() {
            return provisionedConfiguration != null ? provisionedConfiguration.toBuilder() : null;
        }

        public final void setProvisionedConfiguration(RedshiftProvisionedConfiguration.BuilderImpl provisionedConfiguration) {
            this.provisionedConfiguration = provisionedConfiguration != null ? provisionedConfiguration.build() : null;
        }

        @Override
        public final Builder provisionedConfiguration(RedshiftProvisionedConfiguration provisionedConfiguration) {
            this.provisionedConfiguration = provisionedConfiguration;
            return this;
        }

        @Override
        public RedshiftQueryEngineConfiguration build() {
            return new RedshiftQueryEngineConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
