/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configurations for a text prompt template. To include a variable, enclose a word in double curly braces as
 * in <code>{{variable}}</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TextPromptTemplateConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TextPromptTemplateConfiguration.Builder, TextPromptTemplateConfiguration> {
    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(TextPromptTemplateConfiguration::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final SdkField<CachePointBlock> CACHE_POINT_FIELD = SdkField
            .<CachePointBlock> builder(MarshallingType.SDK_POJO).memberName("cachePoint")
            .getter(getter(TextPromptTemplateConfiguration::cachePoint)).setter(setter(Builder::cachePoint))
            .constructor(CachePointBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cachePoint").build()).build();

    private static final SdkField<List<PromptInputVariable>> INPUT_VARIABLES_FIELD = SdkField
            .<List<PromptInputVariable>> builder(MarshallingType.LIST)
            .memberName("inputVariables")
            .getter(getter(TextPromptTemplateConfiguration::inputVariables))
            .setter(setter(Builder::inputVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputVariables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PromptInputVariable> builder(MarshallingType.SDK_POJO)
                                            .constructor(PromptInputVariable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, CACHE_POINT_FIELD,
            INPUT_VARIABLES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String text;

    private final CachePointBlock cachePoint;

    private final List<PromptInputVariable> inputVariables;

    private TextPromptTemplateConfiguration(BuilderImpl builder) {
        this.text = builder.text;
        this.cachePoint = builder.cachePoint;
        this.inputVariables = builder.inputVariables;
    }

    /**
     * <p>
     * The message for the prompt.
     * </p>
     * 
     * @return The message for the prompt.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * A cache checkpoint within a template configuration.
     * </p>
     * 
     * @return A cache checkpoint within a template configuration.
     */
    public final CachePointBlock cachePoint() {
        return cachePoint;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputVariables property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputVariables() {
        return inputVariables != null && !(inputVariables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the variables in the prompt template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputVariables} method.
     * </p>
     * 
     * @return An array of the variables in the prompt template.
     */
    public final List<PromptInputVariable> inputVariables() {
        return inputVariables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(cachePoint());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputVariables() ? inputVariables() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextPromptTemplateConfiguration)) {
            return false;
        }
        TextPromptTemplateConfiguration other = (TextPromptTemplateConfiguration) obj;
        return Objects.equals(text(), other.text()) && Objects.equals(cachePoint(), other.cachePoint())
                && hasInputVariables() == other.hasInputVariables() && Objects.equals(inputVariables(), other.inputVariables());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextPromptTemplateConfiguration")
                .add("Text", text() == null ? null : "*** Sensitive Data Redacted ***").add("CachePoint", cachePoint())
                .add("InputVariables", inputVariables() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        case "cachePoint":
            return Optional.ofNullable(clazz.cast(cachePoint()));
        case "inputVariables":
            return Optional.ofNullable(clazz.cast(inputVariables()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("text", TEXT_FIELD);
        map.put("cachePoint", CACHE_POINT_FIELD);
        map.put("inputVariables", INPUT_VARIABLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TextPromptTemplateConfiguration, T> g) {
        return obj -> g.apply((TextPromptTemplateConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextPromptTemplateConfiguration> {
        /**
         * <p>
         * The message for the prompt.
         * </p>
         * 
         * @param text
         *        The message for the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * A cache checkpoint within a template configuration.
         * </p>
         * 
         * @param cachePoint
         *        A cache checkpoint within a template configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachePoint(CachePointBlock cachePoint);

        /**
         * <p>
         * A cache checkpoint within a template configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link CachePointBlock.Builder} avoiding the
         * need to create one manually via {@link CachePointBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CachePointBlock.Builder#build()} is called immediately and its
         * result is passed to {@link #cachePoint(CachePointBlock)}.
         * 
         * @param cachePoint
         *        a consumer that will call methods on {@link CachePointBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cachePoint(CachePointBlock)
         */
        default Builder cachePoint(Consumer<CachePointBlock.Builder> cachePoint) {
            return cachePoint(CachePointBlock.builder().applyMutation(cachePoint).build());
        }

        /**
         * <p>
         * An array of the variables in the prompt template.
         * </p>
         * 
         * @param inputVariables
         *        An array of the variables in the prompt template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputVariables(Collection<PromptInputVariable> inputVariables);

        /**
         * <p>
         * An array of the variables in the prompt template.
         * </p>
         * 
         * @param inputVariables
         *        An array of the variables in the prompt template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputVariables(PromptInputVariable... inputVariables);

        /**
         * <p>
         * An array of the variables in the prompt template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.PromptInputVariable.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.PromptInputVariable#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.PromptInputVariable.Builder#build()} is called
         * immediately and its result is passed to {@link #inputVariables(List<PromptInputVariable>)}.
         * 
         * @param inputVariables
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.PromptInputVariable.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputVariables(java.util.Collection<PromptInputVariable>)
         */
        Builder inputVariables(Consumer<PromptInputVariable.Builder>... inputVariables);
    }

    static final class BuilderImpl implements Builder {
        private String text;

        private CachePointBlock cachePoint;

        private List<PromptInputVariable> inputVariables = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TextPromptTemplateConfiguration model) {
            text(model.text);
            cachePoint(model.cachePoint);
            inputVariables(model.inputVariables);
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final CachePointBlock.Builder getCachePoint() {
            return cachePoint != null ? cachePoint.toBuilder() : null;
        }

        public final void setCachePoint(CachePointBlock.BuilderImpl cachePoint) {
            this.cachePoint = cachePoint != null ? cachePoint.build() : null;
        }

        @Override
        public final Builder cachePoint(CachePointBlock cachePoint) {
            this.cachePoint = cachePoint;
            return this;
        }

        public final List<PromptInputVariable.Builder> getInputVariables() {
            List<PromptInputVariable.Builder> result = PromptInputVariablesListCopier.copyToBuilder(this.inputVariables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputVariables(Collection<PromptInputVariable.BuilderImpl> inputVariables) {
            this.inputVariables = PromptInputVariablesListCopier.copyFromBuilder(inputVariables);
        }

        @Override
        public final Builder inputVariables(Collection<PromptInputVariable> inputVariables) {
            this.inputVariables = PromptInputVariablesListCopier.copy(inputVariables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputVariables(PromptInputVariable... inputVariables) {
            inputVariables(Arrays.asList(inputVariables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputVariables(Consumer<PromptInputVariable.Builder>... inputVariables) {
            inputVariables(Stream.of(inputVariables).map(c -> PromptInputVariable.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TextPromptTemplateConfiguration build() {
            return new TextPromptTemplateConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
