/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAgentActionGroupRequest extends BedrockAgentRequest implements
        ToCopyableBuilder<UpdateAgentActionGroupRequest.Builder, UpdateAgentActionGroupRequest> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(UpdateAgentActionGroupRequest::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentId").build()).build();

    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentVersion").getter(getter(UpdateAgentActionGroupRequest::agentVersion))
            .setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentVersion").build()).build();

    private static final SdkField<String> ACTION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionGroupId").getter(getter(UpdateAgentActionGroupRequest::actionGroupId))
            .setter(setter(Builder::actionGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("actionGroupId").build()).build();

    private static final SdkField<String> ACTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionGroupName").getter(getter(UpdateAgentActionGroupRequest::actionGroupName))
            .setter(setter(Builder::actionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateAgentActionGroupRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> PARENT_ACTION_GROUP_SIGNATURE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("parentActionGroupSignature")
            .getter(getter(UpdateAgentActionGroupRequest::parentActionGroupSignatureAsString))
            .setter(setter(Builder::parentActionGroupSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentActionGroupSignature").build())
            .build();

    private static final SdkField<Map<String, String>> PARENT_ACTION_GROUP_SIGNATURE_PARAMS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("parentActionGroupSignatureParams")
            .getter(getter(UpdateAgentActionGroupRequest::parentActionGroupSignatureParams))
            .setter(setter(Builder::parentActionGroupSignatureParams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentActionGroupSignatureParams")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ActionGroupExecutor> ACTION_GROUP_EXECUTOR_FIELD = SdkField
            .<ActionGroupExecutor> builder(MarshallingType.SDK_POJO).memberName("actionGroupExecutor")
            .getter(getter(UpdateAgentActionGroupRequest::actionGroupExecutor)).setter(setter(Builder::actionGroupExecutor))
            .constructor(ActionGroupExecutor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupExecutor").build())
            .build();

    private static final SdkField<String> ACTION_GROUP_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionGroupState").getter(getter(UpdateAgentActionGroupRequest::actionGroupStateAsString))
            .setter(setter(Builder::actionGroupState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupState").build()).build();

    private static final SdkField<APISchema> API_SCHEMA_FIELD = SdkField.<APISchema> builder(MarshallingType.SDK_POJO)
            .memberName("apiSchema").getter(getter(UpdateAgentActionGroupRequest::apiSchema)).setter(setter(Builder::apiSchema))
            .constructor(APISchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiSchema").build()).build();

    private static final SdkField<FunctionSchema> FUNCTION_SCHEMA_FIELD = SdkField
            .<FunctionSchema> builder(MarshallingType.SDK_POJO).memberName("functionSchema")
            .getter(getter(UpdateAgentActionGroupRequest::functionSchema)).setter(setter(Builder::functionSchema))
            .constructor(FunctionSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionSchema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD,
            AGENT_VERSION_FIELD, ACTION_GROUP_ID_FIELD, ACTION_GROUP_NAME_FIELD, DESCRIPTION_FIELD,
            PARENT_ACTION_GROUP_SIGNATURE_FIELD, PARENT_ACTION_GROUP_SIGNATURE_PARAMS_FIELD, ACTION_GROUP_EXECUTOR_FIELD,
            ACTION_GROUP_STATE_FIELD, API_SCHEMA_FIELD, FUNCTION_SCHEMA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String agentId;

    private final String agentVersion;

    private final String actionGroupId;

    private final String actionGroupName;

    private final String description;

    private final String parentActionGroupSignature;

    private final Map<String, String> parentActionGroupSignatureParams;

    private final ActionGroupExecutor actionGroupExecutor;

    private final String actionGroupState;

    private final APISchema apiSchema;

    private final FunctionSchema functionSchema;

    private UpdateAgentActionGroupRequest(BuilderImpl builder) {
        super(builder);
        this.agentId = builder.agentId;
        this.agentVersion = builder.agentVersion;
        this.actionGroupId = builder.actionGroupId;
        this.actionGroupName = builder.actionGroupName;
        this.description = builder.description;
        this.parentActionGroupSignature = builder.parentActionGroupSignature;
        this.parentActionGroupSignatureParams = builder.parentActionGroupSignatureParams;
        this.actionGroupExecutor = builder.actionGroupExecutor;
        this.actionGroupState = builder.actionGroupState;
        this.apiSchema = builder.apiSchema;
        this.functionSchema = builder.functionSchema;
    }

    /**
     * <p>
     * The unique identifier of the agent for which to update the action group.
     * </p>
     * 
     * @return The unique identifier of the agent for which to update the action group.
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * The unique identifier of the agent version for which to update the action group.
     * </p>
     * 
     * @return The unique identifier of the agent version for which to update the action group.
     */
    public final String agentVersion() {
        return agentVersion;
    }

    /**
     * <p>
     * The unique identifier of the action group.
     * </p>
     * 
     * @return The unique identifier of the action group.
     */
    public final String actionGroupId() {
        return actionGroupId;
    }

    /**
     * <p>
     * Specifies a new name for the action group.
     * </p>
     * 
     * @return Specifies a new name for the action group.
     */
    public final String actionGroupName() {
        return actionGroupName;
    }

    /**
     * <p>
     * Specifies a new name for the action group.
     * </p>
     * 
     * @return Specifies a new name for the action group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Update the built-in or computer use action for this action group. If you specify a value, you must leave the
     * <code>description</code>, <code>apiSchema</code>, and <code>actionGroupExecutor</code> fields empty for this
     * action group.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To allow your agent to request the user for additional information when trying to complete a task, set this field
     * to <code>AMAZON.UserInput</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To allow your agent to generate, run, and troubleshoot code when trying to complete a task, set this field to
     * <code>AMAZON.CodeInterpreter</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To allow your agent to use an Anthropic computer use tool, specify one of the following values.
     * </p>
     * <important>
     * <p>
     * Computer use is a new Anthropic Claude model capability (in beta) available with Anthropic Claude 3.7 Sonnet and
     * Claude 3.5 Sonnet v2 only. When operating computer use functionality, we recommend taking additional security
     * precautions, such as executing computer actions in virtual environments with restricted data access and limited
     * internet connectivity. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-computer-use.html">Configure an Amazon Bedrock
     * Agent to complete tasks with computer use tools</a>.
     * </p>
     * </important>
     * <ul>
     * <li>
     * <p>
     * <code>ANTHROPIC.Computer</code> - Gives the agent permission to use the mouse and keyboard and take screenshots.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ANTHROPIC.TextEditor</code> - Gives the agent permission to view, create and edit files.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ANTHROPIC.Bash</code> - Gives the agent permission to run commands in a bash shell.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * During orchestration, if your agent determines that it needs to invoke an API in an action group, but doesn't
     * have enough information to complete the API request, it will invoke this action group instead and return an <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html">Observation</a>
     * reprompting the user for more information.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #parentActionGroupSignature} will return {@link ActionGroupSignature#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #parentActionGroupSignatureAsString}.
     * </p>
     * 
     * @return Update the built-in or computer use action for this action group. If you specify a value, you must leave
     *         the <code>description</code>, <code>apiSchema</code>, and <code>actionGroupExecutor</code> fields empty
     *         for this action group. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To allow your agent to request the user for additional information when trying to complete a task, set
     *         this field to <code>AMAZON.UserInput</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To allow your agent to generate, run, and troubleshoot code when trying to complete a task, set this
     *         field to <code>AMAZON.CodeInterpreter</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To allow your agent to use an Anthropic computer use tool, specify one of the following values.
     *         </p>
     *         <important>
     *         <p>
     *         Computer use is a new Anthropic Claude model capability (in beta) available with Anthropic Claude 3.7
     *         Sonnet and Claude 3.5 Sonnet v2 only. When operating computer use functionality, we recommend taking
     *         additional security precautions, such as executing computer actions in virtual environments with
     *         restricted data access and limited internet connectivity. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-computer-use.html">Configure an Amazon
     *         Bedrock Agent to complete tasks with computer use tools</a>.
     *         </p>
     *         </important>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ANTHROPIC.Computer</code> - Gives the agent permission to use the mouse and keyboard and take
     *         screenshots.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ANTHROPIC.TextEditor</code> - Gives the agent permission to view, create and edit files.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ANTHROPIC.Bash</code> - Gives the agent permission to run commands in a bash shell.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <p>
     *         During orchestration, if your agent determines that it needs to invoke an API in an action group, but
     *         doesn't have enough information to complete the API request, it will invoke this action group instead and
     *         return an <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html"
     *         >Observation</a> reprompting the user for more information.
     * @see ActionGroupSignature
     */
    public final ActionGroupSignature parentActionGroupSignature() {
        return ActionGroupSignature.fromValue(parentActionGroupSignature);
    }

    /**
     * <p>
     * Update the built-in or computer use action for this action group. If you specify a value, you must leave the
     * <code>description</code>, <code>apiSchema</code>, and <code>actionGroupExecutor</code> fields empty for this
     * action group.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To allow your agent to request the user for additional information when trying to complete a task, set this field
     * to <code>AMAZON.UserInput</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To allow your agent to generate, run, and troubleshoot code when trying to complete a task, set this field to
     * <code>AMAZON.CodeInterpreter</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To allow your agent to use an Anthropic computer use tool, specify one of the following values.
     * </p>
     * <important>
     * <p>
     * Computer use is a new Anthropic Claude model capability (in beta) available with Anthropic Claude 3.7 Sonnet and
     * Claude 3.5 Sonnet v2 only. When operating computer use functionality, we recommend taking additional security
     * precautions, such as executing computer actions in virtual environments with restricted data access and limited
     * internet connectivity. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-computer-use.html">Configure an Amazon Bedrock
     * Agent to complete tasks with computer use tools</a>.
     * </p>
     * </important>
     * <ul>
     * <li>
     * <p>
     * <code>ANTHROPIC.Computer</code> - Gives the agent permission to use the mouse and keyboard and take screenshots.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ANTHROPIC.TextEditor</code> - Gives the agent permission to view, create and edit files.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ANTHROPIC.Bash</code> - Gives the agent permission to run commands in a bash shell.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * During orchestration, if your agent determines that it needs to invoke an API in an action group, but doesn't
     * have enough information to complete the API request, it will invoke this action group instead and return an <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html">Observation</a>
     * reprompting the user for more information.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #parentActionGroupSignature} will return {@link ActionGroupSignature#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #parentActionGroupSignatureAsString}.
     * </p>
     * 
     * @return Update the built-in or computer use action for this action group. If you specify a value, you must leave
     *         the <code>description</code>, <code>apiSchema</code>, and <code>actionGroupExecutor</code> fields empty
     *         for this action group. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         To allow your agent to request the user for additional information when trying to complete a task, set
     *         this field to <code>AMAZON.UserInput</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To allow your agent to generate, run, and troubleshoot code when trying to complete a task, set this
     *         field to <code>AMAZON.CodeInterpreter</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To allow your agent to use an Anthropic computer use tool, specify one of the following values.
     *         </p>
     *         <important>
     *         <p>
     *         Computer use is a new Anthropic Claude model capability (in beta) available with Anthropic Claude 3.7
     *         Sonnet and Claude 3.5 Sonnet v2 only. When operating computer use functionality, we recommend taking
     *         additional security precautions, such as executing computer actions in virtual environments with
     *         restricted data access and limited internet connectivity. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-computer-use.html">Configure an Amazon
     *         Bedrock Agent to complete tasks with computer use tools</a>.
     *         </p>
     *         </important>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ANTHROPIC.Computer</code> - Gives the agent permission to use the mouse and keyboard and take
     *         screenshots.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ANTHROPIC.TextEditor</code> - Gives the agent permission to view, create and edit files.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ANTHROPIC.Bash</code> - Gives the agent permission to run commands in a bash shell.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         <p>
     *         During orchestration, if your agent determines that it needs to invoke an API in an action group, but
     *         doesn't have enough information to complete the API request, it will invoke this action group instead and
     *         return an <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html"
     *         >Observation</a> reprompting the user for more information.
     * @see ActionGroupSignature
     */
    public final String parentActionGroupSignatureAsString() {
        return parentActionGroupSignature;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParentActionGroupSignatureParams
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasParentActionGroupSignatureParams() {
        return parentActionGroupSignatureParams != null && !(parentActionGroupSignatureParams instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The configuration settings for a computer use action.
     * </p>
     * <important>
     * <p>
     * Computer use is a new Anthropic Claude model capability (in beta) available with Claude 3.7 Sonnet and Claude 3.5
     * Sonnet v2 only. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-computer-use.html">Configure an Amazon Bedrock
     * Agent to complete tasks with computer use tools</a>.
     * </p>
     * </important>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParentActionGroupSignatureParams}
     * method.
     * </p>
     * 
     * @return The configuration settings for a computer use action.</p> <important>
     *         <p>
     *         Computer use is a new Anthropic Claude model capability (in beta) available with Claude 3.7 Sonnet and
     *         Claude 3.5 Sonnet v2 only. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-computer-use.html">Configure an Amazon
     *         Bedrock Agent to complete tasks with computer use tools</a>.
     *         </p>
     */
    public final Map<String, String> parentActionGroupSignatureParams() {
        return parentActionGroupSignatureParams;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried out upon
     * invoking the action.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried out
     *         upon invoking the action.
     */
    public final ActionGroupExecutor actionGroupExecutor() {
        return actionGroupExecutor;
    }

    /**
     * <p>
     * Specifies whether the action group is available for the agent to invoke or not when sending an <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a>
     * request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionGroupState}
     * will return {@link ActionGroupState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionGroupStateAsString}.
     * </p>
     * 
     * @return Specifies whether the action group is available for the agent to invoke or not when sending an <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html"
     *         >InvokeAgent</a> request.
     * @see ActionGroupState
     */
    public final ActionGroupState actionGroupState() {
        return ActionGroupState.fromValue(actionGroupState);
    }

    /**
     * <p>
     * Specifies whether the action group is available for the agent to invoke or not when sending an <a
     * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">InvokeAgent</a>
     * request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionGroupState}
     * will return {@link ActionGroupState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionGroupStateAsString}.
     * </p>
     * 
     * @return Specifies whether the action group is available for the agent to invoke or not when sending an <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html"
     *         >InvokeAgent</a> request.
     * @see ActionGroupState
     */
    public final String actionGroupStateAsString() {
        return actionGroupState;
    }

    /**
     * <p>
     * Contains either details about the S3 object containing the OpenAPI schema for the action group or the JSON or
     * YAML-formatted payload defining the schema. For more information, see <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group OpenAPI
     * schemas</a>.
     * </p>
     * 
     * @return Contains either details about the S3 object containing the OpenAPI schema for the action group or the
     *         JSON or YAML-formatted payload defining the schema. For more information, see <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group OpenAPI
     *         schemas</a>.
     */
    public final APISchema apiSchema() {
        return apiSchema;
    }

    /**
     * <p>
     * Contains details about the function schema for the action group or the JSON or YAML-formatted payload defining
     * the schema.
     * </p>
     * 
     * @return Contains details about the function schema for the action group or the JSON or YAML-formatted payload
     *         defining the schema.
     */
    public final FunctionSchema functionSchema() {
        return functionSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(actionGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(actionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(parentActionGroupSignatureAsString());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasParentActionGroupSignatureParams() ? parentActionGroupSignatureParams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(actionGroupExecutor());
        hashCode = 31 * hashCode + Objects.hashCode(actionGroupStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(apiSchema());
        hashCode = 31 * hashCode + Objects.hashCode(functionSchema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAgentActionGroupRequest)) {
            return false;
        }
        UpdateAgentActionGroupRequest other = (UpdateAgentActionGroupRequest) obj;
        return Objects.equals(agentId(), other.agentId()) && Objects.equals(agentVersion(), other.agentVersion())
                && Objects.equals(actionGroupId(), other.actionGroupId())
                && Objects.equals(actionGroupName(), other.actionGroupName())
                && Objects.equals(description(), other.description())
                && Objects.equals(parentActionGroupSignatureAsString(), other.parentActionGroupSignatureAsString())
                && hasParentActionGroupSignatureParams() == other.hasParentActionGroupSignatureParams()
                && Objects.equals(parentActionGroupSignatureParams(), other.parentActionGroupSignatureParams())
                && Objects.equals(actionGroupExecutor(), other.actionGroupExecutor())
                && Objects.equals(actionGroupStateAsString(), other.actionGroupStateAsString())
                && Objects.equals(apiSchema(), other.apiSchema()) && Objects.equals(functionSchema(), other.functionSchema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateAgentActionGroupRequest")
                .add("AgentId", agentId())
                .add("AgentVersion", agentVersion())
                .add("ActionGroupId", actionGroupId())
                .add("ActionGroupName", actionGroupName())
                .add("Description", description())
                .add("ParentActionGroupSignature", parentActionGroupSignatureAsString())
                .add("ParentActionGroupSignatureParams",
                        hasParentActionGroupSignatureParams() ? parentActionGroupSignatureParams() : null)
                .add("ActionGroupExecutor", actionGroupExecutor()).add("ActionGroupState", actionGroupStateAsString())
                .add("ApiSchema", apiSchema()).add("FunctionSchema", functionSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "agentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        case "actionGroupId":
            return Optional.ofNullable(clazz.cast(actionGroupId()));
        case "actionGroupName":
            return Optional.ofNullable(clazz.cast(actionGroupName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "parentActionGroupSignature":
            return Optional.ofNullable(clazz.cast(parentActionGroupSignatureAsString()));
        case "parentActionGroupSignatureParams":
            return Optional.ofNullable(clazz.cast(parentActionGroupSignatureParams()));
        case "actionGroupExecutor":
            return Optional.ofNullable(clazz.cast(actionGroupExecutor()));
        case "actionGroupState":
            return Optional.ofNullable(clazz.cast(actionGroupStateAsString()));
        case "apiSchema":
            return Optional.ofNullable(clazz.cast(apiSchema()));
        case "functionSchema":
            return Optional.ofNullable(clazz.cast(functionSchema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentId", AGENT_ID_FIELD);
        map.put("agentVersion", AGENT_VERSION_FIELD);
        map.put("actionGroupId", ACTION_GROUP_ID_FIELD);
        map.put("actionGroupName", ACTION_GROUP_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("parentActionGroupSignature", PARENT_ACTION_GROUP_SIGNATURE_FIELD);
        map.put("parentActionGroupSignatureParams", PARENT_ACTION_GROUP_SIGNATURE_PARAMS_FIELD);
        map.put("actionGroupExecutor", ACTION_GROUP_EXECUTOR_FIELD);
        map.put("actionGroupState", ACTION_GROUP_STATE_FIELD);
        map.put("apiSchema", API_SCHEMA_FIELD);
        map.put("functionSchema", FUNCTION_SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAgentActionGroupRequest, T> g) {
        return obj -> g.apply((UpdateAgentActionGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAgentActionGroupRequest> {
        /**
         * <p>
         * The unique identifier of the agent for which to update the action group.
         * </p>
         * 
         * @param agentId
         *        The unique identifier of the agent for which to update the action group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * The unique identifier of the agent version for which to update the action group.
         * </p>
         * 
         * @param agentVersion
         *        The unique identifier of the agent version for which to update the action group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        /**
         * <p>
         * The unique identifier of the action group.
         * </p>
         * 
         * @param actionGroupId
         *        The unique identifier of the action group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionGroupId(String actionGroupId);

        /**
         * <p>
         * Specifies a new name for the action group.
         * </p>
         * 
         * @param actionGroupName
         *        Specifies a new name for the action group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionGroupName(String actionGroupName);

        /**
         * <p>
         * Specifies a new name for the action group.
         * </p>
         * 
         * @param description
         *        Specifies a new name for the action group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Update the built-in or computer use action for this action group. If you specify a value, you must leave the
         * <code>description</code>, <code>apiSchema</code>, and <code>actionGroupExecutor</code> fields empty for this
         * action group.
         * </p>
         * <ul>
         * <li>
         * <p>
         * To allow your agent to request the user for additional information when trying to complete a task, set this
         * field to <code>AMAZON.UserInput</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To allow your agent to generate, run, and troubleshoot code when trying to complete a task, set this field to
         * <code>AMAZON.CodeInterpreter</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To allow your agent to use an Anthropic computer use tool, specify one of the following values.
         * </p>
         * <important>
         * <p>
         * Computer use is a new Anthropic Claude model capability (in beta) available with Anthropic Claude 3.7 Sonnet
         * and Claude 3.5 Sonnet v2 only. When operating computer use functionality, we recommend taking additional
         * security precautions, such as executing computer actions in virtual environments with restricted data access
         * and limited internet connectivity. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-computer-use.html">Configure an Amazon
         * Bedrock Agent to complete tasks with computer use tools</a>.
         * </p>
         * </important>
         * <ul>
         * <li>
         * <p>
         * <code>ANTHROPIC.Computer</code> - Gives the agent permission to use the mouse and keyboard and take
         * screenshots.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ANTHROPIC.TextEditor</code> - Gives the agent permission to view, create and edit files.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ANTHROPIC.Bash</code> - Gives the agent permission to run commands in a bash shell.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p>
         * During orchestration, if your agent determines that it needs to invoke an API in an action group, but doesn't
         * have enough information to complete the API request, it will invoke this action group instead and return an
         * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html">
         * Observation</a> reprompting the user for more information.
         * </p>
         * 
         * @param parentActionGroupSignature
         *        Update the built-in or computer use action for this action group. If you specify a value, you must
         *        leave the <code>description</code>, <code>apiSchema</code>, and <code>actionGroupExecutor</code>
         *        fields empty for this action group. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        To allow your agent to request the user for additional information when trying to complete a task, set
         *        this field to <code>AMAZON.UserInput</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To allow your agent to generate, run, and troubleshoot code when trying to complete a task, set this
         *        field to <code>AMAZON.CodeInterpreter</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To allow your agent to use an Anthropic computer use tool, specify one of the following values.
         *        </p>
         *        <important>
         *        <p>
         *        Computer use is a new Anthropic Claude model capability (in beta) available with Anthropic Claude 3.7
         *        Sonnet and Claude 3.5 Sonnet v2 only. When operating computer use functionality, we recommend taking
         *        additional security precautions, such as executing computer actions in virtual environments with
         *        restricted data access and limited internet connectivity. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-computer-use.html">Configure an
         *        Amazon Bedrock Agent to complete tasks with computer use tools</a>.
         *        </p>
         *        </important>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ANTHROPIC.Computer</code> - Gives the agent permission to use the mouse and keyboard and take
         *        screenshots.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ANTHROPIC.TextEditor</code> - Gives the agent permission to view, create and edit files.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ANTHROPIC.Bash</code> - Gives the agent permission to run commands in a bash shell.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <p>
         *        During orchestration, if your agent determines that it needs to invoke an API in an action group, but
         *        doesn't have enough information to complete the API request, it will invoke this action group instead
         *        and return an <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html"
         *        >Observation</a> reprompting the user for more information.
         * @see ActionGroupSignature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionGroupSignature
         */
        Builder parentActionGroupSignature(String parentActionGroupSignature);

        /**
         * <p>
         * Update the built-in or computer use action for this action group. If you specify a value, you must leave the
         * <code>description</code>, <code>apiSchema</code>, and <code>actionGroupExecutor</code> fields empty for this
         * action group.
         * </p>
         * <ul>
         * <li>
         * <p>
         * To allow your agent to request the user for additional information when trying to complete a task, set this
         * field to <code>AMAZON.UserInput</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To allow your agent to generate, run, and troubleshoot code when trying to complete a task, set this field to
         * <code>AMAZON.CodeInterpreter</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * To allow your agent to use an Anthropic computer use tool, specify one of the following values.
         * </p>
         * <important>
         * <p>
         * Computer use is a new Anthropic Claude model capability (in beta) available with Anthropic Claude 3.7 Sonnet
         * and Claude 3.5 Sonnet v2 only. When operating computer use functionality, we recommend taking additional
         * security precautions, such as executing computer actions in virtual environments with restricted data access
         * and limited internet connectivity. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-computer-use.html">Configure an Amazon
         * Bedrock Agent to complete tasks with computer use tools</a>.
         * </p>
         * </important>
         * <ul>
         * <li>
         * <p>
         * <code>ANTHROPIC.Computer</code> - Gives the agent permission to use the mouse and keyboard and take
         * screenshots.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ANTHROPIC.TextEditor</code> - Gives the agent permission to view, create and edit files.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ANTHROPIC.Bash</code> - Gives the agent permission to run commands in a bash shell.
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * <p>
         * During orchestration, if your agent determines that it needs to invoke an API in an action group, but doesn't
         * have enough information to complete the API request, it will invoke this action group instead and return an
         * <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html">
         * Observation</a> reprompting the user for more information.
         * </p>
         * 
         * @param parentActionGroupSignature
         *        Update the built-in or computer use action for this action group. If you specify a value, you must
         *        leave the <code>description</code>, <code>apiSchema</code>, and <code>actionGroupExecutor</code>
         *        fields empty for this action group. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        To allow your agent to request the user for additional information when trying to complete a task, set
         *        this field to <code>AMAZON.UserInput</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To allow your agent to generate, run, and troubleshoot code when trying to complete a task, set this
         *        field to <code>AMAZON.CodeInterpreter</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To allow your agent to use an Anthropic computer use tool, specify one of the following values.
         *        </p>
         *        <important>
         *        <p>
         *        Computer use is a new Anthropic Claude model capability (in beta) available with Anthropic Claude 3.7
         *        Sonnet and Claude 3.5 Sonnet v2 only. When operating computer use functionality, we recommend taking
         *        additional security precautions, such as executing computer actions in virtual environments with
         *        restricted data access and limited internet connectivity. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-computer-use.html">Configure an
         *        Amazon Bedrock Agent to complete tasks with computer use tools</a>.
         *        </p>
         *        </important>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ANTHROPIC.Computer</code> - Gives the agent permission to use the mouse and keyboard and take
         *        screenshots.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ANTHROPIC.TextEditor</code> - Gives the agent permission to view, create and edit files.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ANTHROPIC.Bash</code> - Gives the agent permission to run commands in a bash shell.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        <p>
         *        During orchestration, if your agent determines that it needs to invoke an API in an action group, but
         *        doesn't have enough information to complete the API request, it will invoke this action group instead
         *        and return an <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html"
         *        >Observation</a> reprompting the user for more information.
         * @see ActionGroupSignature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionGroupSignature
         */
        Builder parentActionGroupSignature(ActionGroupSignature parentActionGroupSignature);

        /**
         * <p>
         * The configuration settings for a computer use action.
         * </p>
         * <important>
         * <p>
         * Computer use is a new Anthropic Claude model capability (in beta) available with Claude 3.7 Sonnet and Claude
         * 3.5 Sonnet v2 only. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-computer-use.html">Configure an Amazon
         * Bedrock Agent to complete tasks with computer use tools</a>.
         * </p>
         * </important>
         * 
         * @param parentActionGroupSignatureParams
         *        The configuration settings for a computer use action.</p> <important>
         *        <p>
         *        Computer use is a new Anthropic Claude model capability (in beta) available with Claude 3.7 Sonnet and
         *        Claude 3.5 Sonnet v2 only. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-computer-use.html">Configure an
         *        Amazon Bedrock Agent to complete tasks with computer use tools</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentActionGroupSignatureParams(Map<String, String> parentActionGroupSignatureParams);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried out upon
         * invoking the action.
         * </p>
         * 
         * @param actionGroupExecutor
         *        The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried
         *        out upon invoking the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionGroupExecutor(ActionGroupExecutor actionGroupExecutor);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Lambda function containing the business logic that is carried out upon
         * invoking the action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionGroupExecutor.Builder} avoiding the
         * need to create one manually via {@link ActionGroupExecutor#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionGroupExecutor.Builder#build()} is called immediately and
         * its result is passed to {@link #actionGroupExecutor(ActionGroupExecutor)}.
         * 
         * @param actionGroupExecutor
         *        a consumer that will call methods on {@link ActionGroupExecutor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionGroupExecutor(ActionGroupExecutor)
         */
        default Builder actionGroupExecutor(Consumer<ActionGroupExecutor.Builder> actionGroupExecutor) {
            return actionGroupExecutor(ActionGroupExecutor.builder().applyMutation(actionGroupExecutor).build());
        }

        /**
         * <p>
         * Specifies whether the action group is available for the agent to invoke or not when sending an <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html"
         * >InvokeAgent</a> request.
         * </p>
         * 
         * @param actionGroupState
         *        Specifies whether the action group is available for the agent to invoke or not when sending an <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">
         *        InvokeAgent</a> request.
         * @see ActionGroupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionGroupState
         */
        Builder actionGroupState(String actionGroupState);

        /**
         * <p>
         * Specifies whether the action group is available for the agent to invoke or not when sending an <a
         * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html"
         * >InvokeAgent</a> request.
         * </p>
         * 
         * @param actionGroupState
         *        Specifies whether the action group is available for the agent to invoke or not when sending an <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html">
         *        InvokeAgent</a> request.
         * @see ActionGroupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionGroupState
         */
        Builder actionGroupState(ActionGroupState actionGroupState);

        /**
         * <p>
         * Contains either details about the S3 object containing the OpenAPI schema for the action group or the JSON or
         * YAML-formatted payload defining the schema. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group OpenAPI
         * schemas</a>.
         * </p>
         * 
         * @param apiSchema
         *        Contains either details about the S3 object containing the OpenAPI schema for the action group or the
         *        JSON or YAML-formatted payload defining the schema. For more information, see <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group
         *        OpenAPI schemas</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiSchema(APISchema apiSchema);

        /**
         * <p>
         * Contains either details about the S3 object containing the OpenAPI schema for the action group or the JSON or
         * YAML-formatted payload defining the schema. For more information, see <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html">Action group OpenAPI
         * schemas</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link APISchema.Builder} avoiding the need to
         * create one manually via {@link APISchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link APISchema.Builder#build()} is called immediately and its result
         * is passed to {@link #apiSchema(APISchema)}.
         * 
         * @param apiSchema
         *        a consumer that will call methods on {@link APISchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apiSchema(APISchema)
         */
        default Builder apiSchema(Consumer<APISchema.Builder> apiSchema) {
            return apiSchema(APISchema.builder().applyMutation(apiSchema).build());
        }

        /**
         * <p>
         * Contains details about the function schema for the action group or the JSON or YAML-formatted payload
         * defining the schema.
         * </p>
         * 
         * @param functionSchema
         *        Contains details about the function schema for the action group or the JSON or YAML-formatted payload
         *        defining the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionSchema(FunctionSchema functionSchema);

        /**
         * <p>
         * Contains details about the function schema for the action group or the JSON or YAML-formatted payload
         * defining the schema.
         * </p>
         * This is a convenience method that creates an instance of the {@link FunctionSchema.Builder} avoiding the need
         * to create one manually via {@link FunctionSchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FunctionSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #functionSchema(FunctionSchema)}.
         * 
         * @param functionSchema
         *        a consumer that will call methods on {@link FunctionSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #functionSchema(FunctionSchema)
         */
        default Builder functionSchema(Consumer<FunctionSchema.Builder> functionSchema) {
            return functionSchema(FunctionSchema.builder().applyMutation(functionSchema).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRequest.BuilderImpl implements Builder {
        private String agentId;

        private String agentVersion;

        private String actionGroupId;

        private String actionGroupName;

        private String description;

        private String parentActionGroupSignature;

        private Map<String, String> parentActionGroupSignatureParams = DefaultSdkAutoConstructMap.getInstance();

        private ActionGroupExecutor actionGroupExecutor;

        private String actionGroupState;

        private APISchema apiSchema;

        private FunctionSchema functionSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAgentActionGroupRequest model) {
            super(model);
            agentId(model.agentId);
            agentVersion(model.agentVersion);
            actionGroupId(model.actionGroupId);
            actionGroupName(model.actionGroupName);
            description(model.description);
            parentActionGroupSignature(model.parentActionGroupSignature);
            parentActionGroupSignatureParams(model.parentActionGroupSignatureParams);
            actionGroupExecutor(model.actionGroupExecutor);
            actionGroupState(model.actionGroupState);
            apiSchema(model.apiSchema);
            functionSchema(model.functionSchema);
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getActionGroupId() {
            return actionGroupId;
        }

        public final void setActionGroupId(String actionGroupId) {
            this.actionGroupId = actionGroupId;
        }

        @Override
        public final Builder actionGroupId(String actionGroupId) {
            this.actionGroupId = actionGroupId;
            return this;
        }

        public final String getActionGroupName() {
            return actionGroupName;
        }

        public final void setActionGroupName(String actionGroupName) {
            this.actionGroupName = actionGroupName;
        }

        @Override
        public final Builder actionGroupName(String actionGroupName) {
            this.actionGroupName = actionGroupName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getParentActionGroupSignature() {
            return parentActionGroupSignature;
        }

        public final void setParentActionGroupSignature(String parentActionGroupSignature) {
            this.parentActionGroupSignature = parentActionGroupSignature;
        }

        @Override
        public final Builder parentActionGroupSignature(String parentActionGroupSignature) {
            this.parentActionGroupSignature = parentActionGroupSignature;
            return this;
        }

        @Override
        public final Builder parentActionGroupSignature(ActionGroupSignature parentActionGroupSignature) {
            this.parentActionGroupSignature(parentActionGroupSignature == null ? null : parentActionGroupSignature.toString());
            return this;
        }

        public final Map<String, String> getParentActionGroupSignatureParams() {
            if (parentActionGroupSignatureParams instanceof SdkAutoConstructMap) {
                return null;
            }
            return parentActionGroupSignatureParams;
        }

        public final void setParentActionGroupSignatureParams(Map<String, String> parentActionGroupSignatureParams) {
            this.parentActionGroupSignatureParams = ActionGroupSignatureParamsCopier.copy(parentActionGroupSignatureParams);
        }

        @Override
        public final Builder parentActionGroupSignatureParams(Map<String, String> parentActionGroupSignatureParams) {
            this.parentActionGroupSignatureParams = ActionGroupSignatureParamsCopier.copy(parentActionGroupSignatureParams);
            return this;
        }

        public final ActionGroupExecutor.Builder getActionGroupExecutor() {
            return actionGroupExecutor != null ? actionGroupExecutor.toBuilder() : null;
        }

        public final void setActionGroupExecutor(ActionGroupExecutor.BuilderImpl actionGroupExecutor) {
            this.actionGroupExecutor = actionGroupExecutor != null ? actionGroupExecutor.build() : null;
        }

        @Override
        public final Builder actionGroupExecutor(ActionGroupExecutor actionGroupExecutor) {
            this.actionGroupExecutor = actionGroupExecutor;
            return this;
        }

        public final String getActionGroupState() {
            return actionGroupState;
        }

        public final void setActionGroupState(String actionGroupState) {
            this.actionGroupState = actionGroupState;
        }

        @Override
        public final Builder actionGroupState(String actionGroupState) {
            this.actionGroupState = actionGroupState;
            return this;
        }

        @Override
        public final Builder actionGroupState(ActionGroupState actionGroupState) {
            this.actionGroupState(actionGroupState == null ? null : actionGroupState.toString());
            return this;
        }

        public final APISchema.Builder getApiSchema() {
            return apiSchema != null ? apiSchema.toBuilder() : null;
        }

        public final void setApiSchema(APISchema.BuilderImpl apiSchema) {
            this.apiSchema = apiSchema != null ? apiSchema.build() : null;
        }

        @Override
        public final Builder apiSchema(APISchema apiSchema) {
            this.apiSchema = apiSchema;
            return this;
        }

        public final FunctionSchema.Builder getFunctionSchema() {
            return functionSchema != null ? functionSchema.toBuilder() : null;
        }

        public final void setFunctionSchema(FunctionSchema.BuilderImpl functionSchema) {
            this.functionSchema = functionSchema != null ? functionSchema.build() : null;
        }

        @Override
        public final Builder functionSchema(FunctionSchema functionSchema) {
            this.functionSchema = functionSchema;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAgentActionGroupRequest build() {
            return new UpdateAgentActionGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
