/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The rate limits for the URLs that you want to crawl. You should be authorized to crawl the URLs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WebCrawlerLimits implements SdkPojo, Serializable,
        ToCopyableBuilder<WebCrawlerLimits.Builder, WebCrawlerLimits> {
    private static final SdkField<Integer> RATE_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("rateLimit").getter(getter(WebCrawlerLimits::rateLimit)).setter(setter(Builder::rateLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateLimit").build()).build();

    private static final SdkField<Integer> MAX_PAGES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxPages").getter(getter(WebCrawlerLimits::maxPages)).setter(setter(Builder::maxPages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxPages").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RATE_LIMIT_FIELD,
            MAX_PAGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer rateLimit;

    private final Integer maxPages;

    private WebCrawlerLimits(BuilderImpl builder) {
        this.rateLimit = builder.rateLimit;
        this.maxPages = builder.maxPages;
    }

    /**
     * <p>
     * The max rate at which pages are crawled, up to 300 per minute per host.
     * </p>
     * 
     * @return The max rate at which pages are crawled, up to 300 per minute per host.
     */
    public final Integer rateLimit() {
        return rateLimit;
    }

    /**
     * <p>
     * The max number of web pages crawled from your source URLs, up to 25,000 pages. If the web pages exceed this
     * limit, the data source sync will fail and no web pages will be ingested.
     * </p>
     * 
     * @return The max number of web pages crawled from your source URLs, up to 25,000 pages. If the web pages exceed
     *         this limit, the data source sync will fail and no web pages will be ingested.
     */
    public final Integer maxPages() {
        return maxPages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rateLimit());
        hashCode = 31 * hashCode + Objects.hashCode(maxPages());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebCrawlerLimits)) {
            return false;
        }
        WebCrawlerLimits other = (WebCrawlerLimits) obj;
        return Objects.equals(rateLimit(), other.rateLimit()) && Objects.equals(maxPages(), other.maxPages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WebCrawlerLimits").add("RateLimit", rateLimit()).add("MaxPages", maxPages()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rateLimit":
            return Optional.ofNullable(clazz.cast(rateLimit()));
        case "maxPages":
            return Optional.ofNullable(clazz.cast(maxPages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("rateLimit", RATE_LIMIT_FIELD);
        map.put("maxPages", MAX_PAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WebCrawlerLimits, T> g) {
        return obj -> g.apply((WebCrawlerLimits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WebCrawlerLimits> {
        /**
         * <p>
         * The max rate at which pages are crawled, up to 300 per minute per host.
         * </p>
         * 
         * @param rateLimit
         *        The max rate at which pages are crawled, up to 300 per minute per host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rateLimit(Integer rateLimit);

        /**
         * <p>
         * The max number of web pages crawled from your source URLs, up to 25,000 pages. If the web pages exceed this
         * limit, the data source sync will fail and no web pages will be ingested.
         * </p>
         * 
         * @param maxPages
         *        The max number of web pages crawled from your source URLs, up to 25,000 pages. If the web pages exceed
         *        this limit, the data source sync will fail and no web pages will be ingested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxPages(Integer maxPages);
    }

    static final class BuilderImpl implements Builder {
        private Integer rateLimit;

        private Integer maxPages;

        private BuilderImpl() {
        }

        private BuilderImpl(WebCrawlerLimits model) {
            rateLimit(model.rateLimit);
            maxPages(model.maxPages);
        }

        public final Integer getRateLimit() {
            return rateLimit;
        }

        public final void setRateLimit(Integer rateLimit) {
            this.rateLimit = rateLimit;
        }

        @Override
        public final Builder rateLimit(Integer rateLimit) {
            this.rateLimit = rateLimit;
            return this;
        }

        public final Integer getMaxPages() {
            return maxPages;
        }

        public final void setMaxPages(Integer maxPages) {
            this.maxPages = maxPages;
        }

        @Override
        public final Builder maxPages(Integer maxPages) {
            this.maxPages = maxPages;
            return this;
        }

        @Override
        public WebCrawlerLimits build() {
            return new WebCrawlerLimits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
