/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.DocumentContent;
import software.amazon.awssdk.services.bedrockagent.model.DocumentMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KnowledgeBaseDocument
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KnowledgeBaseDocument> {
    private static final SdkField<DocumentMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadata").getter(KnowledgeBaseDocument.getter(KnowledgeBaseDocument::metadata)).setter(KnowledgeBaseDocument.setter(Builder::metadata)).constructor(DocumentMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final SdkField<DocumentContent> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(KnowledgeBaseDocument.getter(KnowledgeBaseDocument::content)).setter(KnowledgeBaseDocument.setter(Builder::content)).constructor(DocumentContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_FIELD, CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KnowledgeBaseDocument.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DocumentMetadata metadata;
    private final DocumentContent content;

    private KnowledgeBaseDocument(BuilderImpl builder) {
        this.metadata = builder.metadata;
        this.content = builder.content;
    }

    public final DocumentMetadata metadata() {
        return this.metadata;
    }

    public final DocumentContent content() {
        return this.content;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseDocument)) {
            return false;
        }
        KnowledgeBaseDocument other = (KnowledgeBaseDocument)obj;
        return Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.content(), other.content());
    }

    public final String toString() {
        return ToString.builder((String)"KnowledgeBaseDocument").add("Metadata", (Object)this.metadata()).add("Content", (Object)this.content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("metadata", METADATA_FIELD);
        map.put("content", CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseDocument, T> g) {
        return obj -> g.apply((KnowledgeBaseDocument)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DocumentMetadata metadata;
        private DocumentContent content;

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseDocument model) {
            this.metadata(model.metadata);
            this.content(model.content);
        }

        public final DocumentMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(DocumentMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(DocumentMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final DocumentContent.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(DocumentContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(DocumentContent content) {
            this.content = content;
            return this;
        }

        public KnowledgeBaseDocument build() {
            return new KnowledgeBaseDocument(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KnowledgeBaseDocument> {
        public Builder metadata(DocumentMetadata var1);

        default public Builder metadata(Consumer<DocumentMetadata.Builder> metadata) {
            return this.metadata((DocumentMetadata)((DocumentMetadata.Builder)DocumentMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder content(DocumentContent var1);

        default public Builder content(Consumer<DocumentContent.Builder> content) {
            return this.content((DocumentContent)((DocumentContent.Builder)DocumentContent.builder().applyMutation(content)).build());
        }
    }
}

