/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FlowNodeType {
    INPUT("Input"),
    OUTPUT("Output"),
    KNOWLEDGE_BASE("KnowledgeBase"),
    CONDITION("Condition"),
    LEX("Lex"),
    PROMPT("Prompt"),
    LAMBDA_FUNCTION("LambdaFunction"),
    STORAGE("Storage"),
    AGENT("Agent"),
    RETRIEVAL("Retrieval"),
    ITERATOR("Iterator"),
    COLLECTOR("Collector"),
    INLINE_CODE("InlineCode"),
    LOOP("Loop"),
    LOOP_INPUT("LoopInput"),
    LOOP_CONTROLLER("LoopController"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FlowNodeType> VALUE_MAP;
    private final String value;

    private FlowNodeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FlowNodeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FlowNodeType> knownValues() {
        EnumSet<FlowNodeType> knownValues = EnumSet.allOf(FlowNodeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FlowNodeType.class, FlowNodeType::toString);
    }
}

