/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.DocumentIdentifier;
import software.amazon.awssdk.services.bedrockagent.model.DocumentIdentifiersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteKnowledgeBaseDocumentsRequest
extends BedrockAgentRequest
implements ToCopyableBuilder<Builder, DeleteKnowledgeBaseDocumentsRequest> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(DeleteKnowledgeBaseDocumentsRequest.getter(DeleteKnowledgeBaseDocumentsRequest::knowledgeBaseId)).setter(DeleteKnowledgeBaseDocumentsRequest.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceId").getter(DeleteKnowledgeBaseDocumentsRequest.getter(DeleteKnowledgeBaseDocumentsRequest::dataSourceId)).setter(DeleteKnowledgeBaseDocumentsRequest.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("dataSourceId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(DeleteKnowledgeBaseDocumentsRequest.getter(DeleteKnowledgeBaseDocumentsRequest::clientToken)).setter(DeleteKnowledgeBaseDocumentsRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<DocumentIdentifier>> DOCUMENT_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("documentIdentifiers").getter(DeleteKnowledgeBaseDocumentsRequest.getter(DeleteKnowledgeBaseDocumentsRequest::documentIdentifiers)).setter(DeleteKnowledgeBaseDocumentsRequest.setter(Builder::documentIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD, DATA_SOURCE_ID_FIELD, CLIENT_TOKEN_FIELD, DOCUMENT_IDENTIFIERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteKnowledgeBaseDocumentsRequest.memberNameToFieldInitializer();
    private final String knowledgeBaseId;
    private final String dataSourceId;
    private final String clientToken;
    private final List<DocumentIdentifier> documentIdentifiers;

    private DeleteKnowledgeBaseDocumentsRequest(BuilderImpl builder) {
        super(builder);
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.dataSourceId = builder.dataSourceId;
        this.clientToken = builder.clientToken;
        this.documentIdentifiers = builder.documentIdentifiers;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasDocumentIdentifiers() {
        return this.documentIdentifiers != null && !(this.documentIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<DocumentIdentifier> documentIdentifiers() {
        return this.documentIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocumentIdentifiers() ? this.documentIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteKnowledgeBaseDocumentsRequest)) {
            return false;
        }
        DeleteKnowledgeBaseDocumentsRequest other = (DeleteKnowledgeBaseDocumentsRequest)((Object)obj);
        return Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasDocumentIdentifiers() == other.hasDocumentIdentifiers() && Objects.equals(this.documentIdentifiers(), other.documentIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteKnowledgeBaseDocumentsRequest").add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("DataSourceId", (Object)this.dataSourceId()).add("ClientToken", (Object)this.clientToken()).add("DocumentIdentifiers", this.hasDocumentIdentifiers() ? this.documentIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "dataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "documentIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.documentIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("dataSourceId", DATA_SOURCE_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("documentIdentifiers", DOCUMENT_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteKnowledgeBaseDocumentsRequest, T> g) {
        return obj -> g.apply((DeleteKnowledgeBaseDocumentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRequest.BuilderImpl
    implements Builder {
        private String knowledgeBaseId;
        private String dataSourceId;
        private String clientToken;
        private List<DocumentIdentifier> documentIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteKnowledgeBaseDocumentsRequest model) {
            super(model);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.dataSourceId(model.dataSourceId);
            this.clientToken(model.clientToken);
            this.documentIdentifiers(model.documentIdentifiers);
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<DocumentIdentifier.Builder> getDocumentIdentifiers() {
            List<DocumentIdentifier.Builder> result = DocumentIdentifiersCopier.copyToBuilder(this.documentIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentIdentifiers(Collection<DocumentIdentifier.BuilderImpl> documentIdentifiers) {
            this.documentIdentifiers = DocumentIdentifiersCopier.copyFromBuilder(documentIdentifiers);
        }

        @Override
        public final Builder documentIdentifiers(Collection<DocumentIdentifier> documentIdentifiers) {
            this.documentIdentifiers = DocumentIdentifiersCopier.copy(documentIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentIdentifiers(DocumentIdentifier ... documentIdentifiers) {
            this.documentIdentifiers(Arrays.asList(documentIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentIdentifiers(Consumer<DocumentIdentifier.Builder> ... documentIdentifiers) {
            this.documentIdentifiers(Stream.of(documentIdentifiers).map(c -> (DocumentIdentifier)((DocumentIdentifier.Builder)DocumentIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteKnowledgeBaseDocumentsRequest build() {
            return new DeleteKnowledgeBaseDocumentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteKnowledgeBaseDocumentsRequest> {
        public Builder knowledgeBaseId(String var1);

        public Builder dataSourceId(String var1);

        public Builder clientToken(String var1);

        public Builder documentIdentifiers(Collection<DocumentIdentifier> var1);

        public Builder documentIdentifiers(DocumentIdentifier ... var1);

        public Builder documentIdentifiers(Consumer<DocumentIdentifier.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

