/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagent.BedrockAgentClient;
import software.amazon.awssdk.services.bedrockagent.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagent.model.ActionGroupSummary;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentActionGroupsRequest;
import software.amazon.awssdk.services.bedrockagent.model.ListAgentActionGroupsResponse;

public class ListAgentActionGroupsIterable
implements SdkIterable<ListAgentActionGroupsResponse> {
    private final BedrockAgentClient client;
    private final ListAgentActionGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAgentActionGroupsIterable(BedrockAgentClient client, ListAgentActionGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAgentActionGroupsResponseFetcher();
    }

    public Iterator<ListAgentActionGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ActionGroupSummary> actionGroupSummaries() {
        Function<ListAgentActionGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.actionGroupSummaries() != null) {
                return response.actionGroupSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAgentActionGroupsResponseFetcher
    implements SyncPageFetcher<ListAgentActionGroupsResponse> {
        private ListAgentActionGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListAgentActionGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAgentActionGroupsResponse nextPage(ListAgentActionGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListAgentActionGroupsIterable.this.client.listAgentActionGroups(ListAgentActionGroupsIterable.this.firstRequest);
            }
            return ListAgentActionGroupsIterable.this.client.listAgentActionGroups((ListAgentActionGroupsRequest)((Object)ListAgentActionGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

