/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The endpoint information to connect to your Confluence data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfluenceSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfluenceSourceConfiguration.Builder, ConfluenceSourceConfiguration> {
    private static final SdkField<String> HOST_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostUrl").getter(getter(ConfluenceSourceConfiguration::hostUrl)).setter(setter(Builder::hostUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostUrl").build()).build();

    private static final SdkField<String> HOST_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostType").getter(getter(ConfluenceSourceConfiguration::hostTypeAsString))
            .setter(setter(Builder::hostType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostType").build()).build();

    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authType").getter(getter(ConfluenceSourceConfiguration::authTypeAsString))
            .setter(setter(Builder::authType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()).build();

    private static final SdkField<String> CREDENTIALS_SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialsSecretArn").getter(getter(ConfluenceSourceConfiguration::credentialsSecretArn))
            .setter(setter(Builder::credentialsSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsSecretArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_URL_FIELD,
            HOST_TYPE_FIELD, AUTH_TYPE_FIELD, CREDENTIALS_SECRET_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String hostUrl;

    private final String hostType;

    private final String authType;

    private final String credentialsSecretArn;

    private ConfluenceSourceConfiguration(BuilderImpl builder) {
        this.hostUrl = builder.hostUrl;
        this.hostType = builder.hostType;
        this.authType = builder.authType;
        this.credentialsSecretArn = builder.credentialsSecretArn;
    }

    /**
     * <p>
     * The Confluence host URL or instance URL.
     * </p>
     * 
     * @return The Confluence host URL or instance URL.
     */
    public final String hostUrl() {
        return hostUrl;
    }

    /**
     * <p>
     * The supported host type, whether online/cloud or server/on-premises.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hostType} will
     * return {@link ConfluenceHostType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hostTypeAsString}.
     * </p>
     * 
     * @return The supported host type, whether online/cloud or server/on-premises.
     * @see ConfluenceHostType
     */
    public final ConfluenceHostType hostType() {
        return ConfluenceHostType.fromValue(hostType);
    }

    /**
     * <p>
     * The supported host type, whether online/cloud or server/on-premises.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hostType} will
     * return {@link ConfluenceHostType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hostTypeAsString}.
     * </p>
     * 
     * @return The supported host type, whether online/cloud or server/on-premises.
     * @see ConfluenceHostType
     */
    public final String hostTypeAsString() {
        return hostType;
    }

    /**
     * <p>
     * The supported authentication type to authenticate and connect to your Confluence instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link ConfluenceAuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The supported authentication type to authenticate and connect to your Confluence instance.
     * @see ConfluenceAuthType
     */
    public final ConfluenceAuthType authType() {
        return ConfluenceAuthType.fromValue(authType);
    }

    /**
     * <p>
     * The supported authentication type to authenticate and connect to your Confluence instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link ConfluenceAuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The supported authentication type to authenticate and connect to your Confluence instance.
     * @see ConfluenceAuthType
     */
    public final String authTypeAsString() {
        return authType;
    }

    /**
     * <p>
     * The Amazon Resource Name of an Secrets Manager secret that stores your authentication credentials for your
     * Confluence instance URL. For more information on the key-value pairs that must be included in your secret,
     * depending on your authentication type, see <a href=
     * "https://docs.aws.amazon.com/bedrock/latest/userguide/confluence-data-source-connector.html#configuration-confluence-connector"
     * >Confluence connection configuration</a>.
     * </p>
     * 
     * @return The Amazon Resource Name of an Secrets Manager secret that stores your authentication credentials for
     *         your Confluence instance URL. For more information on the key-value pairs that must be included in your
     *         secret, depending on your authentication type, see <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/confluence-data-source-connector.html#configuration-confluence-connector"
     *         >Confluence connection configuration</a>.
     */
    public final String credentialsSecretArn() {
        return credentialsSecretArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hostTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(credentialsSecretArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfluenceSourceConfiguration)) {
            return false;
        }
        ConfluenceSourceConfiguration other = (ConfluenceSourceConfiguration) obj;
        return Objects.equals(hostUrl(), other.hostUrl()) && Objects.equals(hostTypeAsString(), other.hostTypeAsString())
                && Objects.equals(authTypeAsString(), other.authTypeAsString())
                && Objects.equals(credentialsSecretArn(), other.credentialsSecretArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfluenceSourceConfiguration").add("HostUrl", hostUrl()).add("HostType", hostTypeAsString())
                .add("AuthType", authTypeAsString()).add("CredentialsSecretArn", credentialsSecretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "hostUrl":
            return Optional.ofNullable(clazz.cast(hostUrl()));
        case "hostType":
            return Optional.ofNullable(clazz.cast(hostTypeAsString()));
        case "authType":
            return Optional.ofNullable(clazz.cast(authTypeAsString()));
        case "credentialsSecretArn":
            return Optional.ofNullable(clazz.cast(credentialsSecretArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("hostUrl", HOST_URL_FIELD);
        map.put("hostType", HOST_TYPE_FIELD);
        map.put("authType", AUTH_TYPE_FIELD);
        map.put("credentialsSecretArn", CREDENTIALS_SECRET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfluenceSourceConfiguration, T> g) {
        return obj -> g.apply((ConfluenceSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfluenceSourceConfiguration> {
        /**
         * <p>
         * The Confluence host URL or instance URL.
         * </p>
         * 
         * @param hostUrl
         *        The Confluence host URL or instance URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostUrl(String hostUrl);

        /**
         * <p>
         * The supported host type, whether online/cloud or server/on-premises.
         * </p>
         * 
         * @param hostType
         *        The supported host type, whether online/cloud or server/on-premises.
         * @see ConfluenceHostType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfluenceHostType
         */
        Builder hostType(String hostType);

        /**
         * <p>
         * The supported host type, whether online/cloud or server/on-premises.
         * </p>
         * 
         * @param hostType
         *        The supported host type, whether online/cloud or server/on-premises.
         * @see ConfluenceHostType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfluenceHostType
         */
        Builder hostType(ConfluenceHostType hostType);

        /**
         * <p>
         * The supported authentication type to authenticate and connect to your Confluence instance.
         * </p>
         * 
         * @param authType
         *        The supported authentication type to authenticate and connect to your Confluence instance.
         * @see ConfluenceAuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfluenceAuthType
         */
        Builder authType(String authType);

        /**
         * <p>
         * The supported authentication type to authenticate and connect to your Confluence instance.
         * </p>
         * 
         * @param authType
         *        The supported authentication type to authenticate and connect to your Confluence instance.
         * @see ConfluenceAuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfluenceAuthType
         */
        Builder authType(ConfluenceAuthType authType);

        /**
         * <p>
         * The Amazon Resource Name of an Secrets Manager secret that stores your authentication credentials for your
         * Confluence instance URL. For more information on the key-value pairs that must be included in your secret,
         * depending on your authentication type, see <a href=
         * "https://docs.aws.amazon.com/bedrock/latest/userguide/confluence-data-source-connector.html#configuration-confluence-connector"
         * >Confluence connection configuration</a>.
         * </p>
         * 
         * @param credentialsSecretArn
         *        The Amazon Resource Name of an Secrets Manager secret that stores your authentication credentials for
         *        your Confluence instance URL. For more information on the key-value pairs that must be included in
         *        your secret, depending on your authentication type, see <a href=
         *        "https://docs.aws.amazon.com/bedrock/latest/userguide/confluence-data-source-connector.html#configuration-confluence-connector"
         *        >Confluence connection configuration</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsSecretArn(String credentialsSecretArn);
    }

    static final class BuilderImpl implements Builder {
        private String hostUrl;

        private String hostType;

        private String authType;

        private String credentialsSecretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfluenceSourceConfiguration model) {
            hostUrl(model.hostUrl);
            hostType(model.hostType);
            authType(model.authType);
            credentialsSecretArn(model.credentialsSecretArn);
        }

        public final String getHostUrl() {
            return hostUrl;
        }

        public final void setHostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
        }

        @Override
        public final Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public final String getHostType() {
            return hostType;
        }

        public final void setHostType(String hostType) {
            this.hostType = hostType;
        }

        @Override
        public final Builder hostType(String hostType) {
            this.hostType = hostType;
            return this;
        }

        @Override
        public final Builder hostType(ConfluenceHostType hostType) {
            this.hostType(hostType == null ? null : hostType.toString());
            return this;
        }

        public final String getAuthType() {
            return authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(ConfluenceAuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final String getCredentialsSecretArn() {
            return credentialsSecretArn;
        }

        public final void setCredentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
        }

        @Override
        public final Builder credentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
            return this;
        }

        @Override
        public ConfluenceSourceConfiguration build() {
            return new ConfluenceSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
