/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a connection between two nodes in the flow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowConnection implements SdkPojo, Serializable, ToCopyableBuilder<FlowConnection.Builder, FlowConnection> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(FlowConnection::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(FlowConnection::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(FlowConnection::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("target")
            .getter(getter(FlowConnection::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<FlowConnectionConfiguration> CONFIGURATION_FIELD = SdkField
            .<FlowConnectionConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(FlowConnection::configuration)).setter(setter(Builder::configuration))
            .constructor(FlowConnectionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, NAME_FIELD,
            SOURCE_FIELD, TARGET_FIELD, CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String name;

    private final String source;

    private final String target;

    private final FlowConnectionConfiguration configuration;

    private FlowConnection(BuilderImpl builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.source = builder.source;
        this.target = builder.target;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * Whether the source node that the connection begins from is a condition node (<code>Conditional</code>) or not (
     * <code>Data</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FlowConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Whether the source node that the connection begins from is a condition node (<code>Conditional</code>) or
     *         not (<code>Data</code>).
     * @see FlowConnectionType
     */
    public final FlowConnectionType type() {
        return FlowConnectionType.fromValue(type);
    }

    /**
     * <p>
     * Whether the source node that the connection begins from is a condition node (<code>Conditional</code>) or not (
     * <code>Data</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FlowConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Whether the source node that the connection begins from is a condition node (<code>Conditional</code>) or
     *         not (<code>Data</code>).
     * @see FlowConnectionType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A name for the connection that you can reference.
     * </p>
     * 
     * @return A name for the connection that you can reference.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The node that the connection starts at.
     * </p>
     * 
     * @return The node that the connection starts at.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The node that the connection ends at.
     * </p>
     * 
     * @return The node that the connection ends at.
     */
    public final String target() {
        return target;
    }

    /**
     * <p>
     * The configuration of the connection.
     * </p>
     * 
     * @return The configuration of the connection.
     */
    public final FlowConnectionConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowConnection)) {
            return false;
        }
        FlowConnection other = (FlowConnection) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(source(), other.source()) && Objects.equals(target(), other.target())
                && Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowConnection").add("Type", typeAsString()).add("Name", name()).add("Source", source())
                .add("Target", target()).add("Configuration", configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("target", TARGET_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowConnection, T> g) {
        return obj -> g.apply((FlowConnection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowConnection> {
        /**
         * <p>
         * Whether the source node that the connection begins from is a condition node (<code>Conditional</code>) or not
         * (<code>Data</code>).
         * </p>
         * 
         * @param type
         *        Whether the source node that the connection begins from is a condition node (<code>Conditional</code>)
         *        or not (<code>Data</code>).
         * @see FlowConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowConnectionType
         */
        Builder type(String type);

        /**
         * <p>
         * Whether the source node that the connection begins from is a condition node (<code>Conditional</code>) or not
         * (<code>Data</code>).
         * </p>
         * 
         * @param type
         *        Whether the source node that the connection begins from is a condition node (<code>Conditional</code>)
         *        or not (<code>Data</code>).
         * @see FlowConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowConnectionType
         */
        Builder type(FlowConnectionType type);

        /**
         * <p>
         * A name for the connection that you can reference.
         * </p>
         * 
         * @param name
         *        A name for the connection that you can reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The node that the connection starts at.
         * </p>
         * 
         * @param source
         *        The node that the connection starts at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The node that the connection ends at.
         * </p>
         * 
         * @param target
         *        The node that the connection ends at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * The configuration of the connection.
         * </p>
         * 
         * @param configuration
         *        The configuration of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(FlowConnectionConfiguration configuration);

        /**
         * <p>
         * The configuration of the connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowConnectionConfiguration.Builder}
         * avoiding the need to create one manually via {@link FlowConnectionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowConnectionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(FlowConnectionConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link FlowConnectionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(FlowConnectionConfiguration)
         */
        default Builder configuration(Consumer<FlowConnectionConfiguration.Builder> configuration) {
            return configuration(FlowConnectionConfiguration.builder().applyMutation(configuration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String name;

        private String source;

        private String target;

        private FlowConnectionConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowConnection model) {
            type(model.type);
            name(model.name);
            source(model.source);
            target(model.target);
            configuration(model.configuration);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FlowConnectionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final FlowConnectionConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(FlowConnectionConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(FlowConnectionConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public FlowConnection build() {
            return new FlowConnection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
